/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.opplugin.validator.proutbapply;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.login.utils.DateUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.sihc.soefam.business.application.external.inte.InternationService;
import kd.sihc.soefam.business.queryservice.FaApplyQueryService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class PROutBApplySaveAndSubmitValidator
extends HRDataBaseValidator {
    private static final FaApplyQueryService FA_APPLY_QUERY_SERVICE = (FaApplyQueryService)ServiceFactory.getService(FaApplyQueryService.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity extendedData : dataEntities = this.getDataEntities()) {
            DynamicObject sameApplicantBill;
            DynamicObject dataEntity = extendedData.getDataEntity();
            String auditStatus = dataEntity.getString("auditstatus");
            if ("A".equals(auditStatus) && (sameApplicantBill = FA_APPLY_QUERY_SERVICE.isExistSameApplicant(Long.valueOf(dataEntity.getLong("person.id")), dataEntity.getString("applyformtype"), Long.valueOf(dataEntity.getLong("id")))) != null) {
                String entityKey = this.getEntityKey();
                this.sameBillMessage(extendedData, dataEntity, sameApplicantBill, entityKey);
            }
            Date planLeaveDate = dataEntity.getDate("planleavedate");
            Date planBackDate = dataEntity.getDate("planbackdate");
            if (planLeaveDate != null && planBackDate != null) {
                this.dataMessage(extendedData, planLeaveDate, planBackDate);
            }
            DynamicObjectCollection fAMaterialEntity = dataEntity.getDynamicObjectCollection("famaterialentity");
            List<DynamicObject> notUploadEntity = fAMaterialEntity.stream().filter(entry -> "1".equals(entry.getString("famaterialtpl.ismustupload"))).filter(entry -> entry.getDynamicObjectCollection("famaterialatt").size() == 0).collect(Collectors.toList());
            this.faMaterialMessage(extendedData, notUploadEntity);
        }
    }

    public void faMaterialMessage(ExtendedDataEntity extendedData, List<DynamicObject> notUploadEntity) {
        if (notUploadEntity.size() == 1) {
            this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u4e0a\u4f20\u6750\u6599\u3002", (String)"NotGACApplySaveAndSubmitValidator_1", (String)"sihc-soefam-opplugin", (Object[])new Object[0]));
        } else if (notUploadEntity.size() > 1) {
            this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u4e0a\u4f20\u6750\u6599\u201c%s\u201d\u3002", (String)"NotGACApplySaveAndSubmitValidator_2", (String)"sihc-soefam-opplugin", (Object[])new Object[]{notUploadEntity.size()}));
        }
    }

    public void dataMessage(ExtendedDataEntity extendedData, Date planLeaveDate, Date planBackDate) {
        if (planLeaveDate.after(planBackDate)) {
            String dateFormat = InternationService.getDateFormat();
            String planLendDateStr = DateUtils.formatDate((Date)planLeaveDate, (Object[])new Object[]{dateFormat});
            String planReturnDateStr = DateUtils.formatDate((Date)planBackDate, (Object[])new Object[]{dateFormat});
            OperateOption option = this.getOption();
            if (option == null) {
                return;
            }
            String modelType = option.getVariableValue("modeltypeforwf");
            if (modelType != null && modelType.contains("mobile")) {
                this.addFatalErrorMessage(extendedData, ResManager.loadKDString((String)"\u8ba1\u5212\u51fa\u53d1\u65e5\u671f\u5e94\u65e9\u4e8e\u8ba1\u5212\u8fd4\u56de\u65e5\u671f\uff08%s\uff09\u3002", (String)"PROutBApplySaveAndSubmitValidator_1", (String)"sihc-soefam-opplugin", (Object[])new Object[]{planReturnDateStr}));
            } else {
                this.addFatalErrorMessage(extendedData, ResManager.loadKDString((String)"\u8ba1\u5212\u51fa\u53d1\u65e5\u671f\uff08%1$s\uff09\u5e94\u65e9\u4e8e\u8ba1\u5212\u8fd4\u56de\u65e5\u671f\uff08%2$s\uff09\u3002", (String)"PROutBApplySaveAndSubmitValidator_0", (String)"sihc-soefam-opplugin", (Object[])new Object[]{planLendDateStr, planReturnDateStr}));
            }
        }
    }

    public void sameBillMessage(ExtendedDataEntity extendedData, DynamicObject dataEntity, DynamicObject sameApplicantBill, String entityKey) {
        if ("soefam_proutbapply".equals(entityKey)) {
            this.addFatalErrorMessage(extendedData, ResManager.loadKDString((String)"%1$s\u5f53\u524d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u56e0\u79c1\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7\u5355\u201c%2$s\u201d\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\u7533\u8bf7\u3002", (String)"PROutBApplyPlugin_1", (String)"sihc-soefam-formplugin", (Object[])new Object[]{dataEntity.getString("person.name"), sameApplicantBill.getString("billno")}));
        } else {
            this.addFatalErrorMessage(extendedData, ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u5df2\u6709\u8fdb\u884c\u4e2d\u7684\u56e0\u79c1\u51fa\u56fd\uff08\u5883\uff09\u7533\u8bf7\u5355\u201c%s\u201d\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\u7533\u8bf7\u3002", (String)"PROutBApplySelfListPlugin_0", (String)"sihc-soefam-formplugin", (Object[])new Object[]{sameApplicantBill.getString("billno")}));
        }
    }
}

