/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.opplugin.web.certificate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.domain.certificate.CertificateInRegDomainService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;

public class CertInRegConfirmOp
extends HRDataBaseOp {
    private static final CertificateInRegDomainService CERTIFICATEINREGDOMAINSERVICE = CertificateInRegDomainService.init();
    private static final CertificateApplicationService CERTIFICATEAPPLICATIONSERVICE = (CertificateApplicationService)ServiceFactory.getService(CertificateApplicationService.class);
    List<Object> successCertificateIdList = new ArrayList<Object>();

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject dataEntity = args.getDataEntities()[0];
        DynamicObjectCollection entity = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList saveDynObjList = new ArrayList(entity.size());
        ArrayList<Long> certIdList = new ArrayList<Long>(8);
        ArrayList updateCertObjectList = new ArrayList(entity.size());
        ArrayList certInfoList = new ArrayList(entity.size());
        entity.forEach(dyObj -> this.buildUpdateData(saveDynObjList, (List<Long>)certIdList, updateCertObjectList, certInfoList, (DynamicObject)dyObj));
        DynamicObject[] certInfoArray = CERTIFICATEAPPLICATIONSERVICE.initCertinfo("in_reg", certInfoList.toArray(new DynamicObject[0]));
        Map<Long, Long> certInfoMap = Arrays.stream(certInfoArray).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("certificate.id"), dynamicObject -> dynamicObject.getLong("id"), (v1, v2) -> v1));
        updateCertObjectList.forEach(dynamicObject -> dynamicObject.set("certinfo", certInfoMap.get(dynamicObject.getLong("id"))));
        saveDynObjList.forEach(dynamicObject -> dynamicObject.set("certinfo", certInfoMap.get(dynamicObject.getLong("certificate.id"))));
        CERTIFICATEAPPLICATIONSERVICE.initCertificateManageStatus("in_reg", updateCertObjectList.toArray(new DynamicObject[0]));
        DynamicObject[] certList = this.queryHistoryData(certIdList);
        CERTIFICATEINREGDOMAINSERVICE.update(certList);
        CERTIFICATEINREGDOMAINSERVICE.save(saveDynObjList.toArray(new DynamicObject[0]));
        this.successCertificateIdList.addAll(certIdList);
    }

    private DynamicObject[] queryHistoryData(List<Long> certIdList) {
        QFilter qFilter = new QFilter("certificate", "in", certIdList);
        qFilter.and(new QFilter("latestrecord", "=", (Object)"1"));
        DynamicObject[] certList = CERTIFICATEINREGDOMAINSERVICE.query("latestrecord", qFilter.toArray());
        if (certList != null && certList.length > 0) {
            Arrays.stream(certList).forEach(dynamicObject -> dynamicObject.set("latestrecord", (Object)"0"));
        }
        return certList;
    }

    private void buildUpdateData(List<DynamicObject> saveDynObjList, List<Long> certIdList, List<DynamicObject> dynamicObjectList, List<DynamicObject> certInfoList, DynamicObject dyObj) {
        DynamicObject dynamicObject = CERTIFICATEINREGDOMAINSERVICE.generateEmptyDynamicObject();
        DynamicObject certificateObj = dyObj.getDynamicObject("certificateentity");
        certificateObj.set("storageplace", dyObj.get("storagelocation"));
        certificateObj.set("onfilenum", dyObj.get("onfilenum"));
        DynamicObject certInfoObj = CertificateInRegDomainService.CERT_INFO_HELPER.generateEmptyDynamicObject();
        certInfoObj.set("certificate", (Object)certificateObj);
        certInfoObj.set("org", certificateObj.get("org"));
        certInfoObj.set("certnumber", dyObj.get("certnumber"));
        certInfoObj.set("signdate", dyObj.get("signdate"));
        certInfoObj.set("pervaldate", dyObj.get("pervaldate"));
        certInfoObj.set("signorg", dyObj.get("signorg"));
        certInfoObj.set("signplace", dyObj.get("signplace"));
        certInfoObj.set("remarks", dyObj.get("remarks"));
        certInfoObj.set("faceimage", dyObj.get("faceimageentity"));
        certInfoList.add(certInfoObj);
        certIdList.add(certificateObj.getLong("id"));
        dynamicObjectList.add(certificateObj);
        dynamicObject.set("certificate", (Object)certificateObj);
        dynamicObject.set("certinfo", (Object)certInfoObj);
        dynamicObject.set("storagedate", dyObj.get("storagedate"));
        dynamicObject.set("storagelocation", dyObj.get("storagelocation"));
        dynamicObject.set("remark", dyObj.get("remark"));
        dynamicObject.set("latestrecord", (Object)"1");
        saveDynObjList.add(dynamicObject);
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        this.operationResult.setSuccessPkIds(this.successCertificateIdList);
    }
}

