/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.opplugin.web.certificate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.domain.certificate.helper.CertOutregHelper;
import kd.sihc.soefam.common.constants.certificate.CertificateConstants;

public class CertOutregConfirmOp
extends HRDataBaseOp
implements CertificateConstants {
    private static CertOutregHelper CERTOUTREGHELPER = CertOutregHelper.init();
    private static CertificateApplicationService CERTIFICATEAPPLICATIONSERVICE = new CertificateApplicationService();

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject dataEntity = args.getDataEntities()[0];
        DynamicObjectCollection entity = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList saveDynObjList = new ArrayList(entity.size());
        ArrayList<Long> certIdList = new ArrayList<Long>(8);
        ArrayList updateCertObjectList = new ArrayList(entity.size());
        entity.forEach(dyObj -> this.buildUpdateData(saveDynObjList, (List<Long>)certIdList, updateCertObjectList, (DynamicObject)dyObj));
        CERTIFICATEAPPLICATIONSERVICE.initCertificateManageStatus("out_reg", updateCertObjectList.toArray(new DynamicObject[0]));
        DynamicObject[] certList = this.queryHistoryData(certIdList);
        CERTOUTREGHELPER.update(certList);
        CERTOUTREGHELPER.save(saveDynObjList.toArray(new DynamicObject[0]));
    }

    private DynamicObject[] queryHistoryData(List<Long> certIdList) {
        QFilter qFilter = new QFilter("certificate", "in", certIdList);
        qFilter.and(new QFilter("latestrecord", "=", (Object)"1"));
        DynamicObject[] certList = CERTOUTREGHELPER.query("latestrecord", qFilter.toArray());
        if (certList != null && certList.length > 0) {
            Arrays.stream(certList).forEach(dynamicObject -> dynamicObject.set("latestrecord", (Object)"0"));
        }
        return certList;
    }

    private void buildUpdateData(List<DynamicObject> saveDynObjList, List<Long> certIdList, List<DynamicObject> dynamicObjectList, DynamicObject dyObj) {
        DynamicObject dynamicObject = CERTOUTREGHELPER.generateEmptyDynamicObject();
        DynamicObject certificateObj = dyObj.getDynamicObject("certificateentity");
        DynamicObject certInfoObj = certificateObj.getDynamicObject("certinfo");
        certIdList.add(certificateObj.getLong("id"));
        dynamicObjectList.add(certificateObj);
        dynamicObject.set("certificate", (Object)certificateObj);
        dynamicObject.set("certinfo", (Object)certInfoObj);
        dynamicObject.set("outdate", dyObj.get("outdate"));
        dynamicObject.set("receiver", dyObj.get("receiver"));
        dynamicObject.set("remark", dyObj.get("remark"));
        dynamicObject.set("latestrecord", (Object)"1");
        dynamicObject.set("outreason", dyObj.get("outreason"));
        saveDynObjList.add(dynamicObject);
    }
}

