/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.opplugin.web.certificate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.domain.certificate.CertificateInRegDomainService;
import kd.sihc.soefam.business.domain.certificate.CertificateRepRegDomainService;

public class CertRepRegConfirmOp
extends HRDataBaseOp {
    private static final CertificateRepRegDomainService REPLACEREGDOMAINSERVICE = CertificateRepRegDomainService.init();
    private static final CertificateApplicationService CERTIFICATEAPPLICATIONSERVICE = new CertificateApplicationService();
    private static final HRBaseServiceHelper CERTINFO_HELPER = new HRBaseServiceHelper("soefam_certinfo");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject dataEntity = args.getDataEntities()[0];
        DynamicObjectCollection entity = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList saveDynObjList = new ArrayList(entity.size());
        ArrayList<Long> certIdList = new ArrayList<Long>(8);
        ArrayList updateCertObjectList = new ArrayList(entity.size());
        ArrayList certInfoList = new ArrayList(entity.size());
        entity.forEach(dyObj -> this.buildUpdateData(saveDynObjList, (List<Long>)certIdList, updateCertObjectList, certInfoList, (DynamicObject)dyObj));
        List<Long> oldCertInfoIdList = updateCertObjectList.stream().map(dyn -> dyn.getLong("certinfo.id")).collect(Collectors.toList());
        DynamicObject[] certInfoArray = CERTIFICATEAPPLICATIONSERVICE.initCertinfo("replace_reg", certInfoList.toArray(new DynamicObject[0]));
        Map<Long, Long> certInfoMap = Arrays.stream(certInfoArray).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("certificate.id"), dynamicObject -> dynamicObject.getLong("id"), (v1, v2) -> v1));
        updateCertObjectList.forEach(dynamicObject -> dynamicObject.set("certinfo", certInfoMap.get(dynamicObject.getLong("id"))));
        CERTIFICATEAPPLICATIONSERVICE.initCertificateManageStatus("replace_reg", updateCertObjectList.toArray(new DynamicObject[0]));
        DynamicObject[] certList = this.queryHistoryData(certIdList);
        REPLACEREGDOMAINSERVICE.update(certList);
        this.updateOldCertInfo(oldCertInfoIdList);
        REPLACEREGDOMAINSERVICE.save(saveDynObjList.toArray(new DynamicObject[0]));
    }

    private void updateOldCertInfo(List<Long> oldCertInfoIdList) {
        QFilter qFilter = new QFilter("id", "in", oldCertInfoIdList);
        DynamicObject[] oldCertInfoList = CERTINFO_HELPER.query("effectivestatus", qFilter.toArray());
        List<DynamicObject> certInfoList = Stream.of(oldCertInfoList).filter(dyn -> "1".equals(dyn.getString("effectivestatus"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(certInfoList)) {
            certInfoList.forEach(dyn -> dyn.set("effectivestatus", (Object)"0"));
            CERTINFO_HELPER.update(certInfoList.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject[] queryHistoryData(List<Long> certIdList) {
        QFilter qFilter = new QFilter("certificate", "in", certIdList);
        qFilter.and(new QFilter("latestrecord", "=", (Object)"1"));
        DynamicObject[] certList = REPLACEREGDOMAINSERVICE.query("latestrecord", qFilter.toArray());
        if (certList != null && certList.length > 0) {
            Arrays.stream(certList).forEach(dynamicObject -> dynamicObject.set("latestrecord", (Object)"0"));
        }
        return certList;
    }

    private void buildUpdateData(List<DynamicObject> saveDynObjList, List<Long> certIdList, List<DynamicObject> updateCertObjectList, List<DynamicObject> certInfoList, DynamicObject dyObj) {
        DynamicObject dynamicObject = REPLACEREGDOMAINSERVICE.generateEmptyDynamicObject();
        DynamicObject certificateObj = dyObj.getDynamicObject("certificateentity");
        DynamicObject newCertificateObj = this.buildNewCertificateObj(certInfoList, dyObj, certificateObj);
        certIdList.add(certificateObj.getLong("id"));
        updateCertObjectList.add(certificateObj);
        dynamicObject.set("oldcertinfo", certificateObj.get("certinfo"));
        dynamicObject.set("newcertinfo", (Object)newCertificateObj);
        dynamicObject.set("certificate", (Object)certificateObj);
        certificateObj.set("onfilenum", dyObj.get("newonfilenum"));
        dynamicObject.set("replacedate", dyObj.get("replacedate"));
        dynamicObject.set("remark", dyObj.get("remark"));
        dynamicObject.set("latestrecord", (Object)"1");
        saveDynObjList.add(dynamicObject);
    }

    private DynamicObject buildNewCertificateObj(List<DynamicObject> certInfoObjList, DynamicObject dyObj, DynamicObject certificateObj) {
        DynamicObject certInfoObj = CertificateInRegDomainService.CERT_INFO_HELPER.generateEmptyDynamicObject();
        certInfoObj.set("certificate", (Object)certificateObj);
        certInfoObj.set("org", certificateObj.get("org"));
        certInfoObj.set("certnumber", dyObj.get("newcertnumber"));
        certInfoObj.set("signdate", dyObj.get("signdate"));
        certInfoObj.set("pervaldate", dyObj.get("pervaldate"));
        certInfoObj.set("signorg", dyObj.get("signorg"));
        certInfoObj.set("signplace", dyObj.get("signplace"));
        certInfoObj.set("remarks", dyObj.get("remarks"));
        certInfoObj.set("faceimage", dyObj.get("faceimageentity"));
        certInfoObjList.add(certInfoObj);
        return certInfoObj;
    }
}

