/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.opplugin.web.certificate;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.domain.certificate.CertificateReturnDomainService;
import kd.sihc.soefam.business.task.SscTaskService;
import kd.sihc.soefam.common.utils.StopWatchUtils;
import org.apache.commons.lang3.time.StopWatch;

public class CertreturnregCommitOp
extends HRDataBaseOp {
    private static final CertificateReturnDomainService CERTIFICATERETURNDOMAINSERVICE = new CertificateReturnDomainService();
    private static final CertificateApplicationService CERTIFICATEAPPLICATIONSERVICE = new CertificateApplicationService();
    private static final Log LOG = LogFactory.getLog(CertreturnregCommitOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject dataEntity = args.getDataEntities()[0];
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList updateCertObjectList = new ArrayList(entryentity.size());
        ArrayList certificateIds = new ArrayList(entryentity.size());
        ArrayList faids = new ArrayList(entryentity.size());
        entryentity.forEach(entryObj -> {
            Long certificateId = entryObj.getDynamicObject("certificateentity").getLong("id");
            Long faid = entryObj.getLong("faid");
            certificateIds.add(certificateId);
            faids.add(faid);
        });
        LOG.info("CertreturnregCommitOp.beginOperationTransaction update start");
        StopWatch stopWatch = StopWatchUtils.startWatchTime();
        CERTIFICATERETURNDOMAINSERVICE.updateCertreturn(entryentity, updateCertObjectList, certificateIds, faids);
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertreturnregCommitOp.class, (String)"beginOperationTransaction", (String)"updateCertreturn");
        stopWatch.reset();
        stopWatch.start();
        CERTIFICATEAPPLICATIONSERVICE.initCertificateManageStatus("return_reg", updateCertObjectList.toArray(new DynamicObject[0]));
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertreturnregCommitOp.class, (String)"beginOperationTransaction", (String)"initCertificateManageStatus");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs afterOperationArgs) {
        super.afterExecuteOperationTransaction(afterOperationArgs);
        DynamicObject dataEntity = afterOperationArgs.getDataEntities()[0];
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        List certificateIds = entryEntity.stream().map(dynamicObject -> dynamicObject.getDynamicObject("certificateentity").getLong("id")).collect(Collectors.toList());
        String appNumber = this.getOption().getVariableValue("appnumber");
        StopWatch stopWatch = StopWatchUtils.startWatchTime();
        List taskIdList = SscTaskService.shareTaskHandle(certificateIds, (String)("hstc".equals(appNumber) ? "1" : appNumber), (String)"soefam_certreturn_ssc");
        StopWatchUtils.stopWatchTime((StopWatch)stopWatch, CertreturnregCommitOp.class, (String)"afterExecuteOperationTransaction", null);
        this.getOption().setVariableValue("taskIdList", SerializationUtils.serializeToBase64((Object)taskIdList));
    }
}

