/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soefam.opplugin.web.filingsperson;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sihc.soebs.common.constants.dto.response.cert.CertResDTO;
import kd.sihc.soefam.business.application.service.certificate.CertificateApplicationService;
import kd.sihc.soefam.business.application.service.filingsperson.FilPersonApplicationService;
import kd.sihc.soefam.business.domain.license.LicenseService;
import kd.sihc.soefam.business.servicehelper.ServiceFactory;
import kd.sihc.soefam.common.constants.filingsperson.FilPersonConstants;

public class FilPerAuditEffectOp
extends HRDataBaseOp
implements FilPersonConstants {
    private static final CertificateApplicationService ACTIVITY_BILL_APPLICATION_SERVICE = (CertificateApplicationService)ServiceFactory.getService(CertificateApplicationService.class);
    private static final FilPersonApplicationService FIL_PERSON_APPLICATION_SERVICE = (FilPersonApplicationService)ServiceFactory.getService(FilPersonApplicationService.class);
    private static final LicenseService LICENSE_SERVICE = (LicenseService)ServiceFactory.getService(LicenseService.class);

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        super.onAddValidators(eventArgs);
        eventArgs.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity extendedDataEntity = this.getDataEntities()[0];
                CertResDTO responseDto = LICENSE_SERVICE.checkLicenseNum("soefam_filperlist");
                if (!responseDto.getSuccess().booleanValue()) {
                    this.addFatalErrorMessage(extendedDataEntity, responseDto.getMessage());
                }
            }
        });
    }

    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        super.onPreparePropertys(eventArgs);
        eventArgs.getFieldKeys().add("filingstatus");
        eventArgs.getFieldKeys().add("listtype");
        eventArgs.getFieldKeys().add("effstatus");
        eventArgs.getFieldKeys().add("iregscopedate");
        eventArgs.getFieldKeys().add("status");
        eventArgs.getFieldKeys().add("person");
        eventArgs.getFieldKeys().add("manageorg");
        eventArgs.getFieldKeys().add("org");
        eventArgs.getFieldKeys().add("primanageorg");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0) {
            ACTIVITY_BILL_APPLICATION_SERVICE.initCertificate("enable", dataEntities);
            FIL_PERSON_APPLICATION_SERVICE.updateConFilPersonStatusForAudit(dataEntities);
        }
    }
}

