/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.common.check;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ExpressionEvaluator {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("[0-9\\.+-/*()= ]+");
    private static final Log LOG = LogFactory.getLog(ExpressionEvaluator.class);
    private static final String EXP_REPLACE_END = "([>=<=<>\\+\\-*/()])";
    private static final Map<String, Integer> OPT_PRIORITY_MAP = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 6968472606692771458L;
        {
            this.put("(", 0);
            this.put("+", 2);
            this.put("-", 2);
            this.put("*", 3);
            this.put("/", 3);
            this.put(")", 7);
            this.put("=", 20);
        }
    };

    public static double executeExpression(String expression) {
        if (null == expression || "".equals(expression.trim())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExpCalculator_0", (String)"sihc-soehrr-common", (Object[])new Object[0]));
        }
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        if (!matcher.matches()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u542b\u6709\u975e\u6cd5\u5b57\u7b26\u3002", (String)"ExpCalculator_0", (String)"sihc-soehrr-common", (Object[])new Object[0]));
        }
        Stack<String> optStack = new Stack<String>();
        Stack<BigDecimal> numStack = new Stack<BigDecimal>();
        StringBuilder curNumBuilder = new StringBuilder(16);
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == ' ') continue;
            if (c >= '0' && c <= '9' || c == '.') {
                curNumBuilder.append(c);
                continue;
            }
            if (curNumBuilder.length() > 0) {
                numStack.push(new BigDecimal(curNumBuilder.toString()));
                curNumBuilder.delete(0, curNumBuilder.length());
            }
            String curOpt = String.valueOf(c);
            if (optStack.empty()) {
                optStack.push(curOpt);
                continue;
            }
            if (curOpt.equals("(")) {
                optStack.push(curOpt);
                continue;
            }
            if (curOpt.equals(")")) {
                ExpressionEvaluator.directCalc(optStack, numStack, true);
                continue;
            }
            if (curOpt.equals("=")) {
                ExpressionEvaluator.directCalc(optStack, numStack, false);
                return numStack.pop().doubleValue();
            }
            ExpressionEvaluator.compareAndCalc(optStack, numStack, curOpt);
        }
        if (curNumBuilder.length() > 0) {
            numStack.push(new BigDecimal(curNumBuilder.toString()));
        }
        ExpressionEvaluator.directCalc(optStack, numStack, false);
        return numStack.pop().doubleValue();
    }

    public static void compareAndCalc(Stack<String> optStack, Stack<BigDecimal> numStack, String curOpt) {
        String peekOpt = optStack.peek();
        int priority = ExpressionEvaluator.getPriority(peekOpt, curOpt);
        if (priority == -1 || priority == 0) {
            String opt = optStack.pop();
            BigDecimal num2 = numStack.pop();
            BigDecimal num1 = numStack.pop();
            BigDecimal bigDecimal = ExpressionEvaluator.floatingPointCalc(opt, num1, num2);
            numStack.push(bigDecimal);
            if (optStack.empty()) {
                optStack.push(curOpt);
            } else {
                ExpressionEvaluator.compareAndCalc(optStack, numStack, curOpt);
            }
        } else {
            optStack.push(curOpt);
        }
    }

    public static void directCalc(Stack<String> optStack, Stack<BigDecimal> numStack, boolean isBracket) {
        if (optStack.isEmpty()) {
            return;
        }
        String opt = optStack.pop();
        BigDecimal num2 = numStack.pop();
        BigDecimal num1 = numStack.pop();
        BigDecimal bigDecimal = ExpressionEvaluator.floatingPointCalc(opt, num1, num2);
        numStack.push(bigDecimal);
        if (isBracket) {
            if ("(".equals(optStack.peek())) {
                optStack.pop();
            } else {
                ExpressionEvaluator.directCalc(optStack, numStack, isBracket);
            }
        } else if (!optStack.empty()) {
            ExpressionEvaluator.directCalc(optStack, numStack, isBracket);
        }
    }

    public static BigDecimal floatingPointCalc(String opt, BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        BigDecimal resultBigDecimal = new BigDecimal(0);
        switch (opt) {
            case "+": {
                resultBigDecimal = bigDecimal1.add(bigDecimal2);
                break;
            }
            case "-": {
                resultBigDecimal = bigDecimal1.subtract(bigDecimal2);
                break;
            }
            case "*": {
                resultBigDecimal = bigDecimal1.multiply(bigDecimal2);
                break;
            }
            case "/": {
                resultBigDecimal = bigDecimal1.divide(bigDecimal2, 10, 5);
                break;
            }
        }
        return resultBigDecimal;
    }

    public static int getPriority(String opt1, String opt2) {
        int priority = OPT_PRIORITY_MAP.get(opt2) - OPT_PRIORITY_MAP.get(opt1);
        return priority;
    }

    public static String replaceAllForExpression(String afterReplaceExpression, String tableCell, String cellValue) {
        LOG.info("ExpressionEvaluator.replaceAllForExpression start afterReplaceExpression = {} ,tableCell = {} ,cellValue = {}", new Object[]{afterReplaceExpression, tableCell, cellValue});
        if (afterReplaceExpression.endsWith(tableCell)) {
            int index = afterReplaceExpression.lastIndexOf(tableCell);
            return afterReplaceExpression.substring(0, index) + cellValue;
        }
        String pattern = tableCell + EXP_REPLACE_END;
        String replacement = cellValue + "$1";
        String result = afterReplaceExpression.replaceAll(pattern, replacement);
        LOG.info("ExpressionEvaluator.replaceAllForExpression end afterReplaceExpression = {} ", (Object)result);
        return result;
    }

    public static boolean matchOfExpression(String expression, String tableAndCell) {
        if (expression.endsWith(tableAndCell)) {
            return true;
        }
        String pattern = tableAndCell + EXP_REPLACE_END;
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(expression);
        boolean flag = matcher.find();
        return flag;
    }
}

