/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.common.check;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.sdk.sihc.soehrr.common.spread.Point;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sihc.soehrr.common.check.ExpressionEvaluator;
import kd.sihc.soehrr.common.check.ExpressionItemFeature;

public class ExpressionSplitor {
    private static List<String> chars = Arrays.asList("+", "-", "*", "/", "(", ")", "=", "<>", ">", ">=", "<", "<=");

    public static List<String> split(String expression, String compator) {
        ArrayList items = Lists.newArrayListWithCapacity((int)10);
        String[] cstrs = (expression = expression.replace(" ", "")).split(compator);
        if (cstrs.length != 2) {
            return items;
        }
        List<String> splitItems = ExpressionSplitor.splitItem(expression);
        if (!expression.contains(":")) {
            String expressionAfter = expression;
            for (String item : splitItems) {
                String[] lr = item.split("!");
                Point point = ExcelUtils.pos2Point((String)lr[1]);
                expressionAfter = ExpressionEvaluator.replaceAllForExpression(expressionAfter, item, lr[0] + "!" + point.y + ":" + point.x);
            }
            items.add(expressionAfter);
            return items;
        }
        HashMap itemFeatureMap = new HashMap(splitItems.size());
        splitItems.forEach(splitItem -> {
            if (splitItem.contains(":") && splitItem.contains("!")) {
                String[] itemLr = splitItem.split("!");
                String[] cellItems = itemLr[1].split(":");
                Point sPoint = ExcelUtils.pos2Point((String)cellItems[0]);
                Point ePoint = ExcelUtils.pos2Point((String)cellItems[1]);
                if (sPoint.x == ePoint.x) {
                    itemFeatureMap.put(splitItem, new ExpressionItemFeature(0, sPoint.y, sPoint.x));
                } else if (sPoint.y == ePoint.y) {
                    itemFeatureMap.put(splitItem, new ExpressionItemFeature(1, sPoint.x, sPoint.y));
                }
            }
        });
        int loopNum = ExpressionSplitor.calLoopNum(cstrs[0]);
        for (int index = 0; index < loopNum; ++index) {
            String afterReplace = expression;
            for (String item : splitItems) {
                ExpressionItemFeature feature = (ExpressionItemFeature)itemFeatureMap.get(item);
                String[] itemLr = item.split("!");
                StringBuilder tmpBuilder = new StringBuilder(itemLr[0]);
                tmpBuilder.append("!");
                if (feature.getDirection() == 0) {
                    tmpBuilder.append(feature.getChangeStartPos() + index).append(":").append(feature.getNochangePos());
                    afterReplace = ExpressionEvaluator.replaceAllForExpression(afterReplace, item, tmpBuilder.toString());
                    continue;
                }
                if (feature.getDirection() != 1) continue;
                tmpBuilder.append(feature.getNochangePos()).append(":").append(feature.getChangeStartPos() + index);
                afterReplace = ExpressionEvaluator.replaceAllForExpression(afterReplace, item, tmpBuilder.toString());
            }
            items.add(afterReplace);
        }
        return items;
    }

    public static List<String> splitItem(String singleExpression) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (char ca : singleExpression.toCharArray()) {
            if (!chars.contains(String.valueOf(ca))) {
                builder.append(ca);
                continue;
            }
            if (builder.length() <= 0) continue;
            result.add(builder.toString().trim());
            builder.setLength(0);
        }
        if (builder.length() > 0) {
            result.add(builder.toString().trim());
        }
        return result;
    }

    private static int calLoopNum(String item) {
        if (!item.contains(":") || !item.contains("!")) {
            return 0;
        }
        String[] lrs = item.split("!");
        String[] cells = lrs[1].split(":");
        Point left = ExcelUtils.pos2Point((String)cells[0]);
        Point right = ExcelUtils.pos2Point((String)cells[1]);
        if (left.x == right.x) {
            return right.y - left.y + 1;
        }
        if (left.y == right.y) {
            return right.x - left.x + 1;
        }
        return 0;
    }
}

