/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.common.check;

import java.util.Stack;
import java.util.regex.Pattern;

public class ExpressionValidator {
    private static final String chars = "+-*/().0123456789";

    public static boolean isValidExpression(String expression) {
        if (!ExpressionValidator.isBalanced(expression = expression.replaceAll("\\s", ""))) {
            return false;
        }
        String[] tokens = expression.split("");
        boolean result = true;
        for (int index = 0; index < tokens.length; ++index) {
            String token = tokens[index];
            if (!chars.contains(token)) {
                return false;
            }
            result = ExpressionValidator.valid(tokens, index);
            if (result) continue;
            return false;
        }
        return true;
    }

    private static boolean valid(String[] tokens, int index) {
        String token = tokens[index];
        if ("+-*/".contains(token)) {
            if (index == 0 || index == tokens.length - 1) {
                return false;
            }
            if (index + 1 < tokens.length && !Pattern.matches("[0-9(]", tokens[index + 1])) {
                return false;
            }
            if (!Pattern.matches("[0-9)]", tokens[index - 1])) {
                return false;
            }
        } else if ("()".contains(token)) {
            if ("(".contains(token) ? index + 1 < tokens.length && "+-*/)".contains(tokens[index + 1]) : index + 1 < tokens.length && Pattern.matches("[0-9.]", tokens[index + 1])) {
                return false;
            }
        } else if (".".equals(token)) {
            if (index == 0 || index == tokens.length - 1) {
                return false;
            }
            if (index + 1 < tokens.length && !Character.isDigit(tokens[index + 1].charAt(0))) {
                return false;
            }
        }
        return true;
    }

    private static boolean isBalanced(String expression) {
        Stack<Character> stack = new Stack<Character>();
        for (char ch : expression.toCharArray()) {
            if (ch == '(') {
                stack.push(Character.valueOf(ch));
                continue;
            }
            if (ch != ')' || !stack.isEmpty() && ((Character)stack.pop()).charValue() == '(') continue;
            return false;
        }
        return stack.isEmpty();
    }
}

