/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.common.entity.cyccollecttask;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.sihc.soehrr.common.entity.cyccollecttask.CollectRptTplOrgs;

public class EnableCollectTask
implements Serializable {
    private static final long serialVersionUID = 7358926560503364972L;
    private List<CollectRptTplOrgs> rptTplMapOrgs;
    private DynamicObject cycCollectTask;
    private Date fillStartDate;
    private Date fillEndDate;
    private String belongYear;
    private int genStatus;
    private String errorMsg;

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public List<CollectRptTplOrgs> getRptTplMapOrgs() {
        return this.rptTplMapOrgs;
    }

    public void setRptTplMapOrgs(List<CollectRptTplOrgs> rptTplMapOrgs) {
        if (HRCollUtil.isNotEmpty(this.rptTplMapOrgs)) {
            this.rptTplMapOrgs.addAll(rptTplMapOrgs);
        } else {
            this.rptTplMapOrgs = rptTplMapOrgs;
        }
    }

    public DynamicObject getCycCollectTask() {
        return this.cycCollectTask;
    }

    public void setCycCollectTask(DynamicObject cycCollectTask) {
        this.cycCollectTask = cycCollectTask;
    }

    public Date getFillStartDate() {
        return this.fillStartDate;
    }

    public void setFillStartDate(Date fillStartDate) {
        this.fillStartDate = fillStartDate;
    }

    public Date getFillEndDate() {
        return this.fillEndDate;
    }

    public void setFillEndDate(Date fillEndDate) {
        this.fillEndDate = fillEndDate;
    }

    public void setRptOrgByTask(DynamicObjectCollection taskConfList, DynamicObject dateEntry) {
        DynamicObject belongPeriod = dateEntry.getDynamicObject("belongperiod");
        DynamicObject periodType = belongPeriod.getDynamicObject("periodtype");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject taskConf : taskConfList) {
            DynamicObject rptTpl = taskConf.getDynamicObject("rpttpl");
            DynamicObject rptPeriodType = rptTpl.getDynamicObject("periodtype");
            if (periodType.getLong("id") != rptPeriodType.getLong("id")) continue;
            long rptTplId = rptTpl.getLong("id");
            DynamicObjectCollection fillUnits = taskConf.getDynamicObjectCollection("fillunits");
            List<DynamicObject> fillUnitList = fillUnits.stream().map(fillUnit -> fillUnit.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            CollectRptTplOrgs rptTplOrgs = new CollectRptTplOrgs(rptTplId, fillUnitList);
            rptTplOrgs.setRptTpl(rptTpl);
            rptTplOrgs.setBelongPeriod(belongPeriod);
            rptTplOrgs.setDataStartTime(dateEntry.getDate("datastarttimeval"));
            rptTplOrgs.setDataEndTime(dateEntry.getDate("dataendtimeval"));
            result.add(rptTplOrgs);
        }
        this.setRptTplMapOrgs(result);
    }

    public String getBelongYear() {
        return this.belongYear;
    }

    public void setBelongYear(String belongYear) {
        this.belongYear = belongYear;
    }

    public int getGenStatus() {
        return this.genStatus;
    }

    public void setGenStatus(int genStatus) {
        this.genStatus = genStatus;
    }

    public int allFillTaskSize() {
        int count = 0;
        for (CollectRptTplOrgs rptTplMapOrg : this.rptTplMapOrgs) {
            List<DynamicObject> adminOrgList = rptTplMapOrg.getAdminOrgList();
            count += adminOrgList.size();
        }
        return count;
    }

    public String toString() {
        return "EnableCollectTask{rptTplMapOrgs=" + this.rptTplMapOrgs + ", cycCollectTask=" + this.cycCollectTask + ", fillStartDate=" + this.fillStartDate + ", fillEndDate=" + this.fillEndDate + ", belongYear='" + this.belongYear + '\'' + ", genStatus=" + this.genStatus + '}';
    }
}

