/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.common.enums;

public enum CycleCollectTaskEnum {
    MONTH("monthtab", "monthentry", "m", 1905946591286562816L),
    QUARTER("quartertab", "quarterentity", "q", 1905946507106882560L),
    HALF_YEAR("halfyeartab", "halfyearentity", "hy", 1905946374130667520L),
    YEAR("yeartab", "yearentity", "y", 1905946157293540352L);

    private String tabKey;
    private String entryName;
    private String fieldPrefix;
    private long periodTypeId;

    private CycleCollectTaskEnum(String tabKey, String entryName, String fieldPrefix, long periodTypeId) {
        this.tabKey = tabKey;
        this.entryName = entryName;
        this.fieldPrefix = fieldPrefix;
        this.periodTypeId = periodTypeId;
    }

    public static CycleCollectTaskEnum getByTab(String currentTab) {
        for (CycleCollectTaskEnum value : CycleCollectTaskEnum.values()) {
            if (!value.getTabKey().equals(currentTab)) continue;
            return value;
        }
        return MONTH;
    }

    public static CycleCollectTaskEnum getByPeriodType(long periodTypeId) {
        for (CycleCollectTaskEnum value : CycleCollectTaskEnum.values()) {
            if (value.getPeriodTypeId() != periodTypeId) continue;
            return value;
        }
        return MONTH;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public String getFieldPrefix() {
        return this.fieldPrefix;
    }

    public void setFieldPrefix(String fieldPrefix) {
        this.fieldPrefix = fieldPrefix;
    }

    public long getPeriodTypeId() {
        return this.periodTypeId;
    }

    public void setPeriodTypeId(long periodTypeId) {
        this.periodTypeId = periodTypeId;
    }

    public String getTabKey() {
        return this.tabKey;
    }

    public void setTabKey(String tabKey) {
        this.tabKey = tabKey;
    }
}

