/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.common.utils;

import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SoehrrCommonUtils {
    private SoehrrCommonUtils() {
    }

    public static boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 100 != 0) {
            return true;
        }
        return year % 400 == 0;
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 0);
        c.set(5, 1);
        return c.getTime();
    }

    public static LocalDate getLastDayOfMonth(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate lastDayOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
        return lastDayOfMonth;
    }

    public static LocalDateTime getStartOfDay(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDateTime startOfDay = localDate.atStartOfDay();
        return startOfDay;
    }

    public static Date convertLocalDateTimeToDate(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        Instant instant = zonedDateTime.toInstant();
        long epochMilli = instant.toEpochMilli();
        Date date = new Date(epochMilli);
        return date;
    }

    public static String genThreeRandom() {
        SecureRandom random = new SecureRandom();
        int randomNumber = random.nextInt(99999) + 1;
        return String.format(Locale.ROOT, "%03d", randomNumber);
    }
}

