/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.collecttask;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.DimValueResult;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sihc.soehrr.business.domain.collecttask.CollectTaskFormService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;

public class BatchSettingForFillTaskPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final HRBaseServiceHelper ADMINORG = HRBaseServiceHelper.create((String)"haos_adminorghr");
    private static final CollectTaskFormService COLLECT_TASK_FORM_SERVICE = (CollectTaskFormService)ServiceFactory.getService(CollectTaskFormService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnsave"});
        BasedataEdit fillOrg = (BasedataEdit)this.getView().getControl("fillorg");
        fillOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit belongPeriod = (BasedataEdit)this.getView().getControl("belongperiod");
        belongPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if ("false".equals(formShowParameter.getCustomParam("samePeriod"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"belongperiod", "datastarttime", "dataendtime"});
        } else if ("true".equals(formShowParameter.getCustomParam("samePeriod"))) {
            Long periodTypeId = (Long)formShowParameter.getCustomParam("periodtype");
            this.getPageCache().put("periodTypeId", String.valueOf(periodTypeId));
        }
        if (Boolean.FALSE == formShowParameter.getCustomParam("iscycrpt")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"belongperiod"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("fillunits".equals(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            DynamicObjectCollection fillOrg = (DynamicObjectCollection)this.getModel().getValue("fillorg");
            int unitSize = fillOrg.size();
            int total = returnData.size() + unitSize;
            if (total > 1000) {
                ListSelectedRowCollection needRemoveList = new ListSelectedRowCollection();
                int needRemoveTotal = total - 1000;
                for (int i = returnData.size() - needRemoveTotal; i < returnData.size(); ++i) {
                    needRemoveList.add((Object)returnData.get(i));
                }
                returnData.removeAll((Collection)needRemoveList);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e91000\u6761\u6570\u636e\u3002", (String)"CollectTaskPlugin_10", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            }
            List orgIds = returnData.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject[] orgs = ADMINORG.loadDynamicObjectArray(new QFilter("id", "in", orgIds).toArray());
            DynamicObjectCollection fillOrg2 = (DynamicObjectCollection)this.getModel().getValue("fillorg");
            for (DynamicObject obj2 : orgs) {
                DynamicObject dynamicObject = fillOrg2.addNew();
                dynamicObject.set("fbasedataid", (Object)obj2);
            }
            this.getModel().setValue("fillorg", (Object)fillOrg2);
            this.getView().updateView("fillorg");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button bt = (Button)evt.getSource();
        String key = bt.getKey();
        if (key.equals("btnsave")) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            returnData.put("fillorg", this.getModel().getValue("fillorg"));
            returnData.put("belongperiod", this.getModel().getValue("belongperiod"));
            returnData.put("datastarttime", this.getModel().getValue("datastarttime"));
            returnData.put("dataendtime", this.getModel().getValue("dataendtime"));
            if (((DynamicObjectCollection)this.getModel().getValue("fillorg")).size() < 1 && null == this.getModel().getValue("belongperiod") && null == this.getModel().getValue("datastarttime") && null == this.getModel().getValue("dataendtime")) {
                this.getView().returnDataToParent(null);
            } else {
                this.getView().returnDataToParent(returnData);
            }
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if ("fillorg".equals(propertyName)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setFormId("bos_listf7");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fillunits"));
            DimValueResult result = (DimValueResult)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getEntityDimValue", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "soehrr", "soehrr_collecttask", "47150e89000000ac", "fillunits"});
            if (!result.isAll()) {
                Set hasPermOrgs = result.getDimValueIds();
                List ids = hasPermOrgs.stream().map(Long::parseLong).collect(Collectors.toList());
                QFilter Qfilter = new QFilter("id", "in", ids).and("iscurrentversion", "=", (Object)"1");
                formShowParameter.getListFilterParameter().getQFilters().add(Qfilter);
            } else {
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("iscurrentversion", "=", (Object)"1"));
            }
            formShowParameter.getListFilterParameter().setOrderBy("sortcode asc");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u586b\u62a5\u5355\u4f4d", (String)"CollectTaskPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
        } else if ("belongperiod".equals(propertyName)) {
            Long periodTypeId = Long.parseLong(this.getPageCache().get("periodTypeId"));
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(new QFilter("periodtype", "=", (Object)periodTypeId)));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("belongperiod".equals(name)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (HRObjectUtils.isEmpty((Object)newValue)) {
                return;
            }
            DynamicObject belongPeriod = (DynamicObject)this.getModel().getValue("belongperiod");
            this.getPageCache().put("isChanging", "true");
            String year = (String)this.getView().getFormShowParameter().getCustomParam("year");
            if (HRStringUtils.isEmpty((String)year)) {
                year = new SimpleDateFormat("yyyy").format(new Date());
            }
            Date startDate = belongPeriod.getDate("startdate");
            String startDateString = DateUtils.getDate((Date)startDate);
            this.getModel().setValue("datastarttime", (Object)COLLECT_TASK_FORM_SERVICE.getParseDate(year + startDateString.substring(4)));
            Date endDate = belongPeriod.getDate("enddate");
            String endDatestring = COLLECT_TASK_FORM_SERVICE.checkLeapMonth(DateUtils.getDate((Date)endDate), year);
            this.getModel().setValue("dataendtime", (Object)COLLECT_TASK_FORM_SERVICE.getParseDate(year + endDatestring.substring(4)));
            this.getPageCache().remove("isChanging");
        } else if ("datastarttime".equals(name)) {
            this.checkTime();
            this.endTimeHandler();
        } else if ("dataendtime".equals(name)) {
            this.checkTime();
        }
    }

    private void endTimeHandler() {
        if (null != this.getModel().getValue("datastarttime")) {
            DateTimeEdit endTime = (DateTimeEdit)this.getControl("dataendtime");
            endTime.setMinDate((Date)this.getModel().getValue("datastarttime"));
        }
    }

    private boolean checkTime() {
        if (!HRObjectUtils.isEmpty((Object)this.getPageCache().get("isChanging"))) {
            return true;
        }
        Date startTime = (Date)this.getModel().getValue("datastarttime");
        Date endTime = (Date)this.getModel().getValue("dataendtime");
        if (!HRObjectUtils.isEmpty((Object)startTime) && !HRObjectUtils.isEmpty((Object)endTime) && startTime.after(endTime)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6570\u636e\u5f00\u59cb\u65e5\u671f\u3002", (String)"CollectTaskPlugin_21", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("dataendtime", null);
            return false;
        }
        return true;
    }

    private QFilter getUserAdminOrgsF74View(String entityNumber) {
        long userId = RequestContext.get().getCurrUserId();
        String appId = AppMetadataCache.getAppInfo((String)"soehrr").getId();
        return (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{userId, appId, entityNumber, "47150e89000000ac", null});
    }

    private void openFillUnitsF7() {
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"haos_adminorghr", (boolean)true);
        showListForm.setFormId("bos_listf7");
        showListForm.setShowApproved(false);
        showListForm.setShowUsed(true);
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fillUnits"));
        QFilter adminOrgFilter = this.getUserAdminOrgsF74View("soehrr_collecttask");
        DynamicObjectCollection fillOrg = (DynamicObjectCollection)this.getModel().getValue("fillorg");
        List<Object> unitIds = new ArrayList(0);
        if (fillOrg.size() > 0) {
            unitIds = fillOrg.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        if (!HRObjectUtils.isEmpty((Object)adminOrgFilter)) {
            QFilter Qfilter = new QFilter("id", "in", adminOrgFilter.getValue()).and("iscurrentversion", "=", (Object)"1");
            if (unitIds.size() > 0) {
                QFilter unitIdsFilter = new QFilter("id", "not in", unitIds);
                showListForm.getListFilterParameter().setFilter(Qfilter.and(unitIdsFilter));
            } else {
                showListForm.getListFilterParameter().setFilter(Qfilter);
            }
        } else if (unitIds.size() > 0) {
            showListForm.getListFilterParameter().setFilter(new QFilter("id", "not in", unitIds).and("iscurrentversion", "=", (Object)"1"));
        } else {
            showListForm.getListFilterParameter().setFilter(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        showListForm.setCaption("\u586b\u62a5\u5355\u4f4d");
        this.getView().showForm((FormShowParameter)showListForm);
    }
}

