/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.collecttask;

import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sihc.soehrr.business.domain.collecttask.CollectTaskFormService;
import kd.sihc.soehrr.business.queryservice.CollectTaskQueryService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.common.constants.CollectTaskConstants;

public class CollectTaskIssuePlugin
extends HRDataBaseEdit
implements CollectTaskConstants {
    private static final CollectTaskFormService COLLECT_TASK_FORM_SERVICE = (CollectTaskFormService)ServiceFactory.getService(CollectTaskFormService.class);

    public void afterCreateNewData(EventObject eventObject) {
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        IDataModel dataModel = this.getModel();
        Long taskId = (Long)formShowParameter.getCustomParam("filltask");
        if (taskId != null) {
            this.setOrg(formShowParameter);
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("soehrr_filltask");
            DynamicObject task = hrBaseServiceHelper.loadSingle((Object)taskId);
            Long solution = task.getLong("solution");
            DynamicObject collectTask = CollectTaskQueryService.getByTaskId((Long)solution);
            COLLECT_TASK_FORM_SERVICE.setTaskIssueValue(dataModel, collectTask, task);
            this.getView().setEnable(Boolean.FALSE, new String[]{"reportclassify", "disunit", "year"});
            Date startDate = (Date)collectTask.get("starttime");
            DateTimeEdit startTime = (DateTimeEdit)this.getControl("starttime");
            startTime.setMinDate(COLLECT_TASK_FORM_SERVICE.getMinDate(startDate, "start"));
            DateTimeEdit endTime = (DateTimeEdit)this.getControl("endtime");
            endTime.setMinDate(COLLECT_TASK_FORM_SERVICE.getMinDate(startDate, "start"));
            Long id = (Long)this.getModel().getValue("id");
            if (id.equals(0L)) {
                long newID = ORM.create().genLongId("soehrr_collecttask");
                this.getModel().setValue("id", (Object)newID);
                COLLECT_TASK_FORM_SERVICE.bindParentAttachment(this.getView(), task);
                COLLECT_TASK_FORM_SERVICE.setHatchSolutionValue(task, this.getView(), startDate);
                this.getModel().setDataChanged(false);
                COLLECT_TASK_FORM_SERVICE.taskConfig(taskId, this.getView());
            }
        }
    }

    public void afterBindData(EventObject event) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long taskId = (Long)formShowParameter.getCustomParam("filltask");
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("batchsetting".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)view.getControl("taskfillobjs");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length != 0 && taskId != null) {
                COLLECT_TASK_FORM_SERVICE.openReportUnit((IFormPlugin)this, view);
            }
        } else if ("save".equals(operateKey)) {
            COLLECT_TASK_FORM_SERVICE.dataVerify(args, taskId, view);
        } else if ("publish".equals(operateKey)) {
            boolean result = COLLECT_TASK_FORM_SERVICE.dataVerify(args, taskId, view);
            if (result) {
                return;
            }
            COLLECT_TASK_FORM_SERVICE.fillUnitCheck(args, taskId, view);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("reportUnit".equals(closedCallBackEvent.getActionId())) {
            COLLECT_TASK_FORM_SERVICE.batchReportUnitSettingHandler(closedCallBackEvent, this.getView());
        }
    }

    private void setOrg(FormShowParameter formShowParameter) {
        String orgCache = this.getPageCache().get("org");
        if (HRStringUtils.isEmpty((String)orgCache)) {
            Object orgid = formShowParameter.getCustomParam("orgid");
            if (!Objects.isNull(orgid)) {
                this.getModel().setValue("org", (Object)Long.valueOf(String.valueOf(orgid)));
            } else {
                this.getModel().setValue("org", null);
            }
            this.getPageCache().put("org", "org");
        }
    }
}

