/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.collecttask;

import java.util.Date;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soecadm.business.servicehelper.ServiceFactory;
import kd.sihc.soebs.business.application.external.ManageOrgExternalService;
import kd.sihc.soebs.common.util.CommonListSelectCheck;
import kd.sihc.soehrr.business.application.report.CollectTaskApplicationService;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskService;
import kd.sihc.soehrr.common.constants.SoehrrProjectNameConstants;

public class CollectTaskListPlugin
extends AbstractListPlugin
implements CommonListSelectCheck {
    private static final HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("soehrr_collecttask");
    private static final CollectTaskApplicationService collectTaskApplicationService = (CollectTaskApplicationService)ServiceFactory.getService(CollectTaskApplicationService.class);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.setOrderBy("modifytime desc");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        for (int i = 0; i < listColumns.size(); ++i) {
            if (!"enable".equals(((IListColumn)listColumns.get(i)).getListFieldKey())) continue;
            listColumns.remove(i);
            break;
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        if (SoehrrProjectNameConstants.LIST_OP.contains(operationKey)) {
            this.listSelectCountCheck(this.getView(), evt, this.getSelectedRows());
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (HRStringUtils.equals((String)"number", (String)fieldName)) {
            IListView listView = (IListView)this.getView();
            long taskId = (Long)listView.getFocusRowPkId();
            DynamicObject dynamicObject = hrBaseServiceHelper.loadSingle((Object)taskId);
            HRBaseServiceHelper filltaskHelper = new HRBaseServiceHelper("soehrr_filltask");
            DynamicObject[] fillTasks = filltaskHelper.query("hatchsolution", new QFilter[]{new QFilter("hatchsolution", "=", (Object)taskId)});
            String taskStatus = dynamicObject.getString("status");
            if (!"A".equals(taskStatus)) {
                args.setCancel(true);
                this.showDataReportTaskPage(taskId);
            } else if (fillTasks.length > 0) {
                args.setCancel(true);
                long filltaskId = fillTasks[0].getLong("id");
                BaseShowParameter formShowParameter = new BaseShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setFormId("soehrr_colltaskfillissue");
                formShowParameter.setPageId("soehrr_colltaskfillissue" + filltaskId + RequestContext.get().getGlobalSessionId());
                if (taskId != 0L) {
                    formShowParameter.setPkId((Object)taskId);
                }
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.setCustomParam("filltask", (Object)filltaskId);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u91c7\u96c6\u4efb\u52a1", (String)"FillTaskListPlugin_10", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                DynamicObject currentUserFirstHrBu = ManageOrgExternalService.getCurrentUserFirstHrBu();
                if (currentUserFirstHrBu != null) {
                    formShowParameter.setCustomParam("orgid", currentUserFirstHrBu.get("id"));
                }
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    private void showDataReportTaskPage(Long taskId) {
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(billFormId);
        DynamicObject dynamicObject = hrBaseServiceHelper.loadSingle((Object)taskId);
        if (!this.checkPerm(dynamicObject)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201d\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u201c\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CollectTaskListPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("soehrr_clcttaskdet");
        formShowParameter.setPageId("soehrr_clcttaskdet" + dynamicObject.getPkValue() + RequestContext.get().getGlobalSessionId());
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u91c7\u96c6\u4efb\u52a1-", (String)"CollectTaskListPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]) + dynamicObject.getString("name"));
        formShowParameter.setCustomParam("id", dynamicObject.getPkValue());
        this.getView().showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("publish".equals(operateKey)) {
            if (listSelectedData.size() > 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4e00\u6761\u6570\u636e\u64cd\u4f5c\u3002", (String)"ResearchTaskListPlugin_0", (String)"sihc-soebs-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject collectTaskInfo = hrBaseServiceHelper.queryOne("id,status", new QFilter("id", "=", (Object)((Long)listSelectedData.getPrimaryKeyValues()[0])));
            if (HRObjectUtils.isEmpty((Object)collectTaskInfo)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CollectTaskPlugin_18", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("delete".equals(operateKey) && args.getListSelectedData().size() > 200) {
            this.getView().showTipNotification("\u6700\u591a\u53ef\u9009\u62e9200\u6761\u6570\u636e\u6267\u884c\u3002");
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("delete".equals(afterDoOperationEventArgs.getOperateKey()) && operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            FillTaskService.ins().deleteHatchsolution(successPkIds);
        }
        if ("publish".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            DynamicObject dynamicObject = hrBaseServiceHelper.queryOne("starttime,ismsg", operationResult.getSuccessPkIds().get(0));
            Date starttime = dynamicObject.getDate("starttime");
            boolean ismsg = dynamicObject.getBoolean("ismsg");
            if (ismsg) {
                boolean before = starttime.before(new Date());
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setFormId("soehrr_msgsendview_inh");
                formShowParameter.setPageId("soehrr_msgsendview_inh" + operationResult.getSuccessPkIds().get(0) + RequestContext.get().getGlobalSessionId() + "publish");
                formShowParameter.setCustomParam("id", (Object)((Long)operationResult.getSuccessPkIds().get(0)));
                if (before) {
                    formShowParameter.setCustomParam("parameteroptype", (Object)"publish");
                } else {
                    formShowParameter.setCustomParam("parameteroptype", (Object)"timed_publish");
                }
                this.getView().showForm(formShowParameter);
            }
        }
    }

    private boolean checkPerm(DynamicObject collectTaskInfo) {
        List hasPermOrgs;
        DynamicObject org = collectTaskInfo.getDynamicObject("org");
        DynamicObject disUnit = collectTaskInfo.getDynamicObject("disunit");
        AuthorizedOrgResult userAdminOrgs = collectTaskApplicationService.getUserAdminOrgs("soehrr_collecttask", "disunit");
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId(), (boolean)true);
        if (!HRObjectUtils.isEmpty((Object)userAdminOrgs)) {
            if (userAdminOrgs.isHasAllOrgPerm()) {
                return true;
            }
            hasPermOrgs = userAdminOrgs.getHasPermOrgs();
            if (!hasPermOrgs.contains(disUnit.getLong("id"))) {
                return false;
            }
        }
        if (!HRObjectUtils.isEmpty((Object)userHasPermOrgs)) {
            if (userHasPermOrgs.hasAllOrgPerm()) {
                return true;
            }
            hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
            if (!hasPermOrgs.contains(org.getLong("id"))) {
                return false;
            }
        }
        return true;
    }
}

