/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.collecttask;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.DimValueResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sihc.soebs.common.util.FormBizChangeUtils;
import kd.sihc.soehrr.business.domain.collecttask.CollectTaskFormService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.common.constants.CollectTaskConstants;

public class CollectTaskPlugin
extends HRDataBaseEdit
implements CollectTaskConstants,
UploadListener,
BeforeF7SelectListener {
    private static final CollectTaskFormService COLLECT_TASK_FORM_SERVICE = (CollectTaskFormService)ServiceFactory.getService(CollectTaskFormService.class);
    private static final Log LOG = LogFactory.getLog(CollectTaskPlugin.class);
    private static final HRBaseServiceHelper soehrrFilltask = new HRBaseServiceHelper("soehrr_filltask");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fillUnits = (BasedataEdit)this.getView().getControl("fillunits");
        fillUnits.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit belongPeriod = (BasedataEdit)this.getView().getControl("belongperiod");
        belongPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("ifinform", (Object)"1");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (OperationStatus.ADDNEW == formShowParameter.getStatus()) {
            this.getModel().setValue("starttime", (Object)new Date());
            this.getModel().setValue("tasksource", (Object)0);
            COLLECT_TASK_FORM_SERVICE.initBelowOrg(this.getView());
        } else if (OperationStatus.EDIT == formShowParameter.getStatus()) {
            COLLECT_TASK_FORM_SERVICE.setDate(this.getModel());
        }
        COLLECT_TASK_FORM_SERVICE.endTimeHandler(this.getView());
        COLLECT_TASK_FORM_SERVICE.setFieldVisable(this.getView());
        COLLECT_TASK_FORM_SERVICE.setYearComboItems(this.getView());
        DateTimeEdit startDateTime = (DateTimeEdit)this.getControl("starttime");
        startDateTime.setMinDate(HRDateTimeUtils.getNowDate());
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if ("fillunits".equals(propertyName)) {
            COLLECT_TASK_FORM_SERVICE.setFillUnitsShowParameter(beforeF7SelectEvent, (IFormPlugin)this, this.getView());
        } else if ("belongperiod".equals(propertyName)) {
            int row = beforeF7SelectEvent.getRow();
            DynamicObject periodTypeInfo = (DynamicObject)this.getModel().getValue("periodtype", row);
            beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(new QFilter("periodtype", "=", (Object)periodTypeInfo.getLong("id"))));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long taskId = (Long)formShowParameter.getCustomParam("filltask");
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("addreport".equals(operateKey)) {
            if (HRObjectUtils.isEmpty((Object)this.getModel().getValue("reportclassify"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u5206\u7c7b\u3002", (String)"CollectTaskPlugin_2", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            } else {
                COLLECT_TASK_FORM_SERVICE.openAddReportF7((IFormPlugin)this, this.getView());
            }
        } else if ("batchsetting".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("taskfillobjs");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BatchSettingPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            } else if (taskId == null) {
                COLLECT_TASK_FORM_SERVICE.openBatchSetting((IFormPlugin)this, this.getView());
            }
        } else if ("save".equals(operateKey)) {
            FieldTip orgTip = COLLECT_TASK_FORM_SERVICE.getFieldTip(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"CollectTaskPlugin_3", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), "org", !HRObjectUtils.isEmpty((Object)this.getModel().getValue("org")));
            FieldTip disUnitTip = COLLECT_TASK_FORM_SERVICE.getFieldTip(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"CollectTaskPlugin_3", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), "disunit", !HRObjectUtils.isEmpty((Object)this.getModel().getValue("disunit")));
            this.getView().showFieldTip(orgTip);
            this.getView().showFieldTip(disUnitTip);
            Set fillUnits = COLLECT_TASK_FORM_SERVICE.filterFillUnit(this.getModel());
            String message = ResManager.loadKDString((String)"\u65e0\u201d\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u201c\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CollectTaskPlugin_32", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]);
            this.checkPerm(args, fillUnits, message);
        } else if ("publish".equals(operateKey)) {
            Set fillUnits = COLLECT_TASK_FORM_SERVICE.filterFillUnit(this.getModel());
            String message = ResManager.loadKDString((String)"\u65e0\u201d\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u201c\u7684\u201c\u53d1\u5e03\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CollectTaskPlugin_31", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]);
            this.checkPerm(args, fillUnits, message);
        }
    }

    private void checkPerm(BeforeDoOperationEventArgs args, Set<Long> fillUnits, String message) {
        DimValueResult result = (DimValueResult)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getEntityDimValue", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "soehrr", "soehrr_collecttask", "47150e89000000ac", "fillunits"});
        if (!result.isAll()) {
            Set hasPermOrgs = result.getDimValueIds();
            List ids = hasPermOrgs.stream().map(Long::parseLong).collect(Collectors.toList());
            for (Long fillUnit : fillUnits) {
                if (ids.contains(fillUnit)) continue;
                this.getView().showErrorNotification(message);
                args.setCancel(true);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        event.setSkipNoField(true);
        this.getModel().setValue("status", (Object)"A");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormBizChangeUtils.setBizChanged((DynamicObject)dataEntity, (String[])new String[]{"exeunits", "status"});
        List bizChangedProperties = (List)dataEntity.getDataEntityState().getBizChangedProperties();
        if (bizChangedProperties.isEmpty()) {
            this.getModel().setDataChanged(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            this.updateHatchsolution(operationResult.getSuccessPkIds().get(0));
            this.refreshList();
        } else if ("publish".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            this.updateHatchsolution(operationResult.getSuccessPkIds().get(0));
            this.refreshList();
            Date starttime = (Date)this.getModel().getValue("starttime");
            boolean before = starttime.before(new Date());
            boolean ismsg = (Boolean)this.getModel().getValue("ismsg");
            if (ismsg) {
                this.openMsgShowForm(before);
            } else {
                this.showDataReportTaskPage();
            }
        } else if ("deleteentry".equals(operateKey)) {
            COLLECT_TASK_FORM_SERVICE.filterFillUnit(this.getModel());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("changeReportClass".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("taskfillobjs");
                DynamicObject reportclassify = (DynamicObject)this.getModel().getValue("reportclassify");
                COLLECT_TASK_FORM_SERVICE.fillTaskSetting(reportclassify, this.getView());
            } else {
                String id = this.getPageCache().get("oldClass");
                this.getPageCache().put("flag", "cancel");
                this.getModel().setValue("reportclassify", (Object)Long.parseLong(id));
            }
        } else if ("changeDisUnit".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                List cofigExeUnit = COLLECT_TASK_FORM_SERVICE.getCofigExeUnit(this.getView());
                DynamicObjectCollection taskFillObjEntry = this.getModel().getEntryEntity("taskfillobjs");
                if (!cofigExeUnit.isEmpty()) {
                    for (DynamicObject dynamicObject : taskFillObjEntry) {
                        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("fillunits");
                        dynamicObjectCollection.clear();
                        cofigExeUnit.forEach(fillUnitObj -> {
                            DynamicObject fillUnit = dynamicObjectCollection.addNew();
                            fillUnit.set("fbasedataid", fillUnitObj);
                        });
                    }
                } else {
                    for (DynamicObject dynamicObject : taskFillObjEntry) {
                        dynamicObject.set("fillunits", null);
                    }
                }
                this.getView().updateView("taskfillobjs");
            } else {
                this.getPageCache().put("flag", "cancel");
                this.getModel().setValue("disunit", (Object)Long.parseLong(this.getPageCache().get("oldUnit")));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        if ("addreport".equals(actionId)) {
            COLLECT_TASK_FORM_SERVICE.addReportCloseCallBackHandler(closedCallBackEvent, view);
        } else if ("fillunits".equals(actionId)) {
            COLLECT_TASK_FORM_SERVICE.fillUnitsCloseCallBackHandler(closedCallBackEvent, view);
        } else if ("batchsetting".equals(actionId)) {
            COLLECT_TASK_FORM_SERVICE.batchTaskSettingCallBackHandler(closedCallBackEvent, view);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        String name = args.getProperty().getName();
        IFormView view = this.getView();
        if ("datastarttime".equals(name) || "dataendtime".equals(name)) {
            COLLECT_TASK_FORM_SERVICE.modifyTime(name, rowIndex, view);
        } else if ("reportclassify".equals(name)) {
            COLLECT_TASK_FORM_SERVICE.reportClassifyChangeHandler(args, view, (IFormPlugin)this);
        } else if ("belongperiod".equals(name)) {
            COLLECT_TASK_FORM_SERVICE.belongPeriodChangeHandler(args, rowIndex, view);
        } else if ("year".equals(name)) {
            COLLECT_TASK_FORM_SERVICE.yearChangeHandler(view);
        } else if ("disunit".equals(name)) {
            COLLECT_TASK_FORM_SERVICE.disUnitChangeHanlder(args, view, (IFormPlugin)this);
        } else if ("starttime".equals(name)) {
            COLLECT_TASK_FORM_SERVICE.endTimeHandler(view);
            Date startTime = (Date)this.getModel().getValue("starttime");
            Date endTime = (Date)this.getModel().getValue("endtime");
            if (!HRObjectUtils.isEmpty((Object)endTime) && !HRObjectUtils.isEmpty((Object)startTime) && startTime.after(endTime)) {
                this.getModel().setValue("endtime", null);
            }
        } else if ("endtime".equals(name)) {
            COLLECT_TASK_FORM_SERVICE.endTimeChangeHandler(args, this.getView());
        } else if ("fillunits".equals(name)) {
            COLLECT_TASK_FORM_SERVICE.filterFillUnit(this.getModel());
        }
    }

    private void updateHatchsolution(Object collectTaskId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!HRObjectUtils.isEmpty((Object)formShowParameter.getCustomParam("filltask"))) {
            Long fillTaskId = (Long)formShowParameter.getCustomParam("filltask");
            DynamicObject fillTaskInfo = soehrrFilltask.queryOne("id,hatchsolution", new QFilter("id", "=", (Object)fillTaskId).toArray());
            fillTaskInfo.set("hatchsolution", collectTaskId);
            soehrrFilltask.update(new DynamicObject[]{fillTaskInfo});
        }
    }

    private void refreshList() {
        IFormView parentView = this.getView().getParentView();
        if (!HRObjectUtils.isEmpty((Object)parentView)) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    private void openMsgShowForm(boolean before) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("soehrr_msgsendview_inh");
        formShowParameter.setPageId("soehrr_msgsendview_inh" + this.getModel().getDataEntity().getPkValue() + RequestContext.get().getGlobalSessionId() + "publish");
        formShowParameter.setCustomParam("id", this.getModel().getDataEntity().getPkValue());
        formShowParameter.setCustomParam("page", (Object)"publishDetails");
        if (before) {
            formShowParameter.setCustomParam("parameteroptype", (Object)"publish");
        } else {
            formShowParameter.setCustomParam("parameteroptype", (Object)"timed_publish");
        }
        this.getView().showForm(formShowParameter);
    }

    private void showDataReportTaskPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("soehrr_clcttaskdet");
        formShowParameter.setPageId("soehrr_clcttaskdet" + this.getModel().getDataEntity(true).getPkValue() + RequestContext.get().getGlobalSessionId());
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u91c7\u96c6\u4efb\u52a1\u8be6\u60c5-", (String)"CollectTaskListPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]) + this.getModel().getValue("name"));
        formShowParameter.setCustomParam("id", this.getModel().getDataEntity(true).getPkValue());
        formShowParameter.setCustomParam("successsIdf", (Object)"publishSuccess");
        formShowParameter.setCustomParam("parameteroptype", (Object)"publish");
        this.getView().showForm(formShowParameter);
    }
}

