/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.collecttask;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soecadm.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.business.application.report.CollectTaskApplicationService;
import kd.sihc.soehrr.common.enums.MsgSendNameEnum;
import org.apache.commons.lang3.StringUtils;

public class CollectTaskformPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(CollectTaskformPlugin.class);
    private static final HRBaseServiceHelper soehrrCollecttask = new HRBaseServiceHelper("soehrr_collecttask");
    private static final HRBaseServiceHelper soehrrFilltask = new HRBaseServiceHelper("soehrr_filltask");
    private static final CollectTaskApplicationService collectTaskApplicationService = (CollectTaskApplicationService)ServiceFactory.getService(CollectTaskApplicationService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"flexactive0", "flexactive1", "flexactive2"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long collecttaskId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject collectTask = soehrrCollecttask.queryOne((Object)collecttaskId);
        String status = collectTask.getString("status");
        DynamicObject fillTaskInfo = soehrrFilltask.queryOne("id,taskstatus", new QFilter("solution", "=", (Object)collecttaskId).toArray());
        if ("E".equals(fillTaskInfo.getString("taskstatus"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap"});
        }
        Date endTime = collectTask.getDate("endtime");
        this.getModel().setValue("name", (Object)collectTask.getString("name"));
        this.getModel().setValue("endtime", (Object)endTime);
        this.getModel().setValue("taskstatus", (Object)status);
        if (!HRStringUtils.isEmpty((String)status)) {
            this.getPageCache().put("status", status);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.msgShowSuccess();
        String status = this.getPageCache().get("status");
        String fromSumReports = (String)this.getView().getFormShowParameter().getCustomParam("fromSumReports");
        if (!StringUtils.isEmpty((CharSequence)fromSumReports)) {
            this.clickActiveOrder(2);
            return;
        }
        if ("B".equals(status) || "C".equals(status)) {
            this.clickActiveOrder(1);
            return;
        }
        this.clickActiveOrder(0);
    }

    private void msgShowSuccess() {
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("successsIdf");
        String opType = (String)this.getView().getFormShowParameter().getCustomParam("parameteroptype");
        if (!HRStringUtils.isEmpty((String)customParam) && !HRStringUtils.isEmpty((String)opType)) {
            switch (customParam) {
                case "success": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"%1$s\u6210\u529f\u3002", (String)"MsgSendPlugin_12", (String)"sihc-soehrr-formplugin", (Object[])new Object[]{MsgSendNameEnum.valueByKey((String)opType).getVlaue()}));
                    break;
                }
                case "error": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5f85\u4e0a\u62a5\u7684\u586b\u62a5\u4efb\u52a1\uff0c\u5141\u8bb8\u53d1\u9001\u6d88\u606f\u3002", (String)"MsgSendPlugin_8", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "publishSuccess": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"MsgSendPlugin_15", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                }
            }
            this.getView().getFormShowParameter().setCustomParam("successsIdf", null);
            this.getView().getFormShowParameter().setCustomParam("parameteroptype", null);
            this.getView().cacheFormShowParameter();
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.contains("flexactive")) {
            int index = Integer.parseInt(key.substring(key.length() - 1));
            this.clickActiveOrder(index);
        }
    }

    private void clickActiveOrder(int order) {
        this.showNoDataPage();
        HashMap<String, String> selectedStyle = new HashMap<String, String>(3);
        HashMap<String, String> style = new HashMap<String, String>(3);
        String activeSelectStyle = "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgICAgIGJhY2tncm91bmQ6IHZhcigtLXRoZW1lLWNvbG9yLWxldmVsMSk7XG4gICAgICBjb2xvcjogdmFyKC0tdGhlbWUtY29sb3IpO1xufVxuJCBbaWRePVwibGFiY2lyY2xlXCJde1xuICAgICAgYmFja2dyb3VuZDogJ3RoZW1lQ29sb3InICFpbXBvcnRhbnQ7XG4gICAgICBoZWlnaHQ6MTRweCAhaW1wb3J0YW50O1xuICAgICAgd2lkdGg6MTRweCAhaW1wb3J0YW50O1xufSJ9";
        selectedStyle.put("cstyles", activeSelectStyle);
        String activeStyle = "eyJ0eXBlIjowLCJjb250ZW50IjoiJDpob3ZlcntcbiAgICAgYmFja2dyb3VuZDogdmFyKC0tdGhlbWUtY29sb3ItbGV2ZWwxKTtcbiAgICAgY29sb3I6IHZhcigtLXRoZW1lLWNvbG9yKTtcbn0ifQ==";
        style.put("cstyles", activeStyle);
        for (int index = 0; index < 8; ++index) {
            this.getView().updateControlMetadata("flexactive" + index, style);
        }
        this.getView().updateControlMetadata("flexactive" + order, selectedStyle);
        switch (order) {
            case 0: {
                this.showTaskInfo();
                break;
            }
            case 1: {
                this.showTaskTrack();
                break;
            }
            case 2: {
                this.showReportSum();
                break;
            }
        }
    }

    private void showTaskInfo() {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("soehrr_collecttaskinfo");
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId(this.getView().getFormShowParameter().getCustomParam("id"));
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.getOpenStyle().setTargetKey("flex_def");
        if (Objects.nonNull(this.getView().getFormShowParameter().getCustomParam("hasRight"))) {
            baseShowParameter.setHasRight(true);
        }
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void showTaskTrack() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("soehrr_tasktrace");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey("flex_def");
        listShowParameter.setCustomParam("collectTaskId", this.getView().getFormShowParameter().getCustomParam("id"));
        listShowParameter.setHasRight(true);
        String status = this.getPageCache().get("status");
        if (!HRStringUtils.isEmpty((String)status) && ("D".equals(status) || "E".equals(status))) {
            listShowParameter.setStatus(OperationStatus.VIEW);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showReportSum() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("soehrr_sumreports");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey("flex_def");
        listShowParameter.setCustomParam("collectTaskId", this.getView().getFormShowParameter().getCustomParam("id"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showNoDataPage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("flex_def");
        formShowParameter.setFormId("soebs_nodata");
        this.getView().showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("complete".equals(operate.getOperateKey())) {
            long collecttaskId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject collectTaskInfo = soehrrCollecttask.queryOne("id,status,org,disunit", new QFilter("id", "=", (Object)collecttaskId).toArray());
            if (!this.checkPerm(collectTaskInfo)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201d\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u201c\u7684\u201c\u5b8c\u6210\u4efb\u52a1\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CollectTaskListPlugin_2", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("B".equals(collectTaskInfo.getString("status"))) {
                DynamicObject fillTaskInfo = soehrrFilltask.queryOne("id,taskstatus", new QFilter("solution", "=", (Object)collecttaskId));
                if ("E".equals(fillTaskInfo.getString("taskstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u586b\u62a5\u4efb\u52a1\u672a\u751f\u6548,\u4e0d\u5141\u8bb8\u5b8c\u6210\u4efb\u52a1\u3002", (String)"CollectTaskformPlugin_3", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else {
                    this.showCompleteConfirm();
                }
            } else if ("C".equals(collectTaskInfo.getString("status"))) {
                this.showCompleteConfirm();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u8fdb\u884c\u4e2d\u6216\u5f85\u6c47\u603b\u7684\u91c7\u96c6\u4efb\u52a1\u5141\u8bb8\u5b8c\u6210\u3002", (String)"CollectTaskformPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("stop".equals(operate.getOperateKey())) {
            long collecttaskId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject collectTaskInfo = soehrrCollecttask.queryOne("id,status,org,disunit", new QFilter("id", "=", (Object)collecttaskId).toArray());
            if (!this.checkPerm(collectTaskInfo)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201d\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u201c\u7684\u201c\u7ec8\u6b62\u4efb\u52a1\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CollectTaskListPlugin_3", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("B".equals(collectTaskInfo.getString("status"))) {
                this.showStopConfirm();
            } else if ("C".equals(collectTaskInfo.getString("status"))) {
                this.showStopConfirm();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u8fdb\u884c\u4e2d\u6216\u5f85\u6c47\u603b\u7684\u91c7\u96c6\u4efb\u52a1\u5141\u8bb8\u7ec8\u6b62\u3002", (String)"CollectTaskformPlugin_11", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)"complete", (String)operateKey)) {
            ConfirmCallBackListener confirm = new ConfirmCallBackListener("completeConfirm", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b8c\u6210\u4efb\u52a1\u540e\u672a\u4e0a\u62a5\u7684\u586b\u62a5\u4efb\u52a1\u5c06\u4e0d\u518d\u4e0a\u62a5\uff0c\u5e76\u4e14\u4e0d\u53ef\u518d\u6c47\u603b\u62a5\u8868\u548c\u540c\u6b65\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u63d0\u4ea4\uff1f", (String)"CollectTaskformPlugin_0", (String)"sihc-soebs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if ("completeTask".equals(event.getCallBackId())) {
            if (result != MessageBoxResult.Yes) return;
            long collecttaskId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
            DynamicObject collecttaskInfo = soehrrCollecttask.loadDynamicObject(new QFilter("id", "=", (Object)collecttaskId).toArray());
            if (!this.checkPerm(collecttaskInfo)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201d\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u201c\u7684\u201c\u5b8c\u6210\u4efb\u52a1\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CollectTaskListPlugin_2", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
            String status = collecttaskInfo.getString("status");
            if (!HRStringUtils.equals((String)"B", (String)status) && !HRStringUtils.equals((String)"C", (String)status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u8fdb\u884c\u4e2d\u6216\u5f85\u6c47\u603b\u7684\u91c7\u96c6\u4efb\u52a1\u5141\u8bb8\u5b8c\u6210\u3002", (String)"CollectTaskformPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("variable_stopreason", ResManager.loadKDString((String)"\u91c7\u96c6\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u586b\u62a5\u4efb\u52a1\u672a\u4e0a\u62a5\u3002", (String)"CollectTaskformPlugin_2", (String)"sihc-soebs-formplugin", (Object[])new Object[0]));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"finish", (String)"soehrr_collecttask", (DynamicObject[])new DynamicObject[]{collecttaskInfo}, (OperateOption)operateOption);
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5b8c\u6210\u91c7\u96c6\u4efb\u52a1\u3002", (String)"CollectTaskformPlugin_9", (String)"sihc-soebs-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                return;
            }
            ValidateResultCollection validateResult = operationResult.getValidateResult();
            List validateErrors = validateResult.getValidateErrors();
            String message = ((OperateErrorInfo)((ValidateResult)validateErrors.get(0)).getAllErrorInfo().get(0)).getMessage();
            this.getView().showErrorNotification(message);
            return;
        }
        if (!"stopTask".equals(event.getCallBackId())) return;
        if (result != MessageBoxResult.Yes) return;
        long collecttaskId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject collecttaskInfo = soehrrCollecttask.loadDynamicObject(new QFilter("id", "=", (Object)collecttaskId).toArray());
        if (!this.checkPerm(collecttaskInfo)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201d\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u201c\u7684\u201c\u7ec8\u6b62\u4efb\u52a1\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CollectTaskListPlugin_3", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        String status = collecttaskInfo.getString("status");
        if (!HRStringUtils.equals((String)"B", (String)status) && !HRStringUtils.equals((String)"C", (String)status)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u8fdb\u884c\u4e2d\u6216\u5f85\u6c47\u603b\u7684\u91c7\u96c6\u4efb\u52a1\u5141\u8bb8\u7ec8\u6b62\u3002", (String)"CollectTaskformPlugin_11", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("variable_stopreason", ResManager.loadKDString((String)"\u91c7\u96c6\u4efb\u52a1\u5df2\u7ec8\u6b62\u3002", (String)"CollectTaskformPlugin_8", (String)"sihc-soebs-formplugin", (Object[])new Object[0]));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"stop", (String)"soehrr_collecttask", (DynamicObject[])new DynamicObject[]{collecttaskInfo}, (OperateOption)operateOption);
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u91c7\u96c6\u4efb\u52a1\u3002", (String)"CollectTaskformPlugin_10", (String)"sihc-soebs-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        ValidateResultCollection validateResult = operationResult.getValidateResult();
        List validateErrors = validateResult.getValidateErrors();
        String message = ((OperateErrorInfo)((ValidateResult)validateErrors.get(0)).getAllErrorInfo().get(0)).getMessage();
        this.getView().showErrorNotification(message);
    }

    private void showCompleteConfirm() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5b8c\u6210\u4efb\u52a1\u540e\u672a\u4e0a\u62a5\u7684\u586b\u62a5\u4efb\u52a1\u5c06\u4e0d\u53ef\u518d\u4e0a\u62a5\uff0c\u5e76\u4e14\u4e0d\u53ef\u518d\u6c47\u603b\u62a5\u8868\uff0c\u662f\u5426\u786e\u8ba4\u63d0\u4ea4\uff1f", (String)"CollectTaskformPlugin_6", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("completeTask", (IFormPlugin)this));
    }

    private void showStopConfirm() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec8\u6b62\u4efb\u52a1\u540e\u672a\u4e0a\u62a5\u7684\u586b\u62a5\u4efb\u52a1\u5c06\u4e0d\u53ef\u518d\u4e0a\u62a5\uff0c\u5e76\u4e14\u4e0d\u53ef\u518d\u6c47\u603b\u62a5\u8868\uff0c\u662f\u5426\u786e\u8ba4\u63d0\u4ea4\uff1f", (String)"CollectTaskformPlugin_7", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("stopTask", (IFormPlugin)this));
    }

    private boolean checkPerm(DynamicObject collectTaskInfo) {
        List hasPermOrgs;
        DynamicObject org = collectTaskInfo.getDynamicObject("org");
        DynamicObject disUnit = collectTaskInfo.getDynamicObject("disunit");
        AuthorizedOrgResult userAdminOrgs = collectTaskApplicationService.getUserAdminOrgs("soehrr_collecttask", "disunit");
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId(), (boolean)true);
        if (!HRObjectUtils.isEmpty((Object)userAdminOrgs)) {
            if (userAdminOrgs.isHasAllOrgPerm()) {
                return true;
            }
            hasPermOrgs = userAdminOrgs.getHasPermOrgs();
            if (!hasPermOrgs.contains(disUnit.getLong("id"))) {
                return false;
            }
        }
        if (!HRObjectUtils.isEmpty((Object)userHasPermOrgs)) {
            if (userHasPermOrgs.hasAllOrgPerm()) {
                return true;
            }
            hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
            if (!hasPermOrgs.contains(org.getLong("id"))) {
                return false;
            }
        }
        return true;
    }
}

