/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.collecttask;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soecadm.business.servicehelper.ServiceFactory;
import kd.sihc.soebs.business.application.external.ManageOrgExternalService;
import kd.sihc.soehrr.business.application.report.ReportVerApplicationService;
import kd.sihc.soehrr.business.application.report.ReportVerResult;
import kd.sihc.soehrr.business.domain.lock.LockApplicationService;
import kd.sihc.soehrr.business.queryservice.CollectTaskQueryService;
import kd.sihc.soehrr.business.queryservice.FillTaskQueryService;

public class FillTaskListPlugin
extends AbstractListPlugin {
    private static final FillTaskQueryService FILL_TASK_QUERY_SERVICE = (FillTaskQueryService)ServiceFactory.getService(FillTaskQueryService.class);
    private static final ReportVerApplicationService REPORT_VER_APPLICATION_SERVICE = (ReportVerApplicationService)ServiceFactory.getService(ReportVerApplicationService.class);
    private Map<Long, DynamicObject> taskMap = new HashMap<Long, DynamicObject>(1000);
    private Map<Long, DynamicObject> taskHatchSolutionMap = new HashMap<Long, DynamicObject>(1000);

    public void setFilter(SetFilterEvent event) {
        BillList formShowParameter = (BillList)event.getSource();
        String billFormId = formShowParameter.getBillFormId();
        if ("soehrr_filltask".equals(billFormId)) {
            event.setCustomQFilters(Collections.singletonList(new QFilter("taskstatus", "!=", (Object)"E")));
        }
        super.setFilter(event);
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObject[] taskList = FILL_TASK_QUERY_SERVICE.queryFillTasks(event.getPageData().stream().map(DataEntityBase::getPkValue).toArray());
        List hatchSolution = Arrays.stream(taskList).map(task -> task.get("hatchsolution")).collect(Collectors.toList());
        DynamicObject[] collectTask = CollectTaskQueryService.getByTaskId(hatchSolution);
        Map<Long, DynamicObject> objectMap = Arrays.stream(collectTask).collect(Collectors.toMap(task -> task.getLong("id"), task -> task));
        Map<Long, Long> longLongMap = Arrays.stream(taskList).collect(Collectors.toMap(task -> task.getLong("id"), task -> task.getLong("hatchsolution")));
        for (DynamicObject task2 : taskList) {
            Long taskId = task2.getLong("id");
            this.taskMap.put(taskId, task2);
            this.taskHatchSolutionMap.put(taskId, objectMap.get(longLongMap.get(taskId)));
        }
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        Object pkValue = event.getRowData().getPkValue();
        DynamicObject task = this.taskMap.get(pkValue);
        DynamicObject hatchSolution = this.taskHatchSolutionMap.get(pkValue);
        boolean flag = hatchSolution == null ? true : hatchSolution.getString("status").equals("A");
        String taskStatus = task.getString("taskstatus");
        String billStatus = task.getString("billstatus");
        String disUnit = task.getString("disunit.name");
        String exeUnit = task.getString("exeunit.name");
        if (event.getSource() instanceof ListOperationColumnDesc) {
            List operationColItems = (List)event.getFormatValue();
            operationColItems.stream().filter(operationColItem -> "fill".equals(operationColItem.getOperationKey())).forEach(operationColItem -> operationColItem.setVisible("A".equals(taskStatus) && ("A".equals(billStatus) || "G".equals(billStatus)) || "C".equals(taskStatus) && ("G".equals(billStatus) || "F".equals(billStatus))));
            operationColItems.stream().filter(operationColItem -> "issuetask".equals(operationColItem.getOperationKey())).forEach(operationColItem -> operationColItem.setVisible("A".equals(taskStatus) && "A".equals(billStatus) && !HRStringUtils.equals((String)disUnit, (String)exeUnit) && flag));
            operationColItems.stream().filter(operationColItem -> "viewissuetask".equals(operationColItem.getOperationKey())).forEach(operationColItem -> operationColItem.setVisible(hatchSolution != null && !flag));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (HRStringUtils.equals((String)"name", (String)fieldName)) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            long taskId = (Long)listView.getFocusRowPkId();
            DynamicObject dynamicObject = this.getDynamicObject(taskId);
            String billStatus = dynamicObject.getString("billstatus");
            BillShowParameter billShowParameter = this.openFillTaskParameter(dynamicObject);
            if ("A".equals(billStatus) || "G".equals(billStatus) || "F".equals(billStatus)) {
                billShowParameter.setStatus(OperationStatus.EDIT);
            } else {
                billShowParameter.setBillStatus(BillOperationStatus.AUDIT);
            }
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null) {
            long fillTaskId = (Long)this.getFocusRowPkId();
            if ("fill".equals(operateKey)) {
                DynamicObject[] mutexDys = LockApplicationService.checkHasMutex((String)"soehrr_filltask", Collections.singletonList(fillTaskId), (String)"modify");
                ConfirmCallBackListener backListener = new ConfirmCallBackListener("fillmutexbox", (IFormPlugin)this);
                this.mutexMessage(mutexDys, backListener);
                args.getOperationResult().setShowMessage(false);
                if (mutexDys.length == 0) {
                    this.showDataReportTaskPage(fillTaskId);
                }
            }
            if ("issuetask".equals(operateKey) && operationResult.isSuccess()) {
                this.showNewCreateDataCollectTaskPage(fillTaskId);
            }
            if ("viewissuetask".equals(operateKey)) {
                this.showDataCollectTaskDetailPage(fillTaskId);
            }
        }
    }

    private void showDataReportTaskPage(Long taskId) {
        DynamicObject dynamicObject = this.getDynamicObject(taskId);
        String taskStatus = dynamicObject.getString("taskstatus");
        BillShowParameter billShowParameter = this.openFillTaskParameter(dynamicObject);
        if ("A".equals(taskStatus) || "C".equals(taskStatus)) {
            billShowParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)billShowParameter);
        } else if ("B".equals(taskStatus) || "D".equals(taskStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5f85\u4e0a\u62a5\u6216\u5df2\u6253\u56de\u7684\u4efb\u52a1\u5141\u8bb8\u586b\u62a5\u3002", (String)"FillTaskListPlugin_5", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getDynamicObject(Long taskId) {
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(billFormId);
        return hrBaseServiceHelper.loadSingle((Object)taskId);
    }

    private BillShowParameter openFillTaskParameter(DynamicObject dynamicObject) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId(dynamicObject.getPkValue());
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setFormId("soehrr_filltaskapproval");
        billShowParameter.setPageId("soehrr_filltask" + dynamicObject.getPkValue() + RequestContext.get().getGlobalSessionId());
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u586b\u62a5\u4efb\u52a1-", (String)"FillTaskListPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]) + dynamicObject.getString("name"));
        billShowParameter.setCustomParam("id", dynamicObject.getPkValue());
        return billShowParameter;
    }

    private void showNewCreateDataCollectTaskPage(Long taskId) {
        DynamicObject dynamicObject = this.getDynamicObject(taskId);
        Long hatchSolution = dynamicObject.getLong("hatchsolution");
        String taskStatus = dynamicObject.getString("taskstatus");
        String billStatus = dynamicObject.getString("billstatus");
        if (!"A".equals(taskStatus) && !"A".equals(billStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u586b\u62a5\u4efb\u52a1\u72b6\u6001\u4e3a\u5f85\u4e0a\u62a5\u4e14\u5355\u636e\u72b6\u6001\u4e3a\u6682\u5b58\u7684\u4efb\u52a1\u5141\u8bb8\u4e0b\u53d1\u4efb\u52a1\u3002", (String)"FillTaskListPlugin_6", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
        }
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("soehrr_colltaskfillissue");
        formShowParameter.setPageId("soehrr_colltaskfillissue" + taskId + RequestContext.get().getGlobalSessionId());
        if (hatchSolution != 0L) {
            formShowParameter.setPkId((Object)hatchSolution);
        }
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("filltask", (Object)taskId);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u91c7\u96c6\u4efb\u52a1", (String)"FillTaskListPlugin_10", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
        DynamicObject currentUserFirstHrBu = ManageOrgExternalService.getCurrentUserFirstHrBu();
        if (currentUserFirstHrBu != null) {
            formShowParameter.setCustomParam("orgid", currentUserFirstHrBu.get("id"));
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void showDataCollectTaskDetailPage(Long taskId) {
        DynamicObject dynamicObject = this.getDynamicObject(taskId);
        long hatchSolution = dynamicObject.getLong("hatchsolution");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("soehrr_clcttaskdet");
        formShowParameter.setPageId("soehrr_clcttaskdet" + hatchSolution + RequestContext.get().getGlobalSessionId());
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u91c7\u96c6\u4efb\u52a1\u8be6\u60c5-", (String)"CollectTaskListPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]) + dynamicObject.getString("name"));
        formShowParameter.setCustomParam("id", (Object)hatchSolution);
        this.getView().showForm(formShowParameter);
    }

    public void mutexMessage(DynamicObject[] mutexDys, ConfirmCallBackListener backListener) {
        if (mutexDys != null && mutexDys.length != 0) {
            HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u67e5\u770b\u5355\u636e", (String)"FillTaskListPlugin_7", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)(mutexDys[0].getString("user.name") + " \u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002"), (String)"FillTaskListPlugin_8", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, backListener, (Map)btnNameMaps);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
            int size = this.getSelectedRows().size();
            if (size > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4e0a\u62a5\u3002", (String)"FillTaskListPlugin_3", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                Long fillTaskId = Long.valueOf(this.getSelectedRows().get(0).getPrimaryKeyValue().toString());
                DynamicObject fillTask = FILL_TASK_QUERY_SERVICE.queryFillTask(fillTaskId);
                String billStatus = fillTask.getString("billstatus");
                if (HRStringUtils.equals((String)billStatus, (String)"B") || HRStringUtils.equals((String)billStatus, (String)"D") || HRStringUtils.equals((String)billStatus, (String)"C")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5355\u636e\u72b6\u6001\u4e3a\u6682\u5b58\u6216\u5f85\u91cd\u65b0\u63d0\u4ea4\u6216\u5f85\u91cd\u65b0\u4e0a\u62a5\u7684\u6570\u636e\u624d\u5141\u8bb8\u4e0a\u62a5\u3002", (String)"FillTaskListPlugin_4", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else {
                    boolean showConfirm = this.showConfirm(fillTask);
                    if (showConfirm) {
                        args.setCancel(true);
                    }
                }
            }
        }
    }

    private boolean showConfirm(DynamicObject fillTask) {
        String result = this.getPageCache().get("submit_page_cache_id");
        if (result != null && "1".equals(result)) {
            this.getPageCache().put("submit_page_cache_id", "0");
            return false;
        }
        ReportVerResult reportVerResult = ReportVerApplicationService.checkTask((DynamicObject)fillTask);
        int valid = reportVerResult.isValid();
        if (valid == 1) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("submit_confirm_callback", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8868\u4e2d\u5b58\u5728\u6821\u9a8c\u672a\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e0a\u62a5\uff1f", (String)"FillTaskListPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            return true;
        }
        if (valid == 0) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("soehrr_validatorresults");
            formShowParameter.setCustomParam("checkresult", (Object)SerializationUtils.serializeToBase64((Object)reportVerResult));
            this.getView().showForm(formShowParameter);
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        DynamicObject dynamicObject;
        super.confirmCallBack(messageBoxClosedEvent);
        long fillTaskId = (Long)this.getFocusRowPkId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && "submit_confirm_callback".equals(messageBoxClosedEvent.getCallBackId())) {
            this.getPageCache().put("submit_page_cache_id", "1");
            this.getView().invokeOperation("submit");
        }
        if (MessageBoxResult.Yes.equals((Object)result) && "fillmutexbox".equals(messageBoxClosedEvent.getCallBackId())) {
            dynamicObject = this.getDynamicObject(fillTaskId);
            BillShowParameter billShowParameter = this.openFillTaskParameter(dynamicObject);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
        if (MessageBoxResult.Yes.equals((Object)result) && "issuemutexbox".equals(messageBoxClosedEvent.getCallBackId())) {
            dynamicObject = this.getDynamicObject(fillTaskId);
            long hatchsolution = dynamicObject.getLong("hatchsolution");
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId((Object)hatchsolution);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setFormId("soehrr_collecttask");
            billShowParameter.setPageId("soehrr_collecttask" + hatchsolution + RequestContext.get().getGlobalSessionId());
            billShowParameter.setCustomParam("id", dynamicObject.getPkValue());
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

