/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.collecttask;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.SpreadClientInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.CloseToolBtnCommand;
import kd.sdk.sihc.soehrr.business.spread.command.GetSpreadJsonCommand;
import kd.sdk.sihc.soehrr.business.spread.command.HideRbForConfigCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetActiveSheetCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetBtnVisCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetCellLinkCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetCellStyleCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetGCParamsCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetWorkbookOptions4FillTaskCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SpreadBatchInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.abs.SpreadCommand;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.enums.PageTypeEnum;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;
import kd.sihc.soebs.common.util.FormBizChangeUtils;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskCallBackHandler;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskHelper;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskService;
import kd.sihc.soehrr.business.domain.collecttask.SumReportHelper;
import kd.sihc.soehrr.business.domain.rpttpl.RptSampleFormHelper;
import kd.sihc.soehrr.business.queryservice.CollectTaskQueryService;
import kd.sihc.soehrr.business.queryservice.ReportQueryService;
import kd.sihc.soehrr.business.queryservice.RptTplQueryService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.common.spread.SpreadCBackParam;
import kd.sihc.soehrr.formplugin.web.spread.SihcSpreadBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class SumReportPlugin
extends SihcSpreadBasePlugin {
    private static final Log LOG = LogFactory.getLog(SumReportPlugin.class);
    private static final RptTplQueryService RPTTPLQUERYSERVICE = (RptTplQueryService)ServiceFactory.getService(RptTplQueryService.class);
    private static final RepCacheService repCacheService = (RepCacheService)kd.sihc.soebs.business.servicehelper.ServiceFactory.getService(RepCacheService.class);
    private static final kd.sihc.soehrr.business.domain.report.ReportQueryService reportQueryService = (kd.sihc.soehrr.business.domain.report.ReportQueryService)kd.sihc.soebs.business.servicehelper.ServiceFactory.getService(kd.sihc.soehrr.business.domain.report.ReportQueryService.class);
    private static final CollectTaskQueryService COLLECTTASKQUERYSERVICE = (CollectTaskQueryService)kd.sihc.soebs.business.servicehelper.ServiceFactory.getService(CollectTaskQueryService.class);
    private static final ReportQueryService REPORT_QUERY_SERVICE = (ReportQueryService)kd.sihc.soebs.business.servicehelper.ServiceFactory.getService(ReportQueryService.class);
    private static final String[] UN_CHANGED_PROPS = new String[]{"sheetcombo"};
    private static final HRBaseServiceHelper soehrrSumreports = new HRBaseServiceHelper("soehrr_sumreports");

    public void preOpenForm(PreOpenFormEventArgs event) {
        super.preOpenForm(event);
        BillShowParameter formShowParameter = (BillShowParameter)event.getFormShowParameter();
        Object fromBillListHyperLinkClick = formShowParameter.getCustomParam("fromBillListHyperLinkClick");
        if (!Objects.isNull(fromBillListHyperLinkClick)) {
            Long pkId = (Long)formShowParameter.getPkId();
            DynamicObject sumReportInfo = soehrrSumreports.queryOne("id,name", new QFilter("id", "=", (Object)pkId));
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u5df2\u6c47\u603b\u62a5\u8868-%s", (String)"CollectTaskformPlugin_12", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), sumReportInfo.getString("name")));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"filltaskpreviousstep", "filltasknextstep", "export"});
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List fillTaskIds = (List)this.getView().getFormShowParameter().getCustomParam("fillTaskIds");
        Long collectTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("collectTaskId");
        Map sumData = SumReportHelper.sumReport((List)fillTaskIds, (Long)collectTaskId);
        if (Objects.nonNull(sumData)) {
            String sheetJson = (String)sumData.get("sheetJson");
            this.getModel().setValue("trepcontent_tag", (Object)sheetJson);
            this.getModel().setValue("recordjson_tag", sumData.get("recordJson"));
            this.getModel().setValue("collecttask", (Object)collectTaskId);
            int len = fillTaskIds.size();
            for (int index = 0; index < len; ++index) {
                this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("filltask", fillTaskIds.get(index), index);
            }
            DynamicObject[] fillTaskDyns = FillTaskService.ins().getFillTasks(fillTaskIds, "exeunit");
            List orgIds = Arrays.stream(fillTaskDyns).sorted(Comparator.comparing(dynamicObject -> dynamicObject.getString("exeunit.sortcode").length(), Comparator.naturalOrder())).map(k -> k.getDynamicObject("exeunit")).collect(Collectors.toList());
            DynamicObjectCollection fillOrg = (DynamicObjectCollection)this.getModel().getValue("sumorgs");
            for (DynamicObject obj : orgIds) {
                DynamicObject dynamicObject2 = fillOrg.addNew();
                dynamicObject2.set("fbasedataid", (Object)obj);
            }
            this.getModel().setValue("sumorgs", (Object)fillOrg);
            JSONObject spreadJson = SpreadJsonHelper.getSpreadJsonByUncompress((String)sheetJson);
            List sheetNameList = SpreadJsonHelper.getSheetNameList((JSONObject)spreadJson);
            List<String> sheetNamesDesc = this.getSheetNamesDesc(sheetNameList);
            String importReportData = sheetNamesDesc.isEmpty() ? " " : String.join((CharSequence)"\r\n", sheetNamesDesc);
            this.getModel().setValue("importreportdata", (Object)importReportData);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String json = FillTaskHelper.getJson((IFormView)this.getView());
        if (StringUtils.isEmpty((CharSequence)json)) {
            return;
        }
        String uncompressJson = GzipTools.uncompressJson((String)json);
        JSONObject object = JSONObject.parseObject((String)uncompressJson);
        FillTaskHelper.initEntrySpreadData((IFormView)this.getView(), (JSONObject)object);
        SpreadClientInvoker.invokeSetSpreadJsonMethod((IClientViewProxy)this.getCliViProxy(), (String)this.getSpreadKey(), (Object)json);
        SetGCParamsCommand setGCParamsCommand = new SetGCParamsCommand();
        SetWorkbookOptions4FillTaskCommand setWorkbookOptionsCommand = new SetWorkbookOptions4FillTaskCommand(Boolean.valueOf(false));
        CloseToolBtnCommand closeToolBtnCommand = new CloseToolBtnCommand();
        SetBtnVisCommand setBtnVisCommand = new SetBtnVisCommand(Boolean.valueOf(false));
        HideRbForConfigCommand hideCommand = new HideRbForConfigCommand(PageTypeEnum.FILLTASKVIEW.getNum());
        SpreadBatchInvoker.getInstance((SpreadModelParam)this.getSpreadParam(), (List)Lists.newArrayList((Object[])new SpreadCommand[]{setGCParamsCommand, setWorkbookOptionsCommand, closeToolBtnCommand, setBtnVisCommand, hideCommand})).call();
        List fillTaskIds = (List)this.getView().getFormShowParameter().getCustomParam("fillTaskIds");
        FillTaskService.ins().initCacheData4SumReport(super.getSpreadParam(), fillTaskIds);
        this.getPageCache().put("initCacheData4SumReport", "initCacheData4SumReport");
        FillTaskHelper.setEnableStep((IFormView)this.getView(), (JSONObject)object);
        if (HRStringUtils.isEmpty((String)this.getPageCache().get("legend"))) {
            RptSampleFormHelper.loadLegend4FillTask((IFormView)this.getView());
        }
        this.setSheetAndButtonShow();
        this.lockAllSheet();
        this.setSpreadLink();
        Object fromBillListHyperLinkClick = this.getView().getFormShowParameter().getCustomParam("fromBillListHyperLinkClick");
        if (!Objects.isNull(fromBillListHyperLinkClick)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"export"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "number", "description"});
            BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            Long pkId = (Long)formShowParameter.getPkId();
            DynamicObject sumReportInfo = soehrrSumreports.queryOne("id,name", new QFilter("id", "=", (Object)pkId));
            this.getView().setFormTitle(new LocaleString(String.format(ResManager.loadKDString((String)"\u5df2\u6c47\u603b\u62a5\u8868-%s", (String)"CollectTaskformPlugin_12", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), sumReportInfo.getString("name"))));
            this.getView().getFormShowParameter().setCaption(String.format(ResManager.loadKDString((String)"\u5df2\u6c47\u603b\u62a5\u8868-%s", (String)"CollectTaskformPlugin_12", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), this.getModel().getValue("name")));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"export"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
        }
    }

    private void setSpreadLink() {
        String sheetName = this.getModel().getDataEntity().getString("sheetcombo");
        SheetManager sheetManager = super.getSpreadParam().getSheetManager();
        List lockAreas = RepCacheService.ins().getExistAreaByType(sheetManager.getInvoker(), AreaSettingEnum.LOCK);
        repCacheService.getFillOrTotalArea(sheetManager.getInvokerByName(sheetName));
        List points = SumReportHelper.getLinkedData((String)this.getModel().getDataEntity().getString("recordjson_tag"), (String)sheetName, (List)lockAreas);
        if (CollectionUtils.isNotEmpty((Collection)points)) {
            for (String point : points) {
                SetCellLinkCommand setCellLinkCommand = new SetCellLinkCommand(MapInitHelper.ofMap((Object)"si", (Object)sheetName, (Object)"range", (Object)point));
                setCellLinkCommand.invokeMethod(this.getCliViProxy(), this.getSpreadKey());
            }
            SetCellStyleCommand setCellStyleCommand = new SetCellStyleCommand(MapInitHelper.ofMap((Object)"style", (Object)MapInitHelper.ofMap((Object)"td", (Object)0), (Object)"range", (Object)repCacheService.getFillOrTotalArea(sheetManager.getInvokerByName(sheetName)).getAreaPoint()));
            setCellStyleCommand.invokeMethod(this.getCliViProxy(), this.getSpreadKey());
        }
    }

    @Override
    public void spreadCallBack(SpreadCBackParam param) {
        String methodName = param.getMethodName();
        if (HRStringUtils.isEmpty((String)methodName)) {
            return;
        }
        if (HRStringUtils.equals((String)"linkCallBack", (String)methodName)) {
            String cache_json = (String)this.getView().getFormShowParameter().getCustomParam("cache_json");
            if (Objects.nonNull(cache_json)) {
                this.showLinkDetails(param.getArg());
            } else {
                this.getView().getFormShowParameter().setCustomParam("cache_linkCell", (Object)param.getArg());
                this.getView().cacheFormShowParameter();
                GetSpreadJsonCommand spreadJsonCommand = new GetSpreadJsonCommand(CallBackEnum.GET_AFTER_SUMJSON.getM());
                spreadJsonCommand.invokeMethod(this.getCliViProxy(), this.getSpreadKey());
            }
            return;
        }
        if (HRStringUtils.equals((String)CallBackEnum.GET_AFTER_SUMJSON.getM(), (String)methodName)) {
            this.getView().getFormShowParameter().setCustomParam("cache_json", (Object)param.getArg());
            this.getView().cacheFormShowParameter();
            this.showLinkDetails((String)this.getView().getFormShowParameter().getCustomParam("cache_linkCell"));
            return;
        }
        SheetManager sheetManager = super.getSpreadParam().getSheetManager();
        sheetManager.setSheetCache(this.getPageCache());
        FillTaskCallBackHandler.ins().invokeMethod(methodName, param.getArg(), super.getSpreadParam(), (IFormPlugin)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("sheetcombo".equals(name) && !HRStringUtils.isEmpty((String)this.getPageCache().get("initCacheData4SumReport"))) {
            this.setSheetAndButtonShow();
            this.setSpreadLink();
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void click(EventObject evt) {
        GetSpreadJsonCommand spreadJsonCommand;
        super.click(evt);
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        if ("filltaskpreviousstep".equals(key)) {
            spreadJsonCommand = new GetSpreadJsonCommand(CallBackEnum.PREVIOUS_STEP.getM());
            spreadJsonCommand.invokeMethod(this.getCliViProxy(), this.getSpreadKey());
        }
        if ("filltasknextstep".equals(key)) {
            spreadJsonCommand = new GetSpreadJsonCommand(CallBackEnum.NEXT_STEP.getM());
            spreadJsonCommand.invokeMethod(this.getCliViProxy(), this.getSpreadKey());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String parentViewId = (String)this.getView().getFormShowParameter().getCustomParam("parentViewId");
            if (HRStringUtils.isEmpty((String)parentViewId) || Objects.isNull(this.getView().getView(parentViewId))) {
                this.showDataReportTaskPage();
                this.getView().close();
            } else {
                FormShowParameter formShowParameter = this.getView().getView(parentViewId).getFormShowParameter();
                Long taskId = ((DynamicObject)this.getModel().getValue("collecttask")).getLong("id");
                formShowParameter.setCustomParam("id", (Object)taskId);
                formShowParameter.setCustomParam("fromSumReports", (Object)"fromSumReports");
                this.getView().getView(parentViewId).invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getView(parentViewId));
                this.getView().close();
            }
        } else if ("export".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            map.put("fileName", String.join((CharSequence)"_", ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue(), LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)));
            SpreadClientInvoker.invokeExportExcelFileMethod((IClientViewProxy)this.getCliViProxy(), (String)this.getSpreadKey(), (Object)map);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormBizChangeUtils.setBizChanged((DynamicObject)dataEntity, (String[])UN_CHANGED_PROPS);
    }

    private void showLinkDetails(String cell) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        JSONObject recordJson = JSONObject.parseObject((String)dataEntity.getString("recordjson_tag"));
        JSONObject recordSheetObj = recordJson.getJSONObject(dataEntity.getString("sheetcombo"));
        JSONArray record = recordSheetObj.getJSONObject("cellSumDetail").getJSONArray(cell);
        JSONArray orgs = recordSheetObj.getJSONArray("orgs");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("soehrr_penetrateview");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("record", (Object)record);
        formShowParameter.setCustomParam("orgs", (Object)orgs);
        String cache_json = (String)this.getView().getFormShowParameter().getCustomParam("cache_json");
        String uncompressJson = GzipTools.uncompressJson((String)cache_json);
        JSONObject object = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        JSONObject sheet = sheets.getJSONObject(dataEntity.getString("sheetcombo"));
        JSONObject data = sheet.getJSONObject("data");
        JSONObject dataTable = data.getJSONObject("dataTable");
        String sumValue = dataTable.getJSONObject(cell.split(":")[0]).getJSONObject(cell.split(":")[1]).getString("value");
        formShowParameter.setCustomParam("sumValue", (Object)sumValue);
        this.getView().showForm(formShowParameter);
    }

    private void setSheetAndButtonShow() {
        String activeSheetName = this.getActiveSheetName();
        LOG.info("log5 current sheet name {} ", (Object)activeSheetName);
        List orderSheetNames = FillTaskHelper.getOrderSheetNames((IFormView)this.getView());
        int index = 0;
        for (int i = 0; i < orderSheetNames.size(); ++i) {
            if (!activeSheetName.equals(orderSheetNames.get(i))) continue;
            index = i;
        }
        SheetManager sheetManager = super.getSheetData();
        if (Objects.nonNull(sheetManager)) {
            sheetManager.selectSheet(activeSheetName);
            sheetManager.setSheetCache(this.getView());
        }
        this.showOrHiddenLabel(activeSheetName);
        SetActiveSheetCommand setActiveSheetCommand = new SetActiveSheetCommand(activeSheetName);
        setActiveSheetCommand.invokeMethod(this.getCliViProxy(), this.getSpreadKey());
        if (orderSheetNames.size() <= 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"filltaskpreviousstep"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"filltasknextstep"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"sheetcombo"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"sheetcombo"});
            if (index == 0) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"filltaskpreviousstep"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"filltasknextstep"});
            } else if (index == orderSheetNames.size() - 1) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"filltaskpreviousstep"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"filltasknextstep"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"filltaskpreviousstep"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"filltasknextstep"});
            }
        }
    }

    private String getActiveSheetName() {
        DynamicObject dy = this.getModel().getDataEntity(true);
        LOG.info("log1 current sheet name {} ", (Object)dy.getString("sheetcombo"));
        return dy.getString("sheetcombo");
    }

    private List<String> getSheetNamesDesc(List<String> sheetNames) {
        if (sheetNames.isEmpty()) {
            return Collections.emptyList();
        }
        Map maps = RPTTPLQUERYSERVICE.queryImportDataNameByNumber(sheetNames);
        if (maps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList sheetNameDesc = Lists.newArrayListWithCapacity((int)maps.size());
        for (String sheetName : sheetNames) {
            if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)maps.get(sheetName)))) continue;
            sheetNameDesc.add(maps.get(sheetName));
        }
        return sheetNameDesc;
    }

    private void showOrHiddenLabel(String activeSheetName) {
        for (AreaSettingEnum areaSettingEnum : AreaSettingEnum.values()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"containflex" + areaSettingEnum.getValue()});
        }
        LOG.info("log7 current sheet name {} ", (Object)activeSheetName);
        List fillTaskIds = (List)this.getView().getFormShowParameter().getCustomParam("fillTaskIds");
        DynamicObject rptTplByFillTask = reportQueryService.getRptTplByFillTasks(fillTaskIds, activeSheetName);
        LOG.info("log8 rptTplByFillTask {}", (Object)rptTplByFillTask);
        if (HRObjectUtils.isEmpty((Object)rptTplByFillTask)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelapyear"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"labelap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"labelapyear"});
        boolean isCycrpt = false;
        DynamicObject[] reportInfo = REPORT_QUERY_SERVICE.queryReportByFillTask(((Long)fillTaskIds.get(0)).longValue());
        if (reportInfo.length > 0) {
            DynamicObject rptClass = reportInfo[0].getDynamicObject("reportclassify");
            isCycrpt = rptClass.getBoolean("iscycrpt");
        }
        String year = rptTplByFillTask.getString("year");
        String beLongPeriodName = rptTplByFillTask.getDynamicObject("belongperiod").getString("name");
        if (isCycrpt) {
            Label labelapYear = (Label)this.getView().getControl("labelapyear");
            Label labelap = (Label)this.getView().getControl("labelap");
            labelapYear.setText(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"FillTaskPlugin_2", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), year));
            labelap.setText(beLongPeriodName);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelapyear"});
        }
        List reportCacheDtos = FillTaskHelper.getAreaDataBySheet((SpreadModelParam)super.getSpreadParam());
        LOG.info("log10  reportCacheDtos.size {}", (Object)(reportCacheDtos.isEmpty() ? 0 : reportCacheDtos.size()));
        if (!reportCacheDtos.isEmpty()) {
            CacheObjInvoker invokerByName = super.getSheetData().getInvokerByName(this.getActiveSheetName());
            List totalSummary = repCacheService.getExistAreaByType(invokerByName, AreaSettingEnum.TOTAL_SUMMARY);
            for (ReportCacheDto reportCacheDto : reportCacheDtos) {
                AreaSettingDto areaSettingDto;
                AreaSettingEnum areaSetting;
                if (!(reportCacheDto instanceof AreaSettingDto) || (areaSetting = (areaSettingDto = (AreaSettingDto)reportCacheDto).getAreaSetting()) == AreaSettingEnum.CAL && HRCollUtil.isNotEmpty((Collection)totalSummary)) continue;
                this.getView().setVisible(Boolean.TRUE, new String[]{"containflex" + areaSetting.getValue()});
            }
        }
    }

    private void lockAllSheet() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
        List orderSheetNames = FillTaskHelper.getOrderSheetNames((IFormView)this.getView());
        List indexNums = IntStream.range(0, orderSheetNames.size()).boxed().collect(Collectors.toCollection(() -> Lists.newArrayListWithCapacity((int)orderSheetNames.size())));
        Map<String, List> lockSheetMap = Collections.singletonMap("si", indexNums);
        SpreadClientInvoker.invokeLockSheetMethod((IClientViewProxy)this.getCliViProxy(), (String)this.getSpreadKey(), lockSheetMap);
    }

    private void unLockAllSheet() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"attachmentpanelap"});
        List orderSheetNames = FillTaskHelper.getOrderSheetNames((IFormView)this.getView());
        List indexNums = IntStream.range(0, orderSheetNames.size()).boxed().collect(Collectors.toCollection(() -> Lists.newArrayListWithCapacity((int)orderSheetNames.size())));
        Map<String, List> lockSheetMap = Collections.singletonMap("si", indexNums);
        SpreadClientInvoker.invokeUnLockSheetMethod((IClientViewProxy)this.getCliViProxy(), (String)this.getSpreadKey(), lockSheetMap);
    }

    private void showDataReportTaskPage() {
        Long taskId = ((DynamicObject)this.getModel().getValue("collecttask")).getLong("id");
        DynamicObject dynamicObject = COLLECTTASKQUERYSERVICE.getCollectTask(taskId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("soehrr_clcttaskdet");
        formShowParameter.setPageId("soehrr_clcttaskdet" + taskId + RequestContext.get().getGlobalSessionId());
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u91c7\u96c6\u4efb\u52a1\u8be6\u60c5-", (String)"CollectTaskListPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]) + dynamicObject.getString("name"));
        formShowParameter.setCustomParam("id", (Object)taskId);
        formShowParameter.setCustomParam("fromSumReports", (Object)"fromSumReports");
        this.getView().showForm(formShowParameter);
    }
}

