/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.collecttask;

import com.alibaba.fastjson.JSONArray;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDynamicListBasePlugin;
import kd.sdk.sihc.soecadm.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.business.domain.collecttask.CollectTaskService;
import kd.sihc.soehrr.business.queryservice.FillTaskQueryService;

public class TaskTraceListPlugin
extends HRDynamicListBasePlugin {
    private static final Log LOG = LogFactory.getLog(TaskTraceListPlugin.class);
    private static final FillTaskQueryService FILL_TASK_QUERY_SERVICE = (FillTaskQueryService)ServiceFactory.getService(FillTaskQueryService.class);
    private Map<Long, DynamicObject> fillTaskMap = new HashMap<Long, DynamicObject>(1000);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        Object customParam = this.getView().getFormShowParameter().getCustomParam("collectTaskId");
        if (customParam != null) {
            event.getQFilters().add(new QFilter("solution", "=", customParam));
            LOG.info("TaskTraceListPlugin.setFilter setMainOrgQFilter={},setDataPermQFilters={},setSpecialDataPermQFilter={}", new Object[]{event.getMainOrgQFilter(), event.getDataPermQFilters(), event.getBasedataCoreQFilters()});
            event.setMainOrgQFilter(null);
            event.setDataPermQFilters(Collections.emptyList());
            event.setSpecialDataPermQFilter(null);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        for (int i = 0; i < listColumns.size(); ++i) {
            if (!"exeunit.sortcode".equals(((IListColumn)listColumns.get(i)).getListFieldKey())) continue;
            listColumns.remove(i);
            break;
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObject[] taskList;
        super.beforePackageData(event);
        for (DynamicObject task : taskList = FILL_TASK_QUERY_SERVICE.queryFillTasks(event.getPageData().stream().map(DataEntityBase::getPkValue).toArray())) {
            Long taskId = task.getLong("id");
            this.fillTaskMap.put(taskId, task);
        }
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        Object pkValue = event.getRowData().getPkValue();
        DynamicObject task = this.fillTaskMap.get(pkValue);
        String taskStatus = task.getString("taskstatus");
        if ("E".equals(taskStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1", "baritemap2"});
        }
        Date reportTime = task.getDate("reporttime");
        if (event.getSource() instanceof ListOperationColumnDesc) {
            List operationColItems = (List)event.getFormatValue();
            operationColItems.stream().filter(operationColItem -> "traceview".equals(operationColItem.getOperationKey())).forEach(operationColItem -> operationColItem.setVisible("B".equals(taskStatus) || "C".equals(taskStatus) || "D".equals(taskStatus) && reportTime != null || "F".equals(taskStatus)));
            operationColItems.stream().filter(operationColItem -> "repulsebox".equals(operationColItem.getOperationKey())).forEach(operationColItem -> operationColItem.setVisible("B".equals(taskStatus)));
            operationColItems.stream().filter(operationColItem -> "urgent".equals(operationColItem.getOperationKey())).forEach(operationColItem -> operationColItem.setVisible("A".equals(taskStatus) || "C".equals(taskStatus)));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (OperationStatus.VIEW == formShowParameter.getStatus()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap1", "baritemap2"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        operate.getOption().setVariableValue("skipCheckDataPermission", String.valueOf(true));
        Long collectTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("collectTaskId");
        if (!CollectTaskService.ins().checkPerm(collectTaskId, this.getView())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u201d\u7684\u201c%s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskTraceListPlugin_5", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), operate.getOperateName()));
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if ("sumreport".equals(operateKey)) {
            if (operationResult.isSuccess()) {
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setFormId("soehrr_sumreports");
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCaption(ResManager.loadKDString((String)"\u9884\u89c8\u6c47\u603b\u62a5\u8868", (String)"TaskTraceListPlugin_2", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                showParameter.setCustomParam("parentViewId", (Object)this.getView().getParentView().getPageId());
                showParameter.setCustomParam("fillTaskIds", (Object)args.getOperationResult().getSuccessPkIds());
                Long collectTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("collectTaskId");
                showParameter.setCustomParam("collectTaskId", (Object)collectTaskId);
                showParameter.setHasRight(true);
                showParameter.setCustomParam("fillTaskTraceList", (Object)true);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                String message = ((IOperateInfo)args.getOperationResult().getAllErrorOrValidateInfo().get(0)).getMessage();
                if (message.contains("collectTaskValid") || message.contains("fillTaskValid")) {
                    if (message.contains("collectTaskValid")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u8fdb\u884c\u4e2d\u6216\u5f85\u6c47\u603b\u7684\u91c7\u96c6\u4efb\u52a1\u5141\u8bb8\u6c47\u603b\u3002", (String)"TaskTraceListPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                    } else if (message.contains("fillTaskValid")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5df2\u4e0a\u62a5\u7684\u586b\u62a5\u4efb\u52a1\u5141\u8bb8\u6c47\u603b\u3002", (String)"TaskTraceListPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                    }
                    args.getOperationResult().setAllErrorInfo(Collections.emptyList());
                    operationResult.setValidateResult(new ValidateResultCollection());
                    operationResult.setSuccess(true);
                }
            }
        }
        if ("urgent".equals(operateKey)) {
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds != null && successPkIds.size() > 0) {
                operationResult.setSuccess(true);
                operationResult.setAllErrorInfo(Collections.emptyList());
                operationResult.setValidateResult(new ValidateResultCollection());
            }
            if (operationResult.isSuccess()) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setFormId("soehrr_msgsendview_inh");
                List successPkIdsList = JSONArray.parseArray((String)operationResult.getSuccessPkIds().toString(), Long.class);
                formShowParameter.setCustomParam("id", (Object)successPkIdsList);
                formShowParameter.setCustomParam("parameteroptype", (Object)"urgent");
                formShowParameter.setHasRight(true);
                formShowParameter.setCustomParam("fillTaskTraceList", (Object)true);
                this.getView().showForm(formShowParameter);
            }
        }
        if (operationResult.isSuccess()) {
            DynamicObject fillTask;
            long taskId = (Long)this.getFocusRowPkId();
            if ("traceview".equals(operateKey)) {
                fillTask = FILL_TASK_QUERY_SERVICE.queryFillTask(Long.valueOf(taskId));
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setFormId("soehrr_filltask");
                showParameter.setPageId(this.getView().getPageId() + taskId);
                showParameter.setPkId(fillTask.getPkValue());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                String taskStatus = fillTask.getString("taskstatus");
                String billStatus = fillTask.getString("billstatus");
                if ("B".equals(taskStatus)) {
                    showParameter.setStatus(OperationStatus.EDIT);
                } else if ("F".equals(billStatus) || "H".equals(billStatus)) {
                    showParameter.setBillStatus(BillOperationStatus.AUDIT);
                }
                showParameter.setCustomParam("filltask", (Object)SerializationUtils.serializeToBase64((Object)fillTask));
                showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u586b\u62a5\u4efb\u52a1-", (String)"FillTaskListPlugin_9", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]) + fillTask.getString("name"));
                showParameter.setCustomParam("from", (Object)"trace");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "filltaskview"));
                showParameter.setHasRight(true);
                showParameter.setCustomParam("fillTaskTraceList", (Object)true);
                this.getView().showForm((FormShowParameter)showParameter);
            }
            if ("repulsebox".equals(operateKey)) {
                fillTask = FILL_TASK_QUERY_SERVICE.queryFillTask(Long.valueOf(taskId));
                if (!"B".equals(fillTask.getString("taskstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5df2\u4e0a\u62a5\u7684\u586b\u62a5\u4efb\u52a1\u5141\u8bb8\u6253\u56de\u3002", (String)"FillTaskListPlugin_11", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setFormId("soehrr_msgsendview");
                formShowParameter.setPageId("soehrr_msgsendview" + taskId + RequestContext.get().getGlobalSessionId());
                formShowParameter.setCustomParam("id", (Object)taskId);
                formShowParameter.setCustomParam("parameteroptype", (Object)"repulse");
                formShowParameter.setCustomParam("filltask", (Object)SerializationUtils.serializeToBase64((Object)fillTask));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "repulsebox"));
                formShowParameter.setHasRight(true);
                formShowParameter.setCustomParam("fillTaskTraceList", (Object)true);
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("filltaskview".equals(closedCallBackEvent.getActionId()) || "repulsebox".equals(closedCallBackEvent.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

