/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.cyclecollecttask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sihc.soehrr.business.domain.cyccollecttask.CycCollService;
import kd.sihc.soehrr.business.domain.cyccollecttask.disdatehandler.AbstractDateHandler;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;

public class BatchSettingFromPlugin
extends AbstractFormPlugin {
    private CycCollService cycCollService = (CycCollService)ServiceFactory.getService(CycCollService.class);

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Long periodTypeId = (Long)this.getView().getFormShowParameter().getCustomParam("periodtype");
        if (!HRObjectUtils.isEmpty((Object)periodTypeId)) {
            this.getModel().setValue("periodtype", (Object)periodTypeId);
        }
        this.initDropDownData(periodTypeId);
    }

    private void initDropDownData(long periodTypeId) {
        ComboItem item;
        AbstractDateHandler dateHandler = this.cycCollService.getHandlerByPeriodTypeId(periodTypeId);
        List months = dateHandler.monthDropDowns();
        List days = dateHandler.dayDropDowns();
        ArrayList monthComboItems = Lists.newArrayListWithExpectedSize((int)months.size());
        ArrayList dayComboItems = Lists.newArrayListWithExpectedSize((int)days.size());
        int montHCount = 1;
        for (String month : months) {
            item = new ComboItem();
            String monthVal = String.valueOf(montHCount);
            item.setValue(monthVal);
            item.setCaption(new LocaleString(month));
            item.setId(monthVal);
            monthComboItems.add(item);
            ++montHCount;
        }
        for (Integer day : days) {
            item = new ComboItem();
            String dayVal = String.valueOf(day);
            item.setValue(dayVal);
            item.setCaption(new LocaleString(dayVal));
            item.setId(dayVal);
            dayComboItems.add(item);
        }
        ComboEdit startMonthCombo = (ComboEdit)this.getView().getControl("startmonth");
        startMonthCombo.setComboItems((List)monthComboItems);
        this.getModel().setValue("startmonth", (Object)"1");
        ComboEdit startDayCombo = (ComboEdit)this.getView().getControl("startday");
        startDayCombo.setComboItems((List)dayComboItems);
        this.getModel().setValue("startday", (Object)"1");
        ComboEdit endMonthCombo = (ComboEdit)this.getView().getControl("endmonth");
        endMonthCombo.setComboItems((List)monthComboItems);
        this.getModel().setValue("endmonth", (Object)"1");
        ComboEdit endDayCombo = (ComboEdit)this.getView().getControl("endday");
        endDayCombo.setComboItems((List)dayComboItems);
        this.getModel().setValue("endday", (Object)"1");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("do_save".equals(operate.getOperateKey())) {
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)4);
            int startMonth = Integer.parseInt((String)this.getModel().getValue("startmonth"));
            int startDay = Integer.parseInt((String)this.getModel().getValue("startday"));
            int endMonth = Integer.parseInt((String)this.getModel().getValue("endmonth"));
            int endDay = Integer.parseInt((String)this.getModel().getValue("endday"));
            if (startMonth > endMonth || startDay > endDay) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u586b\u62a5\u622a\u6b62\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u586b\u62a5\u5f00\u59cb\u65e5\u671f\u3002", (String)"BatchSettingFromPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                return;
            }
            returnData.put("startmonth", startMonth);
            returnData.put("startday", startDay);
            returnData.put("endmonth", endMonth);
            returnData.put("endday", endDay);
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }
}

