/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.rpttpl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadCommandHelper;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.report.autogetnum.ColIndex;
import kd.sdk.sihc.soehrr.common.report.autogetnum.RowDim;
import kd.sdk.sihc.soehrr.common.report.dto.AutoAreaSettingDto;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soebs.business.util.DynamicObjectAndDataModelUtils;
import kd.sihc.soebs.common.util.FormBizChangeUtils;
import kd.sihc.soehrr.business.domain.autogetnum.AutoGetNumFormHelper;
import kd.sihc.soehrr.business.domain.rpttplarea.RptTplAutoAreaService;
import kd.sihc.soehrr.common.spread.SpreadCBackParam;
import kd.sihc.soehrr.formplugin.web.spread.SihcSpreadBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class AutoGetNumConfPlugin
extends SihcSpreadBasePlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final String[] DEPENDENCY_FIELDS = new String[]{"dateperiodrange", "dateperiod", "fillorgrange", "fillorg", "colv", "groupv", "groupitems", "groupentry"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.initReportData();
        AutoGetNumFormHelper.initRowColConf((SpreadModelParam)super.getSpreadParam());
    }

    @Override
    public void afterBindData(EventObject eventObject) {
        DynamicObject analyseObject;
        String autoAreaStr;
        super.afterBindData(eventObject);
        SpreadCommandHelper.initSpreadApForGetNum((SpreadModelParam)super.getSpreadParam());
        long pkId = (Long)this.getModel().getValue("id");
        if (pkId == 0L && HRStringUtils.isNotEmpty((String)(autoAreaStr = (String)this.getView().getFormShowParameter().getCustomParam("soehrr_rpttplarea_auto")))) {
            AutoAreaSettingDto dto = (AutoAreaSettingDto)GzipTools.deSerializedBytes((String)autoAreaStr);
            DynamicObject srcDyObj = dto.convertDynamicObject();
            DynamicObjectAndDataModelUtils.copyDyToModel((DynamicObject)srcDyObj, (IDataModel)this.getModel());
        }
        if (!HRObjectUtils.isEmpty((Object)(analyseObject = (DynamicObject)this.getModel().getValue("analyseobject")))) {
            AutoGetNumFormHelper.initDropDownConf((IFormView)this.getView(), (DynamicObject)analyseObject);
            AutoGetNumFormHelper.initAnaGroups((IFormView)this.getView(), (DynamicObject)analyseObject);
        }
        this.getModel().setDataChanged(false);
        if (Objects.isNull(this.getModel().getValue("analyseobject"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"rowentryentity", "colentryentity"});
        }
    }

    @Override
    public void spreadCallBack(SpreadCBackParam param) {
    }

    public void beforeClick(BeforeClickEvent evt) {
        DynamicObject analyseObj;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if ((HRStringUtils.equals((String)sourceKey, (String)"groupv") || HRStringUtils.equals((String)sourceKey, (String)"colv")) && HRObjectUtils.isEmpty((Object)(analyseObj = (DynamicObject)this.getModel().getValue("analyseobject")))) {
            String tips = HRStringUtils.equals((String)sourceKey, (String)"colv") ? ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u5bf9\u8c61\uff0c\u518d\u9009\u62e9\u5217\u6307\u6807", (String)"AutoGetNumConfPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u5bf9\u8c61\uff0c\u518d\u9009\u62e9\u5206\u7ec4", (String)"AutoGetNumConfPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if (HRStringUtils.equals((String)sourceKey, (String)"groupitems")) {
            int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("rowentryentity");
            AutoGetNumFormHelper.clickGroupItem((SpreadModelParam)super.getSpreadParam(), (int)rowIndex, (IFormPlugin)this);
        } else if (HRStringUtils.equals((String)sourceKey, (String)"analyseobject")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrptmc_selanobjtreef7");
            showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5206\u6790\u5bf9\u8c61", (String)"AutoGetNumConfPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openAnObjTreeF7"));
            this.getView().showForm(showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        String dateFieldId;
        String changeName = pca.getProperty().getName();
        if (HRStringUtils.equals((String)changeName, (String)"analyseobject")) {
            this.clearDependencyField();
            DynamicObject analyseObject = (DynamicObject)pca.getChangeSet()[0].getNewValue();
            if (HRObjectUtils.isEmpty((Object)analyseObject)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"rowentryentity", "colentryentity"});
                return;
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"rowentryentity", "colentryentity"});
            List<AutoAreaSettingDto> autoGetNumAreas = this.getAutoGetNumAreas();
            if (!autoGetNumAreas.isEmpty()) {
                AutoAreaSettingDto autoAreaSettingDto = autoGetNumAreas.get(0);
                long fillOrgId = autoAreaSettingDto.getFillOrgId();
                long datePeriod = autoAreaSettingDto.getDatePeriod();
                this.getModel().setValue("fillorg", (Object)fillOrgId);
                this.getModel().setValue("dateperiod", (Object)datePeriod);
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("rowentryentity");
            DynamicObjectCollection colEntity = this.getModel().getEntryEntity("colentryentity");
            for (AutoAreaSettingDto autoAreaSettingDto : autoGetNumAreas) {
                SpreadSelector spreadSelector = autoAreaSettingDto.convert2Selector();
                int startRow = spreadSelector.getStartRow();
                int endRow = spreadSelector.getEndRow();
                int startCol = spreadSelector.getStartCol();
                int endCol = spreadSelector.getEndCol();
                this.setRowEntryEntity(entryEntity, autoAreaSettingDto, startRow, endRow);
                this.setColEntryEntity(colEntity, autoAreaSettingDto, startCol, endCol);
            }
            AutoGetNumFormHelper.initDropDownConf((IFormView)this.getView(), (DynamicObject)analyseObject);
            AutoGetNumFormHelper.initAnaGroups((IFormView)this.getView(), (DynamicObject)analyseObject);
        } else if (HRStringUtils.equals((String)changeName, (String)"groupv")) {
            int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("rowentryentity");
            this.getModel().setValue("groupitems", null, rowIndex);
            this.getModel().setValue("groupentry", null, rowIndex);
        } else if (HRStringUtils.equals((String)changeName, (String)"fillorgrange")) {
            String fillOrgFieldId = (String)pca.getChangeSet()[0].getNewValue();
            if (HRStringUtils.isNotEmpty((String)fillOrgFieldId)) {
                this.getModel().setValue("fillorg", (Object)Long.parseLong(fillOrgFieldId));
            }
        } else if (HRStringUtils.equals((String)changeName, (String)"dateperiodrange") && HRStringUtils.isNotEmpty((String)(dateFieldId = (String)pca.getChangeSet()[0].getNewValue()))) {
            this.getModel().setValue("dateperiod", (Object)Long.parseLong(dateFieldId));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String sourceMethod;
        String propName = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)propName, (String)"analyseobject") && "click".equals(sourceMethod = beforeF7SelectEvent.getSourceMethod())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hrptmc_selanobjtreef7");
            showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5206\u6790\u5bf9\u8c61", (String)"AutoGetNumConfPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject anObj = (DynamicObject)this.getModel().getValue("analyseobject");
            if (null != anObj) {
                showParameter.setCustomParam("anObjId", anObj.getPkValue());
                showParameter.setCustomParam("lastTableName", (Object)this.getPageCache().get("tableName"));
            }
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openAnObjTreeF7"));
            this.getView().showForm(showParameter);
            beforeF7SelectEvent.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)source.getOperateKey(), (String)"ensure")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection rowEntryEntity = dataEntity.getDynamicObjectCollection("rowentryentity");
            AtomicBoolean flag = new AtomicBoolean(false);
            rowEntryEntity.forEach(obj -> {
                String groupV = obj.getString("groupv");
                String groupItems = obj.getString("groupitems");
                if (StringUtils.isEmpty((CharSequence)groupV) || StringUtils.isEmpty((CharSequence)groupItems)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u884c\u6307\u6807\u914d\u7f6e\u3002", (String)"AutoGetNumConfPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                }
            });
            if (flag.get()) {
                args.setCancel(true);
                return;
            }
            List<AutoAreaSettingDto> autoGetNumAreas = this.getAutoGetNumAreas();
            long fillOrg = dataEntity.getLong("fillorg.id");
            long dateperiod = dataEntity.getLong("dateperiod.id");
            if (!(autoGetNumAreas.isEmpty() || autoGetNumAreas.get(0).getFillOrgId() == fillOrg && autoGetNumAreas.get(0).getDatePeriod() == dateperiod)) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u53d8\u66f4\u540e\uff0c\u5c06\u540c\u6b65\u66f4\u65b0\u6a21\u677f\u5185\u76f8\u540c\u7684\u5206\u6790\u5bf9\u8c61\u7684\u6570\u636e\u8303\u56f4\u3002", (String)"AutoGetNumConfPlugin_2", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            }
            this.generateAutoArea();
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        String colseFlag = this.getPageCache().get("COLSEBYENSURE");
        if (!StringUtils.isEmpty((CharSequence)colseFlag)) {
            this.getPageCache().remove("COLSEBYENSURE");
            ArrayList ignoreFields = Lists.newArrayList(Arrays.asList(DEPENDENCY_FIELDS));
            ignoreFields.add("analyseobject");
            ignoreFields.add("reportconfid");
            ignoreFields.add("repentryid");
            ignoreFields.add("areapoint");
            FormBizChangeUtils.setBizChanged((DynamicObject)this.getModel().getDataEntity(true), (String[])ignoreFields.toArray(new String[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent cce) {
        Object returnData;
        super.closedCallBack(cce);
        String actionId = cce.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"soehrr_groupitems")) {
            returnData = (DynamicObject)cce.getReturnData();
            if (Objects.isNull(returnData)) {
                return;
            }
            int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("rowentryentity");
            this.getModel().setValue("groupitems", (Object)returnData.getString("itemname"), rowIndex);
            this.getModel().setValue("groupentry", (Object)returnData.getString("groupentry"), rowIndex);
        }
        if ("openAnObjTreeF7".equals(cce.getActionId())) {
            returnData = (Map)cce.getReturnData();
            if (CollectionUtils.isEmpty((Map)returnData)) {
                return;
            }
            this.getModel().setValue("analyseobject", returnData.get("anObjId"));
        }
    }

    private void setColEntryEntity(DynamicObjectCollection colEntity, AutoAreaSettingDto autoAreaSettingDto, int startRow, int endRow) {
        for (DynamicObject colEntryEntity : colEntity) {
            int col = colEntryEntity.getInt("col");
            if (startRow > col || col > endRow) continue;
            List colIndexList = autoAreaSettingDto.getColIndexList();
            for (ColIndex colIndex : colIndexList) {
                int oCol = colIndex.getCol();
                if (oCol != col) continue;
                int seq = colEntryEntity.getInt("seq") - 1;
                this.getModel().setValue("colv", (Object)colIndex.getColValue(), seq);
                this.getModel().setValue("col", (Object)colIndex.getCol(), seq);
            }
        }
    }

    private void setRowEntryEntity(DynamicObjectCollection entryEntity, AutoAreaSettingDto autoAreaSettingDto, int startRow, int endRow) {
        for (DynamicObject rowEntry : entryEntity) {
            int row = rowEntry.getInt("row");
            if (startRow > row || row > endRow) continue;
            List rowDims = autoAreaSettingDto.getRowDims();
            for (RowDim rowDim : rowDims) {
                int oRow = rowDim.getRow();
                if (oRow != row) continue;
                int seq = rowEntry.getInt("seq") - 1;
                this.getModel().setValue("rowno", (Object)rowDim.getRowNo(), seq);
                this.getModel().setValue("groupv", (Object)rowDim.getGroupValue(), seq);
                this.getModel().setValue("groupitems", (Object)rowDim.getGroupItem(), seq);
            }
        }
    }

    private void generateAutoArea() {
        long pkId = (Long)this.getModel().getValue("id");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        AutoAreaSettingDto autoArea = new AutoAreaSettingDto();
        autoArea.setOperate(OperateEnum.ADD);
        String selectStr = (String)this.getView().getFormShowParameter().getCustomParam("spread_selector");
        SpreadSelector selector = (SpreadSelector)GzipTools.deSerializedBytes((String)selectStr);
        autoArea.setAreaPoint(selector.getAreaPointStr());
        autoArea.dyConvert2Dto(dataEntity);
        if (pkId != 0L) {
            autoArea.setId(pkId);
        }
        Map splitAreasByAuto = RptTplAutoAreaService.ins().splitAreaByAuto(selector, autoArea);
        this.getView().returnDataToParent((Object)splitAreasByAuto);
        this.getView().getPageCache().put("COLSEBYENSURE", "1");
        this.getView().close();
    }

    private void clearDependencyField() {
        for (String dependencyField : DEPENDENCY_FIELDS) {
            Object value = this.getModel().getValue(dependencyField);
            if (Objects.isNull(value) || value instanceof DynamicObjectCollection) continue;
            this.getModel().setValue(dependencyField, null);
        }
    }

    private void initReportData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("reportconfid", formShowParameter.getCustomParam("reportconfid"));
        this.getModel().setValue("repentryid", formShowParameter.getCustomParam("repentryid"));
        this.getModel().setValue("areatype", (Object)AreaSettingEnum.SYS_AUTO_NUM.getValue());
    }

    private List<AutoAreaSettingDto> getAutoGetNumAreas() {
        Object param = this.getView().getFormShowParameter().getCustomParam("alldata_spread_selector");
        if (!Objects.isNull(param)) {
            String customParam = (String)param;
            return (List)GzipTools.deSerializedBytes((String)customParam);
        }
        return Lists.newArrayListWithCapacity((int)0);
    }

    private void setComboField(Map<String, String> beforeStageMap, String comboFieldName) {
        if (beforeStageMap.isEmpty()) {
            return;
        }
        ArrayList comboItems = Lists.newArrayListWithCapacity((int)beforeStageMap.size());
        for (Map.Entry<String, String> entry : beforeStageMap.entrySet()) {
            ComboItem comboItem = new ComboItem();
            String key = entry.getKey();
            comboItem.setCaption(new LocaleString(key + "-" + entry.getValue()));
            comboItem.setValue(key + "-" + beforeStageMap.get(key));
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboFieldName);
        comboEdit.setComboItems((List)comboItems);
    }
}

