/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.rpttpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;
import kd.sihc.soehrr.business.application.report.FillTaskApplicationService;
import kd.sihc.soehrr.business.domain.cache.QueryInitCache;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.domain.rpttplarea.RptTplAreaService;
import kd.sihc.soehrr.business.domain.rpttplarea.RptTplAutoAreaService;
import kd.sihc.soehrr.business.domain.rpttplvalidatort.RptTplValidatorService;
import kd.sihc.soehrr.business.domain.rpttplvar.RptTplVarService;

public class RptTplToolsPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(RptTplToolsPlugin.class);
    private static Map<String, QueryInitCache> QUERY_CACHE_HANDLERS = Maps.newHashMapWithExpectedSize((int)16);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("refreshstyle".equals(operateKey)) {
            this.refreshStyle();
        } else if ("showjson".equals(operateKey)) {
            this.showSpreadJson();
        } else if ("exportrpttpl".equals(operateKey)) {
            this.exportRptTpl();
        } else if ("uncompress".equals(operateKey)) {
            this.uncompress();
        } else if ("setrefreshrpttplnum".equals(operateKey)) {
            this.setRefreshRptTplNum();
        }
    }

    private void setRefreshRptTplNum() {
        DynamicObject[] oldRptTpls;
        DynamicObjectCollection numberMappings = this.getView().getModel().getEntryEntity("entryentity");
        HashMap oldMapNew = Maps.newHashMapWithExpectedSize((int)numberMappings.size());
        for (DynamicObject numberMapping : numberMappings) {
            String oldNumber = numberMapping.getString("oldnumber");
            String newNumber = numberMapping.getString("newnumber");
            oldMapNew.put(oldNumber, newNumber);
        }
        LOG.info("RptTplToolsPlugin.setRefreshRptTplNum oldMapNew = {}", (Object)oldMapNew);
        String[] oldNumbers = oldMapNew.keySet().toArray(new String[0]);
        for (DynamicObject oldRptTpl : oldRptTpls = RptTplService.getInstance().loadDynamicObjectArray(new QFilter[]{new QFilter("number", "in", (Object)oldNumbers)})) {
            this.reSetSpreadJson(oldRptTpl, oldMapNew);
            this.reSetVerRule(oldRptTpl, oldMapNew);
            String oldNumber = oldRptTpl.getString("number");
            String newNumber = (String)oldMapNew.get(oldNumber);
            if (HRStringUtils.isEmpty((String)newNumber)) {
                LOG.warn("RptTplToolsPlugin.setRefreshRptTplNum oldNumber = {} has no newNumber", (Object)oldNumber);
                continue;
            }
            oldRptTpl.set("number", (Object)newNumber);
        }
        RptTplService.getInstance().save(oldRptTpls);
        this.getView().showSuccessNotification("\u5237\u65b0\u91cd\u7f6e\u62a5\u8868\u6a21\u677f\u7f16\u7801\u6210\u529f\u3002");
    }

    private void reSetVerRule(DynamicObject oldRptTpl, Map<String, String> oldMapNew) {
        DynamicObjectCollection entryEntity = oldRptTpl.getDynamicObjectCollection("entryentity");
        List rptEntryIds = entryEntity.stream().map(entry -> entry.getLong("id")).collect(Collectors.toList());
        DynamicObject[] validators = RptTplValidatorService.getInstance().loadByRptEntryIds(rptEntryIds);
        for (Map.Entry<String, String> oldNewEntry : oldMapNew.entrySet()) {
            String oldNumber = oldNewEntry.getKey();
            String newNumber = oldNewEntry.getValue();
            for (DynamicObject validator : validators) {
                String tarValue = validator.getString("tarvalue");
                String expression = validator.getString("expression");
                if (tarValue.contains(oldNumber)) {
                    tarValue = tarValue.replace(oldNumber, newNumber);
                    validator.set("tarvalue", (Object)tarValue);
                }
                if (!expression.contains(oldNumber)) continue;
                expression = expression.replace(oldNumber, newNumber);
                validator.set("expression", (Object)expression);
            }
        }
        RptTplValidatorService.getInstance().save(validators);
    }

    private void reSetSpreadJson(DynamicObject oldRptTpl, Map<String, String> oldMapNew) {
        DynamicObjectCollection entryEntity = oldRptTpl.getDynamicObjectCollection("entryentity");
        for (DynamicObject verEntry : entryEntity) {
            String oldNumber = oldRptTpl.getString("number");
            String spreadJson = verEntry.getString("json_tag");
            String sampleSpreadJson = verEntry.getString("samplejson_tag");
            JSONObject spreadJsonObject = SpreadJsonHelper.getSpreadJsonByUncompress((String)spreadJson);
            JSONObject sampleSpreadJsonObject = SpreadJsonHelper.getSpreadJsonByUncompress((String)sampleSpreadJson);
            this.replaceNumber(spreadJsonObject, oldMapNew, oldNumber);
            verEntry.set("json_tag", (Object)GzipTools.compressJson((String)spreadJsonObject.toJSONString()));
            this.replaceNumber(sampleSpreadJsonObject, oldMapNew, oldNumber);
            verEntry.set("samplejson_tag", (Object)GzipTools.compressJson((String)sampleSpreadJsonObject.toJSONString()));
        }
    }

    private void replaceNumber(JSONObject spreadJsonObject, Map<String, String> oldMapNew, String rptTplNumer) {
        JSONObject sheets = spreadJsonObject.getJSONObject("sheets");
        JSONArray nameStyles = spreadJsonObject.getJSONArray("namedStyles");
        String rptTplNumberNew = oldMapNew.get(rptTplNumer);
        this.doReplaceNumber(sheets, nameStyles, rptTplNumer, rptTplNumberNew, oldMapNew);
        for (Map.Entry<String, String> oldNewEntry : oldMapNew.entrySet()) {
            String oldNumber = oldNewEntry.getKey();
            String newNumber = oldNewEntry.getValue();
            if (HRStringUtils.equals((String)oldNumber, (String)rptTplNumer)) continue;
            this.doReplaceNumber(sheets, nameStyles, oldNumber, newNumber, oldMapNew);
        }
    }

    private void doReplaceNumber(JSONObject sheets, JSONArray nameStyles, String oldNumber, String newNumber, Map<String, String> oldMapNew) {
        if (sheets.containsKey((Object)oldNumber)) {
            JSONObject oldNode = sheets.getJSONObject(oldNumber);
            JSONObject data = oldNode.getJSONObject("data");
            JSONObject dataTable = data.getJSONObject("dataTable");
            HashMap memo = Maps.newHashMapWithExpectedSize((int)16);
            for (Object nameStyle : nameStyles) {
                JSONObject tarStyle = (JSONObject)nameStyle;
                String styleName = tarStyle.getString("name");
                if (!styleName.startsWith(oldNumber)) continue;
                String newStyleName = styleName.replaceAll(oldNumber, newNumber);
                tarStyle.put("name", (Object)newStyleName);
                memo.put(styleName, newStyleName);
            }
            for (Map.Entry rowEntry : dataTable.entrySet()) {
                Object value = rowEntry.getValue();
                JSONObject rowJsonObject = (JSONObject)value;
                rowJsonObject.forEach((key, colVal) -> {
                    JSONObject colJsonObject = (JSONObject)colVal;
                    if (colJsonObject.containsKey((Object)"style")) {
                        String styleStr;
                        Object colStyleObj = colJsonObject.get((Object)"style");
                        if (colStyleObj instanceof JSONObject) {
                            String parentName;
                            JSONObject colStyle = (JSONObject)colStyleObj;
                            if (colStyle.containsKey((Object)"parentName") && memo.containsKey(parentName = colStyle.getString("parentName"))) {
                                colStyle.put("parentName", memo.get(parentName));
                            }
                        } else if (colStyleObj instanceof String && memo.containsKey(styleStr = (String)colStyleObj)) {
                            colJsonObject.put("style", memo.get(styleStr));
                        }
                        String formula = colJsonObject.getString("formula");
                        if (HRStringUtils.isNotEmpty((String)formula)) {
                            for (Map.Entry entry : oldMapNew.entrySet()) {
                                String valNumber = (String)entry.getValue();
                                String keyNumber = (String)entry.getKey();
                                if (!formula.contains(keyNumber)) continue;
                                formula = formula.replace(keyNumber, valNumber);
                            }
                            colJsonObject.put("formula", (Object)formula);
                        }
                    }
                });
            }
            sheets.remove((Object)oldNumber);
            oldNode.put("name", (Object)newNumber);
            sheets.put(newNumber, (Object)oldNode);
        } else {
            LOG.warn("RptTplToolsPlugin.replaceNumber has no oldNumber = {}", (Object)oldNumber);
        }
    }

    private void uncompress() {
        String compressSpreadJson = (String)this.getModel().getValue("compressspreadjson_tag");
        if (HRStringUtils.isEmpty((String)compressSpreadJson)) {
            this.getView().showTipNotification("\u8bf7\u8f93\u5165\u8981\u89e3\u538b\u7684spreadJson\u538b\u7f29\u5b57\u7b26\u4e32\u3002");
            return;
        }
        String uncompressJson = GzipTools.uncompressJson((String)compressSpreadJson);
        JSONObject spreadJsonObject = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        String pretty = JSON.toJSONString((Object)spreadJsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        this.getModel().setValue("spreadcontent2", (Object)pretty);
    }

    private void exportRptTpl() {
        String exportNumbers = (String)this.getModel().getValue("exportrpttplnums");
        if (HRStringUtils.isEmpty((String)exportNumbers)) {
            this.getView().showTipNotification("\u8bf7\u8f93\u5165\u8981\u5bfc\u51fa\u7684\u62a5\u8868\u6a21\u677f\u7f16\u7801\u3002");
            return;
        }
        Object[] numberSplits = exportNumbers.split(",");
        if (HRArrayUtils.isNotEmpty((Object[])numberSplits) && numberSplits.length > 100) {
            this.getView().showTipNotification("\u4e00\u6b21\u6700\u591a\u5bfc\u51fa100\u6761\u62a5\u8868\u6a21\u677f\u6570\u636e\u3002");
            return;
        }
        StringBuilder kSqlText = new StringBuilder();
        Object[] objectArray = numberSplits;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            HRBaseServiceHelper rptTplHelper = new HRBaseServiceHelper("soehrr_rpttpl");
            Object number = objectArray[i];
            QFilter rptTplQfilter = new QFilter("number", "=", number);
            DynamicObject rptTpl = rptTplHelper.loadDynamicObject(rptTplQfilter.toArray());
            if (HRObjectUtils.isEmpty((Object)rptTpl)) {
                this.getView().showTipNotification(String.format("\u62a5\u8868\u7f16\u7801\uff1a%s\u7684\u62a5\u8868\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728", number));
                continue;
            }
            this.genData("soehrr_rpttpl", new DynamicObject[]{rptTpl}, kSqlText);
            List<Long> entryIds = this.getCurrentRptEntryId(rptTpl);
            for (Map.Entry<String, QueryInitCache> cacheEntry : QUERY_CACHE_HANDLERS.entrySet()) {
                QueryInitCache queryInitCache = cacheEntry.getValue();
                List cacheDtoList = queryInitCache.queryRptTplConfByEntryIds(entryIds);
                if (HRCollUtil.isEmpty((Collection)cacheDtoList)) continue;
                List<DynamicObject> dynamicObjects = cacheDtoList.stream().map(ReportCacheDto::convertDynamicObject).collect(Collectors.toList());
                this.genData(cacheEntry.getKey(), dynamicObjects.toArray(new DynamicObject[0]), kSqlText);
            }
        }
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("ksqltext");
        codeSQLshow.setText(kSqlText.toString());
    }

    private List<Long> getCurrentRptEntryId(DynamicObject rptTpl) {
        DynamicObject currentEntry;
        RptTplService rptTplService = RptTplService.getInstance();
        DynamicObject newVersionEntry = rptTplService.getNewVersionEntry(rptTpl);
        ArrayList entryIds = Lists.newArrayListWithExpectedSize((int)2);
        if (!HRObjectUtils.isEmpty((Object)newVersionEntry)) {
            entryIds.add(newVersionEntry.getLong("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)(currentEntry = rptTplService.getCurrentEntry(rptTpl)))) {
            entryIds.add(currentEntry.getLong("id"));
        }
        return entryIds;
    }

    private List<Object> genData(String pageNum, DynamicObject[] rptTpls, StringBuilder ksqltext) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)pageNum);
        String fid = mainEntityType.getPrimaryKey().getAlias();
        Map<Long, DynamicObject> idMapRpt = Arrays.stream(rptTpls).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k, v) -> v));
        if (rptTpls.length == 0) {
            this.getView().showTipNotification("no output");
            return Lists.newArrayList();
        }
        List<Object> idList = Arrays.stream(rptTpls).map(dynamicObject -> dynamicObject.get("id")).collect(Collectors.toList());
        String idListStr = idList.stream().map(obj -> obj instanceof Long ? obj.toString() : String.format(Locale.ROOT, "'%s'", obj)).collect(Collectors.joining(","));
        Collection entityTypes = mainEntityType.getAllEntities().values();
        for (EntityType entityType : entityTypes) {
            String tableName = entityType.getAlias();
            if (HRStringUtils.isEmpty((String)tableName)) continue;
            LinkedHashMap tableFileds = Maps.newLinkedHashMap();
            HashSet mulBaseDataSet = Sets.newHashSet();
            this.mainFieldsExport(entityType, tableName, tableFileds, mulBaseDataSet);
            this.mulLangExport(entityType, tableFileds);
            String wField = this.getWhereField(fid, idListStr, entityType);
            for (Map.Entry entry : tableFileds.entrySet()) {
                String entryTable = (String)entry.getKey();
                LOG.info("RptTplToolsPlugin.genData entryTable= {}", (Object)entryTable);
                if ("t_soehrr_rpttplentry".equals(entryTable)) {
                    List<Long> entryIds = this.getCurrentRptEntryId(rptTpls[0]);
                    LOG.info("RptTplToolsPlugin.genData entryTable= {}", (Object)entryTable);
                    if (HRCollUtil.isEmpty(entryIds)) {
                        ksqltext.append(this.genKqlString(((StringBuilder)entry.getValue()).toString(), entryTable, wField, entityType.getDBRouteKey()));
                        continue;
                    }
                    StringBuilder buffer = new StringBuilder(16);
                    buffer.append(wField).append(" and FENTRYID IN (");
                    for (Long entryId : entryIds) {
                        buffer.append(entryId).append(",");
                    }
                    buffer.deleteCharAt(buffer.length() - 1).append(')');
                    String kSql = this.genKqlString(((StringBuilder)entry.getValue()).toString(), entryTable, buffer.toString(), entityType.getDBRouteKey());
                    kSql = this.writeSpreadJsonToSql(kSql, idMapRpt);
                    ksqltext.append(kSql);
                    continue;
                }
                String kSql = this.genKqlString(((StringBuilder)entry.getValue()).toString(), entryTable, wField, entityType.getDBRouteKey());
                ksqltext.append(kSql);
            }
            for (IDataEntityProperty property : mulBaseDataSet) {
                String mulBaseDataFieldStr = String.format(Locale.ROOT, "fpkid,%s,fbasedataid", entityType.getPrimaryKey().getAlias());
                ksqltext.append(this.genKqlString(mulBaseDataFieldStr, ((MulBasedataProp)property).getDynamicCollectionItemPropertyType().getAlias(), wField, entityType.getDBRouteKey()));
            }
        }
        return idList;
    }

    private String writeSpreadJsonToSql(String kSql, Map<Long, DynamicObject> idMapRpt) {
        LOG.info("RptTplToolsPlugin.writeSpreadJsonToSql kSql = {}", (Object)kSql);
        Object[] sqlSplits = kSql.split(";");
        LOG.info("RptTplToolsPlugin.writeSpreadJsonToSql sqlSplits = {}", sqlSplits);
        for (int index = 0; index < sqlSplits.length; ++index) {
            Object sqlSplit = sqlSplits[index];
            if (HRStringUtils.isEmpty((String)sqlSplit)) continue;
            sqlSplit = ((String)sqlSplit).trim();
            if (((String)(sqlSplit = ((String)sqlSplit).replaceAll("\n", ""))).startsWith("DELETE")) continue;
            String expression = ((String)sqlSplit).replace("INSERT INTO t_soehrr_rpttplentry", "");
            LOG.info("RptTplToolsPlugin.writeSpreadJsonToSql expression = {}", (Object)expression);
            String[] fieldAndVal = expression.split(" VALUES ");
            String fields = fieldAndVal[0];
            String values = fieldAndVal[1];
            fields = fields.substring(1, fields.length() - 1);
            values = values.substring(1, values.length() - 1);
            Object[] fieldSplits = fields.split(",");
            String[] valueSplits = values.split(",");
            int fidIndex = Lists.newArrayList((Object[])fieldSplits).indexOf("FID");
            int fEntryIdIndex = Lists.newArrayList((Object[])fieldSplits).indexOf("FENTRYID");
            int jsonIndex = Lists.newArrayList((Object[])fieldSplits).indexOf("FJSON_TAG");
            int sampleJsonIndex = Lists.newArrayList((Object[])fieldSplits).indexOf("FSAMPLEJSON_TAG");
            long fid = Long.parseLong(valueSplits[fidIndex]);
            long fEntryId = Long.parseLong(valueSplits[fEntryIdIndex]);
            DynamicObject rptTplEntry = this.getRptTplEntry(fid, fEntryId, idMapRpt);
            if (null == rptTplEntry) {
                LOG.error("RptTplToolsPlugin.writeSpreadJsonToSql rptTplEntry = {} is null", idMapRpt.entrySet());
                continue;
            }
            String spreadJsonTag = rptTplEntry.getString("json_tag");
            String sampleJsonTag = rptTplEntry.getString("samplejson_tag");
            LOG.info("RptTplToolsPlugin.writeSpreadJsonToSql rptTplEntry = {}", (Object)rptTplEntry);
            valueSplits[jsonIndex] = "'" + spreadJsonTag + "'";
            valueSplits[sampleJsonIndex] = "'" + sampleJsonTag + "'";
            StringBuilder newValStr = new StringBuilder(16);
            newValStr.append('(');
            for (String valueSplit : valueSplits) {
                newValStr.append(valueSplit).append(',');
            }
            newValStr.deleteCharAt(newValStr.length() - 1).append(")");
            LOG.info("RptTplToolsPlugin.writeSpreadJsonToSql newValStr = {}", (Object)newValStr);
            sqlSplits[index] = ((String)sqlSplit).substring(0, ((String)sqlSplit).indexOf(" VALUES ")) + " VALUES " + newValStr;
        }
        String rptEntrySql = String.join((CharSequence)";\n", (CharSequence[])sqlSplits);
        LOG.info("RptTplToolsPlugin.writeSpreadJsonToSql rptEntrySql = {}", (Object)rptEntrySql);
        return rptEntrySql;
    }

    private DynamicObject getRptTplEntry(long fid, long fEntryId, Map<Long, DynamicObject> idMapRpt) {
        LOG.info("RptTplToolsPlugin.getRptTplEntry fid = {}", (Object)fid);
        DynamicObject rptTpl = idMapRpt.get(fid);
        if (HRObjectUtils.isEmpty((Object)rptTpl)) {
            LOG.info("RptTplToolsPlugin.getRptTplEntry rptTpl is null");
            return null;
        }
        DynamicObjectCollection entryEntity = rptTpl.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            if (entry.getLong("id") != fEntryId) continue;
            LOG.info("RptTplToolsPlugin.getRptTplEntry entry id is {}", entry.getPkValue());
            return entry;
        }
        LOG.info("RptTplToolsPlugin.getRptTplEntry entry is null");
        return null;
    }

    private String getWhereField(String fid, String idListStr, EntityType entityType) {
        String wField;
        if (entityType instanceof SubEntryType) {
            IDataEntityType parent = entityType.getParent();
            String parentTable = parent.getAlias();
            String parentPkField = parent.getPrimaryKey().getAlias();
            String table = entityType.getAlias();
            String pkField = entityType.getPrimaryKey().getAlias();
            wField = String.format("%s in (select %s from %s where %s in (select %s from %s where %s in (%s)))", pkField, pkField, table, parentPkField, parentPkField, parentTable, fid, idListStr);
        } else if (entityType instanceof EntryType) {
            String table = entityType.getAlias();
            String pkField = entityType.getPrimaryKey().getAlias();
            wField = String.format(" %s in (select %s from %s where %s in (%s))", pkField, pkField, table, fid, idListStr);
        } else {
            wField = String.format("%s in (%s)", fid, idListStr);
        }
        return wField;
    }

    private void mulLangExport(EntityType entityType, Map<String, StringBuilder> tableFileds) {
        DynamicObjectType localObjectType;
        if (entityType.getLocaleProperty() != null && HRStringUtils.isNotEmpty((String)(localObjectType = entityType.getLocaleProperty().getDynamicCollectionItemPropertyType()).getAlias())) {
            StringBuilder fieldSb = new StringBuilder(entityType.getPrimaryKey().getAlias());
            for (IDataEntityProperty property : localObjectType.getProperties()) {
                String field = property.getAlias();
                if (!HRStringUtils.isNotEmpty((String)field) || property.isDbIgnore() || localObjectType.getPrimaryKey() == property) continue;
                if (fieldSb.length() != 0) {
                    fieldSb.append(",");
                }
                fieldSb.append(field);
            }
            tableFileds.put(localObjectType.getAlias(), fieldSb);
        }
    }

    private void mainFieldsExport(EntityType entityType, String tableName, Map<String, StringBuilder> tableFileds, Set<IDataEntityProperty> mulBaseDataSet) {
        for (IDataEntityProperty property : entityType.getProperties()) {
            String field = property.getAlias();
            if (!HRStringUtils.isNotEmpty((String)field) || property.isDbIgnore() || entityType.getPrimaryKey() == property) continue;
            if (property instanceof MulBasedataProp) {
                mulBaseDataSet.add(property);
                continue;
            }
            String tableGroup = property.getTableGroup();
            String tbName = tableGroup == null ? tableName : tableName + "_" + tableGroup;
            StringBuilder fieldSb = tableFileds.get(tbName);
            if (fieldSb == null) {
                String refId = entityType.getParent() == null ? "" : entityType.getParent().getPrimaryKey().getAlias();
                fieldSb = new StringBuilder(refId);
                tableFileds.put(tbName, fieldSb);
            }
            if (fieldSb.length() != 0) {
                fieldSb.append(',');
            }
            fieldSb.append(field);
            if (!(property instanceof ISimpleProperty) || !((ISimpleProperty)property).isEncrypt()) continue;
            fieldSb.append("_enp");
        }
    }

    private String genKqlString(String selectField, String fromfield, String wherefield, String routefield) {
        Map map;
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        try {
            map = builder.genInsertSQLScript(DBRoute.of((String)routefield), fromfield, selectField, wherefield, "", "");
        }
        catch (Exception var48) {
            throw new KDBizException((Throwable)var48, BosErrorCode.bOS, new Object[]{String.format("ErrorFormField:%s,KSQLExpPlugin Error:%s.", fromfield, var48.getMessage())});
        }
        return map.get("sql").toString();
    }

    private void showSpreadJson() {
        String showNumber = (String)this.getModel().getValue("shownumber");
        DynamicObject rptTpl = RptTplService.getInstance().loadDynamicObject(HrrQfilterUtils.eqNumber((String)showNumber));
        DynamicObject newVersionEntry = RptTplService.getInstance().getNewVersionEntry(rptTpl);
        if (HRObjectUtils.isEmpty((Object)newVersionEntry)) {
            newVersionEntry = RptTplService.getInstance().getCurrentEntry(rptTpl);
        }
        if (HRObjectUtils.isEmpty((Object)newVersionEntry)) {
            this.getView().showTipNotification("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u8868\u6837\u3002");
            return;
        }
        String spreadStr = newVersionEntry.getString("json_tag");
        String uncompressJson = GzipTools.uncompressJson((String)spreadStr);
        JSONObject spreadJsonObject = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        String pretty = JSON.toJSONString((Object)spreadJsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        this.getModel().setValue("spreadcontent", (Object)pretty);
    }

    private void refreshStyle() {
        DynamicObject[] rptTpls;
        String paramNumbers = (String)this.getModel().getValue("rpttplnumbers");
        if (HRStringUtils.isEmpty((String)paramNumbers)) {
            this.getView().showTipNotification("\u8bf7\u8f93\u5165\u201c\u8981\u5237\u65b0\u7684\u6a21\u677f\u7f16\u7801\u201d\u5b57\u6bb5");
            return;
        }
        String[] rptTplNumbers = paramNumbers.split(",");
        for (DynamicObject rptTpl : rptTpls = RptTplService.getInstance().loadDynamicObjectArray(new QFilter[]{new QFilter("number", "in", (Object)rptTplNumbers)})) {
            DynamicObjectCollection entryEntity = rptTpl.getDynamicObjectCollection("entryentity");
            String rptTplNumber = rptTpl.getString("number");
            for (DynamicObject entry : entryEntity) {
                String compressSpreadJson = entry.getString("json_tag");
                String uncompressJson = GzipTools.uncompressJson((String)compressSpreadJson);
                JSONObject spreadJsonObject = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
                JSONArray nameStyles = spreadJsonObject.getJSONArray("namedStyles");
                if (!HRCollUtil.isNotEmpty((Collection)nameStyles)) continue;
                LOG.info("RptTplToolsPlugin.refreshStyle need refresh number = {}", (Object)rptTplNumber);
                JSONObject sheets = (JSONObject)spreadJsonObject.get((Object)"sheets");
                JSONObject firstSheet = (JSONObject)sheets.values().iterator().next();
                FillTaskApplicationService.refreshParentName((String)rptTplNumber, (JSONArray)nameStyles, (JSONObject)firstSheet);
                String newCompressJon = GzipTools.compressJson((String)spreadJsonObject.toJSONString());
                entry.set("json_tag", (Object)newCompressJon);
            }
        }
        RptTplService.getInstance().save(rptTpls);
        this.getView().showSuccessNotification("\u5237\u65b0\u8868\u6837\u6210\u529f\u3002");
    }

    static {
        QUERY_CACHE_HANDLERS.put("soehrr_rpttplvar", (QueryInitCache)RptTplVarService.getInstance());
        QUERY_CACHE_HANDLERS.put(RptTplAreaService.ins().getEntityName(), (QueryInitCache)RptTplAreaService.ins());
        QUERY_CACHE_HANDLERS.put(RptTplAutoAreaService.ins().getEntityName(), (QueryInitCache)RptTplAutoAreaService.ins());
        QUERY_CACHE_HANDLERS.put(RptTplValidatorService.getInstance().getEntityName(), (QueryInitCache)RptTplValidatorService.getInstance());
    }
}

