/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.rpttpl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.SpreadClientInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.HideRbForConfigCommand;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadCommandHelper;
import kd.sdk.sihc.soehrr.common.enums.ActionNameEnum;
import kd.sdk.sihc.soehrr.common.report.dto.RepValidatorDto;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.spread.notify.NotifyListener;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;
import kd.sihc.soebs.common.util.FormBizChangeUtils;
import kd.sihc.soehrr.business.domain.spantable.FormulaFormHelper;
import kd.sihc.soehrr.business.listener.validator.AfterSelectValidatorListener;
import kd.sihc.soehrr.common.spread.SpreadCBackParam;
import kd.sihc.soehrr.formplugin.web.spread.SihcSpreadBasePlugin;
import org.apache.commons.lang3.StringUtils;

public class SetValidatorPlugin
extends SihcSpreadBasePlugin {
    private static final String[] VALIDATOR_FIELDS = new String[]{"comparator", "checklevel", "hintlangu", "tarvalue", "point"};

    @Override
    public void afterCreateNewData(EventObject evt) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String idStr = (String)parameter.getCustomParam("id");
        this.getView().getPageCache().put("cacheTabTable", String.valueOf(idStr));
        String srcSheetNumber = (String)parameter.getCustomParam("number");
        long id = Long.parseLong(idStr);
        this.initReportData();
        FormulaFormHelper.initDropDownList((long)id, (String)srcSheetNumber, (IFormView)this.getView());
        String selectorStr = (String)this.getView().getFormShowParameter().getCustomParam("spread_selector");
        SpreadSelector selector = (SpreadSelector)GzipTools.deSerializedBytes((String)selectorStr);
        String selectPoint = srcSheetNumber + "!" + this.changeSelectPointToFormula(selector);
        this.getModel().setValue("point", (Object)selectPoint);
        String validatorStr = (String)this.getView().getFormShowParameter().getCustomParam("soehrr_rpttplverrule");
        this.getView().getFormShowParameter().setCustomParam("firstChoice", (Object)"1");
        this.getView().getFormShowParameter().setCustomParam("newSheetName", (Object)srcSheetNumber);
        this.getView().cacheFormShowParameter();
        if (HRStringUtils.isNotEmpty((String)validatorStr)) {
            this.initEntrentity(srcSheetNumber, selectPoint, validatorStr);
        }
        SpreadCommandHelper.initSpreadApForFormula((SpreadModelParam)super.getSpreadParam());
    }

    private void initEntrentity(String srcSheetNumber, String selectPoint, String validatorStr) {
        List dtos = (List)GzipTools.deSerializedBytes((String)validatorStr);
        this.getModel().deleteEntryData("entryentity");
        int parentRowIndex = 0;
        for (RepValidatorDto dto : dtos) {
            this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("mname", (Object)dto.getName(), parentRowIndex);
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            entryGrid.selectRows(parentRowIndex);
            this.getModel().deleteEntryData("subentryentity");
            this.getModel().createNewEntryRow("subentryentity");
            this.getModel().setValue("comparator", (Object)dto.getComparator(), 0, parentRowIndex);
            this.getModel().setValue("tarvalue", (Object)dto.getTarvalue(), 0, parentRowIndex);
            this.getModel().setValue("checklevel", (Object)dto.getChecklevel(), 0, parentRowIndex);
            this.getModel().setValue("name", (Object)dto.getName(), 0, parentRowIndex);
            this.getModel().setValue("point", (Object)selectPoint, 0, parentRowIndex);
            this.getModel().setValue("tarreport", (Object)srcSheetNumber, 0, parentRowIndex);
            ++parentRowIndex;
        }
    }

    private void initReportData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.getModel().setValue("reportconfid", formShowParameter.getCustomParam("reportconfid"));
        this.getModel().setValue("repentryid", formShowParameter.getCustomParam("repentryid"));
    }

    @Override
    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setVisible();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.selectRows(0);
        SpreadClientInvoker.invokeLockSheetMethod((IClientViewProxy)this.getCliViProxy(), (String)this.getSpreadKey(), Collections.singletonList("Sheet1"));
        SpreadClientInvoker.invokeLockAllToolbarItems((IClientViewProxy)this.getCliViProxy(), (String)this.getSpreadKey(), (boolean)true);
        SpreadClientInvoker.invokeCloseToolBar((IClientViewProxy)this.getCliViProxy(), (String)this.getSpreadKey());
        new HideRbForConfigCommand("3").invokeMethod(super.getSpreadParam());
    }

    private void setVisible() {
        int ruleSize = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
        this.getView().setVisible(Boolean.valueOf(ruleSize == 0), new String[]{"flexpanelnodataap"});
        this.getView().setVisible(Boolean.valueOf(ruleSize != 0), new String[]{"flexpanelruleap"});
    }

    private String changeSelectPointToFormula(SpreadSelector selector) {
        String excelPoint1 = ExcelUtils.xy2Pos((int)selector.getStartCol(), (int)selector.getStartRow());
        String excelPoint2 = ExcelUtils.xy2Pos((int)selector.getEndCol(), (int)selector.getEndRow());
        String formula = excelPoint1;
        if (!HRStringUtils.equals((String)excelPoint1, (String)excelPoint2)) {
            formula = formula + ":" + excelPoint2;
            return formula;
        }
        return excelPoint1;
    }

    @Override
    public void spreadCallBack(SpreadCBackParam param) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"do_save")) {
            boolean success = args.getOperationResult().isSuccess();
            if (success) {
                String selectorStr = (String)this.getView().getFormShowParameter().getCustomParam("spread_selector");
                SpreadSelector selector = (SpreadSelector)GzipTools.deSerializedBytes((String)selectorStr);
                if (this.getModel().getValue("tarvalue") != null) {
                    this.getModel().setValue("tarvalue", (Object)this.setOperator("").trim());
                }
                Map result = MapInitHelper.ofMap((Object)"spread_selector", (Object)selector, (Object)"data", (Object)this.getModel().getDataEntity(true));
                this.getView().returnDataToParent((Object)result);
                this.getView().getPageCache().put("COLSEBYENSURE", "1");
                this.getView().close();
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"newentry")) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String srcSheetNumber = (String)parameter.getCustomParam("number");
            this.getModel().setValue("tarreport", (Object)srcSheetNumber);
            String selectorStr = (String)this.getView().getFormShowParameter().getCustomParam("spread_selector");
            SpreadSelector selector = (SpreadSelector)GzipTools.deSerializedBytes((String)selectorStr);
            String selectPoint = srcSheetNumber + "!" + this.changeSelectPointToFormula(selector);
            this.getModel().setValue("point", (Object)selectPoint);
            this.setVisible();
        } else if (HRStringUtils.equals((String)operateKey, (String)"deleteentry")) {
            this.setVisible();
        } else if (HRStringUtils.equals((String)operateKey, (String)"do_clear")) {
            this.getModel().setValue("tarvalue", null);
        } else if (HRStringUtils.equals((String)operateKey, (String)"do_add")) {
            this.getModel().setValue("tarvalue", (Object)this.setOperator("+"));
        } else if (HRStringUtils.equals((String)operateKey, (String)"do_sub")) {
            this.getModel().setValue("tarvalue", (Object)this.setOperator("-"));
        } else if (HRStringUtils.equals((String)operateKey, (String)"do_times")) {
            this.getModel().setValue("tarvalue", (Object)this.setOperator("*"));
        } else if (HRStringUtils.equals((String)operateKey, (String)"do_devide")) {
            this.getModel().setValue("tarvalue", (Object)this.setOperator("/"));
        } else if (HRStringUtils.equals((String)operateKey, (String)"do_leftbracket")) {
            String tarvalue = (String)this.getModel().getValue("tarvalue");
            if (HRStringUtils.isEmpty((String)tarvalue)) {
                this.getModel().setValue("tarvalue", (Object)(tarvalue.trim() + "(" + " "));
                return;
            }
            this.getModel().setValue("tarvalue", (Object)(tarvalue.trim() + " " + "(" + " "));
        } else if (HRStringUtils.equals((String)operateKey, (String)"do_rightbracket")) {
            String tarvalue = (String)this.getModel().getValue("tarvalue");
            if (HRStringUtils.isEmpty((String)tarvalue)) {
                return;
            }
            this.getModel().setValue("tarvalue", (Object)(tarvalue.trim() + " " + ")" + " "));
        }
    }

    private String setOperator(String operator) {
        String tarvalue = (String)this.getModel().getValue("tarvalue");
        if (HRStringUtils.isEmpty((String)tarvalue)) {
            return tarvalue;
        }
        tarvalue = tarvalue.trim().endsWith("+") || tarvalue.trim().endsWith("-") || tarvalue.trim().endsWith("*") || tarvalue.trim().endsWith("/") ? this.replaceLastOperator(tarvalue.trim(), operator) : tarvalue.trim() + " " + operator + " ";
        return tarvalue;
    }

    private String replaceLastOperator(String input, String operator) {
        Pattern pattern = Pattern.compile("([+\\-*/])$");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return input.substring(0, input.length() - 1) + operator + " ";
        }
        return input;
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        String changeName = pca.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        int ruleSize = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
        if (ruleSize == 0) {
            return;
        }
        if (HRStringUtils.equals((String)changeName, (String)"name")) {
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue(changeName);
            this.getModel().setValue("mname", (Object)name, rowIndex);
        }
        if (HRStringUtils.equals((String)changeName, (String)"tarreport")) {
            String dropDownName = (String)pca.getChangeSet()[0].getNewValue();
            String tplNumber = FormulaFormHelper.getSpanSheetNumber((String)dropDownName);
            long spanSheetId = FormulaFormHelper.getSpanSheetId((String)dropDownName);
            this.getView().getPageCache().put("cacheTabTable", String.valueOf(spanSheetId));
            FormulaFormHelper.addSheetByTableNo((String)tplNumber, (SpreadModelParam)super.getSpreadParam(), (IFormView)this.getView());
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        String colseFlag = this.getPageCache().get("COLSEBYENSURE");
        if (!StringUtils.isEmpty((CharSequence)colseFlag)) {
            this.getPageCache().remove("COLSEBYENSURE");
            ArrayList ignoreFields = Lists.newArrayList(Arrays.asList(VALIDATOR_FIELDS));
            ignoreFields.add("reportconfid");
            ignoreFields.add("repentryid");
            FormBizChangeUtils.setBizChanged((DynamicObject)this.getModel().getDataEntity(true), (String[])ignoreFields.toArray(new String[0]));
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initSpreadListener();
    }

    private void initSpreadListener() {
        AfterSelectValidatorListener afterSelectListener = new AfterSelectValidatorListener(this.getView());
        this.registerAfterEvent(ActionNameEnum.CELL_SELECT, (NotifyListener)afterSelectListener);
    }
}

