/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.rpttpl.list;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;
import kd.sihc.soebs.common.util.CommonListSelectCheck;
import kd.sihc.soehrr.business.domain.cyccollecttask.CycCollService;
import kd.sihc.soehrr.business.domain.report.ReportService;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.common.constants.SoehrrProjectNameConstants;

public class RptTplListPlugin
extends HRCoreBaseBillList
implements CommonListSelectCheck {
    private static final String AREA_ENTITYS = "soehrr_rpttplarea,soehrr_rpttplarea_auto";
    private static final Map<String, String> IGNORE_ENTITY = MapInitHelper.ofMap((Object)"soehrr_rpttplarea", (Object)"soehrr_rpttplarea,soehrr_rpttplarea_auto", (Object)"soehrr_rpttplarea_auto", (Object)"soehrr_rpttplarea,soehrr_rpttplarea_auto");
    private CycCollService cycCollService = (CycCollService)ServiceFactory.getService(CycCollService.class);
    private static final List<String> IGNORE_LIST = Lists.newArrayList((Object[])new String[]{"soehrr_rpttplvar", "soehrr_rpttplverrule"});
    private RptTplService rptTplService = RptTplService.getInstance();

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (Lists.newArrayList((Object[])new String[]{"delete", "audit", "unaudit", "submit", "unsubmit"}).contains(operateKey)) {
            this.listSelectCountCheck(this.getView(), args, this.getSelectedRows());
        }
        if ("submit".equals(operateKey)) {
            OperateOption option = operate.getOption();
            option.setVariableValue("from", "bos_list");
            operate.setOption(option);
        } else if (HRStringUtils.equals((String)operateKey, (String)"delete")) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            List cacheDtosByIds = this.rptTplService.setCacheDtosDeleteByIds(primaryKeyValues);
            List ignoresEntity = cacheDtosByIds.stream().map(dto -> dto.getEntityId()).distinct().collect(Collectors.toList());
            ArrayList realIgnores = Lists.newArrayListWithExpectedSize((int)ignoresEntity.size());
            for (String ignore : ignoresEntity) {
                String entityId = IGNORE_ENTITY.get(ignore);
                if (HRStringUtils.isNotEmpty((String)entityId)) {
                    realIgnores.add(entityId);
                    continue;
                }
                if (!IGNORE_LIST.contains(ignore)) continue;
                realIgnores.add(ignore);
            }
            if (HRCollUtil.isNotEmpty((Collection)realIgnores)) {
                operate.getOption().setVariableValue("ignorerefentityids", String.join((CharSequence)",", realIgnores));
            }
            this.getView().getPageCache().put("delete", GzipTools.toByteSerialized((Object)cacheDtosByIds));
        } else if ("disable".equals(operateKey)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            List rptTplIds = selectedRows.stream().map(sr -> (Long)sr.getPrimaryKeyValue()).collect(Collectors.toList());
            List fillTasks = ReportService.ins().queryBeRunByRptTpl(rptTplIds);
            Object[] cycCollSchemas = this.cycCollService.queryEnableByRptTplIds(rptTplIds);
            if (HRCollUtil.isNotEmpty((Collection)fillTasks) || HRArrayUtils.isNotEmpty((Object[])cycCollSchemas)) {
                String msg = ResManager.loadKDString((String)"\u5df2\u6709\u5f85\u751f\u6548\u7684\u6570\u636e\u586b\u62a5\u4efb\u52a1\u6216\u5df2\u542f\u7528\u7684\u5468\u671f\u91c7\u96c6\u65b9\u6848\u5f15\u7528\u8be5\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1\u6216\u65b9\u6848\u914d\u7f6e\u3002", (String)"RptTplListPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs adea) {
        super.afterDoOperation(adea);
        String operateKey = adea.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"delete")) {
            String cacheStr;
            if (adea.getOperationResult().isSuccess() && HRStringUtils.isNotEmpty((String)(cacheStr = this.getView().getPageCache().get("delete")))) {
                this.rptTplService.deleteRptTplDtos((List)GzipTools.deSerializedBytes((String)cacheStr));
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"audit")) {
            DynamicObject[] rptTpls;
            OperationResult operationResult = adea.getOperationResult();
            List successPkIds = operationResult.getSuccessPkIds();
            if (HRCollUtil.isEmpty((Collection)successPkIds)) {
                return;
            }
            List rptTplIds = successPkIds.stream().map(id -> (Long)id).collect(Collectors.toList());
            for (DynamicObject rptTpl : rptTpls = RptTplService.getInstance().queryNowEntryEntityByIds("json_tag", rptTplIds)) {
                this.rptTplService.newNowEditEntry(rptTpl);
            }
            this.rptTplService.copyNewToEditVersion(rptTpls);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        if (SoehrrProjectNameConstants.LIST_OP.contains(operationKey)) {
            this.listSelectCountCheck(this.getView(), evt, this.getSelectedRows());
        }
    }
}

