/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.formplugin.web.spread;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.enums.ActionNameEnum;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.spread.notify.ISpreadListener;
import kd.sdk.sihc.soehrr.common.spread.notify.NotifyEvent;
import kd.sdk.sihc.soehrr.common.spread.properties.SpreadProperties;
import kd.sdk.sihc.soehrr.common.util.HrrStrUtil;
import kd.sihc.soehrr.common.spread.SpreadCBackParam;
import kd.sihc.soehrr.formplugin.web.spread.SihcSpreadBasePlugin;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;

public class SIHCReportSpreadAction
extends SpreadActionAdapter {
    private static final Log LOG = LogFactory.getLog(SIHCReportSpreadAction.class);

    public SIHCReportSpreadAction(AbstractFormPlugin plugin) {
        super(plugin);
    }

    public void addRows(SpreadEvent event) {
        super.addRows(event);
        event.getPostData();
    }

    public void getLookupData(SpreadEvent event) {
        if (event.getPostData().getInvokeParams() != null) {
            int row = (Integer)event.getPostData().getInvokeParams().get("r");
            int col = (Integer)event.getPostData().getInvokeParams().get("c");
            Map lookupDataInfo = (Map)event.getPostData().getInvokeParams().get("lookupInfo");
            HashMap whitelist = Maps.newHashMapWithExpectedSize((int)16);
            whitelist.put("countStart", "setCountStart");
            whitelist.put("countEnd", "setCountEnd");
            whitelist.put("countModel", "setCountModel");
            whitelist.put("left", "setLeft");
            whitelist.put("right", "setRight");
            whitelist.put("pipeiModel", "setPipeiModel");
            whitelist.put("value", "setValue");
            try {
                LookUpDataArgs bean = new LookUpDataArgs();
                for (Map.Entry white : whitelist.entrySet()) {
                    BeanUtils.setProperty((Object)bean, (String)((String)white.getKey()), lookupDataInfo.get(white.getKey()));
                }
                bean.setR(row);
                bean.setC(col);
                MethodUtils.invokeMethod((Object)this.plugin, (String)"spreadF7LookUpData", (Object)bean);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                LOG.error("getLookupData error ", (Throwable)ex);
                String tips = ResManager.loadKDString((String)"spread\u63a7\u4ef6\u56de\u8c03\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (String)"SIHCReportSpreadAction_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]);
                throw new KDBizException(tips);
            }
        }
    }

    public void askExecute(SpreadEvent event) {
        super.askExecute(event);
        SpreadCBackParam spreadCBackParam = new SpreadCBackParam();
        String method = String.valueOf(event.getPostData().getInvokeParams().get("method"));
        spreadCBackParam.setMethodName(method);
        Object spreadParam = event.getPostData().getInvokeParams().get("data");
        spreadCBackParam.setSpreadParam(spreadParam);
        try {
            MethodUtils.invokeMethod((Object)this.plugin, (String)"toolBarAskExecute", (Object)spreadCBackParam);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error("invokePluginMethod error ", (Throwable)ex);
            throw new KDException(BosErrorCode.systemError, new Object[]{ex});
        }
        catch (KDBizException kdEx) {
            throw kdEx;
        }
    }

    public void invokePluginMethod(SpreadEvent event) {
        String methodName = (String)event.getPostData().getInvokeParams().get(SpreadProperties.GetSpreadJsonMethod.INVOKEMETHOD.k());
        LinkedHashMap invokeParams = event.getPostData().getInvokeParams();
        Object data = invokeParams.get("data");
        SpreadCBackParam spreadCBackParam = new SpreadCBackParam();
        String args = data instanceof List ? JSONArray.toJSONString(data) : (String)event.getPostData().getInvokeParams().get("data");
        if (methodName.contains(CallBackEnum.INSERT_VAR.getM()) || methodName.contains(CallBackEnum.SHEET_CALC.getM()) || methodName.contains(CallBackEnum.CROSS_SHEET_CALC.getM())) {
            args = methodName.split("_")[1];
            methodName = methodName.split("_")[0];
        } else if (methodName.contains(CallBackEnum.OPEN_FORMULA_JSON.getM())) {
            spreadCBackParam.setCusArg(methodName.split("_")[1]);
            methodName = methodName.split("_")[0];
        } else if ("linkCallBack".equals(methodName)) {
            args = invokeParams.get("r") + ":" + invokeParams.get("c");
        }
        if (HRStringUtils.isEmpty((String)args)) {
            args = "";
        }
        spreadCBackParam.setMethodName(methodName);
        spreadCBackParam.setArg(args);
        try {
            MethodUtils.invokeMethod((Object)this.plugin, (String)"spreadCallBack", (Object)spreadCBackParam);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error("invokePluginMethod error ", (Throwable)ex);
            throw new KDException(BosErrorCode.systemError, new Object[]{ex});
        }
    }

    public void selectedSpread(SpreadEvent event) {
        super.selectedSpread(event);
        SpreadPostDataInfo data = event.getPostData();
        if (this.selectDataNotNull(data)) {
            SihcSpreadBasePlugin basePlugin;
            Map status;
            this.sortSelectData(data);
            SpreadSelector selector = new SpreadSelector(((Integer)data.getSelRows().get(0)).intValue(), ((Integer)data.getSelCols().get(0)).intValue(), ((Integer)data.getSelRows().get(data.getSelRows().size() - 1)).intValue(), ((Integer)data.getSelCols().get(data.getSelCols().size() - 1)).intValue(), data.getSelRows().size(), data.getSelCols().size());
            if (SihcSpreadBasePlugin.class.isAssignableFrom(this.plugin.getClass()) && !HRMapUtils.isEmpty((Map)(status = (Map)(basePlugin = (SihcSpreadBasePlugin)((Object)SihcSpreadBasePlugin.class.cast(this.plugin))).getCliViProxy().getViewState(basePlugin.getSpreadKey()))) && status.containsKey("selections")) {
                List selections = (List)status.get("selections");
                selector.setSelections(selections);
            }
            IPageCache pageCache = this.plugin.getPageCache();
            pageCache.put("spread_selector", SerializationUtils.serializeToBase64((Object)selector));
            NotifyEvent selectEvent = new NotifyEvent((Object)this.getSheet(), ActionNameEnum.CELL_SELECT, (Object)selector);
            this.doBeforeNotify(selectEvent);
            if (!selectEvent.isCancel()) {
                this.doAfterNotify(this.getSheet(), ActionNameEnum.CELL_SELECT, selector);
            }
        }
    }

    public void updateCellValue(SpreadEvent event) {
        Spread spread = (Spread)event.getSource();
        SpreadPostDataInfo data = spread.getPostDataInfo();
        if (data == null) {
            data = event.getPostData();
        }
        if (HRCollUtil.isEmpty((Collection)data.getValues())) {
            return;
        }
        data.getValues().forEach(v -> {
            if (v.get("v") instanceof String) {
                v.put("v", HrrStrUtil.trim((String)v.get("v").toString()));
            }
        });
        SheetManager sheet = this.getSheet();
        NotifyEvent notifyEvent = new NotifyEvent((Object)sheet, ActionNameEnum.UPDATE_MULVALUE, (Object)data);
        if (!data.getValues().isEmpty()) {
            this.doBeforeNotify(notifyEvent);
            if (notifyEvent.isCancel()) {
                IPageCache pageCache = this.plugin.getPageCache();
                sheet.setSheetCache(pageCache);
                return;
            }
        }
        for (LinkedHashMap e : data.getValues()) {
            Object val = e.get("v");
            if (!(val instanceof Number) && !(val instanceof String) && !(val instanceof Character) && val != null) continue;
            Integer r = (Integer)e.get("r");
            Integer c = (Integer)e.get("c");
            Cell cell = sheet.getCell(r.intValue(), c.intValue());
            if (Objects.nonNull(cell)) {
                cell.setValue(val);
            }
            NotifyEvent evt = new NotifyEvent((Object)sheet, ActionNameEnum.UPDATE_VALUE, (Object)cell);
            this.doBeforeNotify(evt);
            if (evt.isCancel()) continue;
            if (evt.getCheckParam() != null) {
                val = evt.getCheckParam();
            }
            if (!Objects.nonNull(cell) || !cell.setValue(val)) continue;
            this.doAfterNotify(sheet, ActionNameEnum.UPDATE_VALUE, cell);
        }
        IPageCache pageCache = this.plugin.getPageCache();
        sheet.setSheetCache(pageCache);
    }

    public void updateFormula(SpreadEvent event) {
        List formulas;
        Spread spread;
        SpreadPostDataInfo data;
        super.updateFormula(event);
        SheetManager sheetManager = null;
        try {
            sheetManager = this.getSheet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sheetManager != null && (data = (spread = (Spread)event.getSource()).getPostDataInfo()).getInvokeParams() != null && data.getInvokeParams().get("formulas") != null && !(formulas = (List)data.getInvokeParams().get("formulas")).isEmpty()) {
            NotifyEvent mulevt = new NotifyEvent((Object)sheetManager, ActionNameEnum.UPDATE_MULFORMULA, (Object)formulas);
            this.doBeforeNotify(mulevt);
            for (Map item : formulas) {
                Cell cell = sheetManager.getCell(((Integer)item.get("r")).intValue(), ((Integer)item.get("c")).intValue());
                String fVal = (String)item.get("f");
                NotifyEvent evt = new NotifyEvent((Object)sheetManager, ActionNameEnum.UPDATE_FORMULA, (Object)cell);
                this.doBeforeNotify(evt);
                if (evt.isCancel()) continue;
                if (Objects.nonNull(cell)) {
                    cell.setFormula(fVal);
                }
                this.doAfterNotify(sheetManager, ActionNameEnum.UPDATE_FORMULA, cell);
            }
            sheetManager.setSheetCache(this.plugin.getView().getPageCache());
        }
    }

    private SheetManager getSheet() {
        SheetManager ssh = null;
        if (SihcSpreadBasePlugin.class.isAssignableFrom(this.plugin.getClass())) {
            ssh = ((SihcSpreadBasePlugin)this.plugin).getSheetData();
        }
        if (ssh != null) {
            return ssh;
        }
        IPageCache pageCache = this.plugin.getView().getPageCache();
        String serial = pageCache.get("spread_table_data_cache");
        if (serial != null) {
            ssh = SheetManager.getSheetFromJsonStr((String)serial);
        }
        if (ssh == null) {
            ssh = new SheetManager("Sheet1", "base64H4sIAAAAAAAAA6VUXY7TMBC+ysrPZZWWBUHe2LYrKrEUteUJocqNJ62pY0f2pD9b7Ql45B7cgNvAPRjbSbtRu7xQKY09P9/8fDM5sA1YJ41mKeveXPeuX7MO40qZ7WcHdmD5cmBNydKcKwcdtpLLlaIHR3rDlRQDjpylaCuovQZ7zQuZvbOW7xuFRLAc5Qb6XGWVoqPR93wni6oYRZXRjqXdJKlB+qbcf+IOYbjLQE1xr+CYQTAY7hC0CCYTrpfQRMoax/fABdhxWUMTcFY5NMUH6ZClX77SXcny1nArjkYvO8ytAJCOBzaZzR8UgsN5ZpSCDOdJcvPWa6g+ivecAVXrpuDvIJqsrK+o0hT4la8w862YmG285tY8gJ5ZLpXUSxJPUWbrmRmKU1ltm75RVaEvmOEKQmrjPJcZUCoisHMI7xlf+C4eWHL8c7GxB5YbnxzTxhZcXbVf3V65uyLi5MJK9kg/goWcVwo99x+NgEtQwevPz++/f/1gdWJ3UXNrxJ5EymRr36HAakClLkXWBk3W/whzhhggiIn/hVCQYx+UGmkBuzA4aMq2wAV648zUnbQNmyequyEdlr6Ih1raS0IMvcQVmcSqxxUSrRDQaFUK5wc0VkM8P6ulnKbIMWjo7p6cTfSJg3Kcb6/hFZp7sMu4NiOdGxfXobRSo7/7OCUvwU7lQ+jTVgqf7Btf3gr87lPmYVfXUgtfxaN3NxibcgoXV3UCjoBorl3rOxHFMcO2ZqTpw4NnDlF8yWFAfOB5hCi+5HAnaXFtSzQUEseLb1RC27Tu/hn4+GmHaxW1QdZDQqP0F9LgFm1ZBQAA");
        }
        return ssh;
    }

    private void sortSelectData(SpreadPostDataInfo data) {
        data.getSelRows().sort(Comparator.comparingInt(Integer::intValue));
        data.getSelCols().sort(Comparator.comparingInt(Integer::intValue));
        int rowIndex = data.getSelRows().indexOf(-1);
        int colIndex = data.getSelCols().indexOf(-1);
        if (rowIndex != -1) {
            data.getSelRows().remove(rowIndex);
        }
        if (colIndex != -1) {
            data.getSelCols().remove(colIndex);
        }
    }

    private boolean selectDataNotNull(SpreadPostDataInfo data) {
        return data.getSelRows() != null && !data.getSelRows().isEmpty() && data.getSelCols() != null && !data.getSelCols().isEmpty();
    }

    private void doBeforeNotify(NotifyEvent evt) {
        if (ISpreadListener.class.isAssignableFrom(this.plugin.getClass())) {
            ((ISpreadListener)this.plugin).doBeforeNotify(evt);
        }
    }

    private void doAfterNotify(Object source, ActionNameEnum actionName, Object param) {
        if (ISpreadListener.class.isAssignableFrom(this.plugin.getClass())) {
            ((ISpreadListener)this.plugin).doAfterNotify(new NotifyEvent(source, actionName, param));
        }
    }

    public void deleteColumns(SpreadEvent event) {
        super.deleteColumns(event);
    }
}

