/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.application.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.domain.rpttplarea.RptTplAreaService;
import kd.sihc.soehrr.business.queryservice.RptTplQueryService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;

public class FillTaskApplicationService {
    private static final HRBaseServiceHelper REPORT_HELPER = new HRBaseServiceHelper("soehrr_report");
    private static final RptTplQueryService RPTTPLQUERYSERVICE = ServiceFactory.getService(RptTplQueryService.class);
    private static final RptTplService rptTplService = RptTplService.getInstance();

    public static void updateFillTask(DynamicObject[] solutions, List<DynamicObject> fillTasks) {
        ArrayList allReports = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList reportClassifys = Lists.newArrayListWithExpectedSize((int)solutions.length);
        Arrays.asList(solutions).forEach(solution -> reportClassifys.add(solution.getLong("reportclassify.id")));
        DynamicObject[] rptTpls = RPTTPLQUERYSERVICE.queryRptTplByClasses(reportClassifys);
        HashMap repTplMap = Maps.newHashMapWithExpectedSize((int)rptTpls.length);
        Arrays.asList(rptTpls).forEach(rptTpl -> repTplMap.put(rptTpl.getLong("id"), rptTpl));
        Arrays.asList(solutions).forEach(solution -> {
            DynamicObjectCollection fillObjs = solution.getDynamicObjectCollection("taskfillobjs");
            List solutionFillTasks = fillTasks.stream().filter(ft -> ft.getLong("solution") == solution.getLong("id")).collect(Collectors.toList());
            Map<String, Map<Long, List<DynamicObject>>> anaResult = FillTaskApplicationService.analysisFillObj(solution, fillObjs, repTplMap);
            Map<Long, List<DynamicObject>> reportMap = anaResult.get("ORGREPORT");
            Map<Long, List<DynamicObject>> reportTemplate = anaResult.get("ORGREPORTTEMPLATE");
            long[] ids = ORM.create().genLongIds("soehrr_filltask", solutionFillTasks.size());
            Map<Long, Long> rptMapVersionId = fillObjs.stream().collect(Collectors.toMap(fo -> fo.getLong("rpttpl.id"), fo -> fo.getLong("repentryid")));
            for (int index = 0; index < solutionFillTasks.size(); ++index) {
                DynamicObject fillTask = (DynamicObject)solutionFillTasks.get(index);
                fillTask.set("id", (Object)ids[index]);
                Long orgId = fillTask.getLong("exeunit");
                String taskJson = FillTaskApplicationService.composeAllRptTemplate(reportTemplate.get(orgId), rptMapVersionId);
                fillTask.set("trepcontent_tag", (Object)taskJson);
                List<DynamicObject> reports = reportMap.get(orgId);
                reports.forEach(report -> report.set("filltask", (Object)fillTask.getLong("id")));
                allReports.addAll(reports);
            }
        });
        REPORT_HELPER.save(allReports.toArray(new DynamicObject[0]));
    }

    private static Map<String, Map<Long, List<DynamicObject>>> analysisFillObj(DynamicObject solution, DynamicObjectCollection fillObjs, Map<Long, DynamicObject> tplMap) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        HashMap orgRptTemplateMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap orgReportMap = Maps.newHashMapWithExpectedSize((int)16);
        long currentUserId = RequestContext.get().getCurrUserId();
        List<Long> rptVersionEntryIds = fillObjs.stream().map(fo -> fo.getLong("repentryid")).collect(Collectors.toList());
        DynamicObject[] rptAreas = RptTplAreaService.ins().loadByRptEntryIds(rptVersionEntryIds, Lists.newArrayList((Object[])new AreaSettingEnum[]{AreaSettingEnum.FILL, AreaSettingEnum.DYNAMIC_SUMMARY}));
        Map<Long, DynamicObject> entryIdMapArea = Arrays.stream(rptAreas).collect(Collectors.toMap(area -> area.getLong("repentryid"), area -> area, (k, v) -> v));
        fillObjs.forEach(fillobj -> {
            DynamicObjectCollection fillUnits = fillobj.getDynamicObjectCollection("fillunits");
            String reportName = fillobj.getDynamicObject("rpttpl").getString("name");
            DynamicObject reportClassify = fillobj.getDynamicObject("rpttpl").getDynamicObject("reportclassify");
            long rptVersionEntryId = fillobj.getLong("repentryid");
            fillUnits.forEach(fillUnit -> {
                List<DynamicObject> reportList;
                List<DynamicObject> rpts;
                Long orgId = fillUnit.getDynamicObject("fbasedataid").getLong("id");
                if (orgRptTemplateMap.containsKey(orgId)) {
                    rpts = (List)orgRptTemplateMap.get(orgId);
                } else {
                    rpts = Lists.newArrayListWithExpectedSize((int)10);
                    orgRptTemplateMap.put(orgId, rpts);
                }
                DynamicObject rptTpl = (DynamicObject)tplMap.get(fillobj.getLong("rpttpl.id"));
                rpts.add(rptTpl);
                DynamicObject report = REPORT_HELPER.generateEmptyDynamicObject();
                HashSet ignoreKeys = Sets.newHashSetWithExpectedSize((int)16);
                ignoreKeys.add("fillunits");
                HRDynamicObjectUtils.copy((DynamicObject)fillobj, (DynamicObject)report, (Set)ignoreKeys, (boolean)false);
                report.set("name", (Object)reportName);
                report.set("status", (Object)"C");
                report.set("reportstatus", (Object)"A");
                report.set("disunit", (Object)solution.getDynamicObject("disunit"));
                report.set("enable", (Object)"1");
                report.set("creator", (Object)currentUserId);
                report.set("reportclassify", (Object)reportClassify);
                report.set("exeunit", (Object)fillUnit.getDynamicObject("fbasedataid"));
                report.set("org", (Object)solution.getDynamicObject("org"));
                report.set("year", (Object)solution.getString("year"));
                report.set("collecttask", (Object)solution.getLong("id"));
                report.set("iscurrentversion", (Object)"1");
                report.set("repentryid", (Object)rptVersionEntryId);
                DynamicObject rptArea = (DynamicObject)entryIdMapArea.get(rptVersionEntryId);
                if (!HRObjectUtils.isEmpty((Object)rptArea)) {
                    report.set("fillarea", (Object)rptArea.getString("areapoint"));
                }
                if (orgReportMap.containsKey(orgId)) {
                    reportList = (List)orgReportMap.get(orgId);
                } else {
                    reportList = Lists.newArrayListWithExpectedSize((int)10);
                    orgReportMap.put(orgId, reportList);
                }
                reportList.add(report);
            });
        });
        result.put("ORGREPORT", orgReportMap);
        result.put("ORGREPORTTEMPLATE", orgRptTemplateMap);
        return result;
    }

    private static String composeAllRptTemplate(List<DynamicObject> rptList, Map<Long, Long> rptMapVersionId) {
        String result;
        if (HRCollUtil.isEmpty(rptList)) {
            return "";
        }
        DynamicObject firstRptTpl = rptList.get(0);
        DynamicObject newVersionEntry = rptTplService.getEntryById(firstRptTpl, rptMapVersionId.get(firstRptTpl.getLong("id")));
        String firstTemplateJson = newVersionEntry.getString("json_tag");
        String firstUncompressJson = GzipTools.uncompressJson((String)firstTemplateJson);
        JSONObject srcSheetJson = JSONObject.parseObject((String)firstUncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject srcFirstSheet = (JSONObject)srcSheetJson.getJSONObject("sheets").values().iterator().next();
        if (rptList.size() == 1) {
            srcSheetJson.put("sheets", (Object)MapInitHelper.ofMap((Object)firstRptTpl.getString("number"), (Object)srcFirstSheet));
            srcSheetJson.put("sheetCount", (Object)1);
            result = GzipTools.compressJson((String)srcSheetJson.toJSONString());
        } else {
            srcFirstSheet.put("isSelected", (Object)true);
            srcFirstSheet.put("index", (Object)0);
            srcSheetJson.put("sheets", (Object)MapInitHelper.ofMap((Object)firstRptTpl.getString("number"), (Object)srcFirstSheet));
            srcSheetJson.put("sheetCount", (Object)rptList.size());
            srcSheetJson.put("activeSheetIndex", (Object)0);
            for (int index = 1; index < rptList.size(); ++index) {
                DynamicObject otherRptTpl = rptList.get(index);
                Long rptVersionId = rptMapVersionId.get(otherRptTpl.getLong("id"));
                if (null == rptVersionId) continue;
                DynamicObject entryById = rptTplService.getEntryById(otherRptTpl, rptVersionId);
                String tarCompressJson = entryById.getString("json_tag");
                String tarUncompressJson = GzipTools.uncompressJson((String)tarCompressJson);
                JSONObject spreadJsonObject = JSONObject.parseObject((String)tarUncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
                JSONObject spreadSheets = (JSONObject)spreadJsonObject.get((Object)"sheets");
                JSONObject tarFirstSheet = (JSONObject)spreadSheets.values().iterator().next();
                JSONArray tarNameStyles = spreadJsonObject.getJSONArray("namedStyles");
                FillTaskApplicationService.mergeNameStylesToSrc(srcSheetJson, tarNameStyles);
                tarFirstSheet.put("isSelected", (Object)false);
                tarFirstSheet.put("index", (Object)index);
                JSONObject sheets = srcSheetJson.getJSONObject("sheets");
                sheets.put(rptList.get(index).getString("number"), (Object)tarFirstSheet);
            }
            String json = srcSheetJson.toJSONString();
            result = GzipTools.compressJson((String)json);
        }
        return result;
    }

    public static void mergeNameStylesToSrc(JSONObject srcSheetJson, JSONArray tarNameStyles) {
        if (HRCollUtil.isEmpty((Collection)tarNameStyles)) {
            return;
        }
        JSONArray srcNameStyles = srcSheetJson.getJSONArray("namedStyles");
        if (HRCollUtil.isEmpty((Collection)srcNameStyles)) {
            srcSheetJson.put("namedStyles", (Object)tarNameStyles);
            return;
        }
        JSONObject tarFirstNameStyle = tarNameStyles.getJSONObject(0);
        if (Objects.isNull(tarFirstNameStyle)) {
            return;
        }
        String tarStyleName = tarFirstNameStyle.getString("name");
        Map<String, JSONObject> srcNameMapNode = srcNameStyles.stream().collect(Collectors.toMap(json -> ((JSONObject)json).getString("name"), json -> (JSONObject)json, (k, v) -> v));
        JSONObject jsonObject = srcNameMapNode.get(tarStyleName);
        if (Objects.nonNull(jsonObject)) {
            return;
        }
        srcNameStyles.addAll((Collection)tarNameStyles);
    }

    public static Map<String, String> refreshParentName(String rptTplNumber, JSONArray tarNameStyles, JSONObject tarFirstSheet) {
        if (HRCollUtil.isEmpty((Collection)tarNameStyles)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        HashMap memo = Maps.newHashMapWithExpectedSize((int)16);
        for (Object tarNameStyle : tarNameStyles) {
            JSONObject tarStyle = (JSONObject)tarNameStyle;
            String styleName = tarStyle.getString("name");
            if (styleName.startsWith(rptTplNumber)) continue;
            String newStyleName = rptTplNumber + styleName;
            tarStyle.put("name", (Object)newStyleName);
            memo.put(styleName, newStyleName);
        }
        JSONObject data = tarFirstSheet.getJSONObject("data");
        JSONObject dataTable = data.getJSONObject("dataTable");
        for (Map.Entry rowEntry : dataTable.entrySet()) {
            Object value = rowEntry.getValue();
            JSONObject rowJsonObject = (JSONObject)value;
            rowJsonObject.entrySet().forEach(colEntry -> {
                Object colVal = colEntry.getValue();
                JSONObject colJsonObject = (JSONObject)colVal;
                if (colJsonObject.containsKey((Object)"style")) {
                    String styleStr;
                    Object colStyle = colJsonObject.get((Object)"style");
                    if (colStyle instanceof JSONObject && ((JSONObject)colStyle).containsKey((Object)"parentName")) {
                        JSONObject styleObj = (JSONObject)colStyle;
                        String parentName = styleObj.getString("parentName");
                        if (memo.containsKey(parentName)) {
                            styleObj.put("parentName", memo.get(parentName));
                        }
                    } else if (colStyle instanceof String && memo.containsKey(styleStr = (String)colStyle)) {
                        colJsonObject.put("style", memo.get(styleStr));
                    }
                }
            });
        }
        return memo;
    }
}

