/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.application.report;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.util.AreaUtil;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soehrr.business.application.report.ReportPeroidApplicationService;
import kd.sihc.soehrr.business.domain.rpttplvar.RptTplVarService;
import kd.sihc.soehrr.business.queryservice.ReportQueryService;
import kd.sihc.soehrr.business.queryservice.RptTplQueryService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;

public class ReportApplicationService {
    private static final ReportQueryService reportQueryService = ServiceFactory.getService(ReportQueryService.class);
    private static final RptTplQueryService repTplQueryService = ServiceFactory.getService(RptTplQueryService.class);
    private static final HRBaseServiceHelper fillTaskHelper = new HRBaseServiceHelper("soehrr_filltask");
    private static Log LOG = LogFactory.getLog(ReportApplicationService.class);

    public static void dataRetrival(DynamicObject fillTask) {
        if (HRStringUtils.isNotEmpty((String)fillTask.getString("fretridata")) && fillTask.getString("fretridata").equals("true")) {
            LOG.info("dataRetrival haved retrival,no need retrival");
            return;
        }
        String taskReportContent = fillTask.getString("trepcontent_tag");
        if (HRStringUtils.isEmpty((String)taskReportContent)) {
            LOG.info("dataRetrival fill task json is empty");
            return;
        }
        JSONObject target = JSONObject.parseObject((String)GzipTools.uncompressJson((String)taskReportContent), (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheets = (JSONObject)target.get((Object)"sheets");
        DynamicObject[] reports = reportQueryService.queryReportByFillTask(fillTask.getLong("id"));
        LOG.info("dataRetrival filltask have {} report", (Object)reports.length);
        ReportApplicationService.variableRetrive(fillTask, reports, sheets);
        ReportApplicationService.previousPeroidDataRetrival(fillTask, reports, sheets);
        target.put("sheets", (Object)sheets);
        fillTask.set("trepcontent_tag", (Object)GzipTools.compressJson((String)target.toJSONString()));
        fillTask.set("fretridata", (Object)"true");
        fillTask.set("lastrdtime", (Object)new Date());
        fillTaskHelper.updateOne(fillTask);
        LOG.info("dataRetrival filltask{} have finish", (Object)fillTask.getLong("id"));
    }

    public static void dataRetrival4VariableRetrive(DynamicObject fillTask) {
        String taskReportContent = fillTask.getString("trepcontent_tag");
        if (HRStringUtils.isEmpty((String)taskReportContent)) {
            LOG.info("dataRetrival4VariableRetrive fill task json is empty");
            return;
        }
        JSONObject target = JSONObject.parseObject((String)GzipTools.uncompressJson((String)taskReportContent), (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheets = (JSONObject)target.get((Object)"sheets");
        DynamicObject[] reports = reportQueryService.queryReportByFillTask(fillTask.getLong("id"));
        LOG.info("dataRetrival4VariableRetrive filltask have {} report", (Object)reports.length);
        ReportApplicationService.variableRetrive(fillTask, reports, sheets);
        target.put("sheets", (Object)sheets);
        fillTask.set("trepcontent_tag", (Object)GzipTools.compressJson((String)target.toJSONString()));
        fillTask.set("fretridata", (Object)"true");
        fillTask.set("lastrdtime", (Object)new Date());
        fillTaskHelper.updateOne(fillTask);
        LOG.info("dataRetrival4VariableRetrive filltask{} have finish", (Object)fillTask.getLong("id"));
    }

    public static void previousPeroidDataRetrival(DynamicObject fillTask, DynamicObject[] reports, JSONObject sheets) {
        HashMap reportMap = Maps.newHashMapWithExpectedSize((int)reports.length);
        Arrays.asList(reports).forEach(report -> reportMap.put(report.getLong("repentryid"), report));
        QFilter reportFilter = null;
        QFilter lyReportFilter = null;
        HashMap<Long, List<DynamicObject>> rptAreaMap = new HashMap<Long, List<DynamicObject>>();
        DynamicObject[] templateAreas = repTplQueryService.queryRptTplArea(reportMap.keySet().stream().collect(Collectors.toList()), Arrays.asList(String.valueOf(AreaSettingEnum.LAST_GET_NUM.getValue()), String.valueOf(AreaSettingEnum.LYEAR_GET_NUM.getValue())));
        if (templateAreas.length == 0) {
            LOG.info("previousPeroidDataRetrival: not find previous retrive area");
            return;
        }
        HashMap lastMapRepEntryId = Maps.newHashMapWithExpectedSize((int)templateAreas.length);
        for (DynamicObject templateArea : templateAreas) {
            Long repentryid = templateArea.getLong("repentryid");
            if (rptAreaMap.containsKey(repentryid)) {
                ((List)rptAreaMap.get(repentryid)).add(templateArea);
            } else {
                ArrayList<DynamicObject> areaList = new ArrayList<DynamicObject>();
                areaList.add(templateArea);
                rptAreaMap.put(repentryid, areaList);
            }
            long rptTplId = templateArea.getLong("reportconfid.id");
            long exeUnitId = fillTask.getLong("exeunit.id");
            long disUnitId = fillTask.getDynamicObject("disunit").getLong("id");
            DynamicObject currentReport = (DynamicObject)reportMap.get(repentryid);
            String year = currentReport.getString("year");
            QFilter filter = new QFilter("rpttpl", "=", (Object)rptTplId);
            filter.and(new QFilter("exeunit", "=", (Object)exeUnitId));
            filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
            filter.and(new QFilter("reportstatus", "=", (Object)"D"));
            filter.and(new QFilter("disunit", "=", (Object)disUnitId));
            String lastKey = rptTplId + ":";
            lastKey = lastKey + exeUnitId + ":";
            lastKey = lastKey + disUnitId + ":";
            if (String.valueOf(AreaSettingEnum.LAST_GET_NUM.getValue()).equals(templateArea.getString("areatype"))) {
                DynamicObject period = currentReport.getDynamicObject("belongperiod");
                String targetYear = year;
                if (period.getInt("index") == 1) {
                    targetYear = String.valueOf(Integer.parseInt(year) - 1);
                }
                DynamicObject targetPeriod = ReportPeroidApplicationService.getInstance().compute(period);
                long targetPeriodId = targetPeriod.getLong("id");
                lastKey = lastKey + targetYear + ":";
                lastKey = lastKey + targetPeriodId + ":";
                filter.and(new QFilter("year", "=", (Object)targetYear));
                filter.and(new QFilter("belongperiod", "=", (Object)targetPeriodId));
                LOG.info("previousPeroidDataRetrival:last peroid retrive {} from {},filter->{}", new Object[]{templateArea.getString("areapoint"), templateArea.getString("srcareapoint"), filter.toString()});
                if (reportFilter == null) {
                    reportFilter = filter;
                } else {
                    reportFilter.or(filter);
                }
            } else if (String.valueOf(AreaSettingEnum.LYEAR_GET_NUM.getValue()).equals(templateArea.getString("areatype"))) {
                String targetYear = String.valueOf(Integer.parseInt(year) - 1);
                lastKey = lastKey + targetYear + ":";
                filter.and(new QFilter("year", "=", (Object)targetYear));
                filter.and(new QFilter("belongperiod", "=", (Object)currentReport.getLong("belongperiod.id")));
                lastKey = lastKey + currentReport.getLong("belongperiod.id") + ":";
                LOG.info("previousPeroidDataRetrival:last year same peroid retrive {} from {} filter->{}", new Object[]{templateArea.getString("areapoint"), templateArea.getString("srcareapoint"), filter.toString()});
                if (lyReportFilter == null) {
                    lyReportFilter = filter;
                } else {
                    lyReportFilter.or(filter);
                }
            }
            lastMapRepEntryId.put(lastKey, repentryid);
        }
        ReportApplicationService.afterQueryHisReport(String.valueOf(AreaSettingEnum.LAST_GET_NUM.getValue()), reportFilter, rptAreaMap, sheets, lastMapRepEntryId);
        ReportApplicationService.afterQueryHisReport(String.valueOf(AreaSettingEnum.LYEAR_GET_NUM.getValue()), lyReportFilter, rptAreaMap, sheets, lastMapRepEntryId);
    }

    private static void afterQueryHisReport(String areType, QFilter reportFilter, Map<Long, List<DynamicObject>> rptAreaMap, JSONObject sheets, Map<String, Long> lastMapRepEntryId) {
        if (reportFilter != null) {
            DynamicObject[] historyReports = reportQueryService.query(new QFilter[]{reportFilter});
            if (historyReports.length == 0) {
                LOG.info("previousPeroidDataRetrival not find history report,filter {}", (Object)reportFilter.toString());
            }
            Arrays.asList(historyReports).forEach(historyReport -> {
                String hisKey = ReportApplicationService.getHisReportKey(historyReport);
                Long repentryid = (Long)lastMapRepEntryId.get(hisKey);
                List areaList = (List)rptAreaMap.get(repentryid);
                if (HRObjectUtils.isEmpty((Object)areaList)) {
                    LOG.info("previousPeroidDataRetrival history report area is null");
                } else {
                    areaList.forEach(area -> {
                        if (areType.equals(area.getString("areatype"))) {
                            String tareaStr = area.getString("areapoint");
                            String sareaStr = area.getString("srcareapoint");
                            ReportApplicationService.updateReportPrePeriodData(sheets, historyReport, sareaStr, tareaStr);
                        }
                    });
                }
            });
        } else {
            LOG.info("previousPeroidDataRetrival no valid report filter");
        }
    }

    private static String getHisReportKey(DynamicObject historyReport) {
        long rptTplId = historyReport.getLong("rpttpl.id");
        long exeUnitId = historyReport.getLong("exeunit.id");
        long disUnitId = historyReport.getLong("disunit.id");
        String targetYear = historyReport.getString("year");
        long targetPeriodId = historyReport.getLong("belongperiod.id");
        String lastKey = rptTplId + ":";
        lastKey = lastKey + exeUnitId + ":";
        lastKey = lastKey + disUnitId + ":";
        lastKey = lastKey + targetYear + ":";
        if (targetPeriodId != 0L) {
            lastKey = lastKey + targetPeriodId + ":";
        }
        return lastKey;
    }

    public static void updateReportPrePeriodData(JSONObject sheets, DynamicObject srcReport, String srcArea, String targetArea) {
        String srcReportContent = srcReport.getString("json_tag");
        if (HRStringUtils.isEmpty((String)srcReportContent)) {
            return;
        }
        JSONObject srcSheet = SpreadJsonHelper.getFirstSheetJson((String)srcReportContent);
        JSONObject srcData = (JSONObject)srcSheet.get((Object)"data");
        JSONObject srcDataTable = (JSONObject)srcData.get((Object)"dataTable");
        List srcCells = AreaUtil.splitCell((String)srcArea);
        JSONObject targetSheet = null;
        for (Object sheet : sheets.values()) {
            JSONObject tmpSheet = (JSONObject)sheet;
            if (!srcReport.getDynamicObject("rpttpl").getString("number").equals(tmpSheet.getString("name"))) continue;
            targetSheet = tmpSheet;
            break;
        }
        if (targetSheet != null) {
            JSONObject targetData = (JSONObject)targetSheet.get((Object)"data");
            JSONObject targetDataTable = (JSONObject)targetData.get((Object)"dataTable");
            List targetCellls = AreaUtil.splitCell((String)targetArea);
            for (int index = 0; index < srcCells.size() && index < targetCellls.size(); ++index) {
                ReportApplicationService.changeTargetCellValue(srcDataTable, (Cell)srcCells.get(index), targetDataTable, (Cell)targetCellls.get(index));
            }
            if (srcCells.size() == targetCellls.size()) {
                // empty if block
            }
        }
    }

    private static void changeTargetCellValue(JSONObject srcDataTable, Cell src, JSONObject targetDataTable, Cell target) {
        JSONObject srcRow = srcDataTable.getJSONObject(String.valueOf(src.getRow()));
        if (srcRow == null) {
            return;
        }
        JSONObject srcCol = srcRow.getJSONObject(String.valueOf(src.getCol()));
        if (srcCol != null && srcCol.containsKey((Object)"value")) {
            JSONObject targetRow = targetDataTable.getJSONObject(String.valueOf(target.getRow()));
            if (targetRow == null) {
                return;
            }
            JSONObject targetCol = targetRow.getJSONObject(String.valueOf(target.getCol()));
            if (targetCol != null) {
                if (ReportApplicationService.isNumeric(srcCol.getString("value"))) {
                    targetCol.put("value", (Object)new BigDecimal(srcCol.getString("value")));
                } else {
                    targetCol.put("value", (Object)srcCol.getString("value"));
                }
            }
        }
    }

    private static boolean isNumeric(String str) {
        if (HRStringUtils.isEmpty((String)str)) {
            return false;
        }
        try {
            Double aDouble = Doubles.tryParse((String)str);
            return aDouble != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static void variableRetrive(DynamicObject fillTask, DynamicObject[] reports, JSONObject sheets) {
        ArrayList rptentryIds = Lists.newArrayListWithExpectedSize((int)reports.length);
        Arrays.asList(reports).forEach(report -> rptentryIds.add(report.getLong("repentryid")));
        List<DynamicObject> reportVars = RptTplVarService.getInstance().queryByRepConfIds(rptentryIds);
        HashMap reportVarMap = Maps.newHashMap();
        reportVars.forEach(var -> {
            List<DynamicObject> tmpList = null;
            if (reportVarMap.containsKey(var.getLong("reportconfid.id"))) {
                tmpList = (List)reportVarMap.get(var.getLong("reportconfid.id"));
            } else {
                tmpList = new ArrayList();
                reportVarMap.put(var.getLong("reportconfid.id"), tmpList);
            }
            tmpList.add((DynamicObject)var);
        });
        Arrays.asList(reports).forEach(report -> {
            List tplVars = (List)reportVarMap.get(report.getLong("rpttpl.id"));
            if (tplVars == null) {
                return;
            }
            for (DynamicObject var : tplVars) {
                String value = ReportApplicationService.getVariableValue(fillTask, report, !HRObjectUtils.isEmpty((Object)var) && !HRObjectUtils.isEmpty((Object)var.getDynamicObject("reportvar")) && var.getDynamicObject("reportvar").containsProperty("varnumber") ? var.getDynamicObject("reportvar").getString("varnumber") : " ");
                if (HRStringUtils.isEmpty((String)value)) continue;
                String rptTplNumber = var.getDynamicObject("reportconfid").getString("number");
                String point = var.getString("point");
                String[] axis = point.split(":");
                for (Object sheet : sheets.values()) {
                    JSONObject tmpSheet = (JSONObject)sheet;
                    if (!rptTplNumber.equals(tmpSheet.getString("name"))) continue;
                    String srcValue = "";
                    JSONObject data = tmpSheet.getJSONObject("data");
                    JSONObject datatable = data.getJSONObject("dataTable");
                    JSONObject row = datatable.getJSONObject(axis[0]);
                    JSONObject col = null;
                    if (!HRObjectUtils.isEmpty((Object)row)) {
                        col = row.getJSONObject(axis[1]);
                    }
                    if (!HRObjectUtils.isEmpty(col)) {
                        srcValue = col.getString("value");
                    }
                    if (null == srcValue) continue;
                    StringBuilder builder = new StringBuilder("#{");
                    builder.append(var.getDynamicObject("reportvar").getString("name"));
                    builder.append("}");
                    col.put("value", (Object)srcValue.replace(builder.toString(), HRStringUtils.isEmpty((String)value) ? "" : value));
                    LOG.info("variableRetrive {} -> {}", (Object)builder.toString(), (Object)(HRStringUtils.isEmpty((String)value) ? "" : value));
                }
            }
        });
    }

    private static String getVariableValue(DynamicObject fillTask, DynamicObject report, String var) {
        if ("adminorg".equals(var)) {
            return fillTask.getDynamicObject("exeunit").getString("name");
        }
        if ("filluser".equals(var)) {
            return RequestContext.get().getUserName();
        }
        if ("belongperiod".equals(var)) {
            return report.getDynamicObject("belongperiod").getString("name");
        }
        if ("startdate".equals(var)) {
            Date date = report.getDate("datastarttime");
            return DateUtils.dateToString((Date)date, (DatePattern)DatePattern.YYYY_MM_DD);
        }
        if ("enddate".equals(var)) {
            Date date = report.getDate("dataendtime");
            return DateUtils.dateToString((Date)date, (DatePattern)DatePattern.YYYY_MM_DD);
        }
        if ("belongyear".equals(var)) {
            return report.getString("year");
        }
        return "";
    }
}

