/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.application.report;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ReportPeroidApplicationService {
    private Map<String, Map<String, DynamicObject>> peroidMap = new HashMap<String, Map<String, DynamicObject>>(16);
    private Map<String, Integer> typeMaxIndex = new HashMap<String, Integer>(4);
    private static ReportPeroidApplicationService computer;

    private ReportPeroidApplicationService() {
        HRBaseServiceHelper peroidHelper = new HRBaseServiceHelper("soehrr_belongperiod");
        DynamicObject[] periodObjs = peroidHelper.query("id,name,number,periodtype,index", new QFilter[0], "index desc");
        Arrays.asList(periodObjs).forEach(peroid -> {
            String periodtypeNumber = peroid.getDynamicObject("periodtype").getString("number");
            int val = peroid.getInt("index");
            if (!this.typeMaxIndex.containsKey(periodtypeNumber)) {
                this.typeMaxIndex.put(periodtypeNumber, val);
            }
            Map<Object, Object> map = null;
            map = !this.peroidMap.containsKey(periodtypeNumber) ? new HashMap(16) : this.peroidMap.get(periodtypeNumber);
            map.put(String.valueOf(val), peroid);
            this.peroidMap.put(periodtypeNumber, map);
        });
    }

    public static ReportPeroidApplicationService getInstance() {
        if (computer == null) {
            computer = new ReportPeroidApplicationService();
        }
        return computer;
    }

    public DynamicObject compute(DynamicObject peroid) {
        String periodtypeNumber = peroid.getDynamicObject("periodtype").getString("number");
        int val = peroid.getInt("index");
        int lastVal = val - 1;
        if (val == 1) {
            lastVal = this.typeMaxIndex.get(periodtypeNumber);
        }
        Map<String, DynamicObject> typePeroids = this.peroidMap.get(periodtypeNumber);
        return typePeroids.get(String.valueOf(lastVal));
    }
}

