/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.application.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.filltask.BorderStyleRecordDto;
import kd.sdk.sihc.soehrr.common.report.dto.RepValidatorDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soehrr.business.application.report.ReportVerParam;
import kd.sihc.soehrr.business.application.report.ReportVerResult;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskCheckStyleService;
import kd.sihc.soehrr.business.domain.rpttplvalidatort.RptTplValidatorService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.common.check.ExpressionEvaluator;
import kd.sihc.soehrr.common.check.ExpressionSplitor;

public class ReportVerApplicationService {
    private static FillTaskCheckStyleService fillTaskCheckStyleService = ServiceFactory.getService(FillTaskCheckStyleService.class);
    private static final Log LOG = LogFactory.getLog(ReportVerApplicationService.class);

    public static ReportVerResult checkTask(DynamicObject fillTask, SpreadModelParam spreadParam) {
        List allSheetsVerRules = spreadParam.getSheetManager().getAllSheetRuleByEntity("soehrr_rpttplverrule");
        Map<Long, RepValidatorDto> verRuleIdMapDto = allSheetsVerRules.stream().collect(Collectors.toMap(ver -> ver.getId(), ver -> ver));
        String compressSpreadJson = fillTask.getString("trepcontent_tag");
        String uncompressJson = GzipTools.uncompressJson((String)compressSpreadJson);
        JSONObject spreadJsonObject = JSON.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        Map datatableMap = SpreadJsonHelper.sheetNameMapDataTable((JSONObject)spreadJsonObject);
        return ReportVerApplicationService.checkByDto(datatableMap, allSheetsVerRules, verRuleIdMapDto, Collections.emptyList());
    }

    public static ReportVerResult checkTask(DynamicObject fillTask) {
        List allSheetsVerRules = RptTplValidatorService.getInstance().getRptTplCacheByFillTask(fillTask.getLong("id"));
        Map<Long, RepValidatorDto> verRuleIdMapDto = allSheetsVerRules.stream().collect(Collectors.toMap(ReportCacheDto::getId, ver -> ver));
        String compressSpreadJson = fillTask.getString("trepcontent_tag");
        String uncompressJson = GzipTools.uncompressJson((String)compressSpreadJson);
        JSONObject spreadJsonObject = JSON.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        Map datatableMap = SpreadJsonHelper.sheetNameMapDataTable((JSONObject)spreadJsonObject);
        return ReportVerApplicationService.checkByDto(datatableMap, allSheetsVerRules, verRuleIdMapDto, Collections.emptyList());
    }

    public static List<ReportVerResult> checkCell(List<ReportVerParam> params, SpreadModelParam spreadParam, JSONObject spreadJsonObject) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)10);
        List allSheetsVerRules = spreadParam.getSheetManager().getAllSheetRuleByEntity("soehrr_rpttplverrule");
        Map<Long, RepValidatorDto> verRuleIdMapDto = allSheetsVerRules.stream().collect(Collectors.toMap(ver -> ver.getId(), ver -> ver));
        Map datatableMap = SpreadJsonHelper.sheetNameMapDataTable((JSONObject)spreadJsonObject);
        for (ReportVerParam param : params) {
            ReportVerResult result = new ReportVerResult();
            StringBuilder builder = new StringBuilder(param.getSheetName());
            builder.append("!").append(param.getRow()).append(":").append(param.getCol());
            ArrayList needRules = Lists.newArrayListWithExpectedSize((int)10);
            for (RepValidatorDto verRuleDto : allSheetsVerRules) {
                if (!ExpressionEvaluator.matchOfExpression((String)verRuleDto.getExpression(), (String)builder.toString())) continue;
                needRules.add(verRuleDto);
            }
            if (needRules.isEmpty()) {
                result.setInputParam(param);
                results.add(result);
                continue;
            }
            List<BorderStyleRecordDto> borderStyleRecords = fillTaskCheckStyleService.getAllBorderRecordInManager(spreadParam);
            ReportVerResult check = ReportVerApplicationService.checkByDto(datatableMap, needRules, verRuleIdMapDto, borderStyleRecords);
            check.setInputParam(param);
            results.add(check);
        }
        return results;
    }

    private static ReportVerResult checkByDto(Map<String, JSONObject> datatableMap, List<RepValidatorDto> needRules, Map<Long, RepValidatorDto> verRuleIdMapDto, List<BorderStyleRecordDto> borderStyleRecords) {
        ReportVerResult result = new ReportVerResult();
        ArrayList errorList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList successList = Lists.newArrayListWithExpectedSize((int)10);
        needRules.forEach(needRule -> {
            boolean evalResult = true;
            String comparator = needRule.getComparator();
            String expression = needRule.getExpression().replace(" ", "");
            try {
                List cellBorderStyles = borderStyleRecords.stream().filter(record -> record.getOperate() != OperateEnum.DELETE && record.getRptVerRuleId() == needRule.getId()).collect(Collectors.toList());
                List verUnits = ExpressionSplitor.splitItem((String)expression);
                Map<String, Object> values = ReportVerApplicationService.exactNum(datatableMap, verUnits);
                boolean needVer = true;
                String afterReplaceExpression = expression;
                for (Map.Entry<String, Object> entry : values.entrySet()) {
                    String item = entry.getKey();
                    Object cellValue = values.get(item);
                    if (HRObjectUtils.isEmpty((Object)cellValue) || !(cellValue instanceof Number)) {
                        needVer = false;
                        if (!HRCollUtil.isNotEmpty(cellBorderStyles)) break;
                        afterReplaceExpression = ExpressionEvaluator.replaceAllForExpression((String)afterReplaceExpression, (String)item, (String)"");
                        break;
                    }
                    String cellValStr = cellValue.toString();
                    double cellDouble = Double.parseDouble(cellValStr);
                    if (cellDouble < 0.0) {
                        cellValStr = "(0" + cellValStr + ")";
                    }
                    afterReplaceExpression = ExpressionEvaluator.replaceAllForExpression((String)afterReplaceExpression, (String)item, (String)cellValStr);
                }
                if (HRCollUtil.isNotEmpty(cellBorderStyles) || needVer) {
                    String[] verLeftAndRight = afterReplaceExpression.split(comparator);
                    if (verLeftAndRight.length == 1 || !needVer) {
                        evalResult = true;
                    } else {
                        double value = ExpressionEvaluator.executeExpression((String)verLeftAndRight[1]);
                        double leftValue = ExpressionEvaluator.executeExpression((String)verLeftAndRight[0]);
                        evalResult = ReportVerApplicationService.eval(comparator, String.valueOf(leftValue), value);
                    }
                }
            }
            catch (Exception ex) {
                LOG.info("ReportVerApplicationService.checkByDto executeExpression has error", (Object)ex);
                evalResult = true;
            }
            RepValidatorDto repValidatorDto = (RepValidatorDto)verRuleIdMapDto.get(needRule.getId());
            if (!evalResult) {
                String[] expresss = expression.split(comparator);
                HashMap map = Maps.newHashMapWithExpectedSize((int)6);
                map.put(ReportVerResult.ERROR_LEVEL, repValidatorDto.getChecklevel());
                String[] cells = expresss[0].split("!");
                String cellStrPoint = cells[1];
                map.put(ReportVerResult.ERROR_SHEET, repValidatorDto.getRptTplName());
                map.put(ReportVerResult.ERROR_SHEET_NUMBER, repValidatorDto.getRptTplNumber());
                map.put(ReportVerResult.ERROR_CELL, cellStrPoint);
                map.put("rptverruleid", String.valueOf(needRule.getId()));
                String needCheck = expression.substring(expression.indexOf(comparator));
                for (String unit : ExpressionSplitor.splitItem((String)needCheck)) {
                    String[] strss = unit.split("!");
                    StringBuilder builder = new StringBuilder((String)repValidatorDto.getNumberMapNames().get(strss[0]));
                    String[] split = strss[1].split(":");
                    String pos = ExcelUtils.xy2Pos((int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[0]));
                    builder.append(pos);
                    needCheck = ExpressionEvaluator.replaceAllForExpression((String)needCheck, (String)unit, (String)builder.toString());
                }
                ReportVerApplicationService.setErrorMap(needCheck, comparator, map);
                errorList.add(map);
            } else {
                HashMap successMap = Maps.newHashMapWithExpectedSize((int)6);
                ReportVerApplicationService.setSuccessMap(expression, needRule.getId(), successMap);
                successList.add(successMap);
            }
        });
        result.setErrors(errorList);
        result.setSuccess(successList);
        return result;
    }

    private static boolean eval(String comparator, String left, Double right) {
        if ("".equals(left)) {
            return true;
        }
        switch (comparator) {
            case "=": {
                return Double.valueOf(left).compareTo(right) == 0;
            }
            case "<>": {
                return Double.valueOf(left).compareTo(right) != 0;
            }
            case ">": {
                return Double.valueOf(left).compareTo(right) > 0;
            }
            case ">=": {
                return Double.valueOf(left).compareTo(right) >= 0;
            }
            case "<": {
                return Double.valueOf(left).compareTo(right) < 0;
            }
            case "<=": {
                return Double.valueOf(left).compareTo(right) <= 0;
            }
        }
        return true;
    }

    public static void setSuccessMap(String expression, Long ruleId, Map<String, Object> successMap) {
        successMap.put("rptverruleid", ruleId);
        HashMap relationPoints = Maps.newHashMapWithExpectedSize((int)6);
        List sheetAndPoints = ExpressionSplitor.splitItem((String)expression);
        for (String sheetAndPoint : sheetAndPoints) {
            String[] arr = sheetAndPoint.split("!");
            String sheetKey = arr[0].trim();
            String cellValue = arr[1].trim();
            if (relationPoints.containsKey(sheetKey)) {
                ((List)relationPoints.get(sheetKey)).add(cellValue);
                continue;
            }
            ArrayList valueList = Lists.newArrayListWithExpectedSize((int)10);
            valueList.add(cellValue);
            relationPoints.put(sheetKey, valueList);
        }
        successMap.put("relationpoints", relationPoints);
    }

    private static void setErrorMap(String bcheck, String comparator, Map<String, String> map) {
        switch (comparator) {
            case "=": {
                map.put(ReportVerResult.ERROR_MSG, bcheck.trim().replace(comparator, ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"COMPARATOR_0", (String)"sihc-soehrr-business", (Object[])new Object[0])));
                break;
            }
            case "<>": {
                map.put(ReportVerResult.ERROR_MSG, bcheck.trim().replace(comparator, ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"COMPARATOR_1", (String)"sihc-soehrr-business", (Object[])new Object[0])));
                break;
            }
            case ">": {
                map.put(ReportVerResult.ERROR_MSG, bcheck.trim().replace(comparator, ResManager.loadKDString((String)"\u5927\u4e8e", (String)"COMPARATOR_2", (String)"sihc-soehrr-business", (Object[])new Object[0])));
                break;
            }
            case ">=": {
                map.put(ReportVerResult.ERROR_MSG, bcheck.trim().replace(comparator, ResManager.loadKDString((String)"\u5927\u4e8e\u6216\u7b49\u4e8e", (String)"COMPARATOR_3", (String)"sihc-soehrr-business", (Object[])new Object[0])));
                break;
            }
            case "<": {
                map.put(ReportVerResult.ERROR_MSG, bcheck.trim().replace(comparator, ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"COMPARATOR_4", (String)"sihc-soehrr-business", (Object[])new Object[0])));
                break;
            }
            case "<=": {
                map.put(ReportVerResult.ERROR_MSG, bcheck.trim().replace(comparator, ResManager.loadKDString((String)"\u5c0f\u4e8e\u6216\u7b49\u4e8e", (String)"COMPARATOR_5", (String)"sihc-soehrr-business", (Object[])new Object[0])));
                break;
            }
        }
    }

    private static Map<String, Object> exactNum(Map<String, JSONObject> datatableMap, List<String> items) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        items.forEach(item -> {
            String[] strs = item.split("!");
            JSONObject datatable = (JSONObject)datatableMap.get(strs[0]);
            String[] cells = strs[1].split(":");
            int row = Integer.parseInt(cells[0]);
            int col = Integer.parseInt(cells[1]);
            result.put((String)item, ReportVerApplicationService.getCellValue(datatable, row, col));
        });
        return result;
    }

    private static Object getCellValue(JSONObject dataTable, int rowNum, int colNum) {
        JSONObject row = dataTable.getJSONObject(String.valueOf(rowNum));
        if (row == null) {
            return null;
        }
        JSONObject col = row.getJSONObject(String.valueOf(colNum));
        if (col == null) {
            return null;
        }
        return col.get((Object)"value");
    }
}

