/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.autogetnum;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.enums.hrreport.FieldComplexTypes;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soehrr.business.domain.autogetnum.HrAnalyseObjService;

public final class AutoGetNumFormHelper {
    private AutoGetNumFormHelper() {
    }

    public static void initDropDownConf(IFormView view, DynamicObject analyseObject) {
        Map<String, List<DynamicObject>> queryFieldsMap = HrAnalyseObjService.ins().fetchQueryFieldByType(analyseObject.getLong("id"), Lists.newArrayList((Object[])new FieldComplexTypes[]{FieldComplexTypes.ADMIN_ORG, FieldComplexTypes.DATE}));
        ArrayList orgComboItems = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList timeComboItems = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<String, List<DynamicObject>> entry : queryFieldsMap.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> dynamicObjects = entry.getValue();
            for (DynamicObject queryField : dynamicObjects) {
                ComboItem item = new ComboItem();
                String number = queryField.getString("fieldalias");
                item.setValue(queryField.getPkValue().toString());
                OrmLocaleValue name = (OrmLocaleValue)queryField.getLocaleString("fieldname");
                String localeValue = name.getLocaleValue();
                item.setCaption(new LocaleString(localeValue));
                item.setId(number);
                if (HRStringUtils.equals((String)key, (String)FieldComplexTypes.ADMIN_ORG.getComplexType())) {
                    orgComboItems.add(item);
                    continue;
                }
                if (!HRStringUtils.equals((String)key, (String)FieldComplexTypes.DATE.getComplexType())) continue;
                timeComboItems.add(item);
            }
        }
        ComboEdit orgCombo = (ComboEdit)view.getControl("fillorgrange");
        orgCombo.setComboItems((List)orgComboItems);
        ComboEdit dateRangeCombo = (ComboEdit)view.getControl("dateperiodrange");
        dateRangeCombo.setComboItems((List)timeComboItems);
        DynamicObject orgField = (DynamicObject)view.getModel().getValue("fillorg");
        DynamicObject datetimeField = (DynamicObject)view.getModel().getValue("dateperiod");
        if (!HRObjectUtils.isEmpty((Object)orgField)) {
            view.getModel().setValue("fillorgrange", (Object)orgField.getString("id"));
        }
        if (!HRObjectUtils.isEmpty((Object)datetimeField)) {
            view.getModel().setValue("dateperiodrange", (Object)datetimeField.getString("id"));
        }
    }

    public static void initAnaGroups(IFormView view, DynamicObject analyseObject) {
        Map<Long, DynamicObjectCollection> groupMapItems = HrAnalyseObjService.ins().fetchGroupItemByAnObj(analyseObject.getLong("id"));
        ArrayList groupComboItems = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<Long, DynamicObjectCollection> entry : groupMapItems.entrySet()) {
            Long groupId = entry.getKey();
            DynamicObjectCollection items = entry.getValue();
            for (DynamicObject groupItem : items) {
                ComboItem colItem = new ComboItem();
                colItem.setValue(groupItem.getString("itemnumber"));
                colItem.setCaption(new LocaleString(groupItem.getString("itemname")));
                colItem.setId(groupId + "_" + groupItem.getPkValue());
                groupComboItems.add(colItem);
            }
        }
        view.getPageCache().put("cache_group_item", GzipTools.toByteSerialized((Object)groupComboItems));
    }

    public static void initRowColConf(SpreadModelParam spreadParam) {
        int index;
        IFormView view = spreadParam.getView();
        IDataModel model = view.getModel();
        String selectorStr = (String)view.getFormShowParameter().getCustomParam("spread_selector");
        SpreadSelector selector = (SpreadSelector)GzipTools.deSerializedBytes((String)selectorStr);
        EntryGrid rowEntryGrid = (EntryGrid)view.getControl("rowentryentity");
        EntryGrid colEntryGrid = (EntryGrid)view.getControl("colentryentity");
        if (selector.getSpanRow() - 1 > 0) {
            rowEntryGrid.getModel().batchCreateNewEntryRow("rowentryentity", selector.getSpanRow() - 1);
        }
        if (selector.getSpanCol() - 1 > 0) {
            colEntryGrid.getModel().batchCreateNewEntryRow("colentryentity", selector.getSpanCol() - 1);
        }
        model.beginInit();
        ArrayList rowItems = Lists.newArrayListWithExpectedSize((int)selector.getSpanRow());
        for (index = 0; index < selector.getSpanRow(); ++index) {
            DynamicObject rowObj = model.getEntryRowEntity("rowentryentity", index);
            int rowNo = index + selector.getStartRow();
            int showRow = rowNo + 1;
            rowObj.set("rowno", (Object)showRow);
            rowObj.set("row", (Object)rowNo);
            ComboItem rowItem = new ComboItem();
            String rowStr = String.valueOf(showRow);
            rowItem.setValue(rowStr);
            rowItem.setCaption(new LocaleString(rowStr));
            rowItem.setId(rowStr);
            rowItems.add(rowItem);
        }
        for (index = 0; index < selector.getSpanCol(); ++index) {
            DynamicObject colObj = model.getEntryRowEntity("colentryentity", index);
            colObj.set("col", (Object)(index + selector.getStartCol()));
            colObj.set("colno", (Object)ExcelUtils.int2pos((int)(index + selector.getStartCol())));
        }
        ComboEdit rowsCombo = (ComboEdit)view.getControl("rowno");
        rowsCombo.setComboItems((List)rowItems);
        model.endInit();
    }

    public static void clickGroupItem(SpreadModelParam spreadParam, int rowIndex, IFormPlugin plugin) {
        IFormView view = spreadParam.getView();
        String groupV = (String)view.getModel().getValue("groupv", rowIndex);
        if (HRStringUtils.isEmpty((String)groupV)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7ec4\uff0c\u518d\u9009\u62e9\u5206\u7ec4\u9879", (String)"AutoGetNumFormHelper_0", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        String groupMapStr = view.getPageCache().get("cache_group_item");
        List groupComboItems = (List)GzipTools.deSerializedBytes((String)groupMapStr);
        ArrayList initComboItems = Lists.newArrayListWithExpectedSize((int)10);
        for (ComboItem groupComboItem : groupComboItems) {
            String comboItemId = groupComboItem.getId();
            String[] groupMsg = comboItemId.split("_");
            String groupId = groupMsg[0];
            if (!groupId.equals(groupV)) continue;
            initComboItems.add(groupComboItem);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("soehrr_groupitems");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("groupitems", (Object)GzipTools.toByteSerialized((Object)initComboItems));
        parameter.setCloseCallBack(new CloseCallBack(plugin, "soehrr_groupitems"));
        view.showForm(parameter);
    }
}

