/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.autogetnum;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.enums.hrreport.FieldComplexTypes;

public class HrAnalyseObjService {
    private static final HRBaseServiceHelper queryFieldHelper = new HRBaseServiceHelper("hrptmc_anobjqueryfield");
    private HRBaseServiceHelper calculateFieldHelper = new HRBaseServiceHelper("hrptmc_calculatefield");
    private static final HRBaseServiceHelper groupFieldHelper = new HRBaseServiceHelper("hrptmc_anobjgroupfield");
    private static final Log LOG = LogFactory.getLog(HrAnalyseObjService.class);

    public Map<String, List<DynamicObject>> fetchQueryFieldByType(long analyseObjId, List<FieldComplexTypes> fieldComplexTypes) {
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)10);
        for (FieldComplexTypes fieldComplexType : fieldComplexTypes) {
            QFilter analyseObjFilter = new QFilter("anobj", "=", (Object)analyseObjId);
            if (HRStringUtils.isNotEmpty((String)fieldComplexType.getComplexType())) {
                analyseObjFilter.and(new QFilter("complextype", "=", (Object)fieldComplexType.getComplexType()));
            }
            if (!fieldComplexType.getFieldTypes().isEmpty()) {
                analyseObjFilter.and(new QFilter("valuetype", "in", (Object)fieldComplexType.getFieldTypes()));
            }
            if (HRCollUtil.isEmpty((Collection)qFilters)) {
                qFilters.add(analyseObjFilter);
                continue;
            }
            QFilter lastQFilter = (QFilter)qFilters.get(qFilters.size() - 1);
            lastQFilter.or(analyseObjFilter);
        }
        DynamicObject[] queryFields = queryFieldHelper.query("complextype,valuetype,fieldalias,fieldname", qFilters.toArray(new QFilter[0]));
        Map<String, List<DynamicObject>> complexTypeMap = Arrays.stream(queryFields).collect(Collectors.groupingBy(qf -> qf.getString("complextype")));
        return complexTypeMap;
    }

    public Map<Long, DynamicObjectCollection> fetchGroupItemByAnObj(long anObjId) {
        QFilter analyseObjFilter = new QFilter("anobj", "=", (Object)anObjId);
        DynamicObject[] groupFields = groupFieldHelper.loadDynamicObjectArray(analyseObjFilter.toArray());
        HashMap groupMapItems = Maps.newHashMapWithExpectedSize((int)groupFields.length);
        for (DynamicObject groupField : groupFields) {
            long grId = groupField.getLong("id");
            DynamicObjectCollection groupItems = groupField.getDynamicObjectCollection("group");
            groupMapItems.put(grId, groupItems);
        }
        return groupMapItems;
    }

    public DynamicObject getQueryFieldById(Object primaryKey) {
        return queryFieldHelper.queryOne(primaryKey);
    }

    public DynamicObject getCalculateFieldById(Object primaryKey) {
        return this.calculateFieldHelper.queryOne(primaryKey);
    }

    public static HrAnalyseObjService ins() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final HrAnalyseObjService INSTANCE = new HrAnalyseObjService();

        private Instance() {
        }
    }
}

