/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CusExceptionEnum;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.RepValidatorDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sihc.soehrr.business.domain.report.ReportService;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.domain.rpttplarea.RptTplAreaService;
import kd.sihc.soehrr.business.domain.rpttplvalidatort.RptTplValidatorService;

public interface QueryInitCache {
    public static final Log LOG = LogFactory.getLog(QueryInitCache.class);

    default public List<ReportCacheDto> convertCacheDto(List<DynamicObject> dynamicObjects) {
        ArrayList varList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.size());
        try {
            for (DynamicObject dy : dynamicObjects) {
                Class<?> clazz = Class.forName(this.getCacheClass());
                ReportCacheDto cacheDto = (ReportCacheDto)clazz.newInstance();
                cacheDto.dyConvert2Dto(dy);
                varList.add(cacheDto);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOG.error("QueryInitCache.getReportCacheData has error", (Throwable)ex);
            throw new KDBizException(CusExceptionEnum.DATA_ERROR.getName());
        }
        return varList;
    }

    default public List<? extends ReportCacheDto> getReportCacheData(long reportConfId, long currentEntryId) {
        List<DynamicObject> dynamicObjects = this.queryByRepConfId(reportConfId, currentEntryId);
        if (HRCollUtil.isEmpty(dynamicObjects)) {
            return Collections.emptyList();
        }
        return this.convertCacheDto(dynamicObjects);
    }

    default public List<? extends ReportCacheDto> getRptTplCacheByFillTask(long fillTaskId) {
        List<ReportCacheDto> varList;
        block6: {
            String canonicalName;
            Object[] reports;
            block5: {
                reports = ReportService.ins().queryTplByFillTask(fillTaskId);
                if (HRArrayUtils.isEmpty((Object[])reports)) {
                    return Collections.emptyList();
                }
                List<Long> rptEntryIds = Arrays.stream(reports).map(report -> report.getLong("repentryid")).collect(Collectors.toList());
                LOG.info("QueryInitCache.getRptTplCacheByFillTask fillTaskId = {} , rptEntryIds= {} ", (Object)fillTaskId, rptEntryIds);
                canonicalName = this.getClass().getCanonicalName();
                varList = this.queryRptTplConfByEntryIds(rptEntryIds);
                if (!HRStringUtils.equals((String)canonicalName, (String)RptTplValidatorService.class.getCanonicalName())) break block5;
                ArrayList rptTplNumbers = Lists.newArrayListWithExpectedSize((int)16);
                HashMap ruleMapRptNumber = Maps.newHashMapWithExpectedSize((int)varList.size());
                for (ReportCacheDto cacheDto : varList) {
                    RepValidatorDto verRuleDto = (RepValidatorDto)cacheDto;
                    Set<String> splitSheetNumbers = RptTplValidatorService.getInstance().getExpressionSheetNumbers(verRuleDto);
                    ruleMapRptNumber.put(cacheDto.getId(), splitSheetNumbers);
                    rptTplNumbers.addAll(splitSheetNumbers);
                }
                List<String> paramNumbers = rptTplNumbers.stream().distinct().collect(Collectors.toList());
                DynamicObject[] rptTpls = RptTplService.getInstance().queryFieldByNumbers(paramNumbers, new String[0]);
                Map<String, String> numberMapName = Arrays.stream(rptTpls).collect(Collectors.toMap(rt -> rt.getString("number"), rt -> rt.getString("name")));
                for (ReportCacheDto cacheDto : varList) {
                    RepValidatorDto verRuleDto = (RepValidatorDto)cacheDto;
                    Set ruleHasRptNumbers = (Set)ruleMapRptNumber.get(verRuleDto.getId());
                    HashMap expNumberMapName = Maps.newHashMapWithExpectedSize((int)ruleHasRptNumbers.size());
                    for (String ruleHasRptNumber : ruleHasRptNumbers) {
                        String rptTplName = numberMapName.get(ruleHasRptNumber);
                        if (!HRStringUtils.isNotEmpty((String)rptTplName)) continue;
                        expNumberMapName.put(ruleHasRptNumber, rptTplName);
                    }
                    verRuleDto.setNumberMapNames((Map)expNumberMapName);
                }
                break block6;
            }
            if (!HRStringUtils.equals((String)canonicalName, (String)RptTplAreaService.class.getCanonicalName())) break block6;
            Map<Long, DynamicObject> entryIdMapReport = Arrays.stream(reports).collect(Collectors.toMap(report -> report.getLong("repentryid"), report -> report));
            List fillAreas = varList.stream().filter(dto -> {
                AreaSettingDto areaSettingDto = (AreaSettingDto)dto;
                AreaSettingEnum areaSetting = areaSettingDto.getAreaSetting();
                return areaSetting == AreaSettingEnum.FILL || areaSetting == AreaSettingEnum.DYNAMIC_SUMMARY;
            }).collect(Collectors.toList());
            for (ReportCacheDto cacheDto : fillAreas) {
                String reportFillArea;
                AreaSettingDto areaSettingDto = (AreaSettingDto)cacheDto;
                long repEntryId = areaSettingDto.getRepEntryId();
                DynamicObject report2 = entryIdMapReport.get(repEntryId);
                if (HRObjectUtils.isEmpty((Object)report2) || !HRStringUtils.isNotEmpty((String)(reportFillArea = report2.getString("fillarea")))) continue;
                areaSettingDto.setAreaPoint(reportFillArea);
            }
        }
        return varList;
    }

    default public List<ReportCacheDto> queryRptTplConfByEntryIds(List<Long> rptEntryIds) {
        DynamicObject[] dynamicObjects = this.loadByRptEntryIds(rptEntryIds);
        return this.convertCacheDto(Arrays.asList((Object[])dynamicObjects.clone()));
    }

    public DynamicObject[] loadByRptEntryIds(List<Long> var1);

    public List<DynamicObject> queryByRepConfId(long var1, long var3);

    public String getCacheClass();

    public DynamicObject[] queryByRptTplId(List<Long> var1);

    default public List<? extends ReportCacheDto> getRptTplAllConfData(List<Long> rptTplIds) {
        List<DynamicObject> dynamicObjects = Arrays.asList(this.queryByRptTplId(rptTplIds));
        if (HRCollUtil.isEmpty(dynamicObjects)) {
            return Collections.emptyList();
        }
        return this.convertCacheDto(dynamicObjects);
    }

    public void refreshCopyNumber(List<ReportCacheDto> var1, SpreadModelParam var2, DynamicObject var3, String var4);
}

