/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.areaconf.RptAreaConfService;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CollectTypeEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.report.TipContent;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.AutoAreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.RepRuntimeVar;
import kd.sdk.sihc.soehrr.common.report.dto.RepValidatorDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sihc.soehrr.business.domain.cache.QueryInitCache;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.domain.rpttplarea.RptTplAreaService;
import kd.sihc.soehrr.business.domain.rpttplarea.RptTplAutoAreaService;
import kd.sihc.soehrr.business.domain.rpttplvalidatort.RptTplValidatorService;
import kd.sihc.soehrr.business.domain.rpttplvar.RptTplVarService;

public class RepCacheService {
    private static final Map<String, QueryInitCache> QUERY_CACHE_HANDLERS = Maps.newHashMapWithExpectedSize((int)16);

    public void customInitReportConfCache(SpreadModelParam spreadModelParam) {
        HashMap customServiceMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!HRMapUtils.isEmpty((Map)customServiceMap)) {
            for (Map.Entry initCacheEntry : customServiceMap.entrySet()) {
                String key = (String)initCacheEntry.getKey();
                QUERY_CACHE_HANDLERS.put(key, (QueryInitCache)initCacheEntry.getValue());
            }
        }
        this.initReportConfCache(spreadModelParam);
    }

    public void initReportConfCache(SpreadModelParam spreadModelParam) {
        boolean copyFlag;
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        IFormView view = spreadModelParam.getView();
        if (null == sheetManager) {
            return;
        }
        DynamicObject rptTpl = view.getModel().getDataEntity(true);
        BaseShowParameter formShowParameter = (BaseShowParameter)view.getFormShowParameter();
        Object isCopy = formShowParameter.getCustomParam("iscopy");
        boolean bl = copyFlag = Objects.nonNull(isCopy) && (Boolean)isCopy != false;
        if (copyFlag) {
            Object pkId = formShowParameter.getPkId();
            rptTpl = RptTplService.getInstance().loadSingle(pkId);
            String copyName = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s-\u590d\u5236", (String)"RepCacheService_0", (String)"sihc-soehrr-business", (Object[])new Object[0]), rptTpl.getString("name"));
            view.getModel().setValue("name", (Object)copyName);
            view.getModel().setValue("issyspreset", (Object)false);
            view.getModel().setValue("ctrlstrategy", rptTpl.get("ctrlstrategy"));
            view.getModel().setDataChanged(false);
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
            entryEntity.removeIf(entry -> !entry.getBoolean("isnowedit") || entry.getBoolean("isnewversion"));
            view.updateView("entryentity");
        }
        CacheObjInvoker invoker = sheetManager.getInvoker();
        invoker.clearCache();
        List<ReportCacheDto> reportDepends = this.queryAndRefreshRptTplConfs(rptTpl, copyFlag);
        invoker.setCacheDtoList(reportDepends);
        Map areaConfMap = RptAreaConfService.ins().initRptAreaConf();
        sheetManager.setRptAreaConfMapping(areaConfMap);
        sheetManager.setSheetCache(view.getPageCache());
    }

    public void refreshCopyNumber(List<ReportCacheDto> reportDepends, SpreadModelParam spreadModelParam, DynamicObject oldRptTpl, String newRptTplNumber) {
        for (Map.Entry<String, QueryInitCache> initCacheEntry : QUERY_CACHE_HANDLERS.entrySet()) {
            QueryInitCache queryInitCache = initCacheEntry.getValue();
            queryInitCache.refreshCopyNumber(reportDepends, spreadModelParam, oldRptTpl, newRptTplNumber);
        }
    }

    public List<ReportCacheDto> queryAndRefreshRptTplConfs(DynamicObject rptTpl, boolean copyFlag) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        long rptTplId = rptTpl.getLong("id");
        DynamicObject queryRptTpl = RptTplService.getInstance().queryNowEntryEntity("json_tag", rptTplId);
        long currentEntryId = RptTplService.getInstance().getCurrentEntryId(queryRptTpl);
        for (Map.Entry<String, QueryInitCache> initCacheEntry : QUERY_CACHE_HANDLERS.entrySet()) {
            QueryInitCache queryInitCache = initCacheEntry.getValue();
            if (rptTplId == 0L || currentEntryId == 0L) continue;
            List<? extends ReportCacheDto> reportDepends = queryInitCache.getReportCacheData(rptTplId, currentEntryId);
            if (copyFlag) {
                for (ReportCacheDto reportCacheDto : reportDepends) {
                    reportCacheDto.setReportId(0L);
                    reportCacheDto.setRepEntryId(0L);
                    reportCacheDto.setOperate(OperateEnum.ADD);
                    reportCacheDto.setId(0L);
                }
            }
            result.addAll(reportDepends);
        }
        return result;
    }

    public List<ReportCacheDto> queryAllRptTplConfs(DynamicObject[] rptTplList) {
        List<Long> rptTplIds = Arrays.stream(rptTplList).map(rp -> rp.getLong("id")).collect(Collectors.toList());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<String, QueryInitCache> initCacheEntry : QUERY_CACHE_HANDLERS.entrySet()) {
            QueryInitCache queryInitCache = initCacheEntry.getValue();
            List<? extends ReportCacheDto> reportDepends = queryInitCache.getRptTplAllConfData(rptTplIds);
            result.addAll(reportDepends);
        }
        return result;
    }

    public boolean cellHasRuntimeVar(SheetManager sheetManager, Cell cell) {
        List allRuntimeVars = sheetManager.getInvoker().getAllByEntityId("soehrr_rpttplvar");
        for (RepRuntimeVar cacheRuntimeVar : allRuntimeVars) {
            OperateEnum varOperate = cacheRuntimeVar.getOperate();
            if (varOperate == OperateEnum.DELETE) continue;
            Cell compareCell = new Cell();
            compareCell.setRowAndCol(cacheRuntimeVar.getPoint());
            if (!cell.equals((Object)compareCell)) continue;
            return true;
        }
        return false;
    }

    public List<AreaSettingDto> getQueryAreaBySetting(CacheObjInvoker invoker, AreaSettingEnum areaSetting) {
        List queryFillArea = invoker.query("soehrr_rpttplarea");
        return queryFillArea.stream().filter(area -> area.getAreaSetting().getValue() == areaSetting.getValue()).collect(Collectors.toList());
    }

    public List<AreaSettingDto> getAddAreaBySetting(CacheObjInvoker invoker, AreaSettingEnum areaSetting) {
        List queryFillArea = invoker.getAdd("soehrr_rpttplarea");
        return queryFillArea.stream().filter(area -> area.getAreaSetting().getValue() == areaSetting.getValue()).collect(Collectors.toList());
    }

    public List<AreaSettingDto> getDataAreaBySetting(CacheObjInvoker invoker) {
        List<AreaSettingDto> allAreas = this.getAllEnableAreas(invoker);
        return allAreas.stream().filter(area -> area.getAreaSetting().getValue() != AreaSettingEnum.FILL.getValue() && area.getAreaSetting().getValue() != AreaSettingEnum.DYNAMIC_SUMMARY.getValue()).collect(Collectors.toList());
    }

    public List<AreaSettingDto> getAllEnableAreas(CacheObjInvoker invoker) {
        ArrayList allAreas = Lists.newArrayListWithExpectedSize((int)10);
        List dataAreas = invoker.getAllByEntityId("soehrr_rpttplarea");
        List autoGetAreas = invoker.getAllByEntityId("soehrr_rpttplarea_auto");
        allAreas.addAll(dataAreas);
        allAreas.addAll(autoGetAreas);
        return allAreas.stream().filter(area -> Lists.newArrayList((Object[])new OperateEnum[]{OperateEnum.ADD, OperateEnum.QUERY}).contains(area.getOperate())).collect(Collectors.toList());
    }

    public AreaSettingDto getFillOrTotalArea(CacheObjInvoker invoker) {
        List<AreaSettingDto> fillOrTotalArea = this.getExistAreaByType(invoker, AreaSettingEnum.FILL);
        if (HRCollUtil.isEmpty(fillOrTotalArea) && HRCollUtil.isEmpty(fillOrTotalArea = this.getExistAreaByType(invoker, AreaSettingEnum.DYNAMIC_SUMMARY))) {
            return null;
        }
        return fillOrTotalArea.get(0);
    }

    public List<AreaSettingDto> getExistAreaByType(CacheObjInvoker invoker, AreaSettingEnum settingEnum) {
        List<AreaSettingDto> queryFillArea = this.getQueryAreaBySetting(invoker, settingEnum);
        List<AreaSettingDto> addFillArea = this.getAddAreaBySetting(invoker, settingEnum);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        result.addAll(queryFillArea);
        result.addAll(addFillArea);
        return result;
    }

    public TipContent drawDataAreaCheck(SpreadModelParam modelParam, AreaSettingEnum drawAreaEnum) {
        SheetManager sheet = modelParam.getSheetManager();
        CacheObjInvoker invoker = sheet.getInvoker();
        SpreadSelector spreadSelector = modelParam.getSelector();
        if (spreadSelector.getSelections() != null && spreadSelector.getSelections().size() > 1) {
            return new TipContent(false, ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u533a\u57df\u64cd\u4f5c\uff0c\u8bf7\u52ff\u591a\u6b21\u9009\u53d6\u3002", (String)"ReportConfFormHelper_5", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        }
        TipContent fillCheck = this.checkFillArea(modelParam, drawAreaEnum);
        if (!fillCheck.isSuccess()) {
            return fillCheck;
        }
        List<AreaSettingDto> dataAreas = this.getDataAreaBySetting(invoker);
        if (AreaSettingEnum.SYS_AUTO_NUM == drawAreaEnum) {
            return this.checkSysGetNum(spreadSelector, dataAreas, invoker);
        }
        if (AreaSettingEnum.TOTAL_SUMMARY == drawAreaEnum) {
            return this.checkTotalSummary(spreadSelector, dataAreas, invoker);
        }
        return this.drawOnOtherArea(spreadSelector, dataAreas, invoker, drawAreaEnum);
    }

    private TipContent checkTotalSummary(SpreadSelector spreadSelector, List<AreaSettingDto> dataAreas, CacheObjInvoker invoker) {
        AreaSettingDto allFillArea = this.getFillOrTotalArea(invoker);
        SpreadSelector dsSelector = allFillArea.convert2Selector();
        if (!dsSelector.isRowAdjacent(spreadSelector)) {
            return new TipContent(false, ResManager.loadKDString((String)"\u8bf7\u5c06\u7f57\u5217\u6c47\u603b\u533a\u8bbe\u7f6e\u5728\u586b\u62a5\u533a\u5185\u7684\u9996\u884c\u6216\u5c3e\u884c\u3002", (String)"SettingArea_4", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        }
        if (spreadSelector.getSpanRow() > 1) {
            return new TipContent(false, ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5355\u884c\u7f57\u5217\u6c47\u603b\u533a\u3002", (String)"SettingArea_0", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        }
        for (AreaSettingDto dataArea : dataAreas) {
            SpreadSelector dataSelected = dataArea.convert2Selector();
            if (dataArea.getAreaSetting() == AreaSettingEnum.TOTAL_SUMMARY) {
                return new TipContent(false, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f57\u5217\u6c47\u603b\u533a\uff0c\u8bf7\u52ff\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"SettingArea_2", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            }
            if (!spreadSelector.checkIsIntersectArea(dataSelected) || dataArea.getAreaSetting() == AreaSettingEnum.CAL) continue;
            return TipContent.error((String)this.getHadOtherDataArea(allFillArea, AreaSettingEnum.TOTAL_SUMMARY));
        }
        return TipContent.success();
    }

    private TipContent checkSysGetNum(SpreadSelector spreadSelector, List<AreaSettingDto> dataAreas, CacheObjInvoker invoker) {
        AreaSettingDto fillOrTotalArea = this.getFillOrTotalArea(invoker);
        boolean isHad = false;
        for (AreaSettingDto dataArea : dataAreas) {
            SpreadSelector dataSelected = dataArea.convert2Selector();
            if (dataArea.getAreaSetting() != AreaSettingEnum.SYS_AUTO_NUM && spreadSelector.checkIsIntersectArea(dataSelected)) {
                isHad = true;
                break;
            }
            if (dataArea.getAreaSetting() != AreaSettingEnum.SYS_AUTO_NUM || spreadSelector.checkIsInArea(dataSelected) || spreadSelector.equals((Object)dataSelected) || !spreadSelector.checkIsIntersectArea(dataSelected)) continue;
            isHad = true;
            break;
        }
        if (isHad) {
            return TipContent.error((String)this.getHadOtherDataArea(fillOrTotalArea, AreaSettingEnum.SYS_AUTO_NUM));
        }
        return TipContent.success();
    }

    private TipContent drawOnOtherArea(SpreadSelector spreadSelector, List<AreaSettingDto> dataAreas, CacheObjInvoker invoker, AreaSettingEnum drawAreaEnum) {
        AreaSettingDto fillOrTotalArea = this.getFillOrTotalArea(invoker);
        for (AreaSettingDto dataArea : dataAreas) {
            SpreadSelector dataSelected = dataArea.convert2Selector();
            if (!spreadSelector.checkIsIntersectArea(dataSelected)) continue;
            return new TipContent(false, this.getHadOtherDataArea(fillOrTotalArea, drawAreaEnum));
        }
        return TipContent.success();
    }

    private String getHadOtherDataArea(AreaSettingDto fillOrTotalArea, AreaSettingEnum settingEnum) {
        return String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u672a\u8bbe\u7f6e\u8fc7\u5176\u4ed6\u533a\u57df\u7684%1$s\u5185\u8bbe\u7f6e%2$s\u3002", (String)"SettingArea_5", (String)"sihc-soehrr-business", (Object[])new Object[0]), fillOrTotalArea.getAreaSetting().getName().getDescription(), settingEnum.getName().getDescription());
    }

    private TipContent checkFillArea(SpreadModelParam modelParam, AreaSettingEnum areaSettingEnum) {
        SpreadSelector spreadSelector = modelParam.getSelector();
        SheetManager sheet = modelParam.getSheetManager();
        CacheObjInvoker invoker = sheet.getInvoker();
        AreaSettingDto fillArea = this.getFillOrTotalArea(invoker);
        if (null == fillArea) {
            DynamicObject rptTpl = modelParam.getView().getModel().getDataEntity();
            String fillName = HRStringUtils.equals((String)rptTpl.getString("collecttype"), (String)CollectTypeEnum.SUM.getType()) ? AreaSettingEnum.FILL.getName().getDescription() : AreaSettingEnum.DYNAMIC_SUMMARY.getName().getDescription();
            return new TipContent(false, String.format(ResManager.loadKDString((String)"\u8bf7\u5728%1$s\u5185\u8bbe\u7f6e%2$s\u3002", (String)"SettingArea_4", (String)"sihc-soehrr-business", (Object[])new Object[0]), fillName, areaSettingEnum.getName().getDescription()));
        }
        SpreadSelector fillSelector = fillArea.convert2Selector();
        if (!spreadSelector.checkIsInArea(fillSelector)) {
            return new TipContent(false, String.format(ResManager.loadKDString((String)"\u8bf7\u5728%1$s\u5185\u8bbe\u7f6e%2$s\u3002", (String)"SettingArea_4", (String)"sihc-soehrr-business", (Object[])new Object[0]), fillArea.getAreaSetting().getName().getDescription(), areaSettingEnum.getName().getDescription()));
        }
        return new TipContent(true, "");
    }

    public AutoAreaSettingDto queryAutoAreaBySelector(SpreadModelParam param) {
        SheetManager sheetManager = param.getSheetManager();
        List<AutoAreaSettingDto> autoGetNumAreas = this.getAutoGetNumAreas(sheetManager.getInvoker());
        SpreadSelector selector = param.getSelector();
        for (AutoAreaSettingDto autoGetNumArea : autoGetNumAreas) {
            String areaPoint = autoGetNumArea.getAreaPoint();
            SpreadSelector autoArea = new SpreadSelector(areaPoint);
            if (!autoArea.equals((Object)selector) && !selector.checkIsInArea(autoArea)) continue;
            return autoGetNumArea;
        }
        return null;
    }

    public List<AutoAreaSettingDto> getAutoGetNumAreas(CacheObjInvoker cacheObjInvoker) {
        List adds = cacheObjInvoker.getAdd("soehrr_rpttplarea_auto");
        List queries = cacheObjInvoker.query("soehrr_rpttplarea_auto");
        List<AutoAreaSettingDto> autoAdds = adds.stream().filter(ad -> ad.getOperate() != OperateEnum.DELETE).collect(Collectors.toList());
        List autoQueries = queries.stream().filter(qr -> qr.getOperate() != OperateEnum.DELETE).collect(Collectors.toList());
        autoAdds.addAll(autoQueries);
        return autoAdds;
    }

    public RepValidatorDto queryRepValidatorBySelector(SpreadModelParam param) {
        SheetManager sheetManager = param.getSheetManager();
        List<RepValidatorDto> repValidatorDtos = this.getAllRepValidatorAreas(sheetManager.getInvoker());
        SpreadSelector selector = param.getSelector();
        List cellStrs = this.getAllCell(selector).stream().map(cell -> cell.getRow() + ":" + cell.getCol()).collect(Collectors.toList());
        ArrayList repValidatorLists = Lists.newArrayListWithExpectedSize((int)10);
        for (RepValidatorDto repValidatorDto : repValidatorDtos) {
            String point = repValidatorDto.getPoint();
            SpreadSelector validatorArea = new SpreadSelector(point);
            String cellStr = repValidatorDto.getExpression().substring(repValidatorDto.getExpression().indexOf("!") + 1, repValidatorDto.getExpression().indexOf(repValidatorDto.getComparator()));
            if (cellStrs.size() == 1 && cellStrs.contains(cellStr)) {
                return repValidatorDto;
            }
            if (!validatorArea.equals((Object)selector) || !cellStrs.contains(cellStr)) continue;
            repValidatorLists.add(repValidatorDto);
        }
        if (repValidatorLists.size() == selector.getSpanCol() * selector.getSpanRow()) {
            return (RepValidatorDto)repValidatorLists.get(0);
        }
        return null;
    }

    public List<RepValidatorDto> getAllRepValidatorAreas(CacheObjInvoker cacheObjInvoker) {
        List adds = cacheObjInvoker.getAdd("soehrr_rpttplverrule");
        List queries = cacheObjInvoker.query("soehrr_rpttplverrule");
        List<RepValidatorDto> validatorAdds = adds.stream().filter(ad -> ad.getOperate() != OperateEnum.DELETE).collect(Collectors.toList());
        List validatorQueries = queries.stream().filter(qr -> qr.getOperate() != OperateEnum.DELETE).collect(Collectors.toList());
        validatorAdds.addAll(validatorQueries);
        return validatorAdds;
    }

    public List<Cell> getAllCell(SpreadSelector selector) {
        int initSize = selector.getSpanCol() * selector.getSpanRow();
        ArrayList<Cell> cellList = new ArrayList<Cell>(initSize);
        for (int rowIndex = selector.getStartRow(); rowIndex <= selector.getEndRow(); ++rowIndex) {
            for (int colIndex = selector.getStartCol(); colIndex <= selector.getEndCol(); ++colIndex) {
                Cell cell = new Cell().setRowAndCol(rowIndex, colIndex);
                cellList.add(cell);
            }
        }
        return cellList;
    }

    public List<AreaSettingDto> getAllCalArea(CacheObjInvoker invoker) {
        List<AreaSettingDto> queryFillArea = this.getQueryAreaBySetting(invoker, AreaSettingEnum.CAL);
        List<AreaSettingDto> addFillArea = this.getAddAreaBySetting(invoker, AreaSettingEnum.CAL);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        result.addAll(queryFillArea);
        result.addAll(addFillArea);
        return result;
    }

    public boolean hasAnyRptConf(CacheObjInvoker invoker) {
        List cacheDtoList = invoker.getCacheDtoList();
        for (ReportCacheDto cacheDto : cacheDtoList) {
            if (cacheDto instanceof AreaSettingDto) {
                AreaSettingDto areaSettingDto = (AreaSettingDto)cacheDto;
                if (areaSettingDto.getAreaSetting() == AreaSettingEnum.CAL || areaSettingDto.getOperate() == OperateEnum.DELETE) continue;
                return true;
            }
            if (cacheDto instanceof RepRuntimeVar) continue;
            return true;
        }
        return false;
    }

    public List<ReportCacheDto> queryRptTplConfByEntryIds(List<Long> rptEntryIds) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<String, QueryInitCache> initCacheEntry : QUERY_CACHE_HANDLERS.entrySet()) {
            QueryInitCache queryInitCache = initCacheEntry.getValue();
            List<ReportCacheDto> reportCacheDtos = queryInitCache.queryRptTplConfByEntryIds(rptEntryIds);
            result.addAll(reportCacheDtos);
        }
        return result;
    }

    public static RepCacheService ins() {
        return Instance.INSTANCE;
    }

    static {
        QUERY_CACHE_HANDLERS.put("soehrr_rpttplvar", RptTplVarService.getInstance());
        QUERY_CACHE_HANDLERS.put(RptTplAreaService.ins().getEntityName(), RptTplAreaService.ins());
        QUERY_CACHE_HANDLERS.put(RptTplAutoAreaService.ins().getEntityName(), RptTplAutoAreaService.ins());
        QUERY_CACHE_HANDLERS.put(RptTplValidatorService.getInstance().getEntityName(), RptTplValidatorService.getInstance());
    }

    private static class Instance {
        private static final RepCacheService INSTANCE = new RepCacheService();

        private Instance() {
        }
    }
}

