/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.collecttask;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.enums.RptTypeEnum;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskService;
import kd.sihc.soehrr.business.domain.report.ReportService;
import kd.sihc.soehrr.common.entity.RptInfoByFillTask;
import kd.sihc.soehrr.common.enums.CommentTypeEnum;

public class AnnotationHelper {
    public static final String COMMENTS = "comments";

    public static String handManualComments(String spreadJson, String type) {
        String uncompressJson = GzipTools.uncompressJson((String)spreadJson);
        JSONObject object = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        Map<String, List<Object>> newComments = AnnotationHelper.setManualComments(AnnotationHelper.getComments(sheets), type);
        sheets.forEach((key, value) -> {
            if (Objects.nonNull(newComments.get(key))) {
                ((JSONObject)value).put(COMMENTS, newComments.get(key));
            } else {
                ((JSONObject)value).remove((Object)COMMENTS);
            }
        });
        String result = object.toJSONString();
        return GzipTools.compressJson((String)result);
    }

    public static String handVersionChange(String spreadJson, DynamicObject fillTaskDyn) {
        Map<String, SpreadSelector> fillArea = AnnotationHelper.getSheetsFillArea(fillTaskDyn);
        if (fillArea.size() == 0) {
            return spreadJson;
        }
        String uncompressJson = GzipTools.uncompressJson((String)spreadJson);
        JSONObject object = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheets = object.getJSONObject("sheets");
        Map<String, Object> newData = AnnotationHelper.getSheetsDatas(sheets);
        Map<String, Object> oldData = AnnotationHelper.getReportData(fillTaskDyn.getLong("id"));
        Map<String, String> changeData = AnnotationHelper.compareVersion(fillArea, oldData, newData);
        Map<String, Object> comments = AnnotationHelper.getComments(sheets);
        Map<String, List<Object>> newComments = AnnotationHelper.setCompVerComments(comments, changeData);
        newComments.forEach((key, value) -> sheets.getJSONObject(key).put(COMMENTS, value));
        Map<String, Map<String, Object>> newDataMap = AnnotationHelper.markChangeVal(newData, changeData);
        newDataMap.forEach((key, value) -> {
            JSONObject dataTable = sheets.getJSONObject(key).getJSONObject("data").getJSONObject("dataTable");
            value.forEach((ikey, ivalue) -> {
                String[] ikeyArr = ikey.split(";");
                dataTable.getJSONObject(ikeyArr[1]).put(ikeyArr[2], ivalue);
            });
        });
        String result = object.toJSONString();
        return GzipTools.compressJson((String)result);
    }

    public static void deleteMark(JSONObject spreadJsonObject) {
        if (Objects.isNull(spreadJsonObject)) {
            return;
        }
        JSONObject sheets = (JSONObject)spreadJsonObject.get((Object)"sheets");
        sheets.forEach((sheetKey, sheetValue) -> {
            JSONObject data = ((JSONObject)sheetValue).getJSONObject("data");
            JSONObject dataTable = data.getJSONObject("dataTable");
            dataTable.forEach((key, value) -> ((JSONObject)value).forEach((ikey, ivalue) -> {
                Object styleObj = ((JSONObject)ivalue).get((Object)"style");
                if (Objects.nonNull(styleObj) && styleObj instanceof JSONObject) {
                    ((JSONObject)styleObj).remove((Object)"cellType");
                }
            }));
        });
    }

    public static void deleteDataClassComment(JSONObject object) {
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        String regex = String.format("^\u3010(%s\u3011)", CommentTypeEnum.UPDATEV.getPrefix().getLocaleValue());
        Pattern pattern = Pattern.compile(regex);
        sheets.forEach((sheetKey, sheetValue) -> {
            JSONArray comments = ((JSONObject)sheetValue).getJSONArray(COMMENTS);
            if (Objects.nonNull(comments)) {
                JSONArray newComments = new JSONArray();
                for (Object comment : comments) {
                    List filterTextArr;
                    JSONObject commentMap = (JSONObject)comment;
                    if (HRStringUtils.isEmpty((String)commentMap.getString("text")) || (filterTextArr = Arrays.stream(commentMap.getString("text").split("\n")).filter(line -> !pattern.matcher((CharSequence)line).find()).collect(Collectors.toList())).size() <= 0) continue;
                    commentMap.put("text", (Object)String.join((CharSequence)"\n", filterTextArr));
                    Map<String, Double> calcWH = AnnotationHelper.calcCommentSize(commentMap.getString("text"));
                    commentMap.put("height", (Object)calcWH.get("height"));
                    commentMap.put("width", (Object)calcWH.get("width"));
                    newComments.add((Object)commentMap);
                }
                ((JSONObject)sheetValue).put(COMMENTS, (Object)newComments);
            }
        });
    }

    public static JSONObject deleteComment(JSONObject object) {
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        sheets.forEach((sheetKey, sheetValue) -> {
            JSONArray comments = ((JSONObject)sheetValue).getJSONArray(COMMENTS);
            if (Objects.nonNull(comments)) {
                ((JSONObject)sheetValue).remove((Object)COMMENTS);
            }
        });
        return object;
    }

    private static Map<String, Map<String, Object>> markChangeVal(Map<String, Object> newData, Map<String, String> changeData) {
        HashMap<String, Map<String, Object>> newDataMap = new HashMap<String, Map<String, Object>>(100);
        changeData.forEach((key, value) -> {
            JSONObject dataVal = (JSONObject)newData.get(key);
            JSONObject cellType = new JSONObject();
            cellType.put("allowOverflow", (Object)true);
            cellType.put("editorType", (Object)1);
            cellType.put("kK", (Object)false);
            cellType.put("nK", (Object)"");
            cellType.put("typeName", (Object)"1");
            JSONObject dotMark = new JSONObject();
            dotMark.put("backgroundColor", (Object)"green");
            dotMark.put("visibility", (Object)true);
            dotMark.put("position", (Object)new int[]{0});
            cellType.put("dotMark", (Object)dotMark);
            JSONObject style = new JSONObject();
            if (Objects.nonNull(dataVal.get((Object)"style"))) {
                style = dataVal.getJSONObject("style");
            }
            style.put("cellType", (Object)cellType);
            dataVal.put("style", (Object)style);
            String sheetName = key.split(";")[0];
            newDataMap.computeIfAbsent(sheetName, k -> new HashMap(16)).put(key, dataVal);
        });
        return newDataMap;
    }

    public static Map<String, String> compareVersion(Map<String, SpreadSelector> fillArea, Map<String, Object> oldData, Map<String, Object> newData) {
        HashMap<String, String> changeValsMap = new HashMap<String, String>(newData.size());
        for (Map.Entry<String, SpreadSelector> entry : fillArea.entrySet()) {
            SpreadSelector value = entry.getValue();
            String key = entry.getKey();
            if (Objects.isNull(value)) continue;
            for (int startRow = value.getStartRow(); startRow <= value.getEndRow(); ++startRow) {
                for (int startCol = value.getStartCol(); startCol <= value.getEndCol(); ++startCol) {
                    String newValue;
                    boolean isFormula;
                    String keyName = key + ";" + startRow + ";" + startCol;
                    boolean bl = isFormula = Objects.nonNull(oldData.get(keyName)) && Objects.nonNull(((JSONObject)oldData.get(keyName)).get((Object)"formula"));
                    if (isFormula) continue;
                    String oldV = Objects.isNull(oldData.get(keyName)) ? null : ((JSONObject)oldData.get(keyName)).getString("value");
                    String newV = Objects.isNull(newData.get(keyName)) ? null : ((JSONObject)newData.get(keyName)).getString("value");
                    String nullValue = ResManager.loadKDString((String)"\u7a7a", (String)"AnnotationHelper_0", (String)"sihc-soehrr-business", (Object[])new Object[0]);
                    String oldValue = HRStringUtils.isEmpty((String)oldV) ? nullValue : oldV;
                    String string = newValue = HRStringUtils.isEmpty((String)newV) ? nullValue : newV;
                    if (HRStringUtils.equals((String)oldValue, (String)newValue)) continue;
                    changeValsMap.put(keyName, oldValue + ";" + newValue);
                }
            }
        }
        return changeValsMap;
    }

    public static Map<String, Object> getComments(JSONObject sheets) {
        HashMap<String, Object> comments = new HashMap<String, Object>(16);
        for (Object sheet : sheets.values()) {
            String sheetName = ((JSONObject)sheet).getString("name");
            if (((JSONObject)sheet).get((Object)COMMENTS) == null) continue;
            JSONArray jsonComments = (JSONArray)((JSONObject)sheet).get((Object)COMMENTS);
            for (Object jsonComment : jsonComments) {
                String key = sheetName + ";" + ((JSONObject)jsonComment).getString("rowIndex") + ";" + ((JSONObject)jsonComment).getString("colIndex");
                comments.put(key, jsonComment);
            }
        }
        return comments;
    }

    private static Map<String, List<Object>> setCompVerComments(Map<String, Object> comments, Map<String, String> changeData) {
        changeData.forEach((key, value) -> {
            String[] values = value.split(";");
            String[] keys = key.split(";");
            String dataChangeText = String.format(ResManager.loadKDString((String)"\u3010\u6570\u636e\u3011\u7531[%s]\u6539\u4e3a[%s]", (String)"AnnotationHelper_1", (String)"sihc-soehrr-business", (Object[])new Object[0]), values[0], values[1]) + "\n";
            JSONObject comment = new JSONObject();
            if (Objects.isNull(comments.get(key))) {
                comment.put("rowIndex", (Object)Integer.valueOf(keys[1]));
                comment.put("colIndex", (Object)Integer.valueOf(keys[2]));
                comment.put("zIndex", (Object)1000);
                comment.put("text", (Object)dataChangeText);
            } else {
                comment = (JSONObject)comments.get(key);
                comment.put("text", (Object)(comment.get((Object)"text") + dataChangeText));
            }
            Map<String, Double> calcWH = AnnotationHelper.calcCommentSize(comment.getString("text"));
            comment.put("height", (Object)calcWH.get("height"));
            comment.put("width", (Object)calcWH.get("width"));
            comments.put((String)key, comment);
        });
        HashMap<String, List<Object>> newCommentMap = new HashMap<String, List<Object>>(100);
        comments.forEach((key, value) -> {
            String sheetName = key.split(";")[0];
            newCommentMap.computeIfAbsent(sheetName, k -> new ArrayList(8)).add(value);
        });
        return newCommentMap;
    }

    private static Map<String, Double> calcCommentSize(String text) {
        String[] textArr = text.split("\n");
        double maxLen = 0.0;
        for (String val : textArr) {
            maxLen = Double.max(maxLen, AnnotationHelper.getTextShowLength(val));
        }
        return MapInitHelper.ofMap((Object)"height", (Object)((double)textArr.length * 16.0 + 40.0), (Object)"width", (Object)(maxLen * 12.5 + 20.0));
    }

    private static double getTextShowLength(String text) {
        double num = text.getBytes(Charset.forName("GBK")).length;
        return num / 2.0;
    }

    private static Map<String, List<Object>> setManualComments(Map<String, Object> comments, String type) {
        HashMap<String, List<Object>> newCommentMap = new HashMap<String, List<Object>>(100);
        String regex = String.format("^\u3010(%s|%s|%s\u3011)", CommentTypeEnum.FILLING.getPrefix().getLocaleValue(), CommentTypeEnum.PUBLISH.getPrefix().getLocaleValue(), CommentTypeEnum.UPDATEV.getPrefix().getLocaleValue());
        Pattern pattern = Pattern.compile(regex);
        comments.forEach((key, value) -> {
            JSONObject valueMap = (JSONObject)value;
            String text = valueMap.getString("text");
            if (HRStringUtils.isNotEmpty((String)text)) {
                String[] textArr = text.split("\n");
                StringBuilder newText = new StringBuilder();
                for (String s : textArr) {
                    String textItem = s.trim();
                    if (!HRStringUtils.isNotEmpty((String)textItem)) continue;
                    Matcher matcher = pattern.matcher(textItem);
                    if (!matcher.find()) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String formattedDate = sdf.format(new Date());
                        textItem = String.format("\u3010%s %s\u3011%s", type, formattedDate, textItem);
                    }
                    newText.append(textItem).append("\n");
                }
                valueMap.put("text", (Object)newText);
                valueMap.remove((Object)"commentState");
                Map<String, Double> calcWH = AnnotationHelper.calcCommentSize(valueMap.getString("text"));
                valueMap.put("height", (Object)calcWH.get("height"));
                valueMap.put("width", (Object)calcWH.get("width"));
                String sheetName = key.split(";")[0];
                newCommentMap.computeIfAbsent(sheetName, k -> new ArrayList(8)).add(valueMap);
            }
        });
        return newCommentMap;
    }

    private static Map<String, SpreadSelector> getSheetsFillArea(DynamicObject fillTaskDyn) {
        Map<Long, List<RptInfoByFillTask>> rptInfos = FillTaskService.ins().queryRptCurJsonByTask(Collections.singletonList(fillTaskDyn.getLong("id")));
        HashMap<String, SpreadSelector> selects = new HashMap<String, SpreadSelector>(16);
        rptInfos.forEach((key, values) -> {
            for (RptInfoByFillTask rptInfoByFillTask : values) {
                String fillArea;
                if (!RptTypeEnum.STATISTICS.getType().equals(rptInfoByFillTask.getRptType()) || !HRStringUtils.isNotEmpty((String)(fillArea = rptInfoByFillTask.getFillArea()))) continue;
                selects.put(rptInfoByFillTask.getRptTplNumber(), new SpreadSelector(fillArea));
            }
        });
        return selects;
    }

    private static Map<String, Object> getSheetsDatas(JSONObject sheets) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        for (Object sheet : sheets.values()) {
            String sheetName = ((JSONObject)sheet).getString("name");
            JSONObject data = ((JSONObject)sheet).getJSONObject("data");
            JSONObject dataTable = data.getJSONObject("dataTable");
            dataTable.forEach((key, value) -> ((JSONObject)value).forEach((ikey, ivalue) -> dataMap.put(sheetName + ";" + key + ";" + ikey, ivalue)));
        }
        return dataMap;
    }

    private static Map<String, Object> getReportData(Long fillTaskId) {
        DynamicObject[] reports = ReportService.ins().loadByFillTask(fillTaskId);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        for (DynamicObject report : reports) {
            String uncompressJson = GzipTools.uncompressJson((String)report.getString("json_tag"));
            JSONObject object = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
            JSONObject sheets = (JSONObject)object.get((Object)"sheets");
            dataMap.putAll(AnnotationHelper.getSheetsDatas(sheets));
        }
        return dataMap;
    }
}

