/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.collecttask;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.DimValueResult;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;
import kd.sihc.soebs.business.application.external.AuthorityExternalService;
import kd.sihc.soebs.business.application.external.SihcEmpPosOrgRelService;
import kd.sihc.soebs.business.application.external.SihcIHSPMService;
import kd.sihc.soebs.business.domain.appointeditor.AppointExternalService;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.queryservice.CollectTaskQueryService;
import kd.sihc.soehrr.business.queryservice.FillTaskQueryService;
import kd.sihc.soehrr.business.queryservice.FillUnitPalnQueryService;
import kd.sihc.soehrr.business.queryservice.ReportQueryService;
import kd.sihc.soehrr.business.queryservice.RptTplQueryService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.common.constants.CollectTaskConstants;
import kd.sihc.soehrr.common.utils.SoehrrCommonUtils;

public class CollectTaskFormService
implements CollectTaskConstants {
    private static final Log LOG = LogFactory.getLog(CollectTaskFormService.class);
    private static final HRBaseServiceHelper HRPI_PERSON_USER_HELPER = new HRBaseServiceHelper("hrpi_personuserrel");
    private static final HRBaseServiceHelper RPT_TPL_HELPER = new HRBaseServiceHelper("soehrr_rpttpl");
    private static final HRBaseServiceHelper ADMINORG_HELPER = HRBaseServiceHelper.create((String)"haos_adminorghr");
    private static final ReportQueryService REPORT_QUERY_SERVICE = ServiceFactory.getService(ReportQueryService.class);
    private final FillUnitPalnQueryService FILL_UNIT_PALAN_QUERY_SERVICE = ServiceFactory.getService(FillUnitPalnQueryService.class);
    private static final RptTplQueryService RPT_TPL_QUERY_SERVICE = ServiceFactory.getService(RptTplQueryService.class);
    private static final FillTaskQueryService FILL_TASK_QUERY_SERVICE = ServiceFactory.getService(FillTaskQueryService.class);

    public DynamicObject getCompanyByCurrentUserId() {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject personInfo = HRPI_PERSON_USER_HELPER.queryOne("id,person", new QFilter("user", "=", (Object)currUserId).toArray());
        if (HRObjectUtils.isEmpty((Object)personInfo)) {
            return null;
        }
        Object[] empposorgrel = SihcEmpPosOrgRelService.getInstance().queryMainPosByPersons(Collections.singletonList(personInfo.getLong("person")));
        if (HRArrayUtils.isEmpty((Object[])empposorgrel)) {
            return null;
        }
        return empposorgrel[0];
    }

    public void initBelowOrg(IFormView view) {
        Map personModelMap = SihcIHSPMService.getPersonModelId();
        LOG.info("BakResearchDomainService.initBelowOrg success: {}", personModelMap.get("success"));
        if (((Boolean)personModelMap.get("success")).booleanValue()) {
            Object data = personModelMap.get("data");
            if (!(data instanceof Map)) {
                return;
            }
            Long personId = (Long)((Map)data).get("person");
            LOG.info("BakResearchDomainService.initBelowOrg personId: {}", (Object)personId);
            Map primaryEmpPosOrgRelMap = AppointExternalService.queryPrimaryEmpposorgrel((Long)personId);
            LOG.info("BakResearchDomainService.initBelowOrg company_id: {}", primaryEmpPosOrgRelMap != null ? primaryEmpPosOrgRelMap.get("company_id") : "");
            String appId = view.getFormShowParameter().getAppId();
            Object[] params = new Object[]{RequestContext.get().getCurrUserId(), appId, view.getFormShowParameter().getFormId(), "47150e89000000ac", "disunit", new HashMap()};
            AuthorizedOrgResult authorizedAdminOrgs = AuthorityExternalService.getUserAdminOrgsF7((Object[])params);
            LOG.info("BakResearchDomainService.initAdminOrg  authorizedAdminOrgs -> {}", (Object)authorizedAdminOrgs);
            List userAdminOrgIdList = authorizedAdminOrgs.getHasPermOrgs();
            if (primaryEmpPosOrgRelMap != null && (userAdminOrgIdList.contains(Long.parseLong(primaryEmpPosOrgRelMap.get("company_id").toString())) || authorizedAdminOrgs.isHasAllOrgPerm())) {
                view.getModel().setValue("disunit", primaryEmpPosOrgRelMap.get("company_id"));
            }
        }
    }

    public void setDate(IDataModel dataModel) {
        try {
            Date nowDate = DateUtils.parseDate((String)DateUtils.getDate((Date)new Date()), (DatePattern)DatePattern.YYYY_MM_DD);
            Date startTime = DateUtils.parseDate((String)DateUtils.getDate((Date)((Date)dataModel.getValue("starttime"))), (DatePattern)DatePattern.YYYY_MM_DD);
            Date endTime = DateUtils.parseDate((String)DateUtils.getDate((Date)((Date)dataModel.getValue("endtime"))), (DatePattern)DatePattern.YYYY_MM_DD);
            if (nowDate.after(startTime)) {
                dataModel.setValue("starttime", (Object)new Date());
            }
            if (nowDate.after(endTime)) {
                dataModel.setValue("endtime", null);
            }
        }
        catch (Exception msg) {
            LOG.error("Edit CollectTask BindData Parse Date Fail", (Throwable)msg);
        }
    }

    public void endTimeHandler(IFormView view) {
        IDataModel dataModel = view.getModel();
        DateTimeEdit endTime = (DateTimeEdit)view.getControl("endtime");
        if (null != dataModel.getValue("starttime")) {
            try {
                endTime.setMinDate(DateUtils.parseDate((String)(DateUtils.getDate((Date)((Date)dataModel.getValue("starttime"))).substring(0, 10) + " 00:00:00"), (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS));
            }
            catch (Exception e) {
                LOG.error("endTimeHandler Parse Date Fail", (Throwable)e);
            }
        } else {
            try {
                endTime.setMinDate(DateUtils.parseDate((String)(DateUtils.getDate((Date)new Date()).substring(0, 10) + " 00:00:00"), (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS));
            }
            catch (Exception e) {
                LOG.error("endTimeHandler Parse Date Fail", (Throwable)e);
            }
        }
    }

    public void setFieldVisable(IFormView view) {
        boolean isCycrpt;
        IDataModel dataModel = view.getModel();
        DynamicObject rptClass = (DynamicObject)dataModel.getValue("reportclassify");
        if (!(HRObjectUtils.isEmpty((Object)rptClass) || HRObjectUtils.isEmpty((Object)(isCycrpt = rptClass.getBoolean("iscycrpt"))) || isCycrpt)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"periodtype", "belongperiod"});
        }
    }

    public void setYearComboItems(IFormView view) {
        ComboEdit year = (ComboEdit)view.getControl("year");
        year.setComboItems(this.getBelongYear());
    }

    public void bindParentAttachment(IFormView view, DynamicObject task) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("attachmentpanelap");
        if (!Objects.isNull(task) && task.containsProperty("solution")) {
            Long solutionId = task.getLong("solution");
            if (solutionId == 0L) {
                return;
            }
            List attachmentDatas = AttachmentServiceHelper.getAttachments((String)"soehrr_collecttask", (Object)solutionId, (String)"attachmentpanelap", (boolean)false);
            String pkID = view.getModel().getDataEntity().getPkValue().toString();
            if (!attachmentDatas.isEmpty()) {
                for (Map attachmentMap : attachmentDatas) {
                    attachmentMap.put("visible", "1001");
                    Timestamp lastModified = (Timestamp)attachmentMap.get("lastModified");
                    attachmentMap.put("lastModified", lastModified.getTime());
                    attachmentMap.put("url", this.getPathfromDownloadUrl(String.valueOf(attachmentMap.get("url"))));
                }
                ClientViewProxy cvp = (ClientViewProxy)view.getService(IClientViewProxy.class);
                cvp.setFieldProperty("attachmentpanelap", "v", (Object)attachmentDatas);
            }
            attachmentPanel.bindData(attachmentDatas);
            AttachmentServiceHelper.upload((String)"soehrr_collecttask", (Object)pkID, (String)"attachmentpanelap", (List)attachmentDatas);
        }
    }

    public String getPathfromDownloadUrl(String urlString) {
        try {
            String url = URLDecoder.decode(urlString, "UTF-8");
            String path = StringUtils.substringAfter((String)url, (String)"path=");
            path = URLDecoder.decode(path, "UTF-8");
            return FilePathUtil.dealPath((String)path, (String)"attach");
        }
        catch (Exception exception) {
            LOG.error("CollectTaskFormService.getPathfromDownloadUrl error");
            return null;
        }
    }

    public void taskConfig(Long taskId, IFormView view) {
        IDataModel dataModel = view.getModel();
        DynamicObject[] reports = REPORT_QUERY_SERVICE.queryReportByFillTask(taskId);
        List<DynamicObject> cofigExeUnit = this.getCofigExeUnit(view);
        dataModel.deleteEntryData("taskfillobjs");
        dataModel.beginInit();
        for (int tag = 0; tag < Math.min(reports.length, 100); ++tag) {
            int newEntryRow = dataModel.createNewEntryRow("taskfillobjs");
            DynamicObject report = reports[tag];
            this.setTaskFillObjsValue(report, tag, dataModel);
            if (cofigExeUnit.size() <= 0) continue;
            DynamicObjectCollection dynamicObjectCollection = ((DynamicObject)dataModel.getDataEntity(true).getDynamicObjectCollection("taskfillobjs").get(newEntryRow)).getDynamicObjectCollection("fillunits");
            cofigExeUnit.forEach(dynamicObject -> {
                DynamicObject fillUnit = dynamicObjectCollection.addNew();
                fillUnit.set("fbasedataid", dynamicObject);
            });
        }
        dataModel.endInit();
        view.updateView("taskfillobjs");
    }

    public void taskConfigSaved(DynamicObject object, IFormView view) {
        IDataModel dataModel = view.getModel();
        DynamicObjectCollection collection = object.getDynamicObjectCollection("taskfillobjs");
        dataModel.deleteEntryData("taskfillobjs");
        for (int tag = 0; tag < Math.min(collection.size(), 100); ++tag) {
            dataModel.createNewEntryRow("taskfillobjs");
            DynamicObject report = (DynamicObject)collection.get(tag);
            this.setTaskFillObjsValue(report, tag, dataModel);
            dataModel.setValue("fillunits", report.get("fillunits"), tag);
        }
        view.updateView("taskfillobjs");
    }

    public void setTaskIssueValue(IDataModel dataModel, DynamicObject collectTask, DynamicObject task) {
        Date nowDate = new Date();
        dataModel.setValue("reportclassify", collectTask.get("reportclassify"));
        dataModel.setValue("disunit", task.get("exeunit"));
        dataModel.setValue("year", collectTask.get("year"));
        dataModel.setValue("name", task.get("name"));
        dataModel.setValue("starttime", (Object)nowDate);
        Date endDate = (Date)collectTask.get("endtime");
        Date nowDates = this.getMinDate(nowDate, "start");
        if (nowDates.before(endDate)) {
            dataModel.setValue("endtime", collectTask.get("endtime"));
        } else {
            dataModel.setValue("endtime", null);
        }
        dataModel.setValue("desc", (Object)collectTask.get("desc").toString());
        dataModel.setValue("tasksource", (Object)0);
    }

    public void setHatchSolutionValue(DynamicObject task, IFormView view, Date startDate) {
        IDataModel dataModel = view.getModel();
        Date nowDate = new Date();
        DateTimeEdit endTime = (DateTimeEdit)view.getControl("endtime");
        Long hatchSolutionId = task.getLong("hatchsolution");
        DynamicObject hatchTask = CollectTaskQueryService.getByTaskId(hatchSolutionId);
        if (!HRObjectUtils.isEmpty((Object)hatchTask)) {
            dataModel.setValue("org", hatchTask.get("org"));
            dataModel.setValue("reportclassify", hatchTask.get("reportclassify"));
            dataModel.setValue("disunit", hatchTask.get("disunit"));
            dataModel.setValue("year", hatchTask.get("year"));
            view.setEnable(Boolean.FALSE, new String[]{"reportclassify", "disunit", "year"});
            dataModel.setValue("name", hatchTask.get("name"));
            dataModel.setValue("starttime", (Object)nowDate);
            dataModel.setValue("endtime", hatchTask.get("endtime"));
            endTime.setMinDate(startDate);
            dataModel.setValue("desc", (Object)hatchTask.get("desc").toString());
            dataModel.setValue("tasksource", (Object)0);
            DynamicObject dataEntity = view.getParentView().getModel().getDataEntity();
            AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("attachment");
            if (!Objects.isNull(dataEntity) && dataEntity.containsProperty("solution")) {
                long solutionId = dataEntity.getLong("hatchsolution");
                if (solutionId == 0L) {
                    return;
                }
                List attachmentDatas = AttachmentServiceHelper.getAttachments((String)"soehrr_filltask", (Object)solutionId, (String)"attachmentpanelap");
                if (!attachmentDatas.isEmpty()) {
                    for (Map attachmentMap : attachmentDatas) {
                        attachmentMap.put("visible", "1001");
                    }
                    ClientViewProxy cvp = (ClientViewProxy)view.getService(IClientViewProxy.class);
                    cvp.setFieldProperty("attachment", "v", (Object)attachmentDatas);
                }
                attachmentPanel.bindData(attachmentDatas);
            }
            dataModel.getDataEntity(true).getDynamicObjectCollection("taskfillobjs").clear();
            this.taskConfigSaved(hatchTask, view);
        }
    }

    public void setFillUnitsShowParameter(BeforeF7SelectEvent beforeF7SelectEvent, IFormPlugin plugin, IFormView view) {
        this.setFillUnitsShowParameter(beforeF7SelectEvent, plugin, view, "soehrr_collecttask");
    }

    public void setFillUnitsShowParameter(BeforeF7SelectEvent beforeF7SelectEvent, IFormPlugin plugin, IFormView view, String entityNumber) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.setFormId("bos_listf7");
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "fillunits"));
        long currUserId = RequestContext.get().getCurrUserId();
        beforeF7SelectEvent.setCustomQFilters(Collections.singletonList(new QFilter("iscurrentversion", "=", (Object)"1")));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u586b\u62a5\u5355\u4f4d", (String)"CollectTaskFormService_3", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        formShowParameter.getListFilterParameter().setOrderBy("sortcode asc");
        view.getPageCache().put("selectedRow", String.valueOf(beforeF7SelectEvent.getRow()));
    }

    public void openAddReportF7(IFormPlugin plugin, IFormView view) {
        IDataModel dataModel = view.getModel();
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"soehrr_rpttpl", (boolean)true);
        showListForm.setFormId("hrcs_querylistf7");
        showListForm.setShowApproved(false);
        showListForm.setShowUsed(true);
        showListForm.setCloseCallBack(new CloseCallBack(plugin, "addreport"));
        DynamicObject reportclassify = (DynamicObject)dataModel.getValue("reportclassify");
        DynamicObjectCollection taskFillobjEntry = dataModel.getEntryEntity("taskfillobjs");
        List rptIds = taskFillobjEntry.stream().map(dynamicObject -> dynamicObject.getLong("rpttpl_id")).collect(Collectors.toList());
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"soehrr_rpttpl", (Long)dataModel.getDataEntity(true).getLong("org.id"));
        QFilter qFilter = new QFilter("reportclassify", "=", (Object)reportclassify.getLong("id")).and("id", "not in", rptIds).and(HrrQfilterUtils.isPublish()).and("enable", "=", (Object)"1").and(baseDataFilter);
        DynamicObject[] reportInfo = RPT_TPL_HELPER.query(qFilter.toArray());
        if (reportInfo.length < 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u9009\u62e9\u7684\u62a5\u8868\u3002", (String)"CollectTaskFormService_0", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        showListForm.getListFilterParameter().setFilter(qFilter);
        showListForm.getListFilterParameter().setOrderBy("modifytime desc");
        view.showForm((FormShowParameter)showListForm);
    }

    public void openReportUnit(IFormPlugin plugin, IFormView view, String entityNumber) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"haos_adminorghr", (boolean)true);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setCloseCallBack(new CloseCallBack(plugin, "reportUnit"));
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u586b\u62a5\u5355\u4f4d", (String)"CollectTaskFormService_3", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        DimValueResult result = (DimValueResult)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getEntityDimValue", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "soehrr", entityNumber, "47150e89000000ac", "fillunits"});
        if (!result.isAll()) {
            Set hasPermOrgs = result.getDimValueIds();
            List ids = hasPermOrgs.stream().map(Long::parseLong).collect(Collectors.toList());
            QFilter Qfilter = new QFilter("id", "in", ids).and("iscurrentversion", "=", (Object)"1");
            listShowParameter.getListFilterParameter().getQFilters().add(Qfilter);
        } else {
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        listShowParameter.getListFilterParameter().setOrderBy("sortcode asc");
        listShowParameter.setShowUsed(true);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public void openReportUnit(IFormPlugin plugin, IFormView view) {
        this.openReportUnit(plugin, view, "soehrr_collecttask");
    }

    public void openBatchSetting(IFormPlugin plugin, IFormView view) {
        IDataModel dataModel = view.getModel();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("soehrr_batchsetting");
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "batchsetting"));
        EntryGrid taskfillobjs = (EntryGrid)view.getControl("taskfillobjs");
        DynamicObject rptClass = (DynamicObject)dataModel.getValue("reportclassify");
        boolean isCycrpt = rptClass.getBoolean("iscycrpt");
        if (isCycrpt) {
            int[] selectRows = taskfillobjs.getSelectRows();
            ArrayList selectedRows = Lists.newArrayListWithExpectedSize((int)selectRows.length);
            for (int selectRow : selectRows) {
                selectedRows.add((DynamicObject)dataModel.getValue("periodtype", selectRow));
            }
            Map<Long, List<DynamicObject>> id = selectedRows.stream().collect(Collectors.groupingBy(dy -> dy.getLong("id")));
            if (id.size() > 1) {
                formShowParameter.setCustomParam("samePeriod", (Object)"false");
            } else {
                formShowParameter.setCustomParam("samePeriod", (Object)"true");
                DynamicObject periodType = (DynamicObject)dataModel.getValue("periodtype", selectRows[0]);
                formShowParameter.setCustomParam("periodtype", (Object)periodType.getLong("id"));
            }
            formShowParameter.setCustomParam("year", dataModel.getValue("year"));
        }
        formShowParameter.setCustomParam("iscycrpt", (Object)isCycrpt);
        view.showForm(formShowParameter);
    }

    public Set<Long> filterFillUnit(IDataModel dataModel) {
        DynamicObjectCollection taskSettingEntry = dataModel.getEntryEntity("taskfillobjs");
        ArrayList<DynamicObject> invokeUnits = new ArrayList<DynamicObject>();
        HashSet<Long> invokeUnitIds = new HashSet<Long>();
        for (DynamicObject dynamicObject2 : taskSettingEntry) {
            DynamicObjectCollection fillUnits = dynamicObject2.getDynamicObjectCollection("fillunits");
            for (DynamicObject fillUnit : fillUnits) {
                invokeUnits.add(fillUnit);
                invokeUnitIds.add(fillUnit.getLong("fbasedataid_id"));
            }
        }
        Map<Long, DynamicObject> idInfoMap = invokeUnits.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("fbasedataid_id"), dynamicObject -> dynamicObject, (k1, k2) -> k1));
        DynamicObjectCollection exeUnits = (DynamicObjectCollection)dataModel.getValue("exeunits");
        exeUnits.clear();
        DynamicObjectCollection collection = new DynamicObjectCollection();
        invokeUnitIds.forEach(obj -> {
            DynamicObject dynamicObject = exeUnits.addNew();
            dynamicObject.set("fbasedataid", (Object)((DynamicObject)idInfoMap.get(obj)).getDynamicObject("fbasedataid"));
            collection.add((Object)dynamicObject);
        });
        if (collection.isEmpty()) {
            return invokeUnitIds;
        }
        dataModel.setValue("exeunits", (Object)collection);
        return invokeUnitIds;
    }

    public List<DynamicObject> getConfigExeUnit(IFormView view, String entityNumber) {
        IDataModel dataModel = view.getModel();
        DynamicObject disunit = (DynamicObject)dataModel.getValue("disunit");
        DynamicObject reportclassify = (DynamicObject)dataModel.getValue("reportclassify");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        if (HRObjectUtils.isEmpty((Object)disunit) || HRObjectUtils.isEmpty((Object)reportclassify)) {
            return list;
        }
        DimValueResult result = (DimValueResult)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getEntityDimValue", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "soehrr", entityNumber, "47150e89000000ac", "fillunits"});
        Set hasPermOrgs = result.getDimValueIds();
        List userAdminOrgIdList = hasPermOrgs.stream().map(Long::parseLong).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = this.FILL_UNIT_PALAN_QUERY_SERVICE.queryFillUnitPlanByRptcls(disunit.getLong("id"), reportclassify.getLong("id"));
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            List collect = Arrays.stream(dynamicObjects).flatMap(dynamicObject -> dynamicObject.getDynamicObjectCollection("entryentity").stream()).map(dynamicObject -> dynamicObject.getDynamicObject("exeunit")).collect(Collectors.toList());
            if (!userAdminOrgIdList.isEmpty()) {
                List exeUnitList = collect.stream().filter(dynamicObject -> userAdminOrgIdList.contains(dynamicObject.getLong("id"))).collect(Collectors.toList());
                list.addAll(exeUnitList);
            } else {
                list.addAll(collect);
            }
        }
        return list;
    }

    public List<DynamicObject> getCofigExeUnit(IFormView view) {
        return this.getConfigExeUnit(view, "soehrr_collecttask");
    }

    public void batchReportUnitSettingHandler(ClosedCallBackEvent closedCallBackEvent, IFormView view) {
        int[] selectRows;
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == returnData) {
            return;
        }
        this.checkFillUnitsSize(view, returnData);
        EntryGrid taskFillObjs = (EntryGrid)view.getControl("taskfillobjs");
        for (int selectRow : selectRows = taskFillObjs.getSelectRows()) {
            if (returnData.isEmpty()) continue;
            DynamicObjectCollection fillUnits = (DynamicObjectCollection)view.getModel().getValue("fillunits", selectRow);
            fillUnits.clear();
            for (ListSelectedRow selectedRow : returnData) {
                DynamicObject unit = fillUnits.addNew();
                unit.set("fbasedataid_id", selectedRow.getPrimaryKeyValue());
                unit.set("fbasedataid", selectedRow.getPrimaryKeyValue());
            }
        }
        view.updateView("taskfillobjs");
    }

    public void batchTaskSettingCallBackHandler(ClosedCallBackEvent closedCallBackEvent, IFormView view) {
        IDataModel dataModel = view.getModel();
        Map data = (Map)closedCallBackEvent.getReturnData();
        if (null == data) {
            return;
        }
        Object dateStartTime = data.get("datastarttime");
        Object dateEndTime = data.get("dataendtime");
        Object belongPeriod = data.get("belongperiod");
        EntryGrid taskfillobjs = (EntryGrid)view.getControl("taskfillobjs");
        int[] selectRows = taskfillobjs.getSelectRows();
        DynamicObject rptClass = (DynamicObject)dataModel.getValue("reportclassify");
        boolean isCycrpt = rptClass.getBoolean("iscycrpt");
        if (HRObjectUtils.isEmpty(dateStartTime) || HRObjectUtils.isEmpty(dateEndTime)) {
            view.getPageCache().put("changeSource", "batchsetting");
        }
        for (int selectRow : selectRows) {
            if (((DynamicObjectCollection)data.get("fillorg")).size() > 0) {
                DynamicObjectCollection fillOrgList = (DynamicObjectCollection)data.get("fillorg");
                DynamicObjectCollection fillUnits = (DynamicObjectCollection)dataModel.getValue("fillunits", selectRow);
                fillUnits.clear();
                for (DynamicObject org : fillOrgList) {
                    DynamicObject unit = fillUnits.addNew();
                    unit.set("fbasedataid_id", (Object)org.getLong("fbasedataid_id"));
                    unit.set("fbasedataid", (Object)org.getDynamicObject("fbasedataid"));
                }
            }
            if (null != belongPeriod) {
                dataModel.setValue("belongperiod", (Object)((DynamicObject)belongPeriod).getLong("id"), selectRow);
            }
            this.setBatchTaskSettingDate(dateStartTime, "datastarttime", selectRow, view);
            this.setBatchTaskSettingDate(dateEndTime, "dataendtime", selectRow, view);
            this.checkTime(selectRow, view);
        }
        view.updateView("taskfillobjs");
        this.filterFillUnit(dataModel);
        if (isCycrpt) {
            this.disableBelongPeriod(view);
        }
        view.getPageCache().remove("changeSource");
    }

    public void fillUnitsCloseCallBackHandler(ClosedCallBackEvent closedCallBackEvent, IFormView view) {
        IDataModel dataModel = view.getModel();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == returnData) {
            return;
        }
        int selectedRow = Integer.parseInt(view.getPageCache().get("selectedRow"));
        this.checkFillUnitsSize(view, returnData);
        List orgIds = returnData.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] orgs = ADMINORG_HELPER.loadDynamicObjectArray(new QFilter("id", "in", orgIds).toArray());
        ArrayList<DynamicObject> sortedOrgList = new ArrayList<DynamicObject>();
        for (ListSelectedRow returnDatum : returnData) {
            for (DynamicObject org : orgs) {
                if (((Long)returnDatum.getPrimaryKeyValue()).longValue() != org.getLong("id")) continue;
                sortedOrgList.add(org);
            }
        }
        DynamicObjectCollection fill = (DynamicObjectCollection)((DynamicObject)dataModel.getDataEntity(true).getDynamicObjectCollection("taskfillobjs").get(selectedRow)).get("fillunits");
        fill.clear();
        for (DynamicObject obj2 : sortedOrgList) {
            DynamicObject dynamicObject = fill.addNew();
            dynamicObject.set("fbasedataid", (Object)obj2);
        }
        view.updateView("taskfillobjs");
        if (!HRStringUtils.equals((String)view.getEntityId(), (String)"soehrr_cyccollecttask")) {
            this.filterFillUnit(dataModel);
        }
    }

    public void addReportCloseCallBackHandler(ClosedCallBackEvent closedCallBackEvent, IFormView view) {
        IDataModel dataModel = view.getModel();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        DynamicObjectCollection taskFillObjEntry = dataModel.getEntryEntity("taskfillobjs");
        if (null == returnData) {
            return;
        }
        this.checkReportsSize(taskFillObjEntry, returnData, view);
        List<Long> tplIds = returnData.stream().map(data -> (Long)data.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] rptTpl = RPT_TPL_QUERY_SERVICE.queryRptTpl(tplIds);
        DynamicObject rptClass = (DynamicObject)dataModel.getValue("reportclassify");
        boolean isCycrpt = rptClass.getBoolean("iscycrpt");
        Map<Long, DynamicObject> rptPeriodTypeMap = Arrays.stream(rptTpl).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject, (k1, k2) -> k1));
        if (isCycrpt) {
            this.cycrptReportHandler(rptTpl, taskFillObjEntry, returnData, rptPeriodTypeMap, view);
        } else {
            this.unCycrptReportHandler(taskFillObjEntry, returnData, rptPeriodTypeMap, dataModel);
        }
    }

    private void unCycrptReportHandler(DynamicObjectCollection taskFillObjEntry, ListSelectedRowCollection returnData, Map<Long, DynamicObject> rptPeriodTypeMap, IDataModel dataModel) {
        int size = taskFillObjEntry.size();
        for (int tag = 0; tag < returnData.size(); ++tag) {
            ListSelectedRow listSelectedRow = returnData.get(tag);
            Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
            dataModel.createNewEntryRow("taskfillobjs");
            dataModel.setValue("rpttpl", (Object)primaryKeyValue, tag + size);
            dataModel.setValue("periodtype", (Object)RPT_YEAR_ID, tag + size);
            dataModel.setValue("belongperiod", (Object)BELONG_PERIOD_YEAR_ID, tag + size);
            DynamicObject rt = rptPeriodTypeMap.get(primaryKeyValue);
            DynamicObject newVersionEntry = RptTplService.getInstance().getNewVersionEntry(rt);
            dataModel.setValue("repentryid", (Object)newVersionEntry.getLong("id"), tag + size);
        }
    }

    private void cycrptReportHandler(DynamicObject[] rptTpl, DynamicObjectCollection taskFillObjEntry, ListSelectedRowCollection returnData, Map<Long, DynamicObject> rptPeriodTypeMap, IFormView view) {
        IDataModel dataModel = view.getModel();
        long belongPeriodId = 0L;
        List yearRpt = Arrays.stream(rptTpl).filter(dynamicObject -> RPT_YEAR_ID.equals(dynamicObject.getDynamicObject("periodtype").getLong("id"))).collect(Collectors.toList());
        if (!yearRpt.isEmpty()) {
            DynamicObject belongPeriod = RPT_TPL_QUERY_SERVICE.queryBelongPeriod(((DynamicObject)yearRpt.get(0)).getLong("periodtype_id"));
            belongPeriodId = belongPeriod.getLong("id");
        }
        int size = taskFillObjEntry.size();
        for (int tag = 0; tag < returnData.size(); ++tag) {
            int index = tag + size;
            ListSelectedRow listSelectedRow = returnData.get(tag);
            Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
            dataModel.createNewEntryRow("taskfillobjs");
            DynamicObject rpt = rptPeriodTypeMap.get(primaryKeyValue);
            DynamicObject newVersionEntry = RptTplService.getInstance().getNewVersionEntry(rpt);
            dataModel.setValue("repentryid", (Object)newVersionEntry.getLong("id"), index);
            dataModel.setValue("rpttpl", (Object)primaryKeyValue, index);
            long periodTypeId = rpt.getLong("periodtype_id");
            dataModel.setValue("periodtype", (Object)periodTypeId, index);
            if (RPT_YEAR_ID.equals(periodTypeId)) {
                dataModel.setValue("belongperiod", (Object)belongPeriodId, index);
                this.setInitTimeValue(index, dataModel);
                continue;
            }
            dataModel.setValue("belongperiod", (Object)"", index);
            dataModel.setValue("datastarttime", (Object)"", index);
            dataModel.setValue("dataendtime", (Object)"", index);
        }
        this.disableBelongPeriod(view);
    }

    private void checkReportsSize(DynamicObjectCollection taskFillObjEntry, ListSelectedRowCollection returnData, IFormView view) {
        int entrySize = taskFillObjEntry.size();
        int total = returnData.size() + entrySize;
        if (total > 100) {
            ListSelectedRowCollection needRemoveList = new ListSelectedRowCollection();
            int needRemoveTotal = total - 100;
            for (int i = returnData.size() - needRemoveTotal; i < returnData.size(); ++i) {
                needRemoveList.add((Object)returnData.get(i));
            }
            returnData.removeAll((Collection)needRemoveList);
            view.showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e95\u6761\u6570\u636e\u3002", (String)"CollectTaskFormService_4", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        }
    }

    public void checkFillUnitsSize(IFormView view, ListSelectedRowCollection returnData) {
        int total = returnData.size();
        if (total > 1000) {
            ListSelectedRowCollection needRemoveList = new ListSelectedRowCollection();
            int needRemoveTotal = total - 1000;
            for (int i = returnData.size() - needRemoveTotal; i < returnData.size(); ++i) {
                needRemoveList.add((Object)returnData.get(i));
            }
            returnData.removeAll((Collection)needRemoveList);
            view.showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e91000\u6761\u6570\u636e\u3002", (String)"CollectTaskFormService_2", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        }
    }

    private void setBatchTaskSettingDate(Object dataTime, String dateField, int selectRow, IFormView view) {
        IDataModel dataModel = view.getModel();
        if (null == dataTime) {
            return;
        }
        view.getPageCache().put("isChanging", "true");
        String strTime = DateUtils.getDate((Date)((Date)dataTime));
        String newDate = this.getFillYear(dataModel) + strTime.substring(4);
        newDate = this.checkLeapMonth(newDate, view.getModel());
        dataModel.setValue(dateField, (Object)newDate, selectRow);
        view.getPageCache().remove("isChanging");
    }

    public String getFillYear(IDataModel dataModel) {
        if (null == dataModel.getValue("year")) {
            return new SimpleDateFormat("yyyy").format(new Date());
        }
        return String.valueOf(dataModel.getValue("year"));
    }

    public Date getMinDate(Date date, String type) {
        String dateString = new SimpleDateFormat(DatePattern.YYYY_MM_DD.getValue()).format(date);
        if (HRStringUtils.equals((String)type, (String)"start")) {
            return this.getParseDate(dateString + " 00:00:00", DatePattern.YYYY_MM_DD_HH_MM_SS);
        }
        return this.getParseDate(dateString + " 23:59:59", DatePattern.YYYY_MM_DD_HH_MM_SS);
    }

    public void modifyTime(String key, int index, IFormView view) {
        IDataModel dataModel = view.getModel();
        String fillYear = this.getFillYear(dataModel);
        if (!HRObjectUtils.isEmpty((Object)view.getPageCache().get("isChanging"))) {
            view.getPageCache().remove("isChanging");
            return;
        }
        Date date = null;
        if (HRObjectUtils.isEmpty((Object)dataModel.getValue(key, index))) {
            return;
        }
        Date dateValue = (Date)dataModel.getValue(key, index);
        if ("datastarttime".equals(key)) {
            date = this.dateParse(fillYear, dateValue, " 00:00:00");
        } else if ("dataendtime".equals(key)) {
            date = this.dateParse(fillYear, dateValue, " 23:59:59");
        }
        dataModel.setValue(key, (Object)date, index);
        this.checkTime(index, view);
    }

    public void reportClassifyChangeHandler(PropertyChangedArgs args, IFormView view, IFormPlugin plugin) {
        IDataModel dataModel = view.getModel();
        IPageCache pageCache = view.getPageCache();
        if (!HRObjectUtils.isEmpty((Object)pageCache.get("clear"))) {
            pageCache.remove("clear");
            return;
        }
        DynamicObject newValue = (DynamicObject)args.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)args.getChangeSet()[0].getOldValue();
        if (null != oldValue && newValue != oldValue) {
            pageCache.put("oldClass", String.valueOf(oldValue.getLong("id")));
            if (HRObjectUtils.isEmpty((Object)newValue)) {
                pageCache.put("clear", "cancel");
                dataModel.setValue("reportclassify", (Object)Long.parseLong(pageCache.get("oldClass")));
                return;
            }
            if ("cancel".equals(pageCache.get("flag"))) {
                pageCache.remove("flag");
                return;
            }
            view.showConfirm(ResManager.loadKDString((String)"\u62a5\u8868\u5206\u7c7b\u5207\u6362\uff0c\u5c06\u66ff\u6362\u4efb\u52a1\u914d\u7f6e\u7684\u62a5\u8868\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"CollectTaskPlugin_11", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changeReportClass", plugin));
        } else if (null == oldValue) {
            DynamicObject reportclassify = (DynamicObject)dataModel.getValue("reportclassify");
            this.fillTaskSetting(reportclassify, view);
        }
    }

    public void fillTaskSetting(DynamicObject reportClass, IFormView view) {
        IDataModel dataModel = view.getModel();
        DynamicObject[] reportInfo = RPT_TPL_QUERY_SERVICE.queryRptTplByClass(reportClass.getLong("id"), dataModel.getDataEntity(true).getLong("org.id"));
        List reportInfoList = Arrays.stream(reportInfo).sorted(Comparator.comparing(dy -> dy.getString("number"), Comparator.naturalOrder())).collect(Collectors.toList());
        boolean isCycrpt = reportClass.getBoolean("iscycrpt");
        view.getPageCache().put("iscycrpt", String.valueOf(isCycrpt));
        RptTplService rptTplService = RptTplService.getInstance();
        if (isCycrpt) {
            view.setVisible(Boolean.valueOf(true), new String[]{"periodtype", "belongperiod"});
            Long belongPeriodId = 0L;
            List yearRpt = reportInfoList.stream().filter(dynamicObject -> RPT_YEAR_ID.longValue() == dynamicObject.getDynamicObject("periodtype").getLong("id")).collect(Collectors.toList());
            if (!yearRpt.isEmpty()) {
                DynamicObject belongPeriod = RPT_TPL_QUERY_SERVICE.queryBelongPeriod(((DynamicObject)yearRpt.get(0)).getLong("periodtype_id"));
                belongPeriodId = belongPeriod.getLong("id");
            }
            List<DynamicObject> cofigExeUnit = this.getCofigExeUnit(view);
            for (int tag = 0; tag < Math.min(reportInfoList.size(), 100); ++tag) {
                int newEntryRow = dataModel.createNewEntryRow("taskfillobjs");
                DynamicObject rptTpl = (DynamicObject)reportInfoList.get(tag);
                DynamicObject newVersionEntry = rptTplService.getNewVersionEntry(rptTpl);
                dataModel.setValue("rpttpl", (Object)((DynamicObject)reportInfoList.get(tag)).getLong("id"), tag);
                dataModel.setValue("repentryid", (Object)newVersionEntry.getLong("id"), tag);
                dataModel.setValue("periodtype", (Object)((DynamicObject)reportInfoList.get(tag)).getLong("periodtype_id"), tag);
                if (!cofigExeUnit.isEmpty()) {
                    DynamicObjectCollection dynamicObjectCollection = ((DynamicObject)dataModel.getDataEntity(true).getDynamicObjectCollection("taskfillobjs").get(newEntryRow)).getDynamicObjectCollection("fillunits");
                    cofigExeUnit.forEach(dynamicObject -> {
                        DynamicObject fillUnit = dynamicObjectCollection.addNew();
                        fillUnit.set("fbasedataid", dynamicObject);
                    });
                }
                if (RPT_YEAR_ID.longValue() == ((DynamicObject)reportInfoList.get(tag)).getDynamicObject("periodtype").getLong("id")) {
                    dataModel.setValue("belongperiod", (Object)belongPeriodId, tag);
                    this.setInitTimeValue(tag, dataModel);
                    continue;
                }
                dataModel.setValue("belongperiod", (Object)"", tag);
                dataModel.setValue("datastarttime", (Object)"", tag);
                dataModel.setValue("dataendtime", (Object)"", tag);
            }
            view.updateView("taskfillobjs");
            this.disableBelongPeriod(view);
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"periodtype", "belongperiod"});
            List<DynamicObject> cofigExeUnit = this.getCofigExeUnit(view);
            for (int tag = 0; tag < Math.min(reportInfoList.size(), 100); ++tag) {
                int newEntryRow = dataModel.createNewEntryRow("taskfillobjs");
                DynamicObject rptTpl = (DynamicObject)reportInfoList.get(tag);
                DynamicObject newVersionEntry = rptTplService.getNewVersionEntry(rptTpl);
                dataModel.setValue("rpttpl", (Object)((DynamicObject)reportInfoList.get(tag)).getLong("id"), tag);
                dataModel.setValue("repentryid", (Object)newVersionEntry.getLong("id"), tag);
                dataModel.setValue("periodtype", (Object)RPT_YEAR_ID, tag);
                dataModel.setValue("belongperiod", (Object)BELONG_PERIOD_YEAR_ID, tag);
                if (cofigExeUnit.isEmpty()) continue;
                DynamicObjectCollection dynamicObjectCollection = ((DynamicObject)dataModel.getDataEntity(true).getDynamicObjectCollection("taskfillobjs").get(newEntryRow)).getDynamicObjectCollection("fillunits");
                cofigExeUnit.forEach(dynamicObject -> {
                    DynamicObject fillUnit = dynamicObjectCollection.addNew();
                    fillUnit.set("fbasedataid", dynamicObject);
                });
            }
            view.updateView("taskfillobjs");
        }
    }

    public void belongPeriodChangeHandler(PropertyChangedArgs args, int rowIndex, IFormView view) {
        IDataModel dataModel = view.getModel();
        IPageCache pageCache = view.getPageCache();
        if ("batchsetting".equals(pageCache.get("changeSource"))) {
            pageCache.remove("changeSource");
            return;
        }
        String isCycrpt = pageCache.get("iscycrpt");
        if (!HRStringUtils.isEmpty((String)isCycrpt) && "false".equals(isCycrpt)) {
            return;
        }
        DynamicObject newValue = (DynamicObject)args.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)args.getChangeSet()[0].getOldValue();
        if (HRObjectUtils.isEmpty((Object)newValue)) {
            dataModel.setValue("belongperiod", (Object)oldValue);
            return;
        }
        this.belongPeriodChangeDateSetter(rowIndex, pageCache, newValue, dataModel);
    }

    public void yearChangeHandler(IFormView view) {
        IDataModel dataModel = view.getModel();
        DynamicObjectCollection taskEntry = dataModel.getEntryEntity("taskfillobjs");
        for (DynamicObject info : taskEntry) {
            Date dataStartTime = info.getDate("datastarttime");
            Date dataEndTime = info.getDate("dataendtime");
            String fillYear = this.getFillYear(dataModel);
            if (!HRObjectUtils.isEmpty((Object)dataStartTime)) {
                String strStartTime = this.checkLeapMonth(DateUtils.getDate((Date)dataStartTime), dataModel);
                info.set("datastarttime", (Object)this.getParseDate(fillYear + strStartTime.substring(4)));
            }
            if (HRObjectUtils.isEmpty((Object)dataEndTime)) continue;
            String strEndTime = this.checkLeapMonth(DateUtils.getDate((Date)dataEndTime), dataModel);
            info.set("dataendtime", (Object)this.getParseDate(fillYear + strEndTime.substring(4)));
        }
        view.updateView("taskfillobjs");
        this.disableBelongPeriod(view);
    }

    public void disUnitChangeHanlder(PropertyChangedArgs args, IFormView view, IFormPlugin plugin) {
        IPageCache pageCache = view.getPageCache();
        IDataModel dataModel = view.getModel();
        String tipMessage = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"CollectTaskFormService_5", (String)"sihc-soehrr-business", (Object[])new Object[0]);
        view.showFieldTip(this.getFieldTip(tipMessage, "disunit", !HRObjectUtils.isEmpty((Object)dataModel.getValue("disunit"))));
        DynamicObject newValue = (DynamicObject)args.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)args.getChangeSet()[0].getOldValue();
        if (HRObjectUtils.isEmpty((Object)newValue)) {
            dataModel.setValue("disunit", (Object)oldValue);
            view.showTipNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u5355\u4f4d\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"CollectTaskFormService_6", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection taskSettingEntry = dataModel.getEntryEntity("taskfillobjs");
        HashSet invokeUnitsIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : taskSettingEntry) {
            DynamicObjectCollection fillUnits = dynamicObject.getDynamicObjectCollection("fillunits");
            for (DynamicObject fillUnit : fillUnits) {
                invokeUnitsIds.add(fillUnit.getDynamicObject("fbasedataid"));
            }
        }
        if (!invokeUnitsIds.isEmpty()) {
            if (null != oldValue && newValue != oldValue) {
                if ("cancel".equals(pageCache.get("flag"))) {
                    pageCache.remove("flag");
                    return;
                }
            } else if (null == oldValue) {
                return;
            }
            pageCache.put("oldUnit", String.valueOf(oldValue.getLong("id")));
            view.showConfirm(ResManager.loadKDString((String)"\u53d1\u5e03\u5355\u4f4d\u5207\u6362\uff0c\u5c06\u66ff\u6362\u4efb\u52a1\u914d\u7f6e\u7684\u586b\u62a5\u5355\u4f4d\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"CollectTaskFormService_7", (String)"sihc-soehrr-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changeDisUnit", plugin));
        } else {
            List<DynamicObject> cofigExeUnit = this.getCofigExeUnit(view);
            DynamicObjectCollection taskFillObjEntry = dataModel.getEntryEntity("taskfillobjs");
            if (!cofigExeUnit.isEmpty()) {
                for (DynamicObject dynamicObject : taskFillObjEntry) {
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("fillunits");
                    dynamicObjectCollection.clear();
                    cofigExeUnit.forEach(fillUnitObj -> {
                        DynamicObject fillUnit = dynamicObjectCollection.addNew();
                        fillUnit.set("fbasedataid", fillUnitObj);
                    });
                }
            }
            view.updateView("taskfillobjs");
        }
    }

    public void endTimeChangeHandler(PropertyChangedArgs args, IFormView view) {
        Date newDate;
        IPageCache pageCache = view.getPageCache();
        IDataModel dataModel = view.getModel();
        if (!HRObjectUtils.isEmpty((Object)pageCache.get("changed"))) {
            pageCache.remove("changed");
            return;
        }
        Date newValue = (Date)args.getChangeSet()[0].getNewValue();
        Date nowDate = this.getParseDate(DateUtils.getDate((Date)new Date()), DatePattern.YYYY_MM_DD);
        if (nowDate.equals(newDate = this.getParseDate(DateUtils.getDate((Date)newValue), DatePattern.YYYY_MM_DD))) {
            pageCache.put("changed", "true");
            dataModel.setValue("endtime", (Object)new Date());
        }
        if (Objects.nonNull(dataModel.getValue("endtime"))) {
            dataModel.setValue("endtime", (Object)CollectTaskFormService.add235959((Date)dataModel.getValue("endtime")));
        }
    }

    public static Date add235959(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalTime endOfDay = LocalTime.MAX;
        LocalDateTime endOfDate = localDateTime.with(endOfDay);
        return Date.from(endOfDate.atZone(ZoneId.systemDefault()).toInstant());
    }

    private void belongPeriodChangeDateSetter(int rowIndex, IPageCache pageCache, DynamicObject newValue, IDataModel dataModel) {
        pageCache.put("isChanging", "true");
        Date startDate = newValue.getDate("startdate");
        String strStartDate = this.checkLeapMonth(DateUtils.getDate((Date)startDate), dataModel);
        Date endDate = newValue.getDate("enddate");
        String strEndDate = this.checkLeapMonth(DateUtils.getDate((Date)endDate), dataModel);
        String fillYear = this.getFillYear(dataModel);
        dataModel.setValue("datastarttime", (Object)(fillYear + strStartDate.substring(4)), rowIndex);
        dataModel.setValue("dataendtime", (Object)(fillYear + strEndDate.substring(4)), rowIndex);
        pageCache.remove("isChanging");
    }

    private Date dateParse(String fillYear, Date dateValue, String timeString) {
        Date date = this.getParseDate(fillYear + DateUtils.getDate((Date)dateValue).substring(4) + timeString, DatePattern.YY_MM_DD_HH_MM_SS);
        return date;
    }

    public void checkTime(int index, IFormView view) {
        IDataModel dataModel = view.getModel();
        if (!HRObjectUtils.isEmpty((Object)view.getPageCache().get("isChanging"))) {
            view.getPageCache().remove("isChanging");
            return;
        }
        Date startTime = (Date)dataModel.getValue("datastarttime", index);
        Date endTime = (Date)dataModel.getValue("dataendtime", index);
        if (!HRObjectUtils.isEmpty((Object)startTime) && !HRObjectUtils.isEmpty((Object)endTime) && startTime.after(endTime)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6570\u636e\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6570\u636e\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CollectTaskFormService_1", (String)"sihc-soehrr-business", (Object[])new Object[0]), index + 1));
            view.getPageCache().put("isChanging", "true");
            dataModel.setValue("dataendtime", null, index);
        }
    }

    public boolean dataVerify(BeforeDoOperationEventArgs args, Long taskId, IFormView view) {
        if (taskId != null) {
            DynamicObject fillTaskInfo = FILL_TASK_QUERY_SERVICE.queryFillTask(taskId);
            long hatchSolution = fillTaskInfo.getLong("hatchsolution");
            String pkValue = view.getModel().getDataEntity().getPkValue().toString();
            if (hatchSolution != 0L && pkValue.equals("0")) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u91c7\u96c6\u4efb\u52a1\u5df2\u5b58\u5728\u3002", (String)"CollectTaskPlugin_26", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
            String taskStatus = fillTaskInfo.getString("taskstatus");
            if (taskStatus.equals("D")) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u586b\u62a5\u4efb\u52a1\u5df2\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u4e0b\u53d1\u4efb\u52a1\u3002", (String)"CollectTaskPlugin_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
            if (taskStatus.equals("F")) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u586b\u62a5\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u4e0b\u53d1\u4efb\u52a1\u3002", (String)"CollectTaskPlugin_27", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
            if (taskStatus.equals("B")) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u586b\u62a5\u4efb\u52a1\u5df2\u4e0a\u62a5\uff0c\u4e0d\u5141\u8bb8\u4e0b\u53d1\u4efb\u52a1\u3002", (String)"CollectTaskPlugin_33", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
            String billStatus = fillTaskInfo.getString("billstatus");
            if (!HRStringUtils.equals((String)billStatus, (String)"A")) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u586b\u62a5\u4efb\u52a1\u5df2\u4e0a\u62a5\uff0c\u4e0d\u5141\u8bb8\u4e0b\u53d1\u4efb\u52a1\u3002", (String)"CollectTaskPlugin_33", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return true;
            }
        }
        return false;
    }

    public void fillUnitCheck(BeforeDoOperationEventArgs args, Long taskId, IFormView view) {
        IDataModel dataModel = view.getModel();
        if (taskId != null) {
            DynamicObjectCollection taskSettingEntry = dataModel.getEntryEntity("taskfillobjs");
            DynamicObject disUnit = (DynamicObject)dataModel.getValue("disunit");
            if (disUnit != null) {
                Long disUnitId = disUnit.getLong("id");
                for (DynamicObject dynamicObject : taskSettingEntry) {
                    DynamicObjectCollection fillUnits = dynamicObject.getDynamicObjectCollection("fillunits");
                    List collect = fillUnits.stream().map(unit -> unit.getLong("fbasedataid.id")).distinct().collect(Collectors.toList());
                    if (!collect.contains(disUnitId)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e0b\u53d1\u4efb\u52a1\u65f6\u586b\u62a5\u5355\u4f4d\u9700\u9009\u62e9\u5f53\u524d\u53d1\u5e03\u5355\u4f4d\u672c\u7ea7\u3002", (String)"CollectTaskFormService_8", (String)"sihc-soehrr-business", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (collect.size() != 1 || !collect.contains(disUnitId)) continue;
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5176\u4ed6\u586b\u62a5\u5355\u4f4d\u3002", (String)"CollectTaskFormService_9", (String)"sihc-soehrr-business", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void disableBelongPeriod(IFormView view) {
        IDataModel dataModel = view.getModel();
        DynamicObjectCollection taskEntry = dataModel.getEntryEntity("taskfillobjs");
        for (int i = 0; i < taskEntry.size(); ++i) {
            if (RPT_YEAR_ID.longValue() != ((DynamicObject)taskEntry.get(i)).getDynamicObject("periodtype").getLong("id")) continue;
            view.setEnable(Boolean.valueOf(false), i, new String[]{"belongperiod"});
        }
    }

    public Date getParseDate(String dateString, DatePattern datePattern) {
        try {
            return DateUtils.parseDate((String)dateString, (DatePattern)datePattern);
        }
        catch (ParseException e) {
            LOG.error("ParseDate error", (Throwable)e);
            return null;
        }
    }

    public Date getParseDate(String dateString) {
        try {
            return DateUtils.parseDate((String)dateString);
        }
        catch (ParseException e) {
            LOG.error("ParseDate error", (Throwable)e);
            return null;
        }
    }

    public void setInitTimeValue(int tag, IDataModel dataModel) {
        String fillYear = this.getFillYear(dataModel);
        String startTimeString = fillYear + "-01-01 00:00:00";
        String endTimeString = fillYear + "-12-31 23:59:59";
        dataModel.setValue("datastarttime", (Object)this.getParseDate(startTimeString, DatePattern.YYYY_MM_DD_HH_MM_SS), tag);
        dataModel.setValue("dataendtime", (Object)this.getParseDate(endTimeString, DatePattern.YYYY_MM_DD_HH_MM_SS), tag);
    }

    public FieldTip getFieldTip(String tips, String fieldKey, boolean flag) {
        FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, fieldKey, tips);
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Collections.singletonList("name"));
        tip.setSuccess(flag);
        tip.setDeleteRule(deleteRule);
        return tip;
    }

    public String checkLeapMonth(String date, IDataModel dataModel) {
        String fillYear = this.getFillYear(dataModel);
        return this.checkLeapMonth(date, fillYear);
    }

    public String checkLeapMonth(String date, String fillYear) {
        if ("02".equals(date.substring(5, 7)) && ("28".equals(date.substring(8, 10)) || "29".equals(date.substring(8, 10)))) {
            int year;
            if (HRStringUtils.isEmpty((String)fillYear)) {
                fillYear = new SimpleDateFormat("yyyy").format(new Date());
            }
            if (SoehrrCommonUtils.isLeapYear((int)(year = Integer.parseInt(fillYear)))) {
                return date.substring(0, 9) + "9";
            }
            return date.substring(0, 9) + "8";
        }
        return date;
    }

    private void setTaskFillObjsValue(DynamicObject report, int tag, IDataModel dataModel) {
        DynamicObject rptTpl = report.getDynamicObject("rpttpl");
        dataModel.setValue("rpttpl", (Object)rptTpl.getLong("id"), tag);
        dataModel.setValue("periodtype", (Object)report.getDynamicObject("periodtype").getLong("id"), tag);
        dataModel.setValue("belongperiod", (Object)report.getDynamicObject("belongperiod").getLong("id"), tag);
        dataModel.setValue("datastarttime", report.get("datastarttime"), tag);
        dataModel.setValue("dataendtime", report.get("dataendtime"), tag);
        dataModel.setValue("repentryid", (Object)report.getLong("repentryid"), tag);
    }

    private List<ComboItem> getBelongYear() {
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        ArrayList yearList = Lists.newArrayListWithExpectedSize((int)year);
        for (int i = year - 2; i < year + 1; ++i) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(String.valueOf(i)));
            comboItem.setValue(String.valueOf(i));
            yearList.add(comboItem);
        }
        return yearList;
    }
}

