/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.collecttask;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sihc.soehrr.business.application.report.CollectTaskApplicationService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;

public class CollectTaskService
extends HRBaseServiceHelper {
    private static final CollectTaskApplicationService collectTaskApplicationService = ServiceFactory.getService(CollectTaskApplicationService.class);

    public static CollectTaskService ins() {
        return Instance.INSTANCE;
    }

    public CollectTaskService() {
        super("soehrr_collecttask");
    }

    public List<Long> getCollectTaskRpts(Long collectId) {
        return super.loadSingle((Object)collectId).getDynamicObjectCollection("taskfillobjs").stream().map(dyn -> dyn.getDynamicObject("rpttpl").getLong("id")).collect(Collectors.toList());
    }

    public List<String> getCollectRpttplNumbers(Long collectId) {
        return super.queryOne((Object)collectId).getDynamicObjectCollection("taskfillobjs").stream().map(k -> k.getString("rpttpl.number")).collect(Collectors.toList());
    }

    public DynamicObject getCollectInfo(Long collectId, String prop) {
        return super.queryOne(prop, new QFilter("id", "=", (Object)collectId).toArray());
    }

    public boolean checkPerm(Long collectTaskId, IFormView view) {
        List hasPermOrgs;
        DynamicObject collectTaskInfo = super.loadSingle((Object)collectTaskId);
        DynamicObject org = collectTaskInfo.getDynamicObject("org");
        DynamicObject disUnit = collectTaskInfo.getDynamicObject("disunit");
        AuthorizedOrgResult userAdminOrgs = collectTaskApplicationService.getUserAdminOrgs("soehrr_collecttask", "disunit");
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId(), (boolean)true);
        if (!HRObjectUtils.isEmpty((Object)userAdminOrgs)) {
            if (userAdminOrgs.isHasAllOrgPerm()) {
                return true;
            }
            hasPermOrgs = userAdminOrgs.getHasPermOrgs();
            if (!hasPermOrgs.contains(disUnit.getLong("id"))) {
                return false;
            }
        }
        if (!HRObjectUtils.isEmpty((Object)userHasPermOrgs)) {
            if (userHasPermOrgs.hasAllOrgPerm()) {
                return true;
            }
            hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
            if (!hasPermOrgs.contains(org.getLong("id"))) {
                return false;
            }
        }
        return true;
    }

    private static class Instance {
        private static final CollectTaskService INSTANCE = new CollectTaskService();

        private Instance() {
        }
    }
}

