/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.collecttask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.command.BorderHlStyleCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetActiveSheetCommand;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.enums.CusExceptionEnum;
import kd.sdk.sihc.soehrr.common.enums.RptTypeEnum;
import kd.sdk.sihc.soehrr.common.filltask.BorderStyleRecordDto;
import kd.sdk.sihc.soehrr.common.report.CallBackFunction;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soebs.business.common.utils.AttachmentTransferUtils;
import kd.sihc.soebs.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.business.application.report.ReportApplicationService;
import kd.sihc.soehrr.business.application.report.ReportVerApplicationService;
import kd.sihc.soehrr.business.application.report.ReportVerParam;
import kd.sihc.soehrr.business.application.report.ReportVerResult;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;
import kd.sihc.soehrr.business.domain.collecttask.AnnotationHelper;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskCheckStyleService;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskService;
import kd.sihc.soehrr.business.domain.collecttask.SumReportHelper;
import kd.sihc.soehrr.business.domain.report.ReportQueryService;
import kd.sihc.soehrr.business.domain.report.ReportService;
import kd.sihc.soehrr.business.queryservice.FillTaskQueryService;
import kd.sihc.soehrr.business.queryservice.RptTplQueryService;
import kd.sihc.soehrr.business.queryservice.SummaryReportQueryHelper;
import kd.sihc.soehrr.common.enums.CommentTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class FillTaskCallBackHandler {
    private static Log LOG = LogFactory.getLog(FillTaskCallBackHandler.class);
    private static final Map<String, CallBackFunction<String, SpreadModelParam, IFormPlugin>> CALLBACK_SERVICE = Maps.newHashMapWithExpectedSize((int)16);
    private static final ReportQueryService reportQueryService = (ReportQueryService)ServiceFactory.getService(ReportQueryService.class);
    private static final FillTaskQueryService fillTaskQueryService = (FillTaskQueryService)ServiceFactory.getService(FillTaskQueryService.class);
    private static final FillTaskCheckStyleService fillTaskCheckStyleService = (FillTaskCheckStyleService)((Object)ServiceFactory.getService(FillTaskCheckStyleService.class));
    private static final SummaryReportQueryHelper SUMMARYREPORTQUERYHELPER = (SummaryReportQueryHelper)ServiceFactory.getService(SummaryReportQueryHelper.class);
    private static final RptTplQueryService RPTTPLQUERYSERVICE = (RptTplQueryService)ServiceFactory.getService(RptTplQueryService.class);
    private static final ReportService REPORTSERVICE = (ReportService)((Object)ServiceFactory.getService(ReportService.class));

    private FillTaskCallBackHandler() {
    }

    private static void fillCheckRuleButton(String spreadJson, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        IFormView view = spreadModelParam.getView();
        DynamicObject fillTask = view.getModel().getDataEntity(true);
        fillTask.set("trepcontent_tag", (Object)spreadJson);
        ReportVerResult reportVerResult = ReportVerApplicationService.checkTask(fillTask, spreadModelParam);
        String uncompressJson = GzipTools.uncompressJson((String)spreadJson);
        JSONObject spreadJsonObject = JSON.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        FillTaskCallBackHandler.drawButtonTipBorders(reportVerResult, spreadJsonObject, fillTask.getLong("id"), spreadModelParam);
        if (reportVerResult.getErrors().size() == 0) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6821\u6838\u901a\u8fc7\u3002", (String)"FillTaskPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("soehrr_validatorresults");
        formShowParameter.setCustomParam("checkresult", (Object)SerializationUtils.serializeToBase64((Object)reportVerResult));
        view.showForm(formShowParameter);
    }

    public void invokeMethod(String methodName, String args, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        CallBackFunction<String, SpreadModelParam, IFormPlugin> function = CALLBACK_SERVICE.get(methodName);
        if (Objects.isNull(function)) {
            throw new KDBizException(CusExceptionEnum.CALLBACK_ERROR.getName());
        }
        function.accept((Object)args, (Object)spreadModelParam, (Object)plugin);
    }

    protected static void saveSpreadData(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        DynamicObject[] rptTplByFillTask;
        IFormView view = spreadParam.getView();
        DynamicObject data = view.getModel().getDataEntity(true);
        LOG.info("view data id :{}, json :{} ,content : {}", new Object[]{data.getLong("id"), spreadJson, data});
        DynamicObject dataEntity = fillTaskQueryService.queryFillTaskWhenCallBack(data.getLong("id"));
        LOG.info("dataEntity id :{} ,content {}", (Object)dataEntity.getLong("id"), (Object)dataEntity);
        Object customParam = view.getFormShowParameter().getCustomParam("from");
        boolean isTraceInfo = !Objects.isNull(customParam) && "trace".equals(customParam);
        spreadJson = AnnotationHelper.handManualComments(spreadJson, isTraceInfo ? CommentTypeEnum.PUBLISH.getPrefix().getLocaleValue() : CommentTypeEnum.FILLING.getPrefix().getLocaleValue());
        LOG.info("handManualComments json :{} ", (Object)spreadJson);
        String jsonField = isTraceInfo ? "reportcontent_tag" : "trepcontent_tag";
        dataEntity.set(jsonField, (Object)spreadJson);
        view.getModel().setValue(jsonField, (Object)spreadJson);
        Object obj = FillTaskService.ins().saveOne(dataEntity);
        LOG.info("FillTaskService.ins().saveOne obj :{} ", obj);
        for (DynamicObject rptTpl : rptTplByFillTask = reportQueryService.getRptTplByFillTasks(dataEntity.getLong("id"))) {
            String tplName = rptTpl.getDynamicObject("rpttpl").getString("name");
            List attachments = AttachmentServiceHelper.getAttachments((String)"soehrr_filltask", (Object)dataEntity.getLong("id"), (String)"attachmentpanelap");
            ArrayList singleAttachments = Lists.newArrayListWithCapacity((int)10);
            for (Map attachment : attachments) {
                if (!tplName.equals(attachment.get("description"))) continue;
                singleAttachments.add(attachment);
            }
            if (singleAttachments.isEmpty()) continue;
            AttachmentTransferUtils.attachmentTransfer((String)"soehrr_report", (Long)rptTpl.getLong("id"), (String)"attachmentpanelap", (List)singleAttachments);
        }
        FillTaskService.ins().saveDependencyData(spreadParam);
        boolean success = HRObjectUtils.isEmpty((Object)obj);
        if (success) {
            view.showErrorNotification(CusExceptionEnum.SAVE_ERROR.getName());
        } else {
            view.updateView();
        }
    }

    protected static void saveAndSubmit(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        LOG.info("FillTaskCallBackHandler check task 1 at {}", (Object)System.currentTimeMillis());
        IFormView view = spreadParam.getView();
        DynamicObject data = view.getModel().getDataEntity(true);
        DynamicObject dataEntity = fillTaskQueryService.queryFillTaskWhenCallBack(data.getLong("id"));
        LOG.info("FillTaskCallBackHandler check task 2 at {}", (Object)System.currentTimeMillis());
        String billStatus = dataEntity.getString("billstatus");
        spreadJson = AnnotationHelper.handManualComments(spreadJson, HRStringUtils.equals((String)"C", (String)billStatus) ? CommentTypeEnum.PUBLISH.getPrefix().getLocaleValue() : CommentTypeEnum.FILLING.getPrefix().getLocaleValue());
        LOG.info("FillTaskCallBackHandler check task 3 at {}", (Object)System.currentTimeMillis());
        dataEntity.set("trepcontent_tag", (Object)spreadJson);
        view.getModel().setValue("trepcontent_tag", (Object)spreadJson);
        Object obj = FillTaskService.ins().saveOne(dataEntity);
        LOG.info("FillTaskCallBackHandler check task 4 at {}", (Object)System.currentTimeMillis());
        LOG.info("FillTaskService.ins().saveOne obj :{} ", obj);
        FillTaskService.ins().saveDependencyData(spreadParam);
        LOG.info("FillTaskCallBackHandler check task 5 at {}", (Object)System.currentTimeMillis());
        boolean success = HRObjectUtils.isEmpty((Object)obj);
        if (success) {
            view.showErrorNotification(CusExceptionEnum.SAVE_ERROR.getName());
        } else {
            DynamicObject newFillTask = fillTaskQueryService.queryFillTaskWhenCallBack(data.getLong("id"));
            LOG.info("FillTaskCallBackHandler check task 6 at {}", (Object)System.currentTimeMillis());
            newFillTask.set("trepcontent_tag", (Object)spreadJson);
            FillTaskCallBackHandler.showConfirm(newFillTask, spreadParam, plugin);
        }
    }

    private static void showConfirm(DynamicObject fillTask, SpreadModelParam spreaParam, IFormPlugin plugin) {
        long now = System.currentTimeMillis();
        ReportVerResult reportVerResult = ReportVerApplicationService.checkTask(fillTask, spreaParam);
        LOG.info("FillTaskCallBackHandler check task used {}", (Object)(System.currentTimeMillis() - now));
        IFormView view = spreaParam.getView();
        int valid = reportVerResult.isValid();
        if (valid == 1) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("submit_confirm_callback", plugin);
            view.showConfirm(ResManager.loadKDString((String)"\u8868\u4e2d\u5b58\u5728\u6821\u9a8c\u672a\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e0a\u62a5\uff1f", (String)"FillTaskListPlugin_1", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        } else if (valid == 0) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("soehrr_validatorresults");
            formShowParameter.setCustomParam("checkresult", (Object)SerializationUtils.serializeToBase64((Object)reportVerResult));
            view.showForm(formShowParameter);
            LOG.info("FillTaskCallBackHandler check task 7 at {}", (Object)System.currentTimeMillis());
        } else {
            view.invokeOperation("submit");
        }
    }

    private static void afterGetJsonToRepulse(String spreadJson, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        IFormView view = spreadModelParam.getView();
        DynamicObject data = view.getModel().getDataEntity(true);
        long fillTaskId = data.getLong("id");
        DynamicObject fillTask = fillTaskQueryService.queryFillTask(data.getLong("id"));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("soehrr_msgsendview");
        showParameter.setPageId("soehrr_msgsendview" + fillTaskId + RequestContext.get().getGlobalSessionId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        spreadJson = AnnotationHelper.handManualComments(spreadJson, CommentTypeEnum.PUBLISH.getPrefix().getLocaleValue());
        fillTask.set("reportcontent_tag", (Object)spreadJson);
        view.getModel().setValue("reportcontent_tag", (Object)spreadJson);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "repulsebox"));
        showParameter.setCustomParam("filltask", (Object)SerializationUtils.serializeToBase64((Object)fillTask));
        showParameter.setCustomParam("id", (Object)fillTaskId);
        showParameter.setCustomParam("parameteroptype", (Object)"repulse");
        showParameter.setCustomParam("page", (Object)"repulseDetails");
        if (Objects.nonNull(view.getFormShowParameter().getCustomParam("fillTaskTraceList"))) {
            showParameter.setCustomParam("fillTaskTraceList", (Object)true);
        }
        view.showForm(showParameter);
    }

    private static void fillTaskReport(String spreadJson, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        DynamicObject fillTask = spreadModelParam.getView().getModel().getDataEntity(true);
        ReportService.ins().splitSpreadJson2Rpt(fillTask.getLong("id"), spreadJson);
    }

    protected static void nextStep(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        IFormView view = spreadParam.getView();
        if (HRStringUtils.isEmpty((String)spreadJson)) {
            return;
        }
        JSONObject spreadJsonObject = SpreadJsonHelper.getSpreadJsonByUncompress((String)spreadJson);
        JSONObject sheets = SpreadJsonHelper.getSheets((JSONObject)spreadJsonObject);
        String sheetName = SpreadJsonHelper.getSelectedSheetName((JSONObject)spreadJsonObject);
        if (StringUtils.isEmpty((CharSequence)sheetName)) {
            return;
        }
        List keyNameList = sheets.keySet().stream().sorted(Comparator.comparingInt(key -> sheets.getJSONObject(key).getIntValue("index"))).collect(Collectors.toList());
        for (int i = 0; i < keyNameList.size(); ++i) {
            if (!sheetName.equals(keyNameList.get(i))) continue;
            int index = i + 1;
            String activeSheetName = (String)keyNameList.get(index);
            view.getModel().setValue("sheetcombo", (Object)activeSheetName);
            SetActiveSheetCommand setActiveSheetCommand = new SetActiveSheetCommand(activeSheetName);
            setActiveSheetCommand.invokeMethod(spreadParam);
            if (index == keyNameList.size() - 1) {
                view.setEnable(Boolean.FALSE, new String[]{"filltasknextstep"});
                view.setEnable(Boolean.TRUE, new String[]{"filltaskpreviousstep"});
                continue;
            }
            if (i == keyNameList.size() - 1) {
                view.setEnable(Boolean.FALSE, new String[]{"filltasknextstep"});
                continue;
            }
            view.setEnable(Boolean.TRUE, new String[]{"filltasknextstep"});
            view.setEnable(Boolean.TRUE, new String[]{"filltaskpreviousstep"});
        }
    }

    protected static void previousStep(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        IFormView view = spreadParam.getView();
        if (HRStringUtils.isEmpty((String)spreadJson)) {
            return;
        }
        JSONObject spreadJsonObject = SpreadJsonHelper.getSpreadJsonByUncompress((String)spreadJson);
        JSONObject sheets = SpreadJsonHelper.getSheets((JSONObject)spreadJsonObject);
        String sheetName = SpreadJsonHelper.getSelectedSheetName((JSONObject)spreadJsonObject);
        if (StringUtils.isEmpty((CharSequence)sheetName)) {
            return;
        }
        List keyNameList = sheets.keySet().stream().sorted(Comparator.comparingInt(key -> sheets.getJSONObject(key).getIntValue("index"))).collect(Collectors.toList());
        for (int i = 0; i < keyNameList.size(); ++i) {
            if (!sheetName.equals(keyNameList.get(i))) continue;
            if (i == 0) {
                view.setEnable(Boolean.FALSE, new String[]{"filltaskpreviousstep"});
                continue;
            }
            int index = i - 1;
            String activeSheetName = (String)keyNameList.get(index);
            view.getModel().setValue("sheetcombo", (Object)activeSheetName);
            SetActiveSheetCommand setActiveSheetCommand = new SetActiveSheetCommand(activeSheetName);
            setActiveSheetCommand.invokeMethod(spreadParam);
            if (index == 0) {
                view.setEnable(Boolean.FALSE, new String[]{"filltaskpreviousstep"});
                view.setEnable(Boolean.TRUE, new String[]{"filltasknextstep"});
                continue;
            }
            if (index == keyNameList.size() - 1) {
                view.setEnable(Boolean.TRUE, new String[]{"filltaskpreviousstep"});
                view.setEnable(Boolean.FALSE, new String[]{"filltasknextstep"});
                continue;
            }
            view.setEnable(Boolean.TRUE, new String[]{"filltaskpreviousstep"});
            view.setEnable(Boolean.TRUE, new String[]{"filltasknextstep"});
        }
    }

    protected static void fillTaskCheckCell(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        IFormView view = spreadParam.getView();
        String verCache = ReportVerParam.class.getName() + view.getPageId();
        String verParamStr = view.getPageCache().get(verCache);
        if (HRStringUtils.isEmpty((String)verParamStr)) {
            return;
        }
        Long fillTaskId = (Long)view.getModel().getDataEntity().getPkValue();
        List reportVerParams = (List)GzipTools.deSerializedBytes((String)verParamStr);
        String uncompressJson = GzipTools.uncompressJson((String)spreadJson);
        JSONObject spreadJsonObject = JSON.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        List<ReportVerResult> reportVerResult = ReportVerApplicationService.checkCell(reportVerParams, spreadParam, spreadJsonObject);
        LOG.info("FillTaskCallBackHandler.fillTaskCheckCell reportVerResult={},fillTaskId={}", reportVerResult, (Object)fillTaskId);
        FillTaskCallBackHandler.drawCellTipBorders(reportVerResult, spreadJsonObject, fillTaskId, spreadParam);
        view.getPageCache().remove(verCache);
    }

    public static void drawCellTipBorders(List<ReportVerResult> reportVerResults, JSONObject spreadJsonObject, long fillTaskId, SpreadModelParam spreadParam) {
        ArrayList clearList = Lists.newArrayListWithCapacity((int)10);
        for (ReportVerResult reportVerResult : reportVerResults) {
            ReportVerParam reportVerParam = reportVerResult.getInputParam();
            String allSheetNames = reportVerParam.getAllSheetNames();
            List<String> orderSheetNames = Arrays.stream(allSheetNames.split(",")).collect(Collectors.toList());
            reportVerParam.setSpreadJsonObject(spreadJsonObject);
            List<Map<String, String>> errors = reportVerResult.getErrors();
            if (!HRCollUtil.isNotEmpty(errors)) continue;
            fillTaskCheckStyleService.recordBorderStyleAndDrawTip(reportVerParam, spreadParam, fillTaskId, orderSheetNames, reportVerResult, clearList);
        }
        List<BorderStyleRecordDto> hasBorderStyles = fillTaskCheckStyleService.getAllBorderRecordInManager(spreadParam);
        for (ReportVerResult reportVerResult : reportVerResults) {
            ReportVerParam reportVerParam = reportVerResult.getInputParam();
            String allSheetNames = reportVerParam.getAllSheetNames();
            List<String> orderSheetNames = Arrays.stream(allSheetNames.split(",")).collect(Collectors.toList());
            List<Map<String, Object>> success = reportVerResult.getSuccess();
            if (!HRCollUtil.isNotEmpty(success)) continue;
            List<Map<String, Object>> successList = reportVerResult.getSuccess();
            for (BorderStyleRecordDto hasBorderStyle : hasBorderStyles) {
                fillTaskCheckStyleService.reductionHighlightCell(successList, hasBorderStyle, orderSheetNames, clearList, hasBorderStyles);
            }
        }
        spreadParam.getSheetManager().setSheetCache(spreadParam.getView());
        LOG.info("FillTaskCallBackHandler.drawCellTipBorders clearList={}", (Object)clearList);
        for (Pair rptAreaConfListPair : clearList) {
            new BorderHlStyleCommand(rptAreaConfListPair).invokeMethod(spreadParam);
        }
    }

    public static void drawButtonTipBorders(ReportVerResult reportVerResult, JSONObject spreadJsonObject, long fillTaskId, SpreadModelParam spreadParam) {
        ArrayList clearList = Lists.newArrayListWithCapacity((int)10);
        List orderSheetNames = SpreadJsonHelper.getOrderSheetNames((JSONObject)spreadJsonObject);
        List<Map<String, String>> errors = reportVerResult.getErrors();
        if (HRCollUtil.isNotEmpty(errors)) {
            for (Map<String, String> error : errors) {
                fillTaskCheckStyleService.recordBorderStyleByError(spreadParam, fillTaskId, error, clearList, orderSheetNames, spreadJsonObject);
            }
        }
        LOG.info("FillTaskCallBackHandler.drawButtonTipBorders clearList={}", (Object)clearList);
        for (Pair rptAreaConfListPair : clearList) {
            new BorderHlStyleCommand(rptAreaConfListPair).invokeMethod(spreadParam);
        }
    }

    protected static void fillTaskImportData(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        IFormView view = spreadParam.getView();
        if (HRStringUtils.isEmpty((String)spreadJson)) {
            LOG.info("spreadJson is empty");
            return;
        }
        DynamicObject data = view.getModel().getDataEntity(true);
        long fillTaskId = data.getLong("id");
        String uncompressJson = GzipTools.uncompressJson((String)spreadJson);
        JSONObject spreadJsonObject = JSONObject.parseObject((String)uncompressJson);
        JSONObject sheets = (JSONObject)spreadJsonObject.get((Object)"sheets");
        String sheetName = SpreadJsonHelper.getSelectedSheetName((JSONObject)spreadJsonObject);
        if (StringUtils.isEmpty((CharSequence)sheetName)) {
            LOG.info("sheetName is empty");
            return;
        }
        List<String> keyNameList = sheets.keySet().stream().sorted(Comparator.comparingInt(key -> sheets.getJSONObject(key).getIntValue("index"))).collect(Collectors.toList());
        Map<String, String> queryImportDataNameByNumber = RPTTPLQUERYSERVICE.queryImportDataTypeByNumber(keyNameList);
        if (queryImportDataNameByNumber.isEmpty()) {
            LOG.info("queryImportDataNameByNumber is empty");
            return;
        }
        ArrayList needUpdateSheetNames = Lists.newArrayList(queryImportDataNameByNumber.keySet());
        Long sumReportsId = (Long)view.getFormShowParameter().getCustomParam("soehrr_sumreports");
        if (sumReportsId == null || sumReportsId == 0L) {
            LOG.info("sumReportsId is empty");
            return;
        }
        DynamicObject sumReports = SUMMARYREPORTQUERYHELPER.querySumReportsById(sumReportsId);
        if (HRObjectUtils.isEmpty((Object)sumReports)) {
            LOG.info("sumReports is empty");
            return;
        }
        Map<String, String> fillAreaBySum = SumReportHelper.getFillAreaBySum(sumReports);
        SheetManager sheetManager = spreadParam.getSheetManager();
        for (Map.Entry<String, String> entry : fillAreaBySum.entrySet()) {
            String activeSheetName = entry.getKey();
            String newAreaPoint = entry.getValue();
            CacheObjInvoker invokerByName = sheetManager.getInvokerByName(activeSheetName);
            AreaSettingDto fillOrTotalArea2 = RepCacheService.ins().getFillOrTotalArea(invokerByName);
            if (Objects.isNull(fillOrTotalArea2)) continue;
            fillOrTotalArea2.setAreaPoint(newAreaPoint);
            sheetManager.setSheetCache(spreadParam.getView());
        }
        List dataTableManagers = sheetManager.getDataTableManagers();
        dataTableManagers.stream().map(dataTableManager -> RepCacheService.ins().getFillOrTotalArea(dataTableManager.getInvoker())).filter(Objects::nonNull).forEach(fillOrTotalArea -> {
            String rptTplNumber = fillOrTotalArea.getRptTplNumber();
            long rptTplEntryId = fillOrTotalArea.getRepEntryId();
            String areaPoint = fillOrTotalArea.getAreaPoint();
            REPORTSERVICE.updateFillAreaWhenFillTask(areaPoint, fillTaskId, rptTplEntryId, rptTplNumber);
        });
        String sumContent = sumReports.getString("trepcontent_tag");
        JSONObject sumSpreadJsonObject = SpreadJsonHelper.getSpreadJsonByUncompress((String)sumContent);
        JSONObject sumSheets = SpreadJsonHelper.getSheets((JSONObject)sumSpreadJsonObject);
        for (String updateSheetName : needUpdateSheetNames) {
            for (Map.Entry entry : sumSheets.entrySet()) {
                String key2 = (String)entry.getKey();
                if (!updateSheetName.equals(key2)) continue;
                JSONObject value = (JSONObject)entry.getValue();
                JSONObject oldJsonObject = sheets.getJSONObject(key2);
                oldJsonObject.put("data", value.get((Object)"data"));
                oldJsonObject.put("validations", value.get((Object)"validations"));
                oldJsonObject.put("rows", value.get((Object)"rows"));
                oldJsonObject.put("spans", value.get((Object)"spans"));
                oldJsonObject.put("rowCount", value.get((Object)"rowCount"));
                if (!RptTypeEnum.DETAIL.getType().equals(queryImportDataNameByNumber.get(key2))) continue;
                oldJsonObject.remove((Object)"comments");
            }
        }
        String newJson = GzipTools.compressJson((String)JSON.toJSONString((Object)spreadJsonObject));
        view.getModel().setValue("trepcontent_tag", (Object)newJson);
        ReportApplicationService.dataRetrival4VariableRetrive(view.getModel().getDataEntity());
        view.updateView();
    }

    public static FillTaskCallBackHandler ins() {
        return Instance.INSTANCE;
    }

    static {
        CALLBACK_SERVICE.put(CallBackEnum.SAVE_FILL_TASK_SPREAD_DATA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)FillTaskCallBackHandler::saveSpreadData));
        CALLBACK_SERVICE.put(CallBackEnum.SAVE_And_SUBMIT_SPREAD_DATA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)FillTaskCallBackHandler::saveAndSubmit));
        CALLBACK_SERVICE.put(CallBackEnum.NEXT_STEP.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)FillTaskCallBackHandler::nextStep));
        CALLBACK_SERVICE.put(CallBackEnum.PREVIOUS_STEP.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)FillTaskCallBackHandler::previousStep));
        CALLBACK_SERVICE.put(CallBackEnum.FILLTASK_AUDIT_REPORT.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)FillTaskCallBackHandler::fillTaskReport));
        CALLBACK_SERVICE.put(CallBackEnum.FILLTASK_CHECK_CELL.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)FillTaskCallBackHandler::fillTaskCheckCell));
        CALLBACK_SERVICE.put(CallBackEnum.AFTER_GETJSON_TOREPULSE.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)FillTaskCallBackHandler::afterGetJsonToRepulse));
        CALLBACK_SERVICE.put(CallBackEnum.FILLTASK_IMPORT_DATA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)FillTaskCallBackHandler::fillTaskImportData));
        CALLBACK_SERVICE.put(CallBackEnum.FILL_CHECKRULE_BUTTON.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)FillTaskCallBackHandler::fillCheckRuleButton));
    }

    private static class Instance {
        private static final FillTaskCallBackHandler INSTANCE = new FillTaskCallBackHandler();

        private Instance() {
        }
    }
}

