/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.collecttask;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.BorderTypeEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.filltask.BorderStyleRecordDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.CellStyle;
import kd.sdk.sihc.soehrr.common.spread.DataTableManager;
import kd.sdk.sihc.soehrr.common.spread.RptAreaConf;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sihc.soehrr.business.application.report.ReportVerParam;
import kd.sihc.soehrr.business.application.report.ReportVerResult;
import org.apache.commons.lang3.tuple.Pair;

public class FillTaskCheckStyleService
extends HRBaseServiceHelper {
    private static final Log LOG = LogFactory.getLog(FillTaskCheckStyleService.class);

    public void recordBorderStyle(SpreadModelParam spreadParam, Long fillTaskId, ReportVerParam reportVerParam, ReportVerResult rptVerResult) {
        LOG.info("FillTaskCheckStyleService.recordBorderStyle rptVerResult={}", (Object)rptVerResult);
        List<Map<String, String>> errors = rptVerResult.getErrors();
        String sheetName = reportVerParam.getSheetName();
        int row = reportVerParam.getRow();
        int col = reportVerParam.getCol();
        JSONObject spreadJsonObject = reportVerParam.getSpreadJsonObject();
        List<BorderStyleRecordDto> hasBorderStyles = this.getByCoordinateInManager(spreadParam, sheetName, row, col);
        Pair spreadJsonData = SpreadJsonHelper.getFromJsonDataTableByName((JSONObject)spreadJsonObject, (String)sheetName);
        JSONObject sheetTable = (JSONObject)spreadJsonData.getLeft();
        JSONArray nameStyles = (JSONArray)spreadJsonData.getRight();
        Map importStylesMap = DataTableManager.nameStyleToStyle((JSONArray)nameStyles);
        for (Map<String, String> error : errors) {
            String errorLevel = error.get(ReportVerResult.ERROR_LEVEL);
            long rptVerRuleId = Long.parseLong(error.get("rptverruleid"));
            DynamicObject borderStyle = this.generateEmptyDynamicObject();
            borderStyle.set("filltaskid", (Object)fillTaskId);
            borderStyle.set("sheetname", (Object)sheetName);
            borderStyle.set("row", (Object)row);
            borderStyle.set("col", (Object)col);
            if (HRCollUtil.isNotEmpty(hasBorderStyles)) {
                boolean isHas = false;
                for (BorderStyleRecordDto hasBorderStyle : hasBorderStyles) {
                    boolean isSameCell;
                    long hasRptVerRuleId = hasBorderStyle.getRptVerRuleId();
                    int hasRow = hasBorderStyle.getRow();
                    int hasCol = hasBorderStyle.getCol();
                    boolean bl = isSameCell = hasRow == row && hasCol == col && hasBorderStyle.getOperate() != OperateEnum.DELETE && hasBorderStyle.getLevel() == Integer.parseInt(errorLevel);
                    if (hasRptVerRuleId != rptVerRuleId || !isSameCell) continue;
                    isHas = true;
                    break;
                }
                if (isHas) continue;
                BorderStyleRecordDto hasBorderStyle = hasBorderStyles.get(0);
                borderStyle.set("bordercolor", (Object)hasBorderStyle.getBorderColor());
                borderStyle.set("borderstyle", (Object)hasBorderStyle.getBorderStyle());
            } else {
                JSONObject rowObj = sheetTable.getJSONObject(String.valueOf(row));
                JSONObject cellObj = rowObj.getJSONObject(String.valueOf(col));
                Object styleObj = cellObj.get((Object)"style");
                this.setBorderStyle(styleObj, importStylesMap, borderStyle);
            }
            borderStyle.set("level", (Object)errorLevel);
            borderStyle.set("rptverruleid", (Object)rptVerRuleId);
            BorderStyleRecordDto styleRecordDto = new BorderStyleRecordDto();
            styleRecordDto.dyConvert2Dto(borderStyle);
            styleRecordDto.setOperate(OperateEnum.ADD);
            spreadParam.getSheetManager().getInvoker().setCacheDto((ReportCacheDto)styleRecordDto);
            spreadParam.getSheetManager().setSheetCache(spreadParam.getView());
        }
    }

    private void setBorderStyle(Object styleObj, Map<String, Object> nameStyles, DynamicObject borderStyle) {
        if (Objects.nonNull(styleObj)) {
            JSONObject style = null;
            if (styleObj instanceof JSONObject) {
                style = (JSONObject)styleObj;
                String parentName = style.getString("parentName");
                if (HRStringUtils.isNotEmpty((String)parentName)) {
                    style = (JSONObject)nameStyles.get(parentName);
                }
            } else if (styleObj instanceof String) {
                String styleStr = (String)styleObj;
                if (HRStringUtils.isEmpty((String)styleStr)) {
                    return;
                }
                style = (JSONObject)nameStyles.get(styleStr);
            }
            if (Objects.nonNull(style)) {
                JSONObject borderLeft = style.getJSONObject("borderLeft");
                JSONObject borderRight = style.getJSONObject("borderRight");
                JSONObject borderTop = style.getJSONObject("borderTop");
                JSONObject borderBottom = style.getJSONObject("borderBottom");
                CharSequence[] borderStyles = DataTableManager.getBorderStyle((JSONObject)borderTop, (JSONObject)borderRight, (JSONObject)borderBottom, (JSONObject)borderLeft);
                CharSequence[] borderColors = DataTableManager.getColorStyle((JSONObject)borderTop, (JSONObject)borderRight, (JSONObject)borderBottom, (JSONObject)borderLeft);
                borderStyle.set("bordercolor", (Object)String.join((CharSequence)",", borderColors));
                borderStyle.set("borderstyle", (Object)String.join((CharSequence)",", borderStyles));
            }
        }
    }

    public void recordBorderStyleByError(SpreadModelParam spreadParam, long fillTaskId, Map<String, String> error, List<Pair<RptAreaConf, List<List<Cell>>>> clearList, List<String> orderSheetNames, JSONObject spreadJsonObject) {
        String cell = error.get("cell");
        String[] cellArr = cell.split(":");
        String errSheetNumber = error.get(ReportVerResult.ERROR_SHEET_NUMBER);
        ReportVerParam reportVerParam = new ReportVerParam(errSheetNumber, Integer.parseInt(cellArr[0]), Integer.parseInt(cellArr[1]), null);
        String errorLevel = error.get(ReportVerResult.ERROR_LEVEL);
        long rptVerRuleId = Long.parseLong(error.get("rptverruleid"));
        int errorRow = reportVerParam.getRow();
        int errorCol = reportVerParam.getCol();
        List<BorderStyleRecordDto> hasBorderStyles = this.getByCoordinateInManager(spreadParam, errSheetNumber, errorRow, errorCol);
        for (BorderStyleRecordDto hasBorderStyle : hasBorderStyles) {
            boolean isSameCell;
            boolean bl = isSameCell = hasBorderStyle.getRow() == errorRow && hasBorderStyle.getCol() == errorCol && hasBorderStyle.getOperate() != OperateEnum.DELETE && hasBorderStyle.getLevel() == Integer.parseInt(errorLevel);
            if (hasBorderStyle.getRptVerRuleId() != rptVerRuleId || !isSameCell) continue;
            return;
        }
        String sheetName = reportVerParam.getSheetName();
        int row = reportVerParam.getRow();
        int col = reportVerParam.getCol();
        BorderStyleRecordDto styleRecordDto = this.genBorderCheckStyle(fillTaskId, sheetName, row, col, error, spreadJsonObject);
        spreadParam.getSheetManager().getInvokerByName(errSheetNumber).setCacheDto((ReportCacheDto)styleRecordDto);
        spreadParam.getSheetManager().setSheetCache(spreadParam.getView());
        boolean isDraw = true;
        for (BorderStyleRecordDto hasBorderStyle : hasBorderStyles) {
            if (Integer.parseInt(errorLevel) <= hasBorderStyle.getLevel() || hasBorderStyle.getOperate() == OperateEnum.DELETE) continue;
            isDraw = false;
            break;
        }
        if (isDraw) {
            int siNo = this.getSiBySheetName(errSheetNumber, orderSheetNames);
            RptAreaConf checkBo = RptAreaConf.getCheckBo((int)Integer.parseInt(errorLevel));
            checkBo.setSi(siNo);
            Pair param = Pair.of((Object)checkBo, Collections.singletonList(Collections.singletonList(new Cell().setRowAndCol(row, col))));
            clearList.add((Pair<RptAreaConf, List<List<Cell>>>)param);
        }
    }

    private BorderStyleRecordDto genBorderCheckStyle(long fillTaskId, String sheetName, int row, int col, Map<String, String> error, JSONObject spreadJsonObject) {
        String errorLevel = error.get(ReportVerResult.ERROR_LEVEL);
        long rptVerRuleId = Long.parseLong(error.get("rptverruleid"));
        DynamicObject borderStyle = this.generateEmptyDynamicObject();
        borderStyle.set("filltaskid", (Object)fillTaskId);
        borderStyle.set("sheetname", (Object)sheetName);
        borderStyle.set("row", (Object)row);
        borderStyle.set("col", (Object)col);
        Pair spreadJsonData = SpreadJsonHelper.getFromJsonDataTableByName((JSONObject)spreadJsonObject, (String)sheetName);
        JSONObject sheetTable = (JSONObject)spreadJsonData.getLeft();
        JSONArray nameStyles = (JSONArray)spreadJsonData.getRight();
        Map importStylesMap = DataTableManager.nameStyleToStyle((JSONArray)nameStyles);
        JSONObject rowObj = sheetTable.getJSONObject(String.valueOf(row));
        JSONObject cellObj = rowObj.getJSONObject(String.valueOf(col));
        Object styleObj = cellObj.get((Object)"style");
        this.setBorderStyle(styleObj, importStylesMap, borderStyle);
        borderStyle.set("level", (Object)errorLevel);
        borderStyle.set("rptverruleid", (Object)rptVerRuleId);
        BorderStyleRecordDto styleRecordDto = new BorderStyleRecordDto();
        styleRecordDto.dyConvert2Dto(borderStyle);
        styleRecordDto.setOperate(OperateEnum.ADD);
        return styleRecordDto;
    }

    public List<BorderStyleRecordDto> getByCoordinateInManager(SpreadModelParam spreadParam, String sheetName, int row, int col) {
        SheetManager sheetManager = spreadParam.getSheetManager();
        CacheObjInvoker invokerByName = sheetManager.getInvokerByName(sheetName);
        List recordDtos = invokerByName.getAllByEntityId("soehrr_filltaskcheckstyle");
        return recordDtos.stream().filter(record -> record.getCol() == col && record.getRow() == row).collect(Collectors.toList());
    }

    public DynamicObject[] queryByFillTaskId(Long fillTaskId) {
        return this.loadDynamicObjectArray(new QFilter("filltaskid", "=", (Object)fillTaskId).toArray());
    }

    public DynamicObject[] queryWarnByFillTaskIds(List<Long> fillTaskIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("filltaskid", "in", fillTaskIds), new QFilter("level", "=", (Object)"1")};
        return this.loadDynamicObjectArray(qFilters);
    }

    public FillTaskCheckStyleService() {
        super("soehrr_filltaskcheckstyle");
    }

    public List<BorderStyleRecordDto> getAllBorderRecordInManager(SpreadModelParam spreadParam) {
        SheetManager sheetManager = spreadParam.getSheetManager();
        List dataTableManagers = sheetManager.getDataTableManagers();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (DataTableManager dataTableManager : dataTableManagers) {
            result.addAll(dataTableManager.getInvoker().getAllEnableByEntityId("soehrr_filltaskcheckstyle"));
        }
        return result;
    }

    public List<BorderStyleRecordDto> isCheckByOtherRule(List<BorderStyleRecordDto> hasBorderStyles, BorderStyleRecordDto bs) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        for (BorderStyleRecordDto hasBorderStyle : hasBorderStyles) {
            if (hasBorderStyle.getOperate() == OperateEnum.DELETE || hasBorderStyle.getRptVerRuleId() == bs.getRptVerRuleId() || !HRStringUtils.equals((String)hasBorderStyle.getSheetName(), (String)bs.getSheetName()) || bs.getRow() != hasBorderStyle.getRow() || bs.getCol() != hasBorderStyle.getCol()) continue;
            result.add(hasBorderStyle);
        }
        return result;
    }

    public void recordBorderStyleAndDrawTip(ReportVerParam reportVerParam, SpreadModelParam spreadParam, long fillTaskId, List<String> orderSheetNames, ReportVerResult reportVerResult, List<Pair<RptAreaConf, List<List<Cell>>>> clearList) {
        int row = reportVerParam.getRow();
        int col = reportVerParam.getCol();
        String activeSheetName = reportVerParam.getSheetName();
        int valid = reportVerResult.isValid();
        List<BorderStyleRecordDto> hasBorderStyles = this.getByCoordinateInManager(spreadParam, activeSheetName, row, col);
        this.recordBorderStyle(spreadParam, fillTaskId, reportVerParam, reportVerResult);
        boolean isDraw = true;
        for (BorderStyleRecordDto hasBorderStyle : hasBorderStyles) {
            if (valid <= hasBorderStyle.getLevel() || hasBorderStyle.getOperate() == OperateEnum.DELETE) continue;
            isDraw = false;
            break;
        }
        if (isDraw) {
            int siNo = this.getSiBySheetName(activeSheetName, orderSheetNames);
            RptAreaConf checkBo = RptAreaConf.getCheckBo((int)valid);
            checkBo.setSi(siNo);
            Pair param = Pair.of((Object)checkBo, Collections.singletonList(Collections.singletonList(new Cell().setRowAndCol(row, col))));
            clearList.add((Pair<RptAreaConf, List<List<Cell>>>)param);
        }
    }

    public void reductionHighlightCell(List<Map<String, Object>> successList, BorderStyleRecordDto bs, List<String> orderSheetNames, List<Pair<RptAreaConf, List<List<Cell>>>> clearList, List<BorderStyleRecordDto> hasBorderStyles) {
        long bsRuleId = bs.getRptVerRuleId();
        int bsRow = bs.getRow();
        int bsCol = bs.getCol();
        String bsSheetName = bs.getSheetName();
        successList.stream().forEach(successData -> {
            long rptVerRuleId = (Long)successData.get("rptverruleid");
            Map relationPoints = (Map)successData.get("relationpoints");
            block0: for (Map.Entry pointEntry : relationPoints.entrySet()) {
                String sheetName = (String)pointEntry.getKey();
                List points = (List)pointEntry.getValue();
                for (String point : points) {
                    String[] splitPoint = point.split(":");
                    int row = Integer.parseInt(splitPoint[0]);
                    int col = Integer.parseInt(splitPoint[1]);
                    if (rptVerRuleId != bsRuleId || !HRStringUtils.equals((String)sheetName, (String)bsSheetName) || bsRow != row || bsCol != col) continue;
                    List<BorderStyleRecordDto> otherRules = this.isCheckByOtherRule(hasBorderStyles, bs);
                    bs.setOperate(OperateEnum.DELETE);
                    int siNo = this.getSiBySheetName(sheetName, orderSheetNames);
                    Cell clearCell = new Cell().setRowAndCol(row, col);
                    if (HRCollUtil.isEmpty(otherRules)) {
                        CellStyle cellStyle = new CellStyle();
                        cellStyle.setBorderStyles(bs.getBorderStyle().split(","));
                        cellStyle.setBorderColors(bs.getBorderColor().split(","));
                        clearCell.setCellStyle(cellStyle);
                        clearList.add(Pair.of((Object)RptAreaConf.reload((int)siNo), Collections.singletonList(Lists.newArrayList((Object[])new Cell[]{clearCell}))));
                        continue block0;
                    }
                    List sameLevels = otherRules.stream().filter(or -> or.getLevel() == bs.getLevel()).collect(Collectors.toList());
                    if (!HRCollUtil.isEmpty(sameLevels)) continue block0;
                    for (BorderStyleRecordDto otherRule : otherRules) {
                        if (otherRule.getLevel() == bs.getLevel()) continue;
                        RptAreaConf checkBo = RptAreaConf.getCheckBo((int)otherRule.getLevel());
                        checkBo.setSi(siNo);
                        clearList.add(Pair.of((Object)checkBo, Collections.singletonList(Lists.newArrayList((Object[])new Cell[]{clearCell}))));
                        continue block0;
                    }
                    continue block0;
                }
            }
        });
    }

    public int getSiBySheetName(String sheetName, List<String> orderSheetNames) {
        for (int index = 0; index < orderSheetNames.size(); ++index) {
            if (!HRStringUtils.equals((String)sheetName, (String)orderSheetNames.get(index))) continue;
            return index;
        }
        return 0;
    }

    public void reloadBorderStyle(List<DynamicObject> warnStyleByFill, JSONObject spreadJsonObject) {
        for (DynamicObject fillTaskStyle : warnStyleByFill) {
            Object styleObj;
            JSONObject colObj;
            JSONObject cols;
            String row = fillTaskStyle.getString("row");
            String col = fillTaskStyle.getString("col");
            String rptTplNumber = fillTaskStyle.getString("sheetname");
            String borderColors = fillTaskStyle.getString("bordercolor");
            String borderStyles = fillTaskStyle.getString("borderstyle");
            JSONObject dataTable = SpreadJsonHelper.getDataTable((JSONObject)spreadJsonObject, (String)rptTplNumber);
            if (Objects.isNull(dataTable) || Objects.isNull(cols = dataTable.getJSONObject(row)) || Objects.isNull(colObj = cols.getJSONObject(col)) || Objects.isNull(styleObj = colObj.get((Object)"style")) || styleObj instanceof String) continue;
            JSONObject style = (JSONObject)styleObj;
            JSONObject borderLeft = style.getJSONObject("borderLeft");
            JSONObject borderRight = style.getJSONObject("borderRight");
            JSONObject borderTop = style.getJSONObject("borderTop");
            JSONObject borderBottom = style.getJSONObject("borderBottom");
            this.setStyleAtt(borderTop, borderColors, borderStyles, 0);
            this.setStyleAtt(borderRight, borderColors, borderStyles, 1);
            this.setStyleAtt(borderBottom, borderColors, borderStyles, 2);
            this.setStyleAtt(borderLeft, borderColors, borderStyles, 3);
        }
    }

    private void setStyleAtt(JSONObject borderStyle, String borderColors, String borderStyles, int index) {
        if (Objects.isNull(borderStyle)) {
            return;
        }
        Object[] colors = borderColors.split(",");
        Object[] borders = borderStyles.split(",");
        Object color = "#00000000";
        int border = BorderTypeEnum.EMPTY.getStyleNo();
        if (HRArrayUtils.isNotEmpty((Object[])colors)) {
            color = colors[index];
        }
        if (HRArrayUtils.isNotEmpty((Object[])borders)) {
            Object borderType = borders[index];
            border = BorderTypeEnum.getBorderTypeByType((String)borderType).getStyleNo();
        }
        borderStyle.put("color", color);
        borderStyle.put("style", (Object)border);
    }
}

