/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.collecttask;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadCommandHelper;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sihc.soehrr.business.queryservice.RptTplQueryService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import org.apache.commons.lang3.StringUtils;

public class FillTaskHelper {
    private static final Log LOG = LogFactory.getLog(FillTaskHelper.class);
    private static RptTplQueryService RPTTPLQUERYSERVICE = ServiceFactory.getService(RptTplQueryService.class);

    public static void initEntrySpreadData(IFormView view, JSONObject jsonObject) {
        FillTaskHelper.setSheetCombo(view, jsonObject);
        List<String> sheetNameList = FillTaskHelper.getOrderSheetNames(view);
        Map<String, String> maps = RPTTPLQUERYSERVICE.queryNameByNumber(sheetNameList);
        SpreadCommandHelper.generateBookManagerByView((IFormView)view, (JSONObject)jsonObject, maps);
    }

    public static String getJson(IFormView view) {
        DynamicObject dy = view.getModel().getDataEntity(true);
        Object customParam = view.getFormShowParameter().getCustomParam("from");
        String json = dy.getString("trepcontent_tag");
        if (!Objects.isNull(customParam) && "trace".equals(customParam)) {
            json = dy.getString("reportcontent_tag");
        }
        return json;
    }

    public static void setEnableStep(IFormView view, JSONObject object) {
        String selectedSheetName = SpreadJsonHelper.getSelectedSheetName((JSONObject)object);
        List orderSheetNames = SpreadJsonHelper.getOrderSheetNames((JSONObject)object);
        if (StringUtils.isEmpty((CharSequence)selectedSheetName) || orderSheetNames.isEmpty()) {
            return;
        }
        if (orderSheetNames.size() == 1) {
            view.setEnable(Boolean.FALSE, new String[]{"filltasknextstep", "filltaskpreviousstep"});
        } else if (selectedSheetName.equals(orderSheetNames.get(0))) {
            view.setEnable(Boolean.FALSE, new String[]{"filltaskpreviousstep"});
        } else if (selectedSheetName.equals(orderSheetNames.get(orderSheetNames.size() - 1))) {
            view.setEnable(Boolean.FALSE, new String[]{"filltasknextstep"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"filltasknextstep", "filltaskpreviousstep"});
        }
    }

    public static void setSheetCombo(IFormView view, JSONObject jsonObject) {
        IDataModel model = view.getModel();
        String selectedSheetName = SpreadJsonHelper.getSelectedSheetName((JSONObject)jsonObject);
        List orderSheetNames = SpreadJsonHelper.getOrderSheetNames((JSONObject)jsonObject);
        if (StringUtils.isEmpty((CharSequence)selectedSheetName) || orderSheetNames.isEmpty()) {
            return;
        }
        model.setValue("sheetcombo", (Object)selectedSheetName);
    }

    public static String getActiveSheetName(IFormView fillTaskView) {
        DynamicObject dy = fillTaskView.getModel().getDataEntity(true);
        LOG.info("log1 current sheet name {} ", (Object)dy.getString("sheetcombo"));
        return dy.getString("sheetcombo");
    }

    public static List<ReportCacheDto> getAreaDataBySheet(SpreadModelParam spreadParam) {
        SheetManager sheetManager = spreadParam.getSheetManager();
        if (null == sheetManager) {
            return Collections.emptyList();
        }
        IFormView fillTaskView = spreadParam.getView();
        String activeSheetName = FillTaskHelper.getActiveSheetName(fillTaskView);
        CacheObjInvoker invokerByName = sheetManager.getInvokerByName(activeSheetName);
        List cacheDtos = invokerByName.getAllEnableByEntityId("soehrr_rpttplarea");
        return cacheDtos;
    }

    public static List<ReportCacheDto> getAreaDataBySheet(SpreadModelParam spreadParam, String activeSheetName) {
        SheetManager sheetManager = spreadParam.getSheetManager();
        if (null == sheetManager) {
            return Collections.emptyList();
        }
        CacheObjInvoker invokerByName = sheetManager.getInvokerByName(activeSheetName);
        List cacheDtos = invokerByName.getAllEnableByEntityId("soehrr_rpttplarea");
        return cacheDtos;
    }

    public static List<String> getOrderSheetNames(IFormView fillTaskView) {
        List orderSheetNames;
        String sheetNameListStr = fillTaskView.getPageCache().get("sheetNameList");
        if (HRStringUtils.isEmpty((String)sheetNameListStr)) {
            String json = FillTaskHelper.getJson(fillTaskView);
            JSONObject spreadJsonObject = SpreadJsonHelper.getSpreadJsonByUncompress((String)json);
            orderSheetNames = SpreadJsonHelper.getOrderSheetNames((JSONObject)spreadJsonObject);
            fillTaskView.getPageCache().put("sheetNameList", SerializationUtils.serializeToBase64((Object)orderSheetNames));
        } else {
            orderSheetNames = (List)SerializationUtils.deSerializeFromBase64((String)sheetNameListStr);
        }
        return orderSheetNames;
    }

    public static List<String> getOrderSheetNames(IDataModel dataModel) {
        DynamicObject dy = dataModel.getDataEntity(true);
        String json = dy.getString("trepcontent_tag");
        JSONObject spreadJsonByUncompress = SpreadJsonHelper.getSpreadJsonByUncompress((String)json);
        return SpreadJsonHelper.getOrderSheetNames((JSONObject)spreadJsonByUncompress);
    }
}

