/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.collecttask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.filltask.BorderStyleRecordDto;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.report.invoker.ReportCacheInvoker;
import kd.sdk.sihc.soehrr.common.spread.DataTableManager;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sihc.soebs.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.business.application.report.CollectTaskApplicationService;
import kd.sihc.soehrr.business.domain.cache.QueryInitCache;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskCheckStyleService;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.domain.rpttplarea.RptTplAreaService;
import kd.sihc.soehrr.business.domain.rpttplvalidatort.RptTplValidatorService;
import kd.sihc.soehrr.business.queryservice.ReportQueryService;
import kd.sihc.soehrr.common.entity.RptInfoByFillTask;
import kd.sihc.soehrr.common.entity.TaskRptFillArea;
import org.apache.commons.lang3.ArrayUtils;

public class FillTaskService
extends HRBaseServiceHelper {
    private static final Log LOG = LogFactory.getLog(FillTaskService.class);
    private final FillTaskCheckStyleService fillTaskCheckStyleService = (FillTaskCheckStyleService)((Object)ServiceFactory.getService(FillTaskCheckStyleService.class));
    private final ReportQueryService reportQueryService = (ReportQueryService)ServiceFactory.getService(ReportQueryService.class);
    private final CollectTaskApplicationService collectTaskAppService = (CollectTaskApplicationService)ServiceFactory.getService(CollectTaskApplicationService.class);
    private final RptTplService rptTplService = RptTplService.getInstance();
    private static final Map<String, QueryInitCache> QUERY_CACHE_HANDLERS = Maps.newHashMapWithExpectedSize((int)16);

    public DynamicObject[] getFillTasks(List<Long> fillTaskIds) {
        return this.loadDynamicObjectArray(new QFilter("id", "in", fillTaskIds).toArray());
    }

    public DynamicObject[] getFillTasks(List<Long> fillTaskIds, String prop) {
        return this.query(prop, new QFilter("id", "in", fillTaskIds).toArray());
    }

    public DynamicObject[] getRepulseRecord(Long fillTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("soehrr_repulserecord");
        return serviceHelper.query("id", new QFilter("taskid", "=", (Object)fillTaskId).toArray());
    }

    public void initCacheData(SpreadModelParam spreadParam) {
        IFormView fillTaskView = spreadParam.getView();
        long taskFillId = (Long)fillTaskView.getModel().getValue("id");
        LOG.info("FillTaskService.initCacheData taskFillId = {},fillTaskName = {}", (Object)taskFillId, fillTaskView.getModel().getValue("name"));
        DynamicObject[] borderStyles = this.fillTaskCheckStyleService.queryByFillTaskId(taskFillId);
        SheetManager sheetManager = spreadParam.getSheetManager();
        sheetManager.clearAllCache();
        for (DynamicObject borderStyle : borderStyles) {
            BorderStyleRecordDto styleRecordDto = new BorderStyleRecordDto();
            styleRecordDto.dyConvert2Dto(borderStyle);
            CacheObjInvoker cacheObjInvoker = sheetManager.getInvokerByName(styleRecordDto.getSheetName());
            cacheObjInvoker.setCacheDto((ReportCacheDto)styleRecordDto);
        }
        for (Map.Entry entry : QUERY_CACHE_HANDLERS.entrySet()) {
            QueryInitCache queryInitCache = (QueryInitCache)entry.getValue();
            List<? extends ReportCacheDto> rptTplCaches = queryInitCache.getRptTplCacheByFillTask(taskFillId);
            for (ReportCacheDto reportCacheDto : rptTplCaches) {
                CacheObjInvoker invokerByName = sheetManager.getInvokerByName(reportCacheDto.getRptTplNumber());
                invokerByName.setCacheDto(reportCacheDto);
            }
        }
        sheetManager.setSheetCache(fillTaskView);
    }

    public void initCacheData4SumReport(SpreadModelParam spreadParam, List<Long> fillTaskIds) {
        IFormView fillTaskView = spreadParam.getView();
        SheetManager sheetManager = spreadParam.getSheetManager();
        sheetManager.clearAllCache();
        for (Map.Entry<String, QueryInitCache> initCacheEntry : QUERY_CACHE_HANDLERS.entrySet()) {
            QueryInitCache queryInitCache = initCacheEntry.getValue();
            ArrayList rptTplCachesList = Lists.newArrayListWithCapacity((int)fillTaskIds.size());
            for (Long fillTaskId : fillTaskIds) {
                List<? extends ReportCacheDto> rptTplCaches = queryInitCache.getRptTplCacheByFillTask(fillTaskId);
                rptTplCachesList.addAll(rptTplCaches);
            }
            for (ReportCacheDto rptTplCache : rptTplCachesList) {
                CacheObjInvoker invokerByName = sheetManager.getInvokerByName(rptTplCache.getRptTplNumber());
                invokerByName.setCacheDto(rptTplCache);
            }
        }
        sheetManager.setSheetCache(fillTaskView);
    }

    public void saveDependencyData(SpreadModelParam spreadParam) {
        List dataTableManagers = spreadParam.getSheetManager().getDataTableManagers();
        for (DataTableManager dataTableManager : dataTableManagers) {
            dataTableManager.getInvoker().delete();
            dataTableManager.getInvoker().add();
        }
    }

    public Map<Long, List<RptInfoByFillTask>> queryRptCurJsonByTask(List<Long> taskIds) {
        DynamicObject[] reports = this.reportQueryService.queryReportByFillTasks(taskIds);
        HashSet rptTplIds = Sets.newHashSetWithExpectedSize((int)reports.length);
        HashSet rptTplEntryIds = Sets.newHashSetWithExpectedSize((int)reports.length);
        HashMap taskMapRptTpl = Maps.newHashMapWithExpectedSize((int)reports.length);
        HashMap entryMapRptId = Maps.newHashMapWithExpectedSize((int)reports.length);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList taskRptFillAreas = Lists.newArrayListWithExpectedSize((int)reports.length);
        for (DynamicObject report : reports) {
            long rptTplId = report.getDynamicObject("rpttpl").getLong("id");
            rptTplIds.add(rptTplId);
            long rptEntryId = report.getLong("repentryid");
            entryMapRptId.put(rptTplId, rptEntryId);
            rptTplEntryIds.add(rptEntryId);
            long fillTaskId = report.getLong("filltask");
            Set taskRptIds = (Set)taskMapRptTpl.get(fillTaskId);
            if (Objects.isNull(taskRptIds)) {
                taskRptIds = Sets.newHashSetWithExpectedSize((int)16);
                taskRptIds.add(rptTplId);
                taskMapRptTpl.put(fillTaskId, taskRptIds);
            } else {
                taskRptIds.add(rptTplId);
            }
            TaskRptFillArea taskRptFillArea = new TaskRptFillArea(fillTaskId, rptTplId, report.getString("fillarea"));
            taskRptFillAreas.add(taskRptFillArea);
        }
        DynamicObject[] rptTpls = this.rptTplService.queryNowEntryEntityByIds(null, rptTplIds);
        Map<Long, DynamicObject> rptTplMaps = Arrays.stream(rptTpls).collect(Collectors.toMap(rpt -> rpt.getLong("id"), rpt -> rpt, (key, val) -> val));
        List<AreaSettingDto> areaSettingDtos = RptTplAreaService.ins().loadByRptTplEntryIds(rptTplEntryIds, Lists.newArrayList((Object[])new AreaSettingEnum[]{AreaSettingEnum.CAL, AreaSettingEnum.LOCK, AreaSettingEnum.DYNAMIC_SUMMARY, AreaSettingEnum.FILL, AreaSettingEnum.TOTAL_SUMMARY}));
        Map<Long, List<AreaSettingDto>> rptEntryIdMapArea = areaSettingDtos.stream().collect(Collectors.groupingBy(dto -> dto.getRepEntryId()));
        for (Map.Entry taskEntryRpt : taskMapRptTpl.entrySet()) {
            Long fillTaskId = (Long)taskEntryRpt.getKey();
            ArrayList rptInfoByFillTasks = Lists.newArrayListWithExpectedSize((int)10);
            result.put(fillTaskId, rptInfoByFillTasks);
            Set rtIdsOfTask = (Set)taskEntryRpt.getValue();
            for (Long rptTplId : rtIdsOfTask) {
                DynamicObject rptTpl = rptTplMaps.get(rptTplId);
                long rptTplPkValue = (Long)rptTpl.getPkValue();
                Long rptEntryId = (Long)entryMapRptId.get(rptTplPkValue);
                List<AreaSettingDto> entryAreas = rptEntryIdMapArea.get(rptEntryId);
                ReportCacheInvoker cacheInvoker = new ReportCacheInvoker();
                if (HRCollUtil.isNotEmpty(entryAreas)) {
                    cacheInvoker.setCacheDtoList(entryAreas);
                }
                List<AreaSettingDto> totalSummaries = RepCacheService.ins().getExistAreaByType((CacheObjInvoker)cacheInvoker, AreaSettingEnum.TOTAL_SUMMARY);
                AreaSettingDto fillOrTotalArea = RepCacheService.ins().getFillOrTotalArea((CacheObjInvoker)cacheInvoker);
                DynamicObject rptEntry = this.rptTplService.getEntryById(rptTpl, rptEntryId);
                if (null == rptEntry) {
                    LOG.info("FillTaskService.queryRptCurJsonByTask rptTpl={} entry is null", (Object)rptTplPkValue);
                    continue;
                }
                RptInfoByFillTask rptTaskInfo = new RptInfoByFillTask();
                rptTaskInfo.setCollectType(rptTpl.getString("collecttype"));
                rptTaskInfo.setRptType(rptTpl.getString("rpttype"));
                rptTaskInfo.setSpreadJson(rptEntry.getString("json_tag"));
                if (HRCollUtil.isNotEmpty(totalSummaries)) {
                    AreaSettingDto totalSummary = totalSummaries.get(0);
                    int direct = RptTplAreaService.ins().totalSummaryDirect((CacheObjInvoker)cacheInvoker, totalSummary.convert2Selector());
                    rptTaskInfo.setDirect(direct);
                    rptTaskInfo.setTotalSummaryArea(totalSummary);
                }
                rptTaskInfo.setRptTplNumber(rptTpl.getString("number"));
                rptTaskInfo.setRptTplId(rptTplPkValue);
                rptTaskInfo.setFillTaskId(fillTaskId.longValue());
                List<AreaSettingDto> cals = RptTplAreaService.ins().getAreaByEntryAndType(cacheInvoker, rptTplPkValue, rptEntryId, AreaSettingEnum.CAL);
                List<AreaSettingDto> locks = RptTplAreaService.ins().getAreaByEntryAndType(cacheInvoker, rptTplPkValue, rptEntryId, AreaSettingEnum.LOCK);
                rptTaskInfo.setCalAreas(cals);
                rptTaskInfo.setLockAreas(locks);
                taskRptFillAreas.stream().forEach(data -> {
                    if (data.getFillTaskId() == fillTaskId.longValue() && data.getRptTplId() == rptTplPkValue) {
                        rptTaskInfo.setFillArea(data.getFillArea());
                    }
                });
                if (Objects.nonNull(fillOrTotalArea)) {
                    rptTaskInfo.setRptTplFillArea(fillOrTotalArea.getAreaPoint());
                }
                rptInfoByFillTasks.add(rptTaskInfo);
            }
        }
        return result;
    }

    public void deleteHatchsolution(List<Object> taskIds) {
        DynamicObject fillTask = this.queryOne("id,hatchsolution", new QFilter("hatchsolution", "in", taskIds).toArray());
        if (!HRObjectUtils.isEmpty((Object)fillTask)) {
            fillTask.set("hatchsolution", null);
            this.updateOne(fillTask);
        }
    }

    public DynamicObject getFillTaskByHatchSolution(Long collectId) {
        return this.queryOne(new QFilter("hatchsolution", "=", (Object)collectId));
    }

    public Object[] updateFillTask(DynamicObject[] objects) {
        if (ArrayUtils.isEmpty((Object[])objects)) {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        return this.update(objects);
    }

    @Deprecated
    public boolean checkPerm(DynamicObject fillTask) {
        List hasPermOrgs;
        DynamicObject org = fillTask.getDynamicObject("org");
        DynamicObject exeUnit = fillTask.getDynamicObject("exeunit");
        AuthorizedOrgResult userAdminOrgs = this.collectTaskAppService.getUserAdminOrgs("soehrr_filltask", "exeunit");
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId(), (boolean)true);
        if (!HRObjectUtils.isEmpty((Object)userAdminOrgs)) {
            if (userAdminOrgs.isHasAllOrgPerm()) {
                return true;
            }
            hasPermOrgs = userAdminOrgs.getHasPermOrgs();
            if (!hasPermOrgs.contains(exeUnit.getLong("id"))) {
                return false;
            }
        }
        if (!HRObjectUtils.isEmpty((Object)userHasPermOrgs)) {
            if (userHasPermOrgs.hasAllOrgPerm()) {
                return true;
            }
            hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
            if (!hasPermOrgs.contains(org.getLong("id"))) {
                return false;
            }
        }
        return true;
    }

    public static FillTaskService ins() {
        return Instance.INSTANCE;
    }

    public FillTaskService() {
        super("soehrr_filltask");
    }

    static {
        QUERY_CACHE_HANDLERS.put(RptTplValidatorService.getInstance().getEntityName(), RptTplValidatorService.getInstance());
        QUERY_CACHE_HANDLERS.put(RptTplAreaService.ins().getEntityName(), RptTplAreaService.ins());
    }

    private static class Instance {
        private static final FillTaskService INSTANCE = new FillTaskService();

        private Instance() {
        }
    }
}

