/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.collecttask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.sihc.soehrr.business.spread.command.DeleteRowCommand;
import kd.sdk.sihc.soehrr.business.spread.command.InsertRowCommand;
import kd.sdk.sihc.soehrr.common.enums.AskExecuteEnum;
import kd.sdk.sihc.soehrr.common.report.CallBackFunction;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskHelper;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplToolBarAskExecutor;
import kd.sihc.soehrr.common.spread.SpreadCBackParam;
import org.apache.commons.lang3.tuple.Pair;

public class RowOperateAskExecutor {
    private static final Log LOG = LogFactory.getLog(RptTplToolBarAskExecutor.class);
    private static final Map<String, CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin>> EXECUTOR_SERVICE = Maps.newHashMapWithExpectedSize((int)16);

    private RowOperateAskExecutor() {
    }

    private static void deleteRow(SpreadCBackParam spreadCBackParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        ArrayList selectIndexList = (ArrayList)spreadCBackParam.getSpreadParam();
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        String activeSheetName = FillTaskHelper.getActiveSheetName(spreadModelParam.getView());
        CacheObjInvoker invokerByName = sheetManager.getInvokerByName(activeSheetName);
        AreaSettingDto fillOrTotalArea = RepCacheService.ins().getFillOrTotalArea(invokerByName);
        if (Objects.isNull(fillOrTotalArea)) {
            return;
        }
        SpreadSelector spreadSelector = fillOrTotalArea.convert2Selector();
        int startRow = spreadSelector.getStartRow();
        int endRow = spreadSelector.getEndRow();
        int spanRow = spreadSelector.getSpanRow();
        ArrayList fillIndexList = Lists.newArrayListWithCapacity((int)spanRow);
        for (int i = startRow; i < startRow + spanRow; ++i) {
            fillIndexList.add(i);
        }
        if (!fillIndexList.containsAll(selectIndexList)) {
            spreadModelParam.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u586b\u62a5\u533a\u5141\u8bb8\u5220\u884c\u3002", (String)"RowOperateAskExecutor_2", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        if (spanRow <= 1 || selectIndexList.size() == spanRow) {
            spreadModelParam.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u5c11\u4fdd\u7559\u4e00\u884c\u586b\u62a5\u533a\u3002", (String)"RowOperateAskExecutor_0", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        int newSpanRow = spanRow - selectIndexList.size();
        int newEndRow = endRow - selectIndexList.size();
        spreadSelector.setSpanRow(newSpanRow);
        spreadSelector.setEndRow(newEndRow);
        fillOrTotalArea.setAreaPoint(spreadSelector.getAreaPoint());
        sheetManager.setSheetCache(spreadModelParam.getView());
        DeleteRowCommand deleteRowCommand = new DeleteRowCommand(selectIndexList.toArray(new Integer[0]));
        deleteRowCommand.invokeMethod(spreadModelParam);
    }

    private static void insertRow(SpreadCBackParam spreadCBackParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        String activeSheetName = FillTaskHelper.getActiveSheetName(spreadModelParam.getView());
        CacheObjInvoker invokerByName = sheetManager.getInvokerByName(activeSheetName);
        AreaSettingDto fillOrTotalArea = RepCacheService.ins().getFillOrTotalArea(invokerByName);
        if (Objects.isNull(fillOrTotalArea)) {
            return;
        }
        SpreadSelector spreadSelector = fillOrTotalArea.convert2Selector();
        int startRow = spreadSelector.getStartRow();
        int spanRow = spreadSelector.getSpanRow();
        int endRow = spreadSelector.getEndRow();
        Integer[] selectRows = spreadModelParam.getSelector().getSelectionsRows();
        Integer row = selectRows[0];
        if (row < startRow || row > endRow) {
            spreadModelParam.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u586b\u62a5\u533a\u5141\u8bb8\u589e\u884c\u3002", (String)"RowOperateAskExecutor_1", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap invokeParamsData = (LinkedHashMap)spreadCBackParam.getSpreadParam();
        int count = Integer.parseInt(String.valueOf(invokeParamsData.get("count")));
        int newSpanRow = spanRow + count;
        spreadSelector.setSpanRow(newSpanRow);
        fillOrTotalArea.setAreaPoint(spreadSelector.getAreaPoint());
        sheetManager.setSheetCache(spreadModelParam.getView());
        InsertRowCommand insertRowCommand = new InsertRowCommand(Pair.of((Object)count, (Object)selectRows));
        insertRowCommand.invokeMethod(spreadModelParam);
    }

    public void invokeMethod(SpreadCBackParam spreadCBackParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        String methodName = spreadCBackParam.getMethodName();
        CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin> function = EXECUTOR_SERVICE.get(methodName);
        if (Objects.isNull(function)) {
            return;
        }
        function.accept((Object)spreadCBackParam, (Object)spreadModelParam, (Object)plugin);
    }

    public static RowOperateAskExecutor ins() {
        return Instance.INSTANCE;
    }

    static {
        EXECUTOR_SERVICE.put(AskExecuteEnum.INSERT_ROW.getM(), (CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin>)((CallBackFunction)RowOperateAskExecutor::insertRow));
        EXECUTOR_SERVICE.put(AskExecuteEnum.DELETE_ROW.getM(), (CallBackFunction<SpreadCBackParam, SpreadModelParam, IFormPlugin>)((CallBackFunction)RowOperateAskExecutor::deleteRow));
    }

    private static class Instance {
        private static final RowOperateAskExecutor INSTANCE = new RowOperateAskExecutor();

        private Instance() {
        }
    }
}

