/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.collecttask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.areaconf.RptAreaConfService;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CollectTypeEnum;
import kd.sdk.sihc.soehrr.common.enums.ExcelFormulaEnum;
import kd.sdk.sihc.soehrr.common.enums.RptTypeEnum;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.spread.RptAreaConf;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;
import kd.sihc.soebs.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.business.application.report.FillTaskApplicationService;
import kd.sihc.soehrr.business.domain.collecttask.AnnotationHelper;
import kd.sihc.soehrr.business.domain.collecttask.CollectTaskService;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskCheckStyleService;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskService;
import kd.sihc.soehrr.common.entity.RptInfoByFillTask;

public class SumReportHelper {
    private static final Log LOG = LogFactory.getLog(SumReportHelper.class);
    private static final FillTaskCheckStyleService fillTaskCheckStyleService = (FillTaskCheckStyleService)((Object)ServiceFactory.getService(FillTaskCheckStyleService.class));

    public static Map<String, String> sumReport(List<Long> fillTaskIds, Long collectTaskId) {
        if (Objects.isNull(fillTaskIds) || fillTaskIds.size() == 0) {
            return null;
        }
        DynamicObject[] fillTaskDyns = FillTaskService.ins().getFillTasks(fillTaskIds);
        Map<Long, List<RptInfoByFillTask>> rptInfos = FillTaskService.ins().queryRptCurJsonByTask(fillTaskIds);
        HashMap rptNumberMap = new HashMap(16);
        HashMap detailFillAreaMap = new HashMap(16);
        rptInfos.forEach((key, value) -> {
            for (RptInfoByFillTask info : value) {
                String fillAreaStr;
                rptNumberMap.put(info.getRptTplNumber(), info);
                if (!RptTypeEnum.DETAIL.getType().equals(info.getRptType()) || !HRStringUtils.isNotEmpty((String)(fillAreaStr = info.getFillArea()))) continue;
                detailFillAreaMap.computeIfAbsent(info.getRptTplNumber(), k -> new HashMap(fillTaskIds.size())).put(info.getFillTaskId(), fillAreaStr);
            }
        });
        LOG.info("SumReportHelper.sumReport rptNumberMap = {},detailFillAreaMap = {}", rptNumberMap, detailFillAreaMap);
        JSONObject pendObject = null;
        HashMap<String, Object> recordJSons = new HashMap<String, Object>(16);
        LinkedHashMap pendSumSheet = new LinkedHashMap(16);
        DynamicObject[] fillTaskWarnStyles = fillTaskCheckStyleService.queryWarnByFillTaskIds(fillTaskIds);
        Map<Long, List<DynamicObject>> fillTaskWarnStyleMap = Arrays.stream(fillTaskWarnStyles).collect(Collectors.groupingBy(fts -> fts.getLong("filltaskid")));
        for (DynamicObject fillTaskDyn : fillTaskDyns) {
            String spreadJson = fillTaskDyn.getString("trepcontent_tag");
            String uncompressJson = GzipTools.uncompressJson((String)spreadJson);
            JSONObject object = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
            List<DynamicObject> warnStyleByFill = fillTaskWarnStyleMap.get(fillTaskDyn.getLong("id"));
            if (HRCollUtil.isNotEmpty(warnStyleByFill)) {
                fillTaskCheckStyleService.reloadBorderStyle(warnStyleByFill, object);
            }
            if (Objects.isNull(pendObject)) {
                pendObject = object;
            } else {
                JSONArray tarNameStyles = object.getJSONArray("namedStyles");
                FillTaskApplicationService.mergeNameStylesToSrc(pendObject, tarNameStyles);
            }
            JSONObject sheets = (JSONObject)object.get((Object)"sheets");
            sheets.forEach((sheetKey, sheetValue) -> pendSumSheet.computeIfAbsent(sheetKey, k -> new ArrayList(16)).add(MapInitHelper.ofMap((Object)"sheet", (Object)sheetValue, (Object)"org", (Object)fillTaskDyn.getDynamicObject("exeunit"), (Object)"taskId", (Object)fillTaskDyn.getLong("id"))));
        }
        LOG.info("SumReportHelper.sumReport pendSumSheet = {}", pendSumSheet);
        JSONObject finalPendObject = pendObject;
        finalPendObject.put("sheetCount", (Object)pendSumSheet.size());
        finalPendObject.put("activeSheetIndex", (Object)0);
        AtomicInteger sheetIndex = new AtomicInteger(0);
        List<String> rptTplNumbers = CollectTaskService.ins().getCollectRpttplNumbers(collectTaskId);
        for (String key2 : rptTplNumbers) {
            List value2 = (List)pendSumSheet.get(key2);
            if (Objects.isNull(value2)) continue;
            String collecttype = ((RptInfoByFillTask)rptNumberMap.get(key2)).getCollectType();
            String rpttype = ((RptInfoByFillTask)rptNumberMap.get(key2)).getRptType();
            Map<Object, Object> handleResult = new HashMap(2);
            if (RptTypeEnum.STATISTICS.getType().equals(rpttype) && CollectTypeEnum.SUM.getType().equals(collecttype)) {
                handleResult = SumReportHelper.handleTotalSum(value2, (RptInfoByFillTask)rptNumberMap.get(key2));
            } else if (RptTypeEnum.STATISTICS.getType().equals(rpttype) && CollectTypeEnum.LIST.getType().equals(collecttype)) {
                handleResult = SumReportHelper.handleListSum(value2, (RptInfoByFillTask)rptNumberMap.get(key2));
            } else if (RptTypeEnum.DETAIL.getType().equals(rpttype)) {
                handleResult = SumReportHelper.handleDetailSum(value2, (RptInfoByFillTask)rptNumberMap.get(key2), (Map)detailFillAreaMap.get(key2));
            }
            JSONObject pendSheet = (JSONObject)handleResult.get("sheetJson");
            pendSheet.put("index", (Object)sheetIndex.get());
            pendSheet.put("isSelected", (Object)(sheetIndex.get() == 0 ? 1 : 0));
            finalPendObject.getJSONObject("sheets").put(key2, (Object)pendSheet);
            sheetIndex.set(sheetIndex.get() + 1);
            recordJSons.put(key2, handleResult.get("recordJson"));
        }
        LOG.info("SumReportHelper.sumReport finalPendObject = {},recordJSons={}", (Object)finalPendObject, recordJSons);
        AnnotationHelper.deleteMark(AnnotationHelper.deleteComment(finalPendObject));
        String newSpreadJsonStr = GzipTools.compressJson((String)finalPendObject.toJSONString());
        return MapInitHelper.ofMap((Object)"sheetJson", (Object)newSpreadJsonStr, (Object)"recordJson", (Object)JSON.toJSONString(recordJSons));
    }

    private static Map<String, JSONObject> handleTotalSum(List<Map<String, Object>> datas, RptInfoByFillTask rptInfoByFillTask) {
        ArrayList<Map> orgList = new ArrayList<Map>(datas.size());
        HashMap<String, List> cellSumDetail = new HashMap<String, List>(16);
        String fillAreaStr = rptInfoByFillTask.getFillArea();
        String uncompressJson = GzipTools.uncompressJson((String)rptInfoByFillTask.getSpreadJson());
        JSONObject object = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        JSONObject pendSheet = sheets.getJSONObject(rptInfoByFillTask.getRptTplNumber());
        if (HRStringUtils.isEmpty((String)fillAreaStr)) {
            HashMap<String, Object> sourceJson = new HashMap<String, Object>(16);
            sourceJson.put("collecttype", rptInfoByFillTask.getCollectType());
            sourceJson.put("rpttype", rptInfoByFillTask.getRptType());
            sourceJson.put("orgs", orgList);
            sourceJson.put("cellSumDetail", cellSumDetail);
            sourceJson.put("fillArea", rptInfoByFillTask.getFillArea());
            return MapInitHelper.ofMap((Object)"sheetJson", (Object)pendSheet, (Object)"recordJson", (Object)((JSONObject)JSONObject.toJSON(sourceJson)));
        }
        SpreadSelector fillArea = new SpreadSelector(rptInfoByFillTask.getFillArea());
        for (Map<String, Object> data : datas) {
            JSONObject sheetJson = (JSONObject)data.get("sheet");
            DynamicObject org = (DynamicObject)data.get("org");
            orgList.add(MapInitHelper.ofMap((Object)"orgId", (Object)org.getString("id"), (Object)"orgName", (Object)org.getString("name"), (Object)"sortcode", (Object)org.getString("sortcode")));
            JSONObject dataTable = sheetJson.getJSONObject("data").getJSONObject("dataTable");
            dataTable.forEach((key, value) -> {
                if (Integer.parseInt(key) >= fillArea.getStartRow() && Integer.parseInt(key) <= fillArea.getEndRow()) {
                    ((JSONObject)value).forEach((ikey, ivalue) -> {
                        if (Integer.parseInt(ikey) >= fillArea.getStartCol() && Integer.parseInt(ikey) <= fillArea.getEndCol()) {
                            Object cellValue = ((JSONObject)ivalue).get((Object)"value");
                            String cellValueStr = ((JSONObject)ivalue).getString("value");
                            if (Objects.nonNull(cellValue) && HRStringUtils.isNotEmpty((String)cellValueStr)) {
                                String cellAddrKey = key + ":" + ikey;
                                cellSumDetail.computeIfAbsent(cellAddrKey, k -> new ArrayList(16)).add(MapInitHelper.ofMap((Object)"v", (Object)cellValue, (Object)"orgId", (Object)org.getString("id")));
                            }
                        }
                    });
                }
            });
        }
        JSONObject pendDataTable = pendSheet.getJSONObject("data").getJSONObject("dataTable");
        List<String> unSumAreaStrArr = SumReportHelper.getNoSumCell(rptInfoByFillTask);
        cellSumDetail.forEach((key, value) -> {
            String[] keys = key.split(":");
            if (!unSumAreaStrArr.contains(key)) {
                BigDecimal accBigDecimal = new BigDecimal(0);
                for (Map valItem : value) {
                    Object numItem = valItem.get("v");
                    if (!SumReportHelper.isValidDouble(numItem)) continue;
                    accBigDecimal = accBigDecimal.add(new BigDecimal(String.valueOf(numItem)));
                }
                pendDataTable.getJSONObject(keys[0]).getJSONObject(keys[1]).put("value", (Object)accBigDecimal);
            }
        });
        HashMap<String, Object> sourceJson = new HashMap<String, Object>(16);
        sourceJson.put("collecttype", rptInfoByFillTask.getCollectType());
        sourceJson.put("rpttype", rptInfoByFillTask.getRptType());
        sourceJson.put("orgs", orgList);
        sourceJson.put("cellSumDetail", cellSumDetail);
        sourceJson.put("fillArea", rptInfoByFillTask.getFillArea());
        return MapInitHelper.ofMap((Object)"sheetJson", (Object)pendSheet, (Object)"recordJson", (Object)((JSONObject)JSONObject.toJSON(sourceJson)));
    }

    private static Map<String, JSONObject> handleListSum(List<Map<String, Object>> datas, RptInfoByFillTask rptInfoByFillTask) {
        JSONObject totalIns;
        datas.sort((map1, map2) -> {
            String orderNum1 = ((DynamicObject)map1.get("org")).getString("sortcode");
            String orderNum2 = ((DynamicObject)map2.get("org")).getString("sortcode");
            return orderNum1.compareTo(orderNum2);
        });
        String uncompressJson = GzipTools.uncompressJson((String)rptInfoByFillTask.getSpreadJson());
        JSONObject object = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        JSONObject pendSheet = sheets.getJSONObject(rptInfoByFillTask.getRptTplNumber());
        if (HRStringUtils.isEmpty((String)rptInfoByFillTask.getFillArea())) {
            return MapInitHelper.ofMap((Object)"sheetJson", (Object)pendSheet);
        }
        boolean isHasSumArea = Objects.nonNull(rptInfoByFillTask.getTotalSummaryArea());
        int direct = rptInfoByFillTask.getDirect();
        CharSequence[] fillAreaArray = rptInfoByFillTask.getFillArea().split(":");
        if (isHasSumArea && direct == 0) {
            fillAreaArray[2] = String.valueOf(Integer.parseInt(fillAreaArray[2]) - 1);
        } else if (isHasSumArea && direct == 1) {
            fillAreaArray[0] = String.valueOf(Integer.parseInt((String)fillAreaArray[0]) + 1);
            fillAreaArray[2] = String.valueOf(Integer.parseInt((String)fillAreaArray[2]) - 1);
        }
        SpreadSelector realFillArea = new SpreadSelector(String.join((CharSequence)":", fillAreaArray));
        int fillRows = realFillArea.getSpanRow();
        int insertRowStart = realFillArea.getEndRow() + 1;
        SumReportHelper.insertRows(pendSheet, insertRowStart, fillRows * (datas.size() - 1));
        LOG.info("SumReportHelper.handleListSum sheetJson = {}", (Object)pendSheet);
        JSONObject pendDataTable = pendSheet.getJSONObject("data").getJSONObject("dataTable");
        JSONArray pendRows = Objects.isNull(pendSheet.getJSONArray("rows")) ? new JSONArray() : pendSheet.getJSONArray("rows");
        JSONArray pendSpans = Objects.isNull(pendSheet.getJSONArray("spans")) ? new JSONArray() : pendSheet.getJSONArray("spans");
        SpreadSelector totalSummaryArea = isHasSumArea ? new SpreadSelector(rptInfoByFillTask.getTotalSummaryArea().getAreaPoint()) : null;
        JSONObject jSONObject = totalIns = isHasSumArea ? JSONObject.parseObject((String)pendDataTable.getJSONObject(String.valueOf(totalSummaryArea.getStartRow())).toJSONString()) : null;
        JSONObject sumRowH = isHasSumArea ? (pendRows.size() > totalSummaryArea.getStartRow() ? pendRows.getJSONObject(totalSummaryArea.getStartRow()) : null) : null;
        int startFIdxAftSum = realFillArea.getStartRow();
        Map rptAreaConf = RptAreaConfService.ins().initRptAreaConf();
        RptAreaConf areaConf = (RptAreaConf)rptAreaConf.get(AreaSettingEnum.DYNAMIC_SUMMARY);
        int len = datas.size();
        for (int index = 0; index < len; ++index) {
            Map<String, Object> data = datas.get(index);
            JSONObject sheetJson = (JSONObject)data.get("sheet");
            JSONObject dataTable = sheetJson.getJSONObject("data").getJSONObject("dataTable");
            JSONArray rows = sheetJson.getJSONArray("rows");
            JSONArray spans = sheetJson.getJSONArray("spans");
            SumReportHelper.handleSpans(pendSpans, spans, fillRows * index, realFillArea);
            for (int sumIndex = 0; sumIndex < fillRows; ++sumIndex) {
                int fromInsertRow = startFIdxAftSum + sumIndex;
                JSONObject fromInsertRowObj = dataTable.getJSONObject(String.valueOf(fromInsertRow));
                int toInsertIndex = startFIdxAftSum + fillRows * index + sumIndex;
                pendDataTable.put(String.valueOf(toInsertIndex), (Object)SumReportHelper.deleteFormula(fromInsertRowObj, areaConf));
                if (!Objects.nonNull(rows) || fromInsertRow >= rows.size() || !Objects.nonNull(rows.get(fromInsertRow))) continue;
                pendRows.set(toInsertIndex, rows.get(fromInsertRow));
            }
        }
        if (isHasSumArea) {
            int endFIdxAftSum = startFIdxAftSum + fillRows * datas.size();
            int sumRIndexAftSum = direct == 0 ? endFIdxAftSum : totalSummaryArea.getStartRow();
            SumReportHelper.handleListSumRow(totalSummaryArea, startFIdxAftSum, endFIdxAftSum, sumRIndexAftSum, pendDataTable);
        }
        pendSheet.put("rows", (Object)pendRows);
        pendSheet.put("spans", (Object)pendSpans);
        return MapInitHelper.ofMap((Object)"sheetJson", (Object)pendSheet);
    }

    private static Map<String, JSONObject> handleDetailSum(List<Map<String, Object>> datas, RptInfoByFillTask rptInfoByFillTask, Map<Long, String> fillAreas) {
        datas.sort((map1, map2) -> {
            String orderNum1 = ((DynamicObject)map1.get("org")).getString("sortcode");
            String orderNum2 = ((DynamicObject)map2.get("org")).getString("sortcode");
            return orderNum1.compareTo(orderNum2);
        });
        String rptTplFillArea = rptInfoByFillTask.getRptTplFillArea();
        String uncompressJson = GzipTools.uncompressJson((String)rptInfoByFillTask.getSpreadJson());
        JSONObject object = JSONObject.parseObject((String)uncompressJson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        JSONObject pendSheet = sheets.getJSONObject(rptInfoByFillTask.getRptTplNumber());
        if (HRStringUtils.isEmpty((String)rptTplFillArea)) {
            return MapInitHelper.ofMap((Object)"sheetJson", (Object)pendSheet, (Object)"recordJson", (Object)((JSONObject)JSONObject.toJSON((Object)MapInitHelper.ofMap((Object)"fillArea", (Object)""))));
        }
        SpreadSelector fillArea = new SpreadSelector(rptTplFillArea);
        int allSumNum = 0;
        for (String fillTaskArea : fillAreas.values()) {
            if (!HRStringUtils.isNotEmpty((String)fillTaskArea)) continue;
            allSumNum += new SpreadSelector(fillTaskArea).getSpanRow();
        }
        int updateRows = allSumNum - fillArea.getSpanRow();
        if (updateRows >= 0) {
            SumReportHelper.insertRows(pendSheet, fillArea.getEndRow() + 1, updateRows);
        } else {
            SumReportHelper.deleteRows(pendSheet, fillArea.getEndRow() + 1, -updateRows);
        }
        LOG.info("SumReportHelper.handleDetailSum updateRows={}, sheetJson = {}", (Object)updateRows, (Object)pendSheet);
        JSONObject pendDataTable = pendSheet.getJSONObject("data").getJSONObject("dataTable");
        JSONArray pendValidations = new JSONArray();
        JSONArray pendRows = Objects.isNull(pendSheet.getJSONArray("rows")) ? new JSONArray() : pendSheet.getJSONArray("rows");
        JSONArray pendSpans = Objects.isNull(pendSheet.getJSONArray("spans")) ? new JSONArray() : pendSheet.getJSONArray("spans");
        int allSumIndex = 0;
        Map rptAreaConf = RptAreaConfService.ins().initRptAreaConf();
        RptAreaConf areaConf = (RptAreaConf)rptAreaConf.get(AreaSettingEnum.DYNAMIC_SUMMARY);
        for (Map<String, Object> data : datas) {
            JSONObject sheetJson = (JSONObject)data.get("sheet");
            Long fillTaskId = (Long)data.get("taskId");
            JSONObject dataTable = sheetJson.getJSONObject("data").getJSONObject("dataTable");
            JSONArray rows = sheetJson.getJSONArray("rows");
            if (Objects.nonNull(sheetJson.getJSONArray("validations"))) {
                JSONArray validations = sheetJson.getJSONArray("validations");
                SumReportHelper.handleValidations(validations, allSumIndex);
                pendValidations.addAll((Collection)validations);
            }
            SpreadSelector fillTaskArea = new SpreadSelector(fillAreas.get(fillTaskId));
            JSONArray spans = sheetJson.getJSONArray("spans");
            SumReportHelper.handleSpans(pendSpans, spans, allSumIndex, fillTaskArea);
            int sumIndex = 0;
            while (sumIndex < fillTaskArea.getSpanRow()) {
                int fromInsertRow = fillTaskArea.getStartRow() + sumIndex;
                JSONObject fromInsertRowObj = dataTable.getJSONObject(String.valueOf(fromInsertRow));
                int toInsertIndex = fillArea.getStartRow() + allSumIndex;
                pendDataTable.put(String.valueOf(toInsertIndex), (Object)SumReportHelper.deleteFormula(fromInsertRowObj, areaConf));
                if (Objects.nonNull(rows) && fromInsertRow < rows.size() && Objects.nonNull(rows.get(fromInsertRow))) {
                    pendRows.set(toInsertIndex, rows.get(fromInsertRow));
                }
                ++sumIndex;
                ++allSumIndex;
            }
        }
        pendSheet.put("validations", (Object)pendValidations);
        pendSheet.put("rows", (Object)pendRows);
        pendSheet.put("spans", (Object)pendSpans);
        String sumFillArea = String.join((CharSequence)":", String.valueOf(fillArea.getStartRow()), String.valueOf(fillArea.getStartCol()), String.valueOf(allSumIndex), String.valueOf(fillArea.getSpanCol()));
        return MapInitHelper.ofMap((Object)"sheetJson", (Object)pendSheet, (Object)"recordJson", (Object)((JSONObject)JSONObject.toJSON((Object)MapInitHelper.ofMap((Object)"fillArea", (Object)sumFillArea))));
    }

    private static void insertRows(JSONObject sheetJson, int insertRow, int insertRows) {
        if (insertRows <= 0) {
            return;
        }
        JSONObject dataTable = sheetJson.getJSONObject("data").getJSONObject("dataTable");
        int rowCount = sheetJson.getIntValue("rowCount");
        JSONArray rows = sheetJson.getJSONArray("rows");
        if (Objects.nonNull(rows)) {
            rows.set(rowCount + insertRows, null);
        }
        int index = 0;
        while (rowCount - index > insertRow) {
            int newRowIndex = rowCount - 1 - index + insertRows;
            int oldRowIndex = rowCount - 1 - index;
            dataTable.put(String.valueOf(newRowIndex), (Object)dataTable.getJSONObject(String.valueOf(oldRowIndex)));
            if (Objects.nonNull(rows) && oldRowIndex < rows.size() && Objects.nonNull(rows.getJSONObject(oldRowIndex))) {
                rows.set(newRowIndex, (Object)rows.getJSONObject(oldRowIndex));
                rows.set(oldRowIndex, null);
            }
            ++index;
        }
        sheetJson.put("rows", (Object)rows);
        JSONArray spans = sheetJson.getJSONArray("spans");
        if (Objects.nonNull(spans)) {
            JSONArray pendAddSpans = new JSONArray();
            for (Object span : spans) {
                int spanRow = ((JSONObject)span).getIntValue("row");
                int spanRowCount = ((JSONObject)span).getIntValue("rowCount");
                if (spanRow >= insertRow) {
                    ((JSONObject)span).put("row", (Object)(spanRow + insertRows));
                    continue;
                }
                if (spanRow >= insertRow || spanRow + spanRowCount < insertRow) continue;
                ((JSONObject)span).put("rowCount", (Object)(insertRow - spanRow));
                pendAddSpans.add((Object)new JSONObject(MapInitHelper.ofMap((Object)"row", (Object)insertRow, (Object)"rowCount", (Object)(spanRowCount - (insertRow - spanRow)), (Object)"col", (Object)((JSONObject)span).getIntValue("col"), (Object)"colCount", (Object)((JSONObject)span).getIntValue("col"))));
            }
            spans.addAll((Collection)pendAddSpans);
        }
        sheetJson.put("rowCount", (Object)(sheetJson.getIntValue("rowCount") + insertRows));
    }

    private static void deleteRows(JSONObject sheetJson, int deleteRow, int deleteRows) {
        int index;
        if (deleteRows <= 0) {
            return;
        }
        JSONObject dataTable = sheetJson.getJSONObject("data").getJSONObject("dataTable");
        int rowCount = sheetJson.getIntValue("rowCount");
        JSONArray rows = sheetJson.getJSONArray("rows");
        for (index = deleteRow; index < rowCount; ++index) {
            int newRowIndex = index - deleteRows;
            int oldRowIndex = index;
            dataTable.put(String.valueOf(newRowIndex), (Object)dataTable.getJSONObject(String.valueOf(oldRowIndex)));
            if (!Objects.nonNull(rows) || oldRowIndex >= rows.size() || !Objects.nonNull(rows.getJSONObject(oldRowIndex))) continue;
            rows.set(newRowIndex, (Object)rows.getJSONObject(oldRowIndex));
        }
        for (index = deleteRows; index > 0; --index) {
            dataTable.remove((Object)String.valueOf(rowCount - index));
            if (!Objects.nonNull(rows) || rowCount - index >= rows.size() || !Objects.nonNull(rows.getJSONObject(rowCount - index))) continue;
            rows.remove(rowCount - index);
        }
        sheetJson.put("rows", (Object)rows);
        JSONArray spans = sheetJson.getJSONArray("spans");
        if (Objects.nonNull(spans)) {
            Iterator iterator = spans.iterator();
            while (iterator.hasNext()) {
                JSONObject span = (JSONObject)iterator.next();
                int spanStart = span.getIntValue("row");
                int spanRowCount = span.getIntValue("rowCount");
                int spanEnd = spanStart + spanRowCount;
                int deleteStart = deleteRow - deleteRows;
                int deleteEnd = deleteRow;
                if (spanStart >= deleteEnd) {
                    span.put("row", (Object)(spanStart - deleteRow));
                    continue;
                }
                if (spanEnd < deleteStart) continue;
                if (spanEnd >= deleteEnd && spanStart < deleteStart) {
                    span.put("rowCount", (Object)(spanRowCount - deleteRows));
                    continue;
                }
                if (spanEnd < deleteEnd && spanStart >= deleteStart) {
                    iterator.remove();
                    continue;
                }
                if (spanStart < deleteEnd && spanEnd >= deleteEnd) {
                    span.put("row", (Object)deleteStart);
                    span.put("rowCount", (Object)(spanEnd - deleteEnd + 1));
                    continue;
                }
                if (spanStart >= deleteStart || spanEnd < deleteStart) continue;
                span.put("rowCount", (Object)(deleteStart - spanStart));
            }
        }
        sheetJson.put("rowCount", (Object)(sheetJson.getIntValue("rowCount") - deleteRows));
    }

    private static List<String> getNoSumCell(RptInfoByFillTask rptInfoByFillTask) {
        List lockAreas;
        List<String> unSumCell = new ArrayList<String>(16);
        List calAreas = rptInfoByFillTask.getCalAreas();
        if (Objects.nonNull(calAreas)) {
            unSumCell = calAreas.stream().map(obj -> {
                SpreadSelector calAreaTor = new SpreadSelector(obj.getAreaPoint());
                return calAreaTor.getStartRow() + ":" + calAreaTor.getStartCol();
            }).collect(Collectors.toList());
        }
        if (Objects.nonNull(lockAreas = rptInfoByFillTask.getLockAreas())) {
            for (AreaSettingDto lockArea : lockAreas) {
                SpreadSelector lockAreaTor = new SpreadSelector(lockArea.getAreaPoint());
                for (int row = lockAreaTor.getStartRow(); row <= lockAreaTor.getEndRow(); ++row) {
                    for (int col = lockAreaTor.getStartCol(); col <= lockAreaTor.getEndCol(); ++col) {
                        unSumCell.add(row + ":" + col);
                    }
                }
            }
        }
        return unSumCell;
    }

    private static void handleListSumRow(SpreadSelector totalSummaryArea, int startFIdxAftSum, int endFIdxAftSum, int sumRIndexAftSum, JSONObject pendDataTable) {
        for (int col = totalSummaryArea.getStartCol(); col <= totalSummaryArea.getEndCol(); ++col) {
            String formula = ExcelFormulaEnum.SUM.getFormula();
            StringBuilder formulaBuilder = new StringBuilder(100);
            String preFormula = formula.substring(0, formula.length() - 1);
            formulaBuilder.append(preFormula);
            formulaBuilder.append(ExcelUtils.xy2Pos((int)col, (int)startFIdxAftSum));
            formulaBuilder.append(":");
            formulaBuilder.append(ExcelUtils.xy2Pos((int)col, (int)(endFIdxAftSum - 1)));
            formulaBuilder.append(")");
            pendDataTable.getJSONObject(String.valueOf(sumRIndexAftSum)).getJSONObject(String.valueOf(col)).put("formula", (Object)formulaBuilder.toString());
        }
    }

    private static void handleValidations(JSONArray validations, int addRows) {
        for (Object validation : validations) {
            String rangesStr = ((JSONObject)validation).getString("ranges");
            ((JSONObject)validation).put("ranges", (Object)SumReportHelper.addNumToString(rangesStr, addRows));
            JSONArray cdRanges = ((JSONObject)validation).getJSONObject("condition").getJSONArray("ranges");
            for (Object cdRange : cdRanges) {
                ((JSONObject)cdRange).put("row", (Object)(((JSONObject)cdRange).getIntValue("row") + addRows));
            }
        }
    }

    private static void handleSpans(JSONArray pendSpans, JSONArray spans, int addRows, SpreadSelector fillArea) {
        if (Objects.nonNull(spans)) {
            for (Object o : spans) {
                JSONObject span = (JSONObject)o;
                int spanRow = span.getIntValue("row");
                if (spanRow < fillArea.getStartRow() || spanRow > fillArea.getEndRow()) continue;
                span.put("row", (Object)(spanRow + addRows));
                Iterator iterator = pendSpans.iterator();
                while (iterator.hasNext()) {
                    JSONObject pendSpan = (JSONObject)iterator.next();
                    if (pendSpan.getIntValue("row") != span.getIntValue("row") || pendSpan.getIntValue("col") != span.getIntValue("col")) continue;
                    iterator.remove();
                    break;
                }
                pendSpans.add((Object)span);
            }
        }
    }

    public static String addNumToString(String input, int num) {
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            int number = Integer.parseInt(matcher.group()) + num;
            matcher.appendReplacement(result, String.valueOf(number));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static boolean isValidDouble(Object obj) {
        try {
            double value = Double.parseDouble(String.valueOf(obj));
            return value >= -1.7976931348623157E308 && value <= Double.MAX_VALUE;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static JSONObject deleteFormula(JSONObject copyFrom, RptAreaConf areaConf) {
        JSONObject newCopyFrom = new JSONObject((Map)copyFrom);
        String color = AreaSettingEnum.FILL.getColor();
        if (Objects.nonNull(areaConf)) {
            color = areaConf.getBakColor();
        }
        String finalColor = color;
        newCopyFrom.forEach((key, value) -> {
            JSONObject valueJson;
            if (value instanceof JSONObject && Objects.nonNull((valueJson = (JSONObject)value).get((Object)"formula"))) {
                valueJson.remove((Object)"formula");
                Object styleObject = valueJson.get((Object)"style");
                if (styleObject instanceof JSONObject) {
                    valueJson.getJSONObject("style").put("backColor", (Object)finalColor);
                }
            }
        });
        return newCopyFrom;
    }

    public static List<String> getLinkedData(String recordJson, String sheetName, List<AreaSettingDto> lockAreas) {
        JSONObject recordObj = JSONObject.parseObject((String)recordJson);
        ArrayList<String> points = new ArrayList<String>(16);
        ArrayList inLockPoints = new ArrayList(16);
        recordObj.forEach((key, value) -> {
            if (sheetName.equals(key) && RptTypeEnum.STATISTICS.getType().equals(((JSONObject)value).getString("rpttype")) && CollectTypeEnum.SUM.getType().equals(((JSONObject)value).getString("collecttype"))) {
                JSONObject sumDetail = ((JSONObject)value).getJSONObject("cellSumDetail");
                sumDetail.forEach((dkey, dvalue) -> {
                    String point = dkey + ":1:1";
                    SpreadSelector spreadSelector = new SpreadSelector(point);
                    points.add(point);
                    for (AreaSettingDto lockArea : lockAreas) {
                        if (!spreadSelector.checkIsInArea(lockArea.convert2Selector())) continue;
                        inLockPoints.add(point);
                    }
                });
            }
        });
        if (!inLockPoints.isEmpty() && !points.isEmpty()) {
            points.removeAll(inLockPoints);
        }
        return points;
    }

    public static Map<String, String> getFillAreaBySum(DynamicObject sumReport) {
        HashMap<String, String> sheetMapArea = new HashMap<String, String>(16);
        JSONObject recordObj = JSONObject.parseObject((String)sumReport.getString("recordjson_tag"));
        for (Map.Entry entry : recordObj.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            sheetMapArea.put(key, ((JSONObject)value).getString("fillArea"));
        }
        return sheetMapArea;
    }
}

