/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.cyccollecttask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sdk.sihc.soehrr.common.enums.CusExceptionEnum;
import kd.sdk.sihc.soehrr.common.util.HrrQfilterUtils;
import kd.sihc.soehrr.business.domain.collecttask.CollectTaskFormService;
import kd.sihc.soehrr.business.domain.cyccollecttask.disdatehandler.AbstractDateHandler;
import kd.sihc.soehrr.business.domain.cyccollecttask.disdatehandler.HalfYearEntryHandler;
import kd.sihc.soehrr.business.domain.cyccollecttask.disdatehandler.MonthEntryHandler;
import kd.sihc.soehrr.business.domain.cyccollecttask.disdatehandler.QuarterEntryHandler;
import kd.sihc.soehrr.business.domain.cyccollecttask.disdatehandler.YearEntryHandler;
import kd.sihc.soehrr.business.queryservice.RptTplQueryService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import kd.sihc.soehrr.common.enums.CycleCollectTaskEnum;

public class CycCollService
extends HRBaseServiceHelper {
    private static final Log LOG = LogFactory.getLog(CycCollService.class);
    private RptTplQueryService rptTplQueryService = ServiceFactory.getService(RptTplQueryService.class);
    private CollectTaskFormService collectTaskService = ServiceFactory.getService(CollectTaskFormService.class);
    private HRBaseServiceHelper adminOrgHelper = HRBaseServiceHelper.create((String)"haos_adminorghr");
    private static final Map<CycleCollectTaskEnum, AbstractDateHandler> ENTRY_DATE_HANDLERS = Maps.newHashMapWithExpectedSize((int)4);

    public CycCollService() {
        super("soehrr_cyccollecttask");
    }

    public void reportClassifyChangeHandler(PropertyChangedArgs args, IFormView view, IFormPlugin plugin) {
        IDataModel dataModel = view.getModel();
        IPageCache pageCache = view.getPageCache();
        if (!HRObjectUtils.isEmpty((Object)pageCache.get("clear"))) {
            pageCache.remove("clear");
            return;
        }
        DynamicObject newValue = (DynamicObject)args.getChangeSet()[0].getNewValue();
        DynamicObject oldValue = (DynamicObject)args.getChangeSet()[0].getOldValue();
        if (null != oldValue && newValue != oldValue) {
            pageCache.put("oldClass", String.valueOf(oldValue.getLong("id")));
            if (HRObjectUtils.isEmpty((Object)newValue)) {
                pageCache.put("clear", "cancel");
                dataModel.setValue("reportclassify", (Object)Long.parseLong(pageCache.get("oldClass")));
                return;
            }
            if ("cancel".equals(pageCache.get("flag"))) {
                pageCache.remove("flag");
                return;
            }
            view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u62a5\u8868\u5206\u7c7b\uff0c\u5c06\u66ff\u6362\u4efb\u52a1\u914d\u7f6e\u7684\u62a5\u8868\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"CollectTaskPlugin_11", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changeReportClass", plugin));
        } else if (null == oldValue) {
            DynamicObject reportClassify = (DynamicObject)dataModel.getValue("reportclassify");
            this.setDefaultRptTpl(reportClassify, view);
        }
    }

    public void setDefaultRptTpl(DynamicObject newRptClassify, IFormView view) {
        IDataModel dataModel = view.getModel();
        DynamicObject cycCollectTask = dataModel.getDataEntity();
        long orgId = cycCollectTask.getLong("org.id");
        DynamicObject[] rptTpls = this.rptTplQueryService.queryRptTplByClass(newRptClassify.getLong("id"), orgId);
        List sortRptTpls = Arrays.stream(rptTpls).sorted(Comparator.comparing(dy -> dy.getDate("modifytime"), Comparator.reverseOrder())).collect(Collectors.toList());
        List<DynamicObject> configExeUnits = this.collectTaskService.getConfigExeUnit(view, "soehrr_cyccollecttask");
        for (int index = 0; index < Math.min(sortRptTpls.size(), 5); ++index) {
            int newEntryRow = dataModel.createNewEntryRow("taskfillobjs");
            DynamicObject rptTpl = (DynamicObject)sortRptTpls.get(index);
            dataModel.setValue("rpttpl", (Object)rptTpl, index);
            if (!HRCollUtil.isNotEmpty(configExeUnits)) continue;
            DynamicObjectCollection fillUnits = ((DynamicObject)dataModel.getDataEntity(true).getDynamicObjectCollection("taskfillobjs").get(newEntryRow)).getDynamicObjectCollection("fillunits");
            configExeUnits.forEach(dynamicObject -> {
                DynamicObject fillUnit = fillUnits.addNew();
                fillUnit.set("fbasedataid", dynamicObject);
            });
        }
        this.initDistributeDateEntry(view);
        view.updateView("taskfillobjs");
    }

    public void openBatchSetHrOrg(IFormPlugin plugin, IFormView view) {
        this.collectTaskService.openReportUnit(plugin, view, "soehrr_cyccollecttask");
    }

    public void addReportCloseCallBackHandler(ClosedCallBackEvent ccbe, IFormView view) {
        IDataModel dataModel = view.getModel();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)ccbe.getReturnData();
        DynamicObjectCollection taskFillObjEntry = dataModel.getEntryEntity("taskfillobjs");
        if (null == returnData) {
            return;
        }
        this.checkReportsSize(taskFillObjEntry, returnData, view);
        int size = taskFillObjEntry.size();
        for (int tag = 0; tag < returnData.size(); ++tag) {
            int index = tag + size;
            ListSelectedRow listSelectedRow = returnData.get(tag);
            Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
            dataModel.createNewEntryRow("taskfillobjs");
            dataModel.setValue("rpttpl", (Object)primaryKeyValue, index);
        }
        view.updateView("taskfillobjs");
    }

    private void checkReportsSize(DynamicObjectCollection taskFillObjEntry, ListSelectedRowCollection returnData, IFormView view) {
        int maxSize;
        int entrySize = taskFillObjEntry.size();
        int total = returnData.size() + entrySize;
        if (total > (maxSize = 100)) {
            ListSelectedRowCollection needRemoveList = new ListSelectedRowCollection();
            int needRemoveTotal = total - maxSize;
            for (int i = returnData.size() - needRemoveTotal; i < returnData.size(); ++i) {
                needRemoveList.add((Object)returnData.get(i));
            }
            returnData.removeAll((Collection)needRemoveList);
            view.showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e9100\u6761\u6570\u636e\u3002", (String)"CollectTaskFormService_4", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        }
    }

    public void initDistributeDateEntry(IFormView view) {
        DynamicObject cycCollectTask = view.getModel().getDataEntity(true);
        Set<Long> taskAllPeriodTypes = this.getTaskAllPeriodTypes(cycCollectTask);
        if (HRCollUtil.isNotEmpty(taskAllPeriodTypes)) {
            view.setVisible(Boolean.TRUE, new String[]{"distributedateflex"});
            for (CycleCollectTaskEnum taskEnum : CycleCollectTaskEnum.values()) {
                view.setVisible(Boolean.FALSE, new String[]{taskEnum.getTabKey()});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"distributedateflex"});
        }
        long pkId = cycCollectTask.getLong("id");
        for (Long taskPeriodType : taskAllPeriodTypes) {
            CycleCollectTaskEnum byPeriodType = CycleCollectTaskEnum.getByPeriodType((long)taskPeriodType);
            view.setVisible(Boolean.TRUE, new String[]{byPeriodType.getTabKey()});
            AbstractDateHandler dateHandler = ENTRY_DATE_HANDLERS.get(byPeriodType);
            if (pkId == 0L) {
                dateHandler.initViewEntry(view);
                continue;
            }
            dateHandler.setDisDateToShowEntry(view);
        }
        view.getModel().setDataChanged(false);
    }

    public void openBatchSetDateEntry(IFormPlugin plugin, IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("soehrr_cycbatchsetting");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack(plugin, "batchsettingdate"));
        Tab tab = (Tab)view.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        CycleCollectTaskEnum taskEnum = CycleCollectTaskEnum.getByTab((String)currentTab);
        parameter.setCustomParam("periodtype", (Object)taskEnum.getPeriodTypeId());
        view.showForm(parameter);
    }

    public void batchSetDateHandler(ClosedCallBackEvent ccbe, IFormView view) {
        Object returnData = ccbe.getReturnData();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        Map returnMap = (Map)returnData;
        Tab tab = (Tab)view.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        CycleCollectTaskEnum taskEnum = CycleCollectTaskEnum.getByTab((String)currentTab);
        EntryGrid entryGrid = (EntryGrid)view.getControl(taskEnum.getEntryName());
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject[] entryDyData = entryGrid.getEntryData().getDataEntitys();
        for (int selectRow : selectRows) {
            DynamicObject entryDyDatum = entryDyData[selectRow];
            AbstractDateHandler dateHandler = ENTRY_DATE_HANDLERS.get(taskEnum);
            if (null == dateHandler) continue;
            String userMonthDayFormat = dateHandler.getUserMonthDayFormat();
            dateHandler.setSettingDateToEntry(view.getModel(), selectRow, returnMap, entryDyDatum, userMonthDayFormat);
        }
        view.updateView(taskEnum.getEntryName());
    }

    public int[] getDateTabSelectRows(IFormView view) {
        Tab tab = (Tab)view.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        CycleCollectTaskEnum taskEnum = CycleCollectTaskEnum.getByTab((String)currentTab);
        EntryGrid entryGrid = (EntryGrid)view.getControl(taskEnum.getEntryName());
        return entryGrid.getSelectRows();
    }

    public AbstractDateHandler getHandlerByPeriodTypeId(long periodTypeId) {
        CycleCollectTaskEnum taskEnum = CycleCollectTaskEnum.getByPeriodType((long)periodTypeId);
        AbstractDateHandler dateHandler = ENTRY_DATE_HANDLERS.get(taskEnum);
        if (null == dateHandler) {
            throw new KDException(BosErrorCode.paramError, new Object[]{String.format(CusExceptionEnum.CALLBACK_ERROR.getName(), "AbstractDateHandler")});
        }
        return dateHandler;
    }

    public void fillUnitsCloseCallBackHandler(ClosedCallBackEvent ccbe, IFormView view) {
        IDataModel dataModel = view.getModel();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)ccbe.getReturnData();
        if (null == returnData) {
            return;
        }
        this.collectTaskService.checkFillUnitsSize(view, returnData);
        List orgIds = returnData.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] orgs = this.adminOrgHelper.loadDynamicObjectArray(new QFilter("id", "in", orgIds).toArray());
        ArrayList sortedOrgList = Lists.newArrayListWithExpectedSize((int)returnData.size());
        for (ListSelectedRow returnDatum : returnData) {
            for (DynamicObject org : orgs) {
                if (((Long)returnDatum.getPrimaryKeyValue()).longValue() != org.getLong("id")) continue;
                sortedOrgList.add(org);
            }
        }
        EntryGrid entryGrid = (EntryGrid)view.getControl("taskfillobjs");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection fillObjects = dataModel.getDataEntity(true).getDynamicObjectCollection("taskfillobjs");
        for (int selectRow : selectRows) {
            DynamicObjectCollection fill = ((DynamicObject)fillObjects.get(selectRow)).getDynamicObjectCollection("fillunits");
            fill.clear();
            for (DynamicObject obj2 : sortedOrgList) {
                DynamicObject dynamicObject = fill.addNew();
                dynamicObject.set("fbasedataid", (Object)obj2);
            }
        }
        view.updateView("taskfillobjs");
    }

    public Set<Long> getTaskAllPeriodTypes(DynamicObject cycCollectTask) {
        ArrayList rptTpls = Lists.newArrayListWithExpectedSize((int)10);
        DynamicObjectCollection taskConfEntry = cycCollectTask.getDynamicObjectCollection("taskfillobjs");
        for (DynamicObject taskConf : taskConfEntry) {
            rptTpls.add(taskConf.getDynamicObject("rpttpl"));
        }
        List periodTypes = rptTpls.stream().map(rt -> rt.getDynamicObject("periodtype")).collect(Collectors.toList());
        return periodTypes.stream().map(pt -> pt.getLong("id")).collect(Collectors.toSet());
    }

    public void setShowEntryToDisDate(DynamicObject cycCollectTask) {
        DynamicObjectCollection entryEntity = cycCollectTask.getDynamicObjectCollection("entryentity");
        int nowYear = HRDateTimeUtils.getYear((Date)new Date());
        entryEntity.removeIf(entry -> entry.getInt("belongyear") == nowYear);
        Set<Long> periodTypeIds = this.getTaskAllPeriodTypes(cycCollectTask);
        for (Long periodTypeId : periodTypeIds) {
            CycleCollectTaskEnum byPeriodType = CycleCollectTaskEnum.getByPeriodType((long)periodTypeId);
            DynamicObjectCollection datePeriodEntry = cycCollectTask.getDynamicObjectCollection(byPeriodType.getEntryName());
            AbstractDateHandler dateHandler = ENTRY_DATE_HANDLERS.get(byPeriodType);
            dateHandler.setShowEntryToDisDate(datePeriodEntry, entryEntity);
        }
    }

    public DynamicObject queryByUnitAndClassify(long disUnitId, long repClassifyId) {
        QFilter qFilter = new QFilter("disunit", "=", (Object)disUnitId);
        qFilter.and(new QFilter("reportclassify", "=", (Object)repClassifyId));
        qFilter.and(new QFilter("enable", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "10"})));
        return this.queryOne(qFilter.toArray());
    }

    public void openMsgShowForm(IFormView view) {
        IDataModel dataModel = view.getModel();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("soehrr_msgsendview_inh");
        formShowParameter.setPageId("soehrr_msgsendview_inh" + dataModel.getDataEntity().getPkValue() + RequestContext.get().getGlobalSessionId() + "enable");
        formShowParameter.setCustomParam("id", dataModel.getDataEntity().getPkValue());
        formShowParameter.setCustomParam("parameteroptype", (Object)"enable");
        view.showForm(formShowParameter);
    }

    public void showDisAndEnable(IFormView view) {
        IDataModel dataModel = view.getModel();
        Long pkId = (Long)dataModel.getValue("id");
        if (pkId == 0L) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_enable"});
        } else {
            String enable = (String)dataModel.getValue("enable");
            if (!"1".equals(enable)) {
                view.setVisible(Boolean.TRUE, new String[]{"bar_enable"});
            }
        }
    }

    public DynamicObject[] queryEnableByRptTplIds(List<Long> rptTplIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("taskfillobjs.rpttpl", "in", rptTplIds), HrrQfilterUtils.enable()};
        return this.query(qFilters);
    }

    static {
        ENTRY_DATE_HANDLERS.put(CycleCollectTaskEnum.MONTH, new MonthEntryHandler());
        ENTRY_DATE_HANDLERS.put(CycleCollectTaskEnum.QUARTER, new QuarterEntryHandler());
        ENTRY_DATE_HANDLERS.put(CycleCollectTaskEnum.HALF_YEAR, new HalfYearEntryHandler());
        ENTRY_DATE_HANDLERS.put(CycleCollectTaskEnum.YEAR, new YearEntryHandler());
    }
}

