/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.cyccollecttask.disdatehandler;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sihc.soehrr.common.entity.cyccollecttask.DistributeDateHandler;
import kd.sihc.soehrr.common.enums.CycleCollectTaskEnum;
import kd.sihc.soehrr.common.utils.SoehrrCommonUtils;

public abstract class AbstractDateHandler
implements DistributeDateHandler {
    private static final Log LOG = LogFactory.getLog(AbstractDateHandler.class);

    public void initViewEntry(IFormView cycCollTaskView) {
        List belongPeriods = this.queryBelongPeriods();
        IDataModel dataModel = cycCollTaskView.getModel();
        CycleCollectTaskEnum cctEnum = this.handlerType();
        dataModel.deleteEntryData(cctEnum.getEntryName());
        String userDateFormat = this.getUserMonthDayFormat();
        String dyDateFormat = "yyyy-" + userDateFormat + " HH:mm:ss";
        try {
            dataModel.beginInit();
            for (int index = 0; index < belongPeriods.size(); ++index) {
                dataModel.createNewEntryRow(cctEnum.getEntryName());
                DynamicObject belongPeriod = (DynamicObject)belongPeriods.get(index);
                dataModel.setValue(cctEnum.getFieldPrefix() + "belongperiod", (Object)belongPeriod, index);
                Date startDate = belongPeriod.getDate("startdate");
                Date endDate = belongPeriod.getDate("enddate");
                startDate = this.checkLeapMonth(startDate);
                endDate = this.checkLeapMonth(endDate);
                String yearVal = NOW_YEAR.getDescription();
                String startDateVal = this.getShowDateVal(startDate, userDateFormat, yearVal);
                String endDateVal = this.getShowDateVal(endDate, userDateFormat, yearVal);
                dataModel.setValue(cctEnum.getFieldPrefix() + "datastarttime", (Object)startDateVal, index);
                dataModel.setValue(cctEnum.getFieldPrefix() + "dataendtime", (Object)endDateVal, index);
                int year = HRDateTimeUtils.getYear((Date)new Date());
                Date realDataStartDate = HRDateTimeUtils.parseDate((String)(year + "-" + HRDateTimeUtils.format((Date)startDate, (String)userDateFormat) + " 00:00:00"), (String)dyDateFormat);
                Date realDataEndDate = HRDateTimeUtils.parseDate((String)(year + "-" + HRDateTimeUtils.format((Date)endDate, (String)userDateFormat) + " 23:59:59"), (String)dyDateFormat);
                dataModel.setValue(cctEnum.getFieldPrefix() + "datastarttime" + "val", (Object)realDataStartDate, index);
                dataModel.setValue(cctEnum.getFieldPrefix() + "dataendtime" + "val", (Object)realDataEndDate, index);
                Date fillStartDate = HRDateTimeUtils.addDay((Date)endDate, (long)1L);
                int fillStartYear = HRDateTimeUtils.getYear((Date)fillStartDate);
                int dataEndYear = HRDateTimeUtils.getYear((Date)endDate);
                if (fillStartYear > dataEndYear) {
                    yearVal = NEXT_YEAR.getDescription();
                    ++year;
                }
                String fillStartVal = this.getShowDateVal(fillStartDate, userDateFormat, yearVal);
                dataModel.setValue(cctEnum.getFieldPrefix() + "startdate", (Object)fillStartVal, index);
                Date fillEndDate = HRDateTimeUtils.addDay((Date)HRDateTimeUtils.addMonth((Date)fillStartDate, (int)1), (long)-1L);
                String fillEndVal = this.getShowDateVal(fillEndDate, userDateFormat, yearVal);
                dataModel.setValue(cctEnum.getFieldPrefix() + "enddate", (Object)fillEndVal, index);
                Date realStartDate = HRDateTimeUtils.parseDate((String)(year + "-" + HRDateTimeUtils.format((Date)fillStartDate, (String)userDateFormat) + " 00:00:00"), (String)dyDateFormat);
                Date realEndDate = HRDateTimeUtils.parseDate((String)(year + "-" + HRDateTimeUtils.format((Date)fillEndDate, (String)userDateFormat) + " 23:59:59"), (String)dyDateFormat);
                dataModel.setValue(cctEnum.getFieldPrefix() + "startdate" + "val", (Object)realStartDate, index);
                dataModel.setValue(cctEnum.getFieldPrefix() + "enddate" + "val", (Object)realEndDate, index);
                dataModel.setValue(cctEnum.getFieldPrefix() + "isdone", (Object)"0", index);
                cycCollTaskView.updateView(cctEnum.getEntryName());
            }
            dataModel.endInit();
        }
        catch (ParseException ex) {
            LOG.error("AbstractDateHandler.initViewEntry parse date error", (Throwable)ex);
        }
    }

    protected String getShowDateVal(Date fillDate, String userDateFormat, String yearVal) {
        String fillEndVal = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s%2$s", (String)"AbstractDateHandler_11", (String)"sihc-soehrr-business", (Object[])new Object[0]), yearVal, HRDateTimeUtils.format((Date)fillDate, (String)userDateFormat));
        return fillEndVal;
    }

    protected Date checkLeapMonth(Date dateTime) {
        String dateTimeStr = DateUtils.getDate((Date)dateTime);
        int year = HRDateTimeUtils.getYear((Date)dateTime);
        if ("02".equals(dateTimeStr.substring(5, 7)) && ("28".equals(dateTimeStr.substring(8, 10)) || "29".equals(dateTimeStr.substring(8, 10)))) {
            dateTimeStr = SoehrrCommonUtils.isLeapYear((int)year) ? dateTimeStr.substring(0, 9) + "9" : dateTimeStr.substring(0, 9) + "8";
            try {
                dateTime = HRDateTimeUtils.parseDate((String)dateTimeStr);
            }
            catch (ParseException ex) {
                LOG.error("AbstractDateHandler.getDateTimeVal has error", (Throwable)ex);
            }
        }
        return dateTime;
    }

    public Long getPeriodTypeId() {
        return this.handlerType().getPeriodTypeId();
    }

    public List<String> monthDropDowns() {
        return Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u540e\u4e00\u6708", (String)"AbstractDateHandler_0", (String)"sihc-soehrr-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540e\u4e8c\u6708", (String)"AbstractDateHandler_1", (String)"sihc-soehrr-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540e\u4e09\u6708", (String)"AbstractDateHandler_2", (String)"sihc-soehrr-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540e\u56db\u6708", (String)"AbstractDateHandler_3", (String)"sihc-soehrr-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540e\u4e94\u6708", (String)"AbstractDateHandler_4", (String)"sihc-soehrr-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540e\u516d\u6708", (String)"AbstractDateHandler_5", (String)"sihc-soehrr-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540e\u4e03\u6708", (String)"AbstractDateHandler_6", (String)"sihc-soehrr-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540e\u516b\u6708", (String)"AbstractDateHandler_7", (String)"sihc-soehrr-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540e\u4e5d\u6708", (String)"AbstractDateHandler_8", (String)"sihc-soehrr-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540e\u5341\u6708", (String)"AbstractDateHandler_9", (String)"sihc-soehrr-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540e\u5341\u4e00\u6708", (String)"AbstractDateHandler_10", (String)"sihc-soehrr-business", (Object[])new Object[0])});
    }

    public List<Integer> dayDropDowns() {
        return Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31});
    }

    public void setSettingDateToEntry(IDataModel model, int selectRow, Map<String, Integer> returnMap, DynamicObject entryDyDatum, String userMonthDayFormat) {
        int startMonth = returnMap.get("startmonth");
        int startDay = returnMap.get("startday");
        int endMonth = returnMap.get("endmonth");
        int endDay = returnMap.get("endday");
        CycleCollectTaskEnum taskEnum = this.handlerType();
        int nowYear = HRDateTimeUtils.getYear((Date)new Date());
        Date realEndDataTime = entryDyDatum.getDate(taskEnum.getFieldPrefix() + "dataendtime" + "val");
        Date fillStartDate = this.calFillDate(realEndDataTime, startMonth, startDay);
        LocalDateTime startOfDay = SoehrrCommonUtils.getStartOfDay((Date)fillStartDate);
        fillStartDate = SoehrrCommonUtils.convertLocalDateTimeToDate((LocalDateTime)startOfDay);
        Date fillEndDate = this.calFillDate(realEndDataTime, endMonth, endDay);
        model.setValue(taskEnum.getFieldPrefix() + "startdate" + "val", (Object)fillStartDate, selectRow);
        model.setValue(taskEnum.getFieldPrefix() + "enddate" + "val", (Object)fillEndDate, selectRow);
        int fillYear = HRDateTimeUtils.getYear((Date)fillStartDate);
        int fillEndYear = HRDateTimeUtils.getYear((Date)fillEndDate);
        String yearText = NOW_YEAR.getDescription();
        String yearEndText = NOW_YEAR.getDescription();
        if (fillYear > nowYear) {
            yearText = NEXT_YEAR.getDescription();
            yearEndText = NEXT_YEAR.getDescription();
        } else if (fillEndYear > nowYear) {
            yearEndText = NEXT_YEAR.getDescription();
        }
        String startShowVal = this.getShowDateVal(fillStartDate, userMonthDayFormat, yearText);
        String endShowVal = this.getShowDateVal(fillEndDate, userMonthDayFormat, yearEndText);
        model.setValue(taskEnum.getFieldPrefix() + "startdate", (Object)startShowVal, selectRow);
        model.setValue(taskEnum.getFieldPrefix() + "enddate", (Object)endShowVal, selectRow);
        Date nowDate = HRDateTimeUtils.getNowDate();
        if (fillStartDate.compareTo(nowDate) <= 0 && fillEndDate.compareTo(nowDate) >= 0) {
            model.setValue(taskEnum.getFieldPrefix() + "isdone", (Object)"0", selectRow);
        }
    }

    public Date calFillDate(Date realEndDataTime, int addMonth, int addDay) {
        Date fillDate = HRDateTimeUtils.addMonth((Date)realEndDataTime, (int)addMonth);
        LocalDate lastDayOfMonth = SoehrrCommonUtils.getLastDayOfMonth((Date)(fillDate = SoehrrCommonUtils.getFirstDayOfMonth((Date)fillDate)));
        int dayOfMonth = lastDayOfMonth.getDayOfMonth();
        if (addDay > dayOfMonth) {
            addDay = dayOfMonth;
        }
        fillDate = HRDateTimeUtils.addDay((Date)fillDate, (long)(addDay - 1));
        return fillDate;
    }

    public String getUserDateFormat() {
        InteServiceImpl inteService = new InteServiceImpl();
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject defaultInteset = inteService.getUserDefaultProgramme(Long.valueOf(currUserId));
        if (HRObjectUtils.isEmpty((Object)defaultInteset)) {
            return "MM-dd";
        }
        String dateFormat = defaultInteset.getString("dateformat");
        if (dateFormat.contains("m")) {
            dateFormat = dateFormat.replaceAll("m", "M");
        }
        return dateFormat;
    }

    public String getUserMonthDayFormat() {
        return AbstractDateHandler.removeYearFromFormat(this.getUserDateFormat());
    }

    public static String removeYearFromFormat(String formatString) {
        String newFormat = formatString.replaceAll("([/\\-.]?yyyy)$", "");
        StringBuilder sb = new StringBuilder(newFormat);
        int index = sb.indexOf("yyyy");
        while (index != -1) {
            if (index > 0 && AbstractDateHandler.isDelimiter(sb.charAt(index - 1))) {
                sb.deleteCharAt(index - 1);
            }
            if (index + 4 < sb.length() && AbstractDateHandler.isDelimiter(sb.charAt(index + 4))) {
                sb.deleteCharAt(index + 4);
            }
            sb.delete(index, index + 4);
            index = sb.indexOf("yyyy");
        }
        if (sb.toString().startsWith("yyyy")) {
            int start = 0;
            if (sb.length() > 4 && AbstractDateHandler.isDelimiter(sb.charAt(4))) {
                start = 1;
            }
            sb.delete(start, start + 4);
        }
        return sb.toString();
    }

    private static boolean isDelimiter(char c) {
        return c == '/' || c == '-' || c == '.';
    }

    public void setDisDateToShowEntry(IFormView view) {
        CycleCollectTaskEnum cctEnum = this.handlerType();
        IDataModel dataModel = view.getModel();
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity("entryentity");
        int nowYear = HRDateTimeUtils.getYear((Date)new Date());
        List targetDataEntry = entryEntity.stream().filter(entry -> entry.getInt("belongyear") == nowYear && entry.getDynamicObject("belongperiod").getLong("periodtype.id") == cctEnum.getPeriodTypeId()).sorted(Comparator.comparing(entry -> entry.getDynamicObject("belongperiod").getString("number"))).collect(Collectors.toList());
        dataModel.deleteEntryData(cctEnum.getEntryName());
        for (DynamicObject targetData : targetDataEntry) {
            int newEntryRow = dataModel.createNewEntryRow(cctEnum.getEntryName());
            for (IDataEntityProperty property : targetData.getDynamicObjectType().getProperties()) {
                String fieldName = property.getName();
                if ("id".equals(fieldName) || "seq".equals(fieldName) || "belongyear".equals(fieldName)) continue;
                dataModel.setValue(cctEnum.getFieldPrefix() + fieldName, targetData.get(fieldName), newEntryRow);
            }
        }
        view.updateView(cctEnum.getEntryName());
    }

    public void setShowEntryToDisDate(DynamicObjectCollection showDateEntity, DynamicObjectCollection entryEntity) {
        int nowYear = HRDateTimeUtils.getYear((Date)new Date());
        CycleCollectTaskEnum taskEnum = this.handlerType();
        for (DynamicObject item : showDateEntity) {
            DynamicObject newDataEntry = new DynamicObject(entryEntity.getDynamicObjectType());
            for (IDataEntityProperty property : entryEntity.getDynamicObjectType().getProperties()) {
                String fieldName = property.getName();
                if ("belongyear".equals(fieldName)) {
                    newDataEntry.set(fieldName, (Object)nowYear);
                    continue;
                }
                if ("seq".equals(fieldName)) continue;
                if ("id".equals(fieldName)) {
                    newDataEntry.set(fieldName, item.get(fieldName));
                    continue;
                }
                newDataEntry.set(fieldName, item.get(taskEnum.getFieldPrefix() + fieldName));
            }
            entryEntity.add((Object)newDataEntry);
        }
    }
}

