/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.report;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soehrr.business.domain.collecttask.FillTaskService;
import kd.sihc.soehrr.business.queryservice.ReportQueryService;
import kd.sihc.soehrr.business.servicehelper.ServiceFactory;
import org.apache.commons.lang3.tuple.Pair;

public class ReportService
extends HRBaseServiceHelper {
    private static final Log LOG = LogFactory.getLog(ReportService.class);
    private final ReportQueryService reportQueryService = ServiceFactory.getService(ReportQueryService.class);

    public void updateFillTaskReportStatus(long fillTaskId, String status) {
        DynamicObject[] reports = this.loadDynamicObjectArray(new QFilter[]{new QFilter("filltask", "=", (Object)fillTaskId)});
        Arrays.asList(reports).forEach(report -> report.set("reportstatus", (Object)status));
        this.update(reports);
    }

    public void splitSpreadJson2Rpt(long fillTaskId, String compressFillJson) {
        DynamicObject[] reports;
        String uncompressJson = GzipTools.uncompressJson((String)compressFillJson);
        for (DynamicObject rpt : reports = this.loadByFillTask(fillTaskId)) {
            DynamicObject rptTpl = rpt.getDynamicObject("rpttpl");
            if (HRObjectUtils.isEmpty((Object)rptTpl)) continue;
            String sheetName = rptTpl.getString("number");
            JSONObject newSpreadJsonObj = SpreadJsonHelper.genNewOneSheetJson((String)uncompressJson, (String)sheetName);
            LOG.debug("ReportService.splitSpreadJson2Rpt.newSpreadJsonObj = {}", (Object)newSpreadJsonObj);
            String newCompressStr = GzipTools.compressJson((String)JSONObject.toJSONString((Object)newSpreadJsonObj));
            rpt.set("json_tag", (Object)newCompressStr);
        }
        this.save(reports);
    }

    public DynamicObject[] loadByFillTask(long fillTaskId) {
        QFilter taskFilter = new QFilter("filltask", "=", (Object)fillTaskId);
        return this.loadDynamicObjectArray(taskFilter.toArray());
    }

    public DynamicObject[] queryTplByFillTask(long fillTaskId) {
        return this.reportQueryService.queryReportByFillTask(fillTaskId);
    }

    public DynamicObject[] queryByRepEntryIds(List<Long> rptEntryIds) {
        QFilter repEntryQfilter = new QFilter("repentryid", "in", rptEntryIds);
        return this.query("fillarea,repentryid", repEntryQfilter.toArray());
    }

    public void updateFillAreaWhenFillTask(String fillarea, Long fillTaskId, Long repentryid, String rptTplNumber) {
        DynamicObject one = this.queryOne("id,fillarea", new QFilter("filltask", "=", (Object)fillTaskId).and("repentryid", "=", (Object)repentryid).and("rpttpl.number", "=", (Object)rptTplNumber));
        if (HRObjectUtils.isEmpty((Object)one) || fillarea.equals(one.getString("fillarea"))) {
            return;
        }
        one.set("fillarea", (Object)fillarea);
        this.updateOne(one);
    }

    public void updateReportStatusToFinish(List<Long> fillTaskIds) {
        DynamicObject[] reports = this.loadDynamicObjectArray(new QFilter[]{new QFilter("collecttask", "in", fillTaskIds)});
        Arrays.asList(reports).forEach(report -> {
            if (HRStringUtils.equals((String)"B", (String)report.getString("reportstatus"))) {
                report.set("reportstatus", (Object)"D");
            } else {
                report.set("reportstatus", (Object)"C");
            }
        });
        this.update(reports);
    }

    public void updateReportStatusToStop(List<Long> fillTaskIds) {
        DynamicObject[] reports = this.loadDynamicObjectArray(new QFilter[]{new QFilter("collecttask", "in", fillTaskIds)});
        Arrays.asList(reports).forEach(report -> report.set("reportstatus", (Object)"C"));
        this.update(reports);
    }

    public List<Pair<DynamicObject, DynamicObject>> queryByFillUnits(Collection<Long> allDisUnits, Set<String> years, Set<Long> rptTplIds, Set<Long> belongPeriods) {
        QFilter[] qFilters = new QFilter[]{new QFilter("exeunit", "in", allDisUnits), new QFilter("year", "in", years), new QFilter("rpttpl", "in", rptTplIds), new QFilter("belongperiod", "in", belongPeriods)};
        DynamicObject[] reports = this.query("id,name,number,rpttpl,reportclassify,exeunit,filltask,year,periodtype,belongperiod,datastarttime,dataendtime,disunit", qFilters);
        List<Long> fillTaskIds = Arrays.stream(reports).map(rep -> rep.getLong("filltask")).collect(Collectors.toList());
        DynamicObject[] fillTasks = FillTaskService.ins().getFillTasks(fillTaskIds, "taskstatus");
        Map<Long, DynamicObject> fillTaskMapId = Arrays.stream(fillTasks).collect(Collectors.toMap(ft -> ft.getLong("id"), ft -> ft, (k, v) -> v));
        ArrayList result = Lists.newArrayListWithExpectedSize((int)reports.length);
        for (DynamicObject report : reports) {
            String taskStatus;
            long fillTaskId = report.getLong("filltask");
            DynamicObject fillTask = fillTaskMapId.get(fillTaskId);
            if (HRObjectUtils.isEmpty((Object)fillTask) || HRStringUtils.equals((String)(taskStatus = fillTask.getString("taskstatus")), (String)"D")) continue;
            result.add(Pair.of((Object)report, (Object)fillTask));
        }
        return result;
    }

    public List<DynamicObject> queryBeRunByRptTpl(List<Long> rptTplIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("rpttpl", "in", rptTplIds)};
        DynamicObject[] reports = this.query("filltask", qFilters);
        List<Long> fillTaskIds = Arrays.stream(reports).map(rep -> rep.getLong("filltask")).collect(Collectors.toList());
        DynamicObject[] fillTasks = FillTaskService.ins().getFillTasks(fillTaskIds, "taskstatus");
        List<DynamicObject> fillList = Arrays.stream(fillTasks).collect(Collectors.toList());
        fillList.removeIf(ft -> !"E".equals(ft.getString("taskstatus")));
        return fillList;
    }

    public ReportService() {
        super("soehrr_report");
    }

    public static ReportService ins() {
        return Instance.INSTANCE;
    }

    private static class Instance {
        private static final ReportService INSTANCE = new ReportService();

        private Instance() {
        }
    }
}

