/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.rpttpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.sdk.sihc.soehrr.business.spread.SpreadClientInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.AutoRowAndColCommand;
import kd.sdk.sihc.soehrr.business.spread.command.GetSpreadJsonCommand;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.enums.CusExceptionEnum;
import kd.sdk.sihc.soehrr.common.report.CallBackFunction;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.properties.SiListEntity;
import kd.sdk.sihc.soehrr.common.spread.properties.SpreadProperties;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplFormHelper;
import kd.sihc.soehrr.business.domain.rpttplvar.RptTplVarService;
import kd.sihc.soehrr.business.domain.spantable.FormulaFormHelper;
import kd.sihc.soehrr.common.utils.SoeHrrPageUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class RptSampleCallBackHandler {
    private static final Map<String, CallBackFunction<String, SpreadModelParam, IFormPlugin>> CALLBACK_SERVICE = Maps.newHashMapWithExpectedSize((int)16);

    private RptSampleCallBackHandler() {
    }

    private static void autoColWidth(String strParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        SiListEntity siParam = new SiListEntity((List)Lists.newArrayList((Object[])new Integer[]{-1}));
        Pair param = Pair.of((Object)SpreadProperties.AutoFitColumns.AUTOFITCOLUMNS.k(), (Object)siParam);
        new AutoRowAndColCommand(param).invokeMethod(spreadModelParam);
    }

    private static void autoRowHigh(String strParam, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        SiListEntity siParam = new SiListEntity((List)Lists.newArrayList((Object[])new Integer[]{-1}));
        Pair param = Pair.of((Object)SpreadProperties.AutoFitRows.AUTOFITROWS.k(), (Object)siParam);
        new AutoRowAndColCommand(param).invokeMethod(spreadModelParam);
    }

    private static void sampleInitFormulas(String compressFormulasStr, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        String uncompressFormula = GzipTools.uncompressJson((String)compressFormulasStr);
        List formulaArray = JSONArray.parseArray((String)uncompressFormula, JSONObject.class);
        if (HRCollUtil.isEmpty((Collection)formulaArray)) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u6b65\u9aa4\u672a\u8bbe\u7f6e\u8ba1\u7b97\u516c\u5f0f\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\u4e0b\u4e00\u6b65?", (String)"RptSampleCallBackHandler_0", (String)"sihc-soehrr-business", (Object[])new Object[0]);
            spreadModelParam.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("has_no_formulas", plugin));
        } else {
            IFormView rptTplView = spreadModelParam.getView().getParentView();
            OperateOption option = OperateOption.create();
            option.setVariableValue("has_no_formulas", "0");
            rptTplView.invokeOperation("nextstep", option);
            spreadModelParam.getView().sendFormAction(rptTplView);
        }
    }

    private static void onlySaveSample(String spreadJson, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        IFormView view = spreadModelParam.getView();
        SoeHrrPageUtils.setSpreadJsonByPView((IFormView)view.getParentView(), (String)spreadJson);
        view.cacheFormShowParameter();
        IFormView rptTplView = view.getParentView();
        OperateOption option = OperateOption.create();
        option.setVariableValue(CallBackEnum.ONLY_SAVE_SAMPLE.getM(), "1");
        rptTplView.invokeOperation("receivesamplejson", option);
        view.sendFormAction(rptTplView);
    }

    private static void sheetCalc(String formulaEnum, SpreadModelParam spreadParam, IFormPlugin plugin) {
        RptTplFormHelper.setSameSheetFormula(spreadParam, formulaEnum);
    }

    private static void getFormulaForSaveSheet(String formulas, SpreadModelParam spreadParam, IFormPlugin plugin) {
        FormulaFormHelper.getFormulaForSaveSheet(spreadParam, formulas, plugin);
    }

    private static void crossSheetCalc(String formulaEnum, SpreadModelParam spreadParam, IFormPlugin plugin) {
        GetSpreadJsonCommand spreadJsonCommand = new GetSpreadJsonCommand(CallBackEnum.OPEN_FORMULA_JSON.getM() + "_" + formulaEnum);
        spreadJsonCommand.invokeMethod(spreadParam);
    }

    private static void insertVar(String insertVarId, SpreadModelParam spreadParam, IFormPlugin plugin) {
        DynamicObject classifyVar = null;
        if (Long.parseLong(insertVarId) != 0L) {
            classifyVar = RptTplVarService.getInstance().loadSingle(Long.parseLong(insertVarId));
        }
        RptTplVarService.getInstance().changeOfInsertVar(classifyVar, spreadParam);
    }

    private static void getSampleFormulas(String compressFormulasStr, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        IFormView view = spreadModelParam.getView();
        view.getFormShowParameter().setCustomParam("formulas", (Object)compressFormulasStr);
        view.cacheFormShowParameter();
        GetSpreadJsonCommand getSpreadJsonCommand = new GetSpreadJsonCommand(CallBackEnum.GET_SAMPLE_SPREADJSON.getM());
        getSpreadJsonCommand.invokeMethod(spreadModelParam);
    }

    private static void getSampleSpreadJson(String spreadCompressJson, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        IFormView view = spreadModelParam.getView();
        String compressFormulasStr = (String)view.getFormShowParameter().getCustomParam("formulas");
        String uncompressFormula = GzipTools.uncompressJson((String)compressFormulasStr);
        List formulaArray = JSONArray.parseArray((String)uncompressFormula, JSONObject.class);
        String newSpreadCompressJson = FormulaFormHelper.parseFormulaAddRptSheet(formulaArray, spreadCompressJson, spreadModelParam);
        SpreadClientInvoker.invokeSetSpreadJsonMethod((IClientViewProxy)spreadModelParam.getProxy(), (String)spreadModelParam.getSpreadKey(), (Object)newSpreadCompressJson);
        List vars = spreadModelParam.getSheetManager().getInvoker().getAllEnableByEntityId("soehrr_rpttplvar");
        view.getFormShowParameter().setCustomParam("soehrr_rpttplvar", (Object)GzipTools.toByteSerialized((Object)vars));
        IFormView rptTplView = view.getParentView();
        SoeHrrPageUtils.setSpreadJsonByPView((IFormView)rptTplView, (String)newSpreadCompressJson);
        view.cacheFormShowParameter();
        OperateOption option = OperateOption.create();
        option.setVariableValue(CallBackEnum.ONLY_SAVE_SAMPLE.getM(), "0");
        rptTplView.invokeOperation("receivesamplejson", option);
        view.sendFormAction(rptTplView);
    }

    public void invokeMethod(String methodName, String args, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        CallBackFunction<String, SpreadModelParam, IFormPlugin> function = CALLBACK_SERVICE.get(methodName);
        if (Objects.isNull(function)) {
            throw new KDBizException(CusExceptionEnum.CALLBACK_ERROR.getName());
        }
        function.accept((Object)args, (Object)spreadModelParam, (Object)plugin);
    }

    public static RptSampleCallBackHandler ins() {
        return Instance.INSTANCE;
    }

    static {
        CALLBACK_SERVICE.put(CallBackEnum.GET_SAMPLE_SPREADJSON.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptSampleCallBackHandler::getSampleSpreadJson));
        CALLBACK_SERVICE.put(CallBackEnum.GET_SAMPLE_FORMULAS.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptSampleCallBackHandler::getSampleFormulas));
        CALLBACK_SERVICE.put(CallBackEnum.INSERT_VAR.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptSampleCallBackHandler::insertVar));
        CALLBACK_SERVICE.put(CallBackEnum.SHEET_CALC.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptSampleCallBackHandler::sheetCalc));
        CALLBACK_SERVICE.put(CallBackEnum.CROSS_SHEET_CALC.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptSampleCallBackHandler::crossSheetCalc));
        CALLBACK_SERVICE.put(CallBackEnum.GET_FORMULA_4SAVESHEET.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptSampleCallBackHandler::getFormulaForSaveSheet));
        CALLBACK_SERVICE.put(CallBackEnum.ONLY_SAVE_SAMPLE.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptSampleCallBackHandler::onlySaveSample));
        CALLBACK_SERVICE.put(CallBackEnum.SAMPLE_INIT_FORMULAS.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptSampleCallBackHandler::sampleInitFormulas));
        CALLBACK_SERVICE.put(CallBackEnum.AUTO_ROW_HIGH.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptSampleCallBackHandler::autoRowHigh));
        CALLBACK_SERVICE.put(CallBackEnum.AUTO_COL_WIDTH.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptSampleCallBackHandler::autoColWidth));
    }

    private static class Instance {
        private static final RptSampleCallBackHandler INSTANCE = new RptSampleCallBackHandler();

        private Instance() {
        }
    }
}

