/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.rpttpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.areaconf.RptAreaConfService;
import kd.sdk.sihc.soehrr.business.spread.SpreadClientInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.SampleToolbarGroupsCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetSheetNameCommand;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.enums.CollectTypeEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.enums.RptTypeEnum;
import kd.sdk.sihc.soehrr.common.report.dto.RepRuntimeVar;
import kd.sdk.sihc.soehrr.common.spread.RptAreaConf;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSetToolParam;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sihc.soehrr.business.application.report.FillTaskApplicationService;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.domain.rpttplvar.RptTplVarService;
import kd.sihc.soehrr.common.utils.SoeHrrPageUtils;

public final class RptSampleFormHelper {
    private static final Log LOG = LogFactory.getLog(RptSampleFormHelper.class);
    private static final Map<String, String> STEP_MAP = Maps.newHashMapWithExpectedSize((int)16);

    private RptSampleFormHelper() {
    }

    public static void changeTab(String operateKey, SpreadModelParam spreadModelParam, OperateOption option) {
        String stepKey;
        String activeTab;
        IFormView view = spreadModelParam.getView();
        String nowTab = view.getPageCache().get("cache_tab_name");
        if (HRStringUtils.isEmpty((String)nowTab)) {
            nowTab = "firstpage";
        }
        if (HRStringUtils.isEmpty((String)(activeTab = STEP_MAP.get(stepKey = operateKey + "_" + nowTab)))) {
            return;
        }
        boolean canLeave = RptSampleFormHelper.leaveNowTab(nowTab, spreadModelParam, operateKey, option);
        if (canLeave) {
            Tab tab = (Tab)view.getControl("tabap");
            tab.activeTab(activeTab);
            view.getPageCache().put("cache_tab_name", activeTab);
            RptSampleFormHelper.arriveActiveTab(activeTab, spreadModelParam);
        }
    }

    public static void arriveActiveTab(String activeTab, SpreadModelParam spreadModelParam) {
        IFormView view = spreadModelParam.getView();
        DynamicObject rptTpl = view.getModel().getDataEntity();
        switch (activeTab) {
            case "firstpage": {
                view.setVisible(Boolean.FALSE, new String[]{"prevstep", "rpt_modify", "bar_save", "legend", "bar_submit"});
                Boolean isCopy = (Boolean)view.getFormShowParameter().getCustomParam("iscopy");
                if (rptTpl.getLong("id") != 0L) {
                    view.setEnable(Boolean.FALSE, new String[]{"reportclassify", "rpttype", "number"});
                }
                if (Objects.nonNull(isCopy) && isCopy.booleanValue()) {
                    view.setEnable(Boolean.FALSE, new String[]{"createorg", "ctrlstrategy", "reportclassify", "rpttype"});
                    boolean exist = CodeRuleServiceHelper.isExist((String)"soehrr_rpttpl", (DynamicObject)rptTpl, null);
                    if (!exist) {
                        view.setEnable(Boolean.valueOf(rptTpl.getLong("id") == 0L), new String[]{"number"});
                    }
                }
                if (!RptSampleFormHelper.isView(view)) break;
                SpreadClientInvoker.invokeLockAllToolbarItems((IClientViewProxy)spreadModelParam.getProxy(), (String)spreadModelParam.getSpreadKey(), (boolean)true);
                break;
            }
            case "secondpage": {
                if (HRStringUtils.isEmpty((String)view.getPageCache().get("cache_spreadap_style"))) {
                    RptSampleFormHelper.showSamplePage(view);
                    if (rptTpl.getBoolean("islocksample") && !RptSampleFormHelper.isView(view)) {
                        view.setVisible(Boolean.TRUE, new String[]{"rpt_modify"});
                    }
                } else {
                    IFormView sampleView;
                    boolean isView = RptSampleFormHelper.isView(view);
                    if ((rptTpl.getBoolean("islocksample") || isView) && Objects.nonNull(sampleView = RptSampleFormHelper.getSampleView(view))) {
                        sampleView.invokeOperation("locksheet");
                        view.sendFormAction(sampleView);
                    }
                    if (!isView && rptTpl.getBoolean("islocksample")) {
                        view.setVisible(Boolean.TRUE, new String[]{"rpt_modify"});
                    }
                }
                view.setVisible(Boolean.TRUE, new String[]{"prevstep", "nextstep"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "legend"});
                break;
            }
            case "thirdpage": {
                AreaSettingEnum[] areaSettingEnums;
                view.setVisible(Boolean.FALSE, new String[]{"nextstep"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_save", "legend"});
                if (HRBaseDataConfigUtil.getAudit((String)view.getEntityId())) {
                    view.setVisible(Boolean.TRUE, new String[]{"bar_submit"});
                }
                String collectType = rptTpl.getString("collecttype");
                String rptTplType = rptTpl.getString("rpttype");
                if (HRStringUtils.equals((String)rptTplType, (String)RptTypeEnum.STATISTICS.getType())) {
                    view.setVisible(Boolean.valueOf(HRStringUtils.equals((String)collectType, (String)CollectTypeEnum.SUM.getType())), new String[]{"containflex" + AreaSettingEnum.CAL.getValue(), "containflex" + AreaSettingEnum.LOCK.getValue(), "containflex" + AreaSettingEnum.FILL.getValue()});
                    view.setVisible(Boolean.valueOf(HRStringUtils.equals((String)collectType, (String)CollectTypeEnum.LIST.getType())), new String[]{"containflex" + AreaSettingEnum.TOTAL_SUMMARY.getValue(), "containflex" + AreaSettingEnum.DYNAMIC_SUMMARY.getValue()});
                    break;
                }
                for (AreaSettingEnum areaSettingEnum : areaSettingEnums = AreaSettingEnum.values()) {
                    if (areaSettingEnum == AreaSettingEnum.DYNAMIC_SUMMARY) {
                        view.setVisible(Boolean.TRUE, new String[]{"containflex" + areaSettingEnum.getValue()});
                        continue;
                    }
                    view.setVisible(Boolean.FALSE, new String[]{"containflex" + areaSettingEnum.getValue()});
                }
                break;
            }
        }
        if (RptSampleFormHelper.isView(view) && HRStringUtils.equals((String)rptTpl.getString("status"), (String)"B")) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_submit"});
        }
    }

    public static boolean leaveNowTab(String activeTab, SpreadModelParam spreadParam, String operateKey, OperateOption option) {
        IFormView view = spreadParam.getView();
        boolean canLeave = true;
        FormShowParameter formShowParameter = view.getFormShowParameter();
        OperationResult operationResult = null;
        switch (activeTab) {
            case "firstpage": {
                OperateOption operateOption = OperateOption.create();
                Boolean isCopy = (Boolean)formShowParameter.getCustomParam("iscopy");
                Boolean isChangeCollect = (Boolean)formShowParameter.getCustomParam("key_change_collecttype");
                operateOption.setVariableValue("saveBase", "0");
                if (Objects.nonNull(isCopy) && isCopy.booleanValue() || Objects.nonNull(isChangeCollect) && isChangeCollect.booleanValue()) {
                    operateOption.setVariableValue("saveBase", "1");
                }
                if (RptSampleFormHelper.isView(view) || !(operationResult = view.invokeOperation("save", operateOption)).isSuccess() || !Objects.nonNull(isChangeCollect) || !isChangeCollect.booleanValue()) break;
                view.getFormShowParameter().setCustomParam("key_change_collecttype", (Object)false);
                view.cacheFormShowParameter();
                break;
            }
            case "secondpage": {
                view.setVisible(Boolean.FALSE, new String[]{"rpt_modify"});
                view.setEnable(Boolean.FALSE, new String[]{"reportclassify"});
                if (RptSampleFormHelper.isView(view) && HRStringUtils.equals((String)operateKey, (String)"prevstep")) break;
                boolean isLockSample = (Boolean)view.getModel().getValue("islocksample");
                IFormView sampleView = RptSampleFormHelper.getSampleView(view);
                if (HRStringUtils.equals((String)operateKey, (String)"nextstep")) {
                    String noFormulas = option.getVariableValue("has_no_formulas", "1");
                    String rptType = (String)view.getModel().getValue("rpttype");
                    if (HRStringUtils.equals((String)rptType, (String)RptTypeEnum.DETAIL.getType())) {
                        noFormulas = "0";
                    }
                    if (!isLockSample && HRStringUtils.equals((String)noFormulas, (String)"1")) {
                        sampleView.invokeOperation(CallBackEnum.SAMPLE_INIT_FORMULAS.getM());
                        view.sendFormAction(sampleView);
                        return false;
                    }
                    if (isLockSample || !HRStringUtils.equals((String)noFormulas, (String)"0")) break;
                    view.getModel().setValue("islocksample", (Object)"1");
                    operationResult = sampleView.invokeOperation(CallBackEnum.GET_SAMPLE_SPREADJSON.getM());
                    view.sendFormAction(sampleView);
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RptSampleFormHelper_2", (String)"sihc-soehrr-business", (Object[])new Object[0]));
                    break;
                }
                operationResult = sampleView.invokeOperation(CallBackEnum.ONLY_SAVE_SAMPLE.getM());
                view.sendFormAction(sampleView);
                break;
            }
            case "thirdpage": {
                if (RptSampleFormHelper.isView(view)) break;
                operationResult = view.invokeOperation("save");
                break;
            }
        }
        if (operationResult != null) {
            canLeave = operationResult.isSuccess();
        }
        return canLeave;
    }

    public static String copyRptTplHandler(SpreadModelParam spreadParam, String pageNowSpreadJson) {
        IFormView view = spreadParam.getView();
        Object oriRptTplId = ((BaseShowParameter)view.getFormShowParameter()).getPkId();
        DynamicObject rptTpl = view.getModel().getDataEntity(true);
        DynamicObjectCollection versionEntry = rptTpl.getDynamicObjectCollection("entryentity");
        String rptTplNumber = rptTpl.getString("number");
        DynamicObject oldRptTpl = RptTplService.getInstance().loadSingle(oriRptTplId);
        String newSpreadJsonStr = pageNowSpreadJson;
        for (DynamicObject entry : versionEntry) {
            String sampleJson = entry.getString("samplejson_tag");
            JSONObject sampleJsonObject = SpreadJsonHelper.getSpreadJsonByUncompress((String)sampleJson);
            SpreadJsonHelper.refreshRptTplNumber((JSONObject)sampleJsonObject, (String)rptTplNumber, (String)oldRptTpl.getString("number"));
            entry.set("samplejson_tag", (Object)GzipTools.compressJson((String)sampleJsonObject.toJSONString()));
            JSONObject spreadJsonObject = SpreadJsonHelper.getSpreadJsonByUncompress((String)pageNowSpreadJson);
            SpreadJsonHelper.refreshRptTplNumber((JSONObject)spreadJsonObject, (String)rptTplNumber, (String)oldRptTpl.getString("number"));
            JSONArray nameStyles = spreadJsonObject.getJSONArray("namedStyles");
            if (HRCollUtil.isNotEmpty((Collection)nameStyles)) {
                JSONObject tarFirstSheet = SpreadJsonHelper.getSheetDataBySheetName((JSONObject)spreadJsonObject, (String)rptTplNumber);
                FillTaskApplicationService.refreshParentName(rptTplNumber, nameStyles, tarFirstSheet);
                newSpreadJsonStr = GzipTools.compressJson((String)spreadJsonObject.toJSONString());
                SpreadClientInvoker.invokeSetSpreadJsonMethod((IClientViewProxy)spreadParam.getProxy(), (String)spreadParam.getSpreadKey(), (Object)newSpreadJsonStr);
            } else {
                newSpreadJsonStr = GzipTools.compressJson((String)spreadJsonObject.toJSONString());
            }
            entry.set("json_tag", (Object)newSpreadJsonStr);
            view.updateView("entryentity");
            view.getModel().setDataChanged(false);
        }
        List cacheDtoList = spreadParam.getSheetManager().getInvoker().getCacheDtoList();
        RepCacheService.ins().refreshCopyNumber(cacheDtoList, spreadParam, oldRptTpl, rptTplNumber);
        spreadParam.getSheetManager().setSheetCache(view);
        new SetSheetNameCommand(new String[]{rptTplNumber}).invokeMethod(spreadParam);
        view.getFormShowParameter().setCustomParam("iscopy", (Object)false);
        view.cacheFormShowParameter();
        return newSpreadJsonStr;
    }

    public static void showSamplePage(IFormView rptTplView) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("soehrr_rptsample");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("soehrr_rptsample");
        String pageId = parameter.getPageId();
        rptTplView.getPageCache().put("cache_spreadap_style", pageId);
        DynamicObject rptTpl = rptTplView.getModel().getDataEntity(true);
        DynamicObject currentEntry = RptTplService.getInstance().getCurrentEntry(rptTpl);
        String spreadJson = "";
        spreadJson = currentEntry == null ? "base64H4sIAAAAAAAAA6VUXY7TMBC+ysrPZZWWBUHe2LYrKrEUteUJocqNJ62pY0f2pD9b7Ql45B7cgNvAPRjbSbtRu7xQKY09P9/8fDM5sA1YJ41mKeveXPeuX7MO40qZ7WcHdmD5cmBNydKcKwcdtpLLlaIHR3rDlRQDjpylaCuovQZ7zQuZvbOW7xuFRLAc5Qb6XGWVoqPR93wni6oYRZXRjqXdJKlB+qbcf+IOYbjLQE1xr+CYQTAY7hC0CCYTrpfQRMoax/fABdhxWUMTcFY5NMUH6ZClX77SXcny1nArjkYvO8ytAJCOBzaZzR8UgsN5ZpSCDOdJcvPWa6g+ivecAVXrpuDvIJqsrK+o0hT4la8w862YmG285tY8gJ5ZLpXUSxJPUWbrmRmKU1ltm75RVaEvmOEKQmrjPJcZUCoisHMI7xlf+C4eWHL8c7GxB5YbnxzTxhZcXbVf3V65uyLi5MJK9kg/goWcVwo99x+NgEtQwevPz++/f/1gdWJ3UXNrxJ5EymRr36HAakClLkXWBk3W/whzhhggiIn/hVCQYx+UGmkBuzA4aMq2wAV648zUnbQNmyequyEdlr6Ih1raS0IMvcQVmcSqxxUSrRDQaFUK5wc0VkM8P6ulnKbIMWjo7p6cTfSJg3Kcb6/hFZp7sMu4NiOdGxfXobRSo7/7OCUvwU7lQ+jTVgqf7Btf3gr87lPmYVfXUgtfxaN3NxibcgoXV3UCjoBorl3rOxHFMcO2ZqTpw4NnDlF8yWFAfOB5hCi+5HAnaXFtSzQUEseLb1RC27Tu/hn4+GmHaxW1QdZDQqP0F9LgFm1ZBQAA" : currentEntry.getString("samplejson_tag");
        SoeHrrPageUtils.setSpreadJsonByPView((IFormView)rptTplView, (String)spreadJson);
        parameter.setCustomParam("number", rptTplView.getModel().getValue("number"));
        rptTplView.showForm(parameter);
    }

    public static IFormView getSampleView(IFormView rptTplView) {
        String samplePageId = rptTplView.getPageCache().get("cache_spreadap_style");
        return rptTplView.getView(samplePageId);
    }

    public static void unLockSampleByRpt(IFormView rptTplView) {
        IFormView sampleView = RptSampleFormHelper.getSampleView(rptTplView);
        if (null == sampleView) {
            RptSampleFormHelper.showSamplePage(rptTplView);
            sampleView = RptSampleFormHelper.getSampleView(rptTplView);
        }
        sampleView.invokeOperation("rpt_modify");
        rptTplView.sendFormAction(sampleView);
        rptTplView.getModel().setValue("islocksample", (Object)"0");
    }

    public static SampleToolbarGroupsCommand genSampleToolParam(DynamicObject rptTpl) {
        SpreadSetToolParam spreadSetToolParam = new SpreadSetToolParam();
        spreadSetToolParam.setCollectType(rptTpl.getString("collecttype"));
        DynamicObject reportClassify = rptTpl.getDynamicObject("reportclassify");
        boolean isCycRpt = reportClassify.getBoolean("iscycrpt");
        String rptType = rptTpl.getString("rpttype");
        spreadSetToolParam.setRptType(rptType);
        DynamicObject[] commonVars = RptTplVarService.getInstance().queryByClassify(0L);
        List<DynamicObject> vars = Arrays.stream(commonVars).collect(Collectors.toList());
        if (!isCycRpt) {
            vars.removeIf(va -> va.getLong("id") == 1930583106167799808L);
        }
        DynamicObject[] classifyVars = RptTplVarService.getInstance().queryByClassify((Long)reportClassify.getPkValue());
        vars.addAll(Arrays.asList(classifyVars));
        spreadSetToolParam.setReportVar(vars.toArray(new DynamicObject[0]));
        return new SampleToolbarGroupsCommand(spreadSetToolParam);
    }

    public static void loadLegend(IFormView view) {
        view.getPageCache().put("legend", "true");
        Container legendFlex = (Container)view.getControl("legend");
        List<FlexPanelAp> dynamicFlexs = RptSampleFormHelper.createDynamicFlex();
        if (legendFlex != null && dynamicFlexs != null && !dynamicFlexs.isEmpty()) {
            List createControls = dynamicFlexs.stream().map(FlexPanelAp::createControl).collect(Collectors.toList());
            legendFlex.addControls(createControls);
        }
    }

    public static void loadLegend4FillTask(IFormView view) {
        view.getPageCache().put("legend", "true");
        Container legendFlex = (Container)view.getControl("legend");
        List<FlexPanelAp> dynamicFlexs = RptSampleFormHelper.createDynamicFlex4FillTask();
        if (legendFlex != null && dynamicFlexs != null && !dynamicFlexs.isEmpty()) {
            List createControls = dynamicFlexs.stream().map(FlexPanelAp::createControl).collect(Collectors.toList());
            legendFlex.addControls(createControls);
        }
    }

    public static boolean isView(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        boolean audit = HRBaseDataConfigUtil.getAudit((String)view.getEntityId());
        if (!audit && formShowParameter.getStatus() != OperationStatus.VIEW) {
            return false;
        }
        return !audit || !HRStringUtils.equals((String)((String)view.getModel().getValue("status")), (String)"A");
    }

    private static List<FlexPanelAp> createDynamicFlex() {
        AreaSettingEnum[] areaSettingEnums;
        Map rptAreaConf = RptAreaConfService.ins().initRptAreaConf();
        if (HRMapUtils.isEmpty((Map)rptAreaConf)) {
            return null;
        }
        ArrayList legendItems = Lists.newArrayListWithExpectedSize((int)rptAreaConf.size());
        for (AreaSettingEnum settingEnum : areaSettingEnums = AreaSettingEnum.values()) {
            FlexPanelAp legendItem;
            RptAreaConf areaConf = (RptAreaConf)rptAreaConf.get(settingEnum);
            if (settingEnum == AreaSettingEnum.CLEAR || AreaSettingEnum.SYS_AUTO_NUM == settingEnum || !Objects.nonNull(legendItem = RptSampleFormHelper.createFlex(settingEnum, areaConf))) continue;
            legendItems.add(legendItem);
        }
        return legendItems;
    }

    private static List<FlexPanelAp> createDynamicFlex4FillTask() {
        AreaSettingEnum[] areaSettingEnums;
        Map rptAreaConf = RptAreaConfService.ins().initRptAreaConf();
        if (HRMapUtils.isEmpty((Map)rptAreaConf)) {
            return null;
        }
        ArrayList legendItems = Lists.newArrayListWithExpectedSize((int)rptAreaConf.size());
        for (AreaSettingEnum settingEnum : areaSettingEnums = AreaSettingEnum.values()) {
            FlexPanelAp legendItem;
            RptAreaConf areaConf = (RptAreaConf)rptAreaConf.get(settingEnum);
            if (settingEnum == AreaSettingEnum.CLEAR || AreaSettingEnum.SYS_AUTO_NUM == settingEnum || !Objects.nonNull(legendItem = RptSampleFormHelper.createFlex4FillTask(settingEnum, areaConf))) continue;
            legendItems.add(legendItem);
        }
        return legendItems;
    }

    private static FlexPanelAp createFlex(AreaSettingEnum settingEnum, RptAreaConf areaConf) {
        if (Objects.isNull(areaConf)) {
            return null;
        }
        FlexPanelAp containFlex = new FlexPanelAp();
        containFlex.setKey("containflex" + settingEnum.getValue());
        containFlex.setGrow(0);
        containFlex.setShrink(0);
        containFlex.setJustifyContent("space-around");
        Margin flexMargin = new Margin();
        flexMargin.setTop("10px");
        flexMargin.setBottom("10px");
        Style flexStyle = new Style();
        flexStyle.setMargin(flexMargin);
        containFlex.setStyle(flexStyle);
        FlexPanelAp colorFlex = new FlexPanelAp();
        colorFlex.setKey("colorflex" + settingEnum.getValue());
        colorFlex.setAlignItems("center");
        colorFlex.setWidth(new LocaleString("16px"));
        colorFlex.setHeight(new LocaleString("16px"));
        colorFlex.setGrow(0);
        colorFlex.setShrink(0);
        colorFlex.setBackColor(areaConf.getBakColor());
        colorFlex.setForeColor(areaConf.getBakColor());
        Margin colorFlexMargin = new Margin();
        colorFlexMargin.setTop("2px");
        Style colorFlexStyle = new Style();
        colorFlexStyle.setMargin(colorFlexMargin);
        colorFlex.setStyle(colorFlexStyle);
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("areanamelabel" + settingEnum.getValue());
        if (settingEnum == AreaSettingEnum.TOTAL_SUMMARY) {
            labelAp.setName(new LocaleString(new MultiLangEnumBridge("\u8ba1\u7b97\u533a\u6216\u7f57\u5217\u6c47\u603b\u533a", "RptSampleFormHelper_0", "sihc-soehrr-business").loadKDString()));
        } else {
            labelAp.setName(new LocaleString(areaConf.getName().getLocaleValue()));
        }
        labelAp.setForeColor("#212121");
        labelAp.setFontSize(14);
        Margin margin = new Margin();
        margin.setRight("24px");
        margin.setLeft("8px");
        Style labelStyle = new Style();
        labelStyle.setMargin(margin);
        labelAp.setStyle(labelStyle);
        containFlex.getItems().add(colorFlex);
        containFlex.getItems().add(labelAp);
        return containFlex;
    }

    private static FlexPanelAp createFlex4FillTask(AreaSettingEnum settingEnum, RptAreaConf areaConf) {
        if (Objects.isNull(areaConf)) {
            return null;
        }
        FlexPanelAp containFlex = new FlexPanelAp();
        containFlex.setKey("containflex" + settingEnum.getValue());
        containFlex.setGrow(0);
        containFlex.setShrink(0);
        containFlex.setJustifyContent("space-around");
        Margin flexMargin = new Margin();
        flexMargin.setTop("10px");
        flexMargin.setBottom("10px");
        Style flexStyle = new Style();
        flexStyle.setMargin(flexMargin);
        containFlex.setStyle(flexStyle);
        FlexPanelAp colorFlex = new FlexPanelAp();
        colorFlex.setKey("colorflex" + settingEnum.getValue());
        colorFlex.setAlignItems("center");
        colorFlex.setWidth(new LocaleString("16px"));
        colorFlex.setHeight(new LocaleString("16px"));
        colorFlex.setGrow(0);
        colorFlex.setShrink(0);
        colorFlex.setBackColor(areaConf.getBakColor());
        colorFlex.setForeColor(areaConf.getBakColor());
        Margin colorFlexMargin = new Margin();
        colorFlexMargin.setTop("2px");
        Style colorFlexStyle = new Style();
        colorFlexStyle.setMargin(colorFlexMargin);
        colorFlex.setStyle(colorFlexStyle);
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("areanamelabel" + settingEnum.getValue());
        if (settingEnum == AreaSettingEnum.TOTAL_SUMMARY) {
            labelAp.setName(new LocaleString(new MultiLangEnumBridge("\u8ba1\u7b97\u533a", "RptSampleFormHelper_0", "sihc-soehrr-business").loadKDString()));
        } else {
            labelAp.setName(new LocaleString(areaConf.getName().getLocaleValue()));
        }
        labelAp.setForeColor("#212121");
        labelAp.setFontSize(14);
        Margin margin = new Margin();
        margin.setRight("24px");
        margin.setLeft("8px");
        Style labelStyle = new Style();
        labelStyle.setMargin(margin);
        labelAp.setStyle(labelStyle);
        containFlex.getItems().add(colorFlex);
        containFlex.getItems().add(labelAp);
        return containFlex;
    }

    public static boolean validateNumber(String newNumber, IFormView view) {
        if (HRStringUtils.isEmpty((String)newNumber)) {
            return true;
        }
        boolean hasChinese = SoeHrrPageUtils.hasChinese((String)newNumber);
        LOG.info("RptSampleFormHelper.validateNumber start newNumber={}", (Object)newNumber);
        boolean hasCalculator = SoeHrrPageUtils.hasCalculator((String)newNumber);
        if (hasCalculator || hasChinese) {
            LOG.info("RptSampleFormHelper.validateNumber end hasCalculator is true");
            FieldTip tip = new FieldTip();
            tip.setFieldKey("number");
            tip.setTip(ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\u53ca\u7279\u6b8a\u5b57\u7b26", (String)"RptSampleFormHelper_3", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            DeleteRule deleteRule = new DeleteRule();
            deleteRule.setAction("isChange");
            deleteRule.setFields(Collections.singletonList("number"));
            tip.setDeleteRule(deleteRule);
            view.showFieldTip(tip);
        }
        LOG.info("RptSampleFormHelper.validateNumber end hasCalculator={}", (Object)hasCalculator);
        return hasCalculator || hasChinese;
    }

    public static void lockOrUnLockPage(SpreadModelParam spreadModelParam, boolean lock, String operateKey) {
        IFormView view = spreadModelParam.getView();
        String nowTab = view.getPageCache().get("cache_tab_name");
        if (HRStringUtils.equals((String)nowTab, (String)"secondpage")) {
            view.setVisible(Boolean.TRUE, new String[]{"rpt_modify"});
        }
        SpreadClientInvoker.invokeLockAllToolbarItems((IClientViewProxy)spreadModelParam.getProxy(), (String)spreadModelParam.getSpreadKey(), (boolean)lock);
        spreadModelParam.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)nowTab, (String)"thirdpage")), new String[]{"bar_submit"});
    }

    public static void loadVarsByRptTpl(SpreadModelParam spreadModelParam, DynamicObject rptTpl, long entryId, boolean isQuery) {
        List<RepRuntimeVar> runtimeVars = RptTplVarService.getInstance().queryDtoByRepConfId(rptTpl.getLong("id"), entryId);
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        sheetManager.clearAllCache();
        if (HRCollUtil.isEmpty(runtimeVars)) {
            runtimeVars = RptTplVarService.getInstance().parseSampleVar(sheetManager, rptTpl);
        } else if (!isQuery) {
            for (RepRuntimeVar runtimeVar : runtimeVars) {
                runtimeVar.setOperate(OperateEnum.ADD);
            }
        }
        sheetManager.getInvoker().setCacheDtoList(runtimeVars);
        sheetManager.setSheetCache(spreadModelParam.getView());
    }

    static {
        STEP_MAP.put("nextstep_firstpage", "secondpage");
        STEP_MAP.put("nextstep_secondpage", "thirdpage");
        STEP_MAP.put("prevstep_secondpage", "firstpage");
        STEP_MAP.put("prevstep_thirdpage", "secondpage");
    }
}

