/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.rpttpl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.command.BorderHlStyleCommand;
import kd.sdk.sihc.soehrr.business.spread.command.ClearAreaCommand;
import kd.sdk.sihc.soehrr.business.spread.command.GetSpreadJsonCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetAreaCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetFormalCommand;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.enums.CusExceptionEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.report.CallBackFunction;
import kd.sdk.sihc.soehrr.common.report.TipContent;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.RepRuntimeVar;
import kd.sdk.sihc.soehrr.common.report.dto.RepValidatorDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.RptAreaConf;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;
import kd.sihc.soehrr.business.domain.rpttpl.RptSampleFormHelper;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplFormHelper;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.domain.rpttplvar.RptTplVarService;
import kd.sihc.soehrr.business.domain.spantable.FormulaFormHelper;
import org.apache.commons.lang3.tuple.Pair;

public final class RptTplCallBackHandler {
    private static final Log LOG = LogFactory.getLog(RptTplCallBackHandler.class);
    private static final Map<String, CallBackFunction<String, SpreadModelParam, IFormPlugin>> CALLBACK_SERVICE = Maps.newHashMapWithExpectedSize((int)16);

    private RptTplCallBackHandler() {
    }

    private static void delDataCheck(String spreadJson, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        SpreadSelector delSelector = spreadModelParam.getSelector();
        List verRulesDto = sheetManager.getAllSheetRuleByEntity("soehrr_rpttplverrule");
        boolean hasDelDto = false;
        for (RepValidatorDto repValidatorDto : verRulesDto) {
            Cell cell = repValidatorDto.getCell();
            SpreadSelector cellSelector = cell.toSelector();
            if (!cellSelector.checkIsInArea(delSelector)) continue;
            hasDelDto = true;
            break;
        }
        IFormView rptTplView = spreadModelParam.getView();
        if (hasDelDto) {
            String msg = ResManager.loadKDString((String)"\u6240\u9009\u533a\u57df\u5168\u90e8\u6821\u6838\u89c4\u5219\u5c06\u88ab\u5220\u9664\uff0c\u662f\u5426\u786e\u5b9a\u6e05\u7a7a\uff1f", (String)"RptTplCallBackHandler_0", (String)"sihc-soehrr-formplugin", (Object[])new Object[0]);
            rptTplView.showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CallBackEnum.DEL_DATA_CHECK.getM(), plugin));
        } else {
            rptTplView.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u6e05\u9664\u7684\u6821\u6838\u89c4\u5219\u3002", (String)"RptTplCallBackHandler_1", (String)"sihc-soehrr-business", (Object[])new Object[0]));
        }
    }

    private static void lockArea(String spreadJson, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        IFormView view = spreadModelParam.getView();
        SpreadSelector spreadSelector = spreadModelParam.getSelector();
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        TipContent check = RepCacheService.ins().drawDataAreaCheck(spreadModelParam, AreaSettingEnum.LOCK);
        if (!check.isSuccess()) {
            view.showTipNotification(check.getTip());
            return;
        }
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        AreaSettingDto lockArea = new AreaSettingDto(spreadSelector, dataEntity, AreaSettingEnum.LOCK);
        sheetManager.getInvoker().setCacheDto((ReportCacheDto)lockArea);
        sheetManager.setSheetCache(view.getPageCache());
        new SetAreaCommand(MapInitHelper.ofMap((Object)sheetManager.areaConf(AreaSettingEnum.LOCK), Collections.singletonList(spreadSelector))).invokeMethod(spreadModelParam);
    }

    private static void lastGetNumGetJson(String spreadJson, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        List highlightArea = sheetManager.getHighlightArea();
        if (HRCollUtil.isEmpty((Collection)highlightArea)) {
            sheetManager.parseSelectStyle(spreadJson);
            sheetManager.setSheetCache(spreadModelParam.getView());
        }
        List<Object> cacheDtoList = RepCacheService.ins().getDataAreaBySetting(sheetManager.getInvoker());
        cacheDtoList = cacheDtoList.stream().filter(dto -> Lists.newArrayList((Object[])new AreaSettingEnum[]{AreaSettingEnum.LAST_GET_NUM, AreaSettingEnum.SYS_AUTO_NUM, AreaSettingEnum.LYEAR_GET_NUM}).contains(dto.getAreaSetting())).collect(Collectors.toList());
        SpreadSelector selector = spreadModelParam.getSelector();
        for (AreaSettingDto areaSettingDto : cacheDtoList) {
            SpreadSelector tarSelector = areaSettingDto.convert2Selector();
            if (!selector.checkIsInArea(tarSelector)) continue;
            RptAreaConf areaConf = sheetManager.areaConf(areaSettingDto.getAreaSetting());
            ArrayList borderCommands = Lists.newArrayListWithExpectedSize((int)2);
            List existHighlightArea = sheetManager.getHighlightArea();
            if (HRCollUtil.isNotEmpty((Collection)existHighlightArea)) {
                borderCommands.add(Pair.of((Object)sheetManager.areaConf(AreaSettingEnum.CLEAR), (Object)existHighlightArea));
            }
            if (areaSettingDto.getAreaSetting() == AreaSettingEnum.SYS_AUTO_NUM) {
                List highlightList = sheetManager.parseHighlightArea(tarSelector);
                borderCommands.add(Pair.of((Object)areaConf, (Object)highlightList));
            } else {
                String otherAreaPoint = areaSettingDto.getOtherAreaPoint();
                if (HRStringUtils.isNotEmpty((String)otherAreaPoint)) {
                    SpreadSelector otherSelector = new SpreadSelector(otherAreaPoint);
                    List highlightList = sheetManager.parseHighlightArea(otherSelector);
                    borderCommands.add(Pair.of((Object)areaConf, (Object)highlightList));
                }
            }
            for (Pair borderCommand : borderCommands) {
                BorderHlStyleCommand command = new BorderHlStyleCommand(borderCommand);
                command.invokeMethod(spreadModelParam);
            }
            sheetManager.setSheetCache(spreadModelParam.getView());
            break;
        }
    }

    private static void dataCheck(String args, SpreadModelParam spreadParam, IFormPlugin plugin) {
        GetSpreadJsonCommand spreadJsonCommand = new GetSpreadJsonCommand(CallBackEnum.DATA_CHECK_INCLUDE_JSON.getM());
        spreadJsonCommand.invokeMethod(spreadParam);
    }

    private static void dataCheckIncludeJson(String args, SpreadModelParam spreadParam, IFormPlugin plugin) {
        RptTplFormHelper.showValidatorPage(plugin, spreadParam, args);
    }

    private static void clearArea(String args, SpreadModelParam spreadParam, IFormPlugin plugin) {
        RptTplFormHelper.clearArea(spreadParam, plugin, false);
    }

    private static void getFormula(String formulas, SpreadModelParam spreadParam, IFormPlugin plugin) {
        FormulaFormHelper.updateSheetFormula(spreadParam, formulas);
    }

    private static void fillArea(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        RptTplFormHelper.drawFillArea(spreadParam, AreaSettingEnum.FILL);
    }

    private static void lastPeriodNumArea(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        RptTplFormHelper.drawByLastDataArea(spreadParam, AreaSettingEnum.LAST_GET_NUM);
    }

    private static void lastYearNumArea(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        RptTplFormHelper.drawByLastDataArea(spreadParam, AreaSettingEnum.LYEAR_GET_NUM);
    }

    private static void dynamicSummaryArea(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        RptTplFormHelper.drawFillArea(spreadParam, AreaSettingEnum.DYNAMIC_SUMMARY);
    }

    private static void totalSummary(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        RptTplFormHelper.drawByTotalSummaryArea(spreadParam, AreaSettingEnum.TOTAL_SUMMARY);
    }

    public static void clearAllRptData(String formulas, SpreadModelParam spreadParam, IFormPlugin plugin) {
        SheetManager sheetManager = spreadParam.getSheetManager();
        CacheObjInvoker invoker = sheetManager.getInvoker();
        List cacheDtoList = invoker.getCacheDtoList();
        ArrayList clearAreaList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList vars = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList formulaList = Lists.newArrayListWithExpectedSize((int)10);
        for (ReportCacheDto cacheDto : cacheDtoList) {
            if (cacheDto.getOperate() == OperateEnum.DELETE) continue;
            if (cacheDto instanceof AreaSettingDto) {
                AreaSettingDto areaSettingDto = (AreaSettingDto)cacheDto;
                SpreadSelector selector = areaSettingDto.convert2Selector();
                if (areaSettingDto.getAreaSetting() == AreaSettingEnum.CAL) {
                    formulaList.add(new Cell().setRowAndCol(selector.getStartRow(), selector.getEndCol()));
                } else if (areaSettingDto.getAreaSetting() == AreaSettingEnum.TOTAL_SUMMARY) {
                    List cells = selector.toCellList();
                    formulaList.addAll(cells);
                }
                clearAreaList.add(selector);
            } else if (cacheDto instanceof RepRuntimeVar) {
                vars.add((RepRuntimeVar)cacheDto);
            }
            cacheDto.setOperate(OperateEnum.DELETE);
        }
        new ClearAreaCommand((List)clearAreaList).invokeMethod(spreadParam);
        RptTplVarService.getInstance().clearAllVarsForSpread(vars, spreadParam);
        new SetFormalCommand((List)formulaList).invokeMethod(spreadParam);
        sheetManager.setSheetCache(spreadParam.getView());
    }

    private static void sysGetNumJson(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        RptTplFormHelper.showAutoGetNumPage(plugin, spreadParam, spreadJson);
    }

    public void invokeMethod(String methodName, String args, SpreadModelParam spreadModelParam, IFormPlugin plugin) {
        CallBackFunction<String, SpreadModelParam, IFormPlugin> function = CALLBACK_SERVICE.get(methodName);
        if (Objects.isNull(function)) {
            throw new KDBizException(CusExceptionEnum.CALLBACK_ERROR.getName());
        }
        function.accept((Object)args, (Object)spreadModelParam, (Object)plugin);
    }

    public static void saveSpreadData(String spreadJson, SpreadModelParam spreadParam, IFormPlugin plugin) {
        DynamicObjectCollection entryEntity;
        Boolean isCopy = (Boolean)spreadParam.getView().getFormShowParameter().getCustomParam("iscopy");
        if (Objects.nonNull(isCopy) && isCopy.booleanValue()) {
            spreadJson = RptSampleFormHelper.copyRptTplHandler(spreadParam, spreadJson);
        }
        boolean saveSample = false;
        if (Objects.isNull(plugin)) {
            saveSample = true;
        }
        IFormView view = spreadParam.getView();
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        long rptTplId = dataEntity.getLong("id");
        LargeTextEdit jsonControl = (LargeTextEdit)view.getControl("json");
        String tagFieldKey = jsonControl.getTagFieldKey();
        DynamicObject queryRptTpl = RptTplService.getInstance().queryNowEntryEntity(tagFieldKey, rptTplId);
        if (HRObjectUtils.isEmpty((Object)queryRptTpl)) {
            queryRptTpl = dataEntity;
        }
        if (HRCollUtil.isEmpty((Collection)(entryEntity = queryRptTpl.getDynamicObjectCollection("entryentity")))) {
            DynamicObject newEntry = new DynamicObject(entryEntity.getDynamicObjectType());
            newEntry.set("isnewversion", (Object)0);
            newEntry.set("isnowedit", (Object)1);
            if (saveSample) {
                newEntry.set("samplejson_tag", (Object)spreadJson);
            } else {
                newEntry.set(tagFieldKey, (Object)spreadJson);
            }
            entryEntity.add((Object)newEntry);
        } else {
            boolean hasCurrent = false;
            for (DynamicObject entry : entryEntity) {
                boolean isCurrent = entry.getBoolean("isnowedit");
                if (!isCurrent) continue;
                if (saveSample) {
                    entry.set("samplejson_tag", (Object)spreadJson);
                } else {
                    entry.set(jsonControl.getTagFieldKey(), (Object)spreadJson);
                }
                hasCurrent = true;
            }
            if (!hasCurrent) {
                DynamicObject firstEntry = (DynamicObject)entryEntity.get(0);
                LOG.warn("RptTplCallBackHandler.saveSpreadData not has current , entry = {}", (Object)firstEntry.getString("id"));
                firstEntry.set("isnewversion", (Object)0);
                firstEntry.set("isnowedit", (Object)1);
                if (saveSample) {
                    firstEntry.set("samplejson_tag", (Object)spreadJson);
                } else {
                    firstEntry.set(jsonControl.getTagFieldKey(), (Object)spreadJson);
                }
            }
        }
        RptTplService.getInstance().saveOne(queryRptTpl);
        if (!saveSample) {
            RptTplService.getInstance().updRelationData(spreadParam, queryRptTpl, null);
        }
    }

    public static RptTplCallBackHandler ins() {
        return Instance.INSTANCE;
    }

    static {
        CALLBACK_SERVICE.put(CallBackEnum.SAVE_SPREAD_DATA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::saveSpreadData));
        CALLBACK_SERVICE.put(CallBackEnum.SYS_GETNUM_JSON.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::sysGetNumJson));
        CALLBACK_SERVICE.put(CallBackEnum.LAST_PERIOD_NUM_AREA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::lastPeriodNumArea));
        CALLBACK_SERVICE.put(CallBackEnum.LAST_YEAR_NUM_AREA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::lastYearNumArea));
        CALLBACK_SERVICE.put(CallBackEnum.LOCK_AREA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::lockArea));
        CALLBACK_SERVICE.put(CallBackEnum.GET_FORMULA_4CLREAR.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::clearAllRptData));
        CALLBACK_SERVICE.put(CallBackEnum.GET_FORMULA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::getFormula));
        CALLBACK_SERVICE.put(CallBackEnum.FILL_AREA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::fillArea));
        CALLBACK_SERVICE.put(CallBackEnum.CLEAR_AREA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::clearArea));
        CALLBACK_SERVICE.put(CallBackEnum.DYNAMIC_LIST_AREA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::dynamicSummaryArea));
        CALLBACK_SERVICE.put(CallBackEnum.LIST_SUMMARY_AREA.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::totalSummary));
        CALLBACK_SERVICE.put(CallBackEnum.DATA_CHECK.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::dataCheck));
        CALLBACK_SERVICE.put(CallBackEnum.DEL_DATA_CHECK.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::delDataCheck));
        CALLBACK_SERVICE.put(CallBackEnum.DATA_CHECK_INCLUDE_JSON.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::dataCheckIncludeJson));
        CALLBACK_SERVICE.put(CallBackEnum.LAST_GETNUM_GETJSON.getM(), (CallBackFunction<String, SpreadModelParam, IFormPlugin>)((CallBackFunction)RptTplCallBackHandler::lastGetNumGetJson));
    }

    private static class Instance {
        private static final RptTplCallBackHandler INSTANCE = new RptTplCallBackHandler();

        private Instance() {
        }
    }
}

