/*
 * Decompiled with CFR 0.152.
 */
package kd.sihc.soehrr.business.domain.rpttpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.sihc.soehrr.business.spread.SpreadClientInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.ClearAreaCommand;
import kd.sdk.sihc.soehrr.business.spread.command.HideRbForConfigCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SampleToolbarGroupsCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetAreaCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetBtnVisCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetFormalCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SetToolbarGroupsCommand;
import kd.sdk.sihc.soehrr.business.spread.command.SpreadBatchInvoker;
import kd.sdk.sihc.soehrr.business.spread.command.UpdCellsValCommand;
import kd.sdk.sihc.soehrr.business.spread.command.abs.SpreadCommand;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadCommandHelper;
import kd.sdk.sihc.soehrr.business.spread.helper.SpreadJsonHelper;
import kd.sdk.sihc.soehrr.common.enums.AreaSettingEnum;
import kd.sdk.sihc.soehrr.common.enums.CallBackEnum;
import kd.sdk.sihc.soehrr.common.enums.CusExceptionEnum;
import kd.sdk.sihc.soehrr.common.enums.ExcelFormulaEnum;
import kd.sdk.sihc.soehrr.common.enums.OperateEnum;
import kd.sdk.sihc.soehrr.common.enums.PageTypeEnum;
import kd.sdk.sihc.soehrr.common.report.TipContent;
import kd.sdk.sihc.soehrr.common.report.dto.AreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.AutoAreaSettingDto;
import kd.sdk.sihc.soehrr.common.report.dto.RepValidatorDto;
import kd.sdk.sihc.soehrr.common.report.dto.ReportCacheDto;
import kd.sdk.sihc.soehrr.common.report.invoker.CacheObjInvoker;
import kd.sdk.sihc.soehrr.common.spread.Cell;
import kd.sdk.sihc.soehrr.common.spread.SheetManager;
import kd.sdk.sihc.soehrr.common.spread.SpreadModelParam;
import kd.sdk.sihc.soehrr.common.spread.SpreadSelector;
import kd.sdk.sihc.soehrr.common.spread.SpreadSetToolParam;
import kd.sdk.sihc.soehrr.common.util.ExcelUtils;
import kd.sdk.sihc.soehrr.common.util.GzipTools;
import kd.sdk.sihc.soehrr.common.util.MapInitHelper;
import kd.sihc.soehrr.business.application.report.FillTaskApplicationService;
import kd.sihc.soehrr.business.domain.cache.RepCacheService;
import kd.sihc.soehrr.business.domain.rpttpl.RptSampleFormHelper;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplCallBackHandler;
import kd.sihc.soehrr.business.domain.rpttpl.RptTplService;
import kd.sihc.soehrr.business.domain.rpttplarea.RptTplAreaService;
import kd.sihc.soehrr.business.domain.rpttplarea.RptTplAutoAreaService;
import kd.sihc.soehrr.common.check.ExpressionEvaluator;
import kd.sihc.soehrr.common.check.ExpressionSplitor;
import kd.sihc.soehrr.common.constants.CollectTaskConstants;
import kd.sihc.soehrr.common.utils.SoeHrrPageUtils;

public final class RptTplFormHelper {
    private static final RepCacheService cacheService = RepCacheService.ins();

    private RptTplFormHelper() {
    }

    public static void drawFillArea(SpreadModelParam spreadModelParam, AreaSettingEnum areaSettingEnum) {
        SheetManager sheet = spreadModelParam.getSheetManager();
        SpreadSelector fillSpreadSelector = spreadModelParam.getSelector();
        CacheObjInvoker invoker = sheet.getInvoker();
        AreaSettingDto fillOrTotalArea = cacheService.getFillOrTotalArea(invoker);
        DynamicObject dataEntity = spreadModelParam.getView().getModel().getDataEntity(true);
        ArrayList clearAreaList = Lists.newArrayListWithExpectedSize((int)10);
        List<AreaSettingDto> otherDataAreaList = cacheService.getDataAreaBySetting(invoker);
        IFormView view = spreadModelParam.getView();
        if (null != fillOrTotalArea) {
            SpreadSelector drawFillSelector = fillOrTotalArea.convert2Selector();
            boolean otherIsOnFill = false;
            for (AreaSettingDto dataSettingDto : otherDataAreaList) {
                if (dataSettingDto.getAreaSetting() == AreaSettingEnum.CAL || !dataSettingDto.convert2Selector().checkIsInArea(drawFillSelector)) continue;
                otherIsOnFill = true;
                break;
            }
            if (otherIsOnFill) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u5df2\u8bbe\u7f6e\u8fc7\u5176\u4ed6\u533a\u57df\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u8bbe\u7f6e\uff0c\u5982\u9700\u8bbe\u7f6e\uff0c\u8bf7\u6e05\u9664\u5f53\u524d\u5176\u4ed6\u533a\u57df\u3002", (String)"FillArea_1", (String)"sihc-soehrr-business", (Object[])new Object[0]), areaSettingEnum.getName().getDescription()));
                return;
            }
        }
        List<AreaSettingDto> allCalArea = RepCacheService.ins().getAllCalArea(invoker);
        for (AreaSettingDto areaSettingDto : allCalArea) {
            if (areaSettingDto.convert2Selector().checkIsInArea(fillSpreadSelector)) continue;
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u586b\u62a5\u533a\u5e94\u5305\u542b\u6240\u6709\u8ba1\u7b97\u533a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u533a\u57df\u3002", (String)"FillArea_0", (String)"sihc-soehrr-business", (Object[])new Object[0]), areaSettingEnum.getName().getDescription()));
            return;
        }
        if (null != fillOrTotalArea) {
            SpreadSelector drawFillSelector = fillOrTotalArea.convert2Selector();
            clearAreaList.add(drawFillSelector);
            fillOrTotalArea.setOperate(OperateEnum.DELETE);
        }
        AreaSettingDto settingDto = new AreaSettingDto(fillSpreadSelector, dataEntity, areaSettingEnum);
        invoker.setCacheDto((ReportCacheDto)settingDto);
        sheet.setSheetCache(spreadModelParam.getView());
        if (HRCollUtil.isNotEmpty((Collection)clearAreaList)) {
            new ClearAreaCommand((List)clearAreaList).invokeMethod(spreadModelParam);
        }
        new SetAreaCommand(MapInitHelper.ofMap((Object)sheet.areaConf(AreaSettingEnum.FILL), Collections.singletonList(fillSpreadSelector))).invokeMethod(spreadModelParam);
        RptTplAreaService.ins().extendCalArea(spreadModelParam);
    }

    public static void drawAutoArea(Map<SpreadSelector, AutoAreaSettingDto> autoNumArea, @NotNull SpreadModelParam param) {
        if (Objects.isNull(autoNumArea)) {
            return;
        }
        SheetManager sheetData = param.getSheetManager();
        Collection<AutoAreaSettingDto> values = autoNumArea.values();
        List<AutoAreaSettingDto> allAutoGetNumAreas = RepCacheService.ins().getAutoGetNumAreas(param.getSheetManager().getInvoker());
        for (AutoAreaSettingDto allAutoGetNumArea : allAutoGetNumAreas) {
            for (Map.Entry<SpreadSelector, AutoAreaSettingDto> entry : autoNumArea.entrySet()) {
                AutoAreaSettingDto autoAreaSettingDto = entry.getValue();
                long analyseObjectId = autoAreaSettingDto.getAnalyseObjectId();
                if (analyseObjectId != allAutoGetNumArea.getAnalyseObjectId()) continue;
                long fillOrgId = autoAreaSettingDto.getFillOrgId();
                allAutoGetNumArea.setFillOrgId(fillOrgId);
                long datePeriod = autoAreaSettingDto.getDatePeriod();
                allAutoGetNumArea.setDatePeriod(datePeriod);
            }
        }
        ArrayList<AutoAreaSettingDto> autoAreaList = new ArrayList<AutoAreaSettingDto>(values);
        Map<String, AutoAreaSettingDto> dtoMap = autoAreaList.stream().collect(Collectors.toMap(AreaSettingDto::getAreaPoint, res -> res, (k, v) -> v));
        CacheObjInvoker invoker = sheetData.getInvoker();
        List<AutoAreaSettingDto> autoGetNumAreas = cacheService.getAutoGetNumAreas(invoker);
        RptTplAutoAreaService.ins().updateAutoAreaData(param, autoGetNumAreas, dtoMap);
        invoker.setCacheDtoList(autoAreaList);
        sheetData.setSheetCache(param.getView());
    }

    public static void drawByLastDataArea(SpreadModelParam modelParam, AreaSettingEnum areaSetting) {
        IFormView view = modelParam.getView();
        SpreadSelector spreadSelector = modelParam.getSelector();
        if (areaSetting != AreaSettingEnum.LAST_GET_NUM && areaSetting != AreaSettingEnum.LYEAR_GET_NUM) {
            throw new KDException(BosErrorCode.paramError, new Object[]{String.format(CusExceptionEnum.PARAM_ERROR.getName(), "areaSetting")});
        }
        if (spreadSelector.getSpanRow() != 1 && spreadSelector.getSpanCol() != 1) {
            String error = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u6216\u5355\u5217\u8bbe\u4e3a%s\u3002", (String)"ReportConfFormHelper_0", (String)"sihc-soehrr-business", (Object[])new Object[0]), areaSetting.getName().loadKDString());
            view.showTipNotification(error);
            return;
        }
        SheetManager sheet = SpreadJsonHelper.getSpreadSheet((IFormView)view);
        TipContent check = cacheService.drawDataAreaCheck(modelParam, areaSetting);
        if (!check.isSuccess()) {
            view.showTipNotification(check.getTip());
            return;
        }
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        AreaSettingDto settingDto = new AreaSettingDto(spreadSelector, dataEntity, areaSetting);
        sheet.setRelationDto(settingDto);
        sheet.setSheetCache(view.getPageCache());
        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u53d6\u503c\u533a\u57df\u3002", (String)"ReportConfFormHelper_2", (String)"sihc-soehrr-business", (Object[])new Object[0]));
    }

    public static void drawByTotalSummaryArea(SpreadModelParam spreadModelParam, AreaSettingEnum areaSetting) {
        if (areaSetting != AreaSettingEnum.TOTAL_SUMMARY) {
            throw new KDException(BosErrorCode.paramError, new Object[]{String.format(CusExceptionEnum.PARAM_ERROR.getName(), "areaSetting")});
        }
        SheetManager sheet = spreadModelParam.getSheetManager();
        CacheObjInvoker invoker = sheet.getInvoker();
        IFormView view = spreadModelParam.getView();
        TipContent check = cacheService.drawDataAreaCheck(spreadModelParam, areaSetting);
        if (!check.isSuccess()) {
            view.showTipNotification(check.getTip());
            return;
        }
        SpreadSelector totalSummarySelector = spreadModelParam.getSelector();
        List<AreaSettingDto> allCalArea = cacheService.getAllCalArea(invoker);
        for (AreaSettingDto calArea : allCalArea) {
            SpreadSelector calSelector = calArea.convert2Selector();
            if (!calSelector.checkIsInArea(totalSummarySelector)) continue;
            calArea.setOperate(OperateEnum.DELETE);
        }
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        AreaSettingDto settingDto = new AreaSettingDto(spreadModelParam.getSelector(), dataEntity, AreaSettingEnum.TOTAL_SUMMARY);
        invoker.setCacheDto((ReportCacheDto)settingDto);
        sheet.setSheetCache(view.getPageCache());
        new SetAreaCommand(MapInitHelper.ofMap((Object)sheet.areaConf(AreaSettingEnum.TOTAL_SUMMARY), Collections.singletonList(totalSummarySelector))).invokeMethod(spreadModelParam);
        RptTplAreaService.ins().drawTotalSummaryAreaFormula(spreadModelParam);
    }

    public static void clearArea(SpreadModelParam spreadModelParam, IFormPlugin plugin, boolean ensure) {
        SheetManager sheet = spreadModelParam.getSheetManager();
        SpreadSelector spreadSelector = spreadModelParam.getSelector();
        CacheObjInvoker invoker = sheet.getInvoker();
        List<Object> dataAreas = cacheService.getDataAreaBySetting(invoker);
        dataAreas = dataAreas.stream().filter(area -> area.getAreaSetting() != AreaSettingEnum.CAL).collect(Collectors.toList());
        AreaSettingDto fillArea = cacheService.getFillOrTotalArea(invoker);
        HashSet clearList = Sets.newHashSetWithExpectedSize((int)10);
        boolean isClearFill = false;
        if (Objects.nonNull(fillArea)) {
            for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
                for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                    SpreadSelector cellSelector = new SpreadSelector(i, j, i, j, 1, 1);
                    List listInArea = cellSelector.getListInArea(dataAreas);
                    clearList.addAll(listInArea);
                    if (!cellSelector.checkIsInArea(fillArea.convert2Selector()) || !HRCollUtil.isEmpty((Collection)listInArea)) continue;
                    clearList.add(fillArea);
                    isClearFill = true;
                }
            }
        }
        if (HRCollUtil.isEmpty((Collection)clearList)) {
            spreadModelParam.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u6e05\u9664\u533a\u57df\u3002", (String)"ReportConfFormHelper_1", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        if (isClearFill && dataAreas.size() > 0 && !ensure) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u5728\u591a\u79cd\u533a\u57df\uff0c\u6e05\u9664\u540e\u6240\u6709\u533a\u57df\u90fd\u5c06\u6e05\u7a7a\uff0c\u786e\u5b9a\u8981\u6e05\u9664\u5417\uff1f", (String)"ReportConfFormHelper_3", (String)"sihc-soehrr-business", (Object[])new Object[0]);
            spreadModelParam.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CallBackEnum.CLEAR_AREA.getM(), plugin));
            return;
        }
        AreaSettingEnum strandArea = AreaSettingEnum.FILL;
        if (isClearFill) {
            strandArea = AreaSettingEnum.CLEAR;
            clearList.addAll(dataAreas);
        }
        ArrayList selectors = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList clearTsFormulas = Lists.newArrayListWithExpectedSize((int)10);
        for (AreaSettingDto clearAreaDto : clearList) {
            AreaSettingEnum areaSetting;
            if (clearAreaDto.getOperate() == OperateEnum.DELETE || (areaSetting = clearAreaDto.getAreaSetting()) == AreaSettingEnum.CAL) continue;
            SpreadSelector selector = clearAreaDto.convert2Selector();
            selectors.add(selector);
            if (areaSetting == AreaSettingEnum.TOTAL_SUMMARY) {
                List clearFormulaCell = selector.toCellList();
                clearTsFormulas.addAll(clearFormulaCell);
            }
            clearAreaDto.setOperate(OperateEnum.DELETE);
        }
        sheet.setSheetCache(spreadModelParam.getView());
        if (strandArea == AreaSettingEnum.CLEAR) {
            new ClearAreaCommand((List)selectors).invokeMethod(spreadModelParam);
        } else {
            new SetAreaCommand(MapInitHelper.ofMap((Object)sheet.areaConf(strandArea), (Object)selectors)).invokeMethod(spreadModelParam);
        }
        if (HRCollUtil.isNotEmpty((Collection)clearTsFormulas)) {
            new SetFormalCommand((List)clearTsFormulas).invokeMethod(spreadModelParam);
        }
        RptTplAreaService.ins().extendCalArea(spreadModelParam);
    }

    public static void initEntrySpreadData(SpreadModelParam spreadModelParam) {
        IFormView rptTplView = spreadModelParam.getView();
        DynamicObject dy = rptTplView.getModel().getDataEntity(true);
        String spreadJson = RptTplService.getInstance().getCurrentJson(dy);
        SpreadCommandHelper.genSheetManagerByView((IFormView)rptTplView, (String)spreadJson);
        HideRbForConfigCommand buttonCommand = new HideRbForConfigCommand(PageTypeEnum.FILLTASKVIEW.getNum());
        RptTplFormHelper.genRptTplToolParam(spreadModelParam);
        SetBtnVisCommand setBtnVisCommand = new SetBtnVisCommand(Boolean.valueOf(false));
        ArrayList spreadCommands = Lists.newArrayList((Object[])new SpreadCommand[]{buttonCommand, setBtnVisCommand});
        SpreadClientInvoker.invokeSetSpreadJsonMethod((IClientViewProxy)spreadModelParam.getProxy(), (String)spreadModelParam.getSpreadKey(), (Object)spreadJson);
        SpreadBatchInvoker.getInstance((SpreadModelParam)spreadModelParam, (List)spreadCommands).call();
        RepCacheService.ins().customInitReportConfCache(spreadModelParam);
    }

    public static void showFormulaPage(String formulaEnum, IFormPlugin plugin, SpreadModelParam spreadParam, String spreadJson) {
        IFormView sampleView = spreadParam.getView();
        String rptNumber = (String)sampleView.getModel().getValue("number");
        DynamicObject rptTpl = RptTplService.getInstance().queryFieldByNumber(rptNumber, false, "reportclassify");
        DynamicObject reportClassify = rptTpl.getDynamicObject("reportclassify");
        if (HRStringUtils.isEmpty((String)rptNumber)) {
            sampleView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u62a5\u8868\u7f16\u7801\uff0c\u518d\u8bbe\u7f6e\u8de8\u8868\u516c\u5f0f\u3002", (String)"RptTplFormHelper_0", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        if (HRObjectUtils.isEmpty((Object)reportClassify)) {
            sampleView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u5206\u7c7b\u3002", (String)"RptTplFormHelper_2", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("soehrr_setformula");
        parameter.setCustomParam("reportclassify", (Object)reportClassify.getLong("id"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String idStr = rptTpl.getPkValue().toString();
        parameter.setCustomParam("id", (Object)idStr);
        parameter.setCustomParam("formula", (Object)ExcelFormulaEnum.valueOf((String)formulaEnum));
        parameter.setCustomParam("number", (Object)rptTpl.getString("number"));
        SoeHrrPageUtils.setSpreadJsonByPView((IFormView)sampleView, (String)spreadJson);
        parameter.setCloseCallBack(new CloseCallBack(plugin, "soehrr_setformula"));
        SpreadSelector spreadSelector = spreadParam.getSelector();
        SheetManager sheetData = spreadParam.getSheetManager();
        Cell cell = sheetData.getCell(spreadSelector.getStartRow(), spreadSelector.getStartCol());
        parameter.setCustomParam("cell", (Object)GzipTools.toByteSerialized((Object)cell));
        parameter.setCustomParam("spread_selector", (Object)GzipTools.toByteSerialized((Object)spreadSelector));
        parameter.setCustomParam("soehrr_rpttpl", (Object)spreadParam.getView().getPageId());
        spreadParam.getView().showForm(parameter);
    }

    public static void showAutoGetNumPage(IFormPlugin plugin, SpreadModelParam spreadParam, String spreadJson) {
        TipContent check = cacheService.drawDataAreaCheck(spreadParam, AreaSettingEnum.SYS_AUTO_NUM);
        if (!check.isSuccess()) {
            spreadParam.getView().showTipNotification(check.getTip());
            return;
        }
        IFormView view = spreadParam.getView();
        BillShowParameter parameter = new BillShowParameter();
        AutoAreaSettingDto autoAreaSettingDto = cacheService.queryAutoAreaBySelector(spreadParam);
        if (Objects.nonNull(autoAreaSettingDto)) {
            OperateEnum operate = autoAreaSettingDto.getOperate();
            if (operate == OperateEnum.ADD) {
                parameter.setCustomParam("soehrr_rpttplarea_auto", (Object)GzipTools.toByteSerialized((Object)autoAreaSettingDto));
            } else if (operate == OperateEnum.QUERY) {
                parameter.setPkId((Object)autoAreaSettingDto.getId());
            }
            parameter.setCustomParam("spread_selector", (Object)GzipTools.toByteSerialized((Object)autoAreaSettingDto.convert2Selector()));
        } else {
            DynamicObject dataEntity = view.getModel().getDataEntity(true);
            parameter.setCustomParam("reportconfid", dataEntity.getPkValue());
            parameter.setCustomParam("repentryid", (Object)RptTplService.getInstance().getCurrentEntryId(dataEntity));
            parameter.setCustomParam("spread_selector", (Object)GzipTools.toByteSerialized((Object)spreadParam.getSelector()));
            List<AutoAreaSettingDto> autoGetNumAreas = RepCacheService.ins().getAutoGetNumAreas(spreadParam.getSheetManager().getInvoker());
            parameter.setCustomParam("alldata_spread_selector", (Object)GzipTools.toByteSerialized(autoGetNumAreas));
        }
        parameter.setFormId("soehrr_rpttplarea_auto");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPageId(String.format("%s_%s", view.getPageId(), RequestContext.get().getCurrUserId()));
        parameter.setCloseCallBack(new CloseCallBack(plugin, "soehrr_rpttplarea_auto"));
        SoeHrrPageUtils.setSpreadJsonByPView((IFormView)view, (String)spreadJson);
        view.showForm((FormShowParameter)parameter);
    }

    public static void genRptTplToolParam(SpreadModelParam spreadParam) {
        DynamicObject dataEntityObject = spreadParam.getView().getModel().getDataEntity();
        SpreadSetToolParam spreadSetToolParam = new SpreadSetToolParam();
        spreadSetToolParam.setCollectType(dataEntityObject.getString("collecttype"));
        spreadSetToolParam.setRptType(dataEntityObject.getString("rpttype"));
        new SetToolbarGroupsCommand(spreadSetToolParam).invokeMethod(spreadParam);
        IFormView sampleView = RptSampleFormHelper.getSampleView(spreadParam.getView());
        if (sampleView != null) {
            SampleToolbarGroupsCommand sampleToolbarGroupsCommand = RptSampleFormHelper.genSampleToolParam(dataEntityObject);
            sampleToolbarGroupsCommand.invokeMethod((IClientViewProxy)sampleView.getService(IClientViewProxy.class), "spreadap");
        }
    }

    public static void setSameSheetFormula(SpreadModelParam spreadParam, String formulaEnum) {
        SpreadSelector selector = spreadParam.getSelector();
        SheetManager sheetManager = spreadParam.getSheetManager();
        Cell cell = sheetManager.getCell(selector.getStartRow(), selector.getStartCol());
        cell.setFormula(null);
        SetFormalCommand command = new SetFormalCommand(Collections.singletonList(cell));
        command.invokeMethod(spreadParam);
        cell.setValue((Object)ExcelFormulaEnum.valueOf((String)formulaEnum).getFormula());
        spreadParam.getView().getFormShowParameter().setCustomParam("cell", (Object)GzipTools.toByteSerialized((Object)cell));
        spreadParam.getView().cacheFormShowParameter();
        UpdCellsValCommand cellsValCommand = new UpdCellsValCommand(MapInitHelper.ofMap((Object)cell.toSelector(), (Object)ExcelFormulaEnum.valueOf((String)formulaEnum).getFormula()));
        cellsValCommand.invokeMethod(spreadParam);
    }

    public static void showValidatorPage(IFormPlugin plugin, SpreadModelParam spreadParam, String spreadJson) {
        List oldRepValidatorDtos;
        String rptNumber = (String)spreadParam.getView().getModel().getValue("number");
        DynamicObject reportclassify = (DynamicObject)spreadParam.getView().getModel().getValue("reportclassify");
        if (HRStringUtils.isEmpty((String)rptNumber)) {
            spreadParam.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u62a5\u8868\u7f16\u7801\uff0c\u518d\u8bbe\u7f6e\u6570\u636e\u6821\u6838\u3002", (String)"RptTplFormHelper_3", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        if (HRObjectUtils.isEmpty((Object)reportclassify)) {
            spreadParam.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u5206\u7c7b\u3002", (String)"RptTplFormHelper_2", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        SpreadSelector selector = spreadParam.getSelector();
        if (selector.getSpanCol() != 1 && selector.getSpanRow() != 1) {
            spreadParam.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u62e9\u591a\u884c\u591a\u5217\u7684\u533a\u57df\u8bbe\u7f6e\u6570\u636e\u6821\u6838\u3002", (String)"RptTplFormHelper_4", (String)"sihc-soehrr-business", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        SheetManager sheetManager = spreadParam.getSheetManager();
        String newPoint = selector.getStartRow() + ":" + selector.getStartCol() + ":" + selector.getSpanRow() + ":" + selector.getSpanCol();
        List<RepValidatorDto> repValidatorDtos = cacheService.getAllRepValidatorAreas(sheetManager.getInvoker());
        if (repValidatorDtos != null && repValidatorDtos.size() > 0 && (oldRepValidatorDtos = repValidatorDtos.stream().filter(repValidatorDto -> newPoint.equals(repValidatorDto.getPoint())).sorted(Comparator.comparing(RepValidatorDto::getCreatetime)).collect(Collectors.toList())).size() > 0) {
            parameter.setCustomParam("soehrr_rpttplverrule", (Object)GzipTools.toByteSerialized(oldRepValidatorDtos));
        }
        IFormView view = spreadParam.getView();
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        parameter.setCustomParam("id", (Object)dataEntity.getPkValue().toString());
        parameter.setCustomParam("number", (Object)dataEntity.getString("number"));
        parameter.setCustomParam("reportclassify", (Object)reportclassify.getLong("id"));
        parameter.setCustomParam("repentryid", (Object)RptTplService.getInstance().getCurrentEntryId(dataEntity));
        parameter.setCustomParam("soehrr_rpttpl", (Object)spreadParam.getView().getPageId());
        parameter.setCustomParam("spread_selector", (Object)GzipTools.toByteSerialized((Object)spreadParam.getSelector()));
        parameter.setFormId("soehrr_setvalidators");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack(plugin, "soehrr_setvalidators"));
        SoeHrrPageUtils.setSpreadJsonByPView((IFormView)view, (String)spreadJson);
        view.showForm(parameter);
    }

    public static void setDataValidation(DynamicObject validator, SpreadModelParam spreadParam) {
        SheetManager sheetManager = spreadParam.getSheetManager();
        DynamicObject rptTpl = spreadParam.getView().getModel().getDataEntity(true);
        rptTpl = RptTplService.getInstance().queryNowEntryEntity(null, (Long)rptTpl.getPkValue());
        SpreadSelector selector = spreadParam.getSelector();
        CacheObjInvoker invoker = sheetManager.getInvoker();
        List cacheDtoList = invoker.getCacheDtoList();
        String newPoint = selector.getStartRow() + ":" + selector.getStartCol() + ":" + selector.getSpanRow() + ":" + selector.getSpanCol();
        for (ReportCacheDto reportCacheDto : cacheDtoList) {
            RepValidatorDto repValidatorDto;
            if (!(reportCacheDto instanceof RepValidatorDto) || !newPoint.equals((repValidatorDto = (RepValidatorDto)reportCacheDto).getPoint())) continue;
            repValidatorDto.setOperate(OperateEnum.DELETE);
        }
        List subentryentity = validator.getDynamicObjectCollection("entryentity").stream().flatMap(dynamicObject -> dynamicObject.getDynamicObjectCollection("subentryentity").stream()).collect(Collectors.toList());
        if (subentryentity.size() > 0) {
            for (DynamicObject dynamicObject2 : subentryentity) {
                String tarvalue = dynamicObject2.getString("tarvalue");
                if (HRStringUtils.isEmpty((String)tarvalue)) {
                    sheetManager.setSheetCache(spreadParam.getView());
                    return;
                }
                String point = dynamicObject2.getString("point");
                String srcExpression = point + dynamicObject2.getString("comparator") + tarvalue;
                List srcExpressionList = ExpressionSplitor.split((String)srcExpression, (String)dynamicObject2.getString("comparator"));
                for (String expression : srcExpressionList) {
                    String orgPoint = expression.substring(expression.indexOf("!") + 1, expression.indexOf(dynamicObject2.getString("comparator"))) + ":1:1";
                    SpreadSelector spreadSelector = new SpreadSelector(orgPoint);
                    RepValidatorDto validatorDto = new RepValidatorDto(spreadSelector, rptTpl, dynamicObject2);
                    validatorDto.setExpression(expression);
                    String allExpression = expression.substring(expression.indexOf(dynamicObject2.getString("comparator")) + dynamicObject2.getString("comparator").length());
                    tarvalue = RptTplFormHelper.replaceWithPoint(allExpression);
                    validatorDto.setTarvalue(RptTplFormHelper.addSpacesAroundOperators(tarvalue));
                    sheetManager.getInvoker().setCacheDto((ReportCacheDto)validatorDto);
                }
            }
        }
        sheetManager.setSheetCache(spreadParam.getView());
    }

    public static String addSpacesAroundOperators(String input) {
        String result = input.replaceAll("([-+*/()])", " $1 ");
        return result.trim();
    }

    public static String replaceWithPoint(String input) {
        List verUnits = ExpressionSplitor.splitItem((String)input);
        for (String item : verUnits) {
            StringBuilder builder = new StringBuilder();
            builder.append(item, 0, item.indexOf("!") + 1);
            String partCell = item.substring(item.indexOf("!") + 1);
            String[] split = partCell.split(":");
            String pos = ExcelUtils.xy2Pos((int)Integer.parseInt(split[1]), (int)Integer.parseInt(split[0]));
            builder.append(pos);
            input = ExpressionEvaluator.replaceAllForExpression((String)input, (String)item, (String)builder.toString());
        }
        return input;
    }

    public static void setSampleViewFormulas(SpreadModelParam spreadModelParam) {
        IFormView rptTplView = spreadModelParam.getView();
        DynamicObject rptTpl = rptTplView.getModel().getDataEntity();
        IFormView sampleView = RptSampleFormHelper.getSampleView(rptTplView);
        String sampleCompressFormulas = (String)sampleView.getFormShowParameter().getCustomParam("formulas");
        String sampleFormulas = GzipTools.uncompressJson((String)sampleCompressFormulas);
        List formulaArray = JSONArray.parseArray((String)sampleFormulas, JSONObject.class);
        SheetManager sheetManager = spreadModelParam.getSheetManager();
        CacheObjInvoker invoker = sheetManager.getInvoker();
        LinkedHashMap commandParam = Maps.newLinkedHashMapWithExpectedSize((int)1);
        ArrayList spreadSelectors = Lists.newArrayListWithExpectedSize((int)formulaArray.size());
        ArrayList setCells = Lists.newArrayListWithExpectedSize((int)formulaArray.size());
        for (JSONObject formula : formulaArray) {
            Integer row = formula.getInteger("r");
            Integer col = formula.getInteger("c");
            String fVal = formula.getString("f");
            Cell cell = sheetManager.getCell(row.intValue(), col.intValue());
            cell.setFormula(fVal);
            spreadSelectors.add(cell.toSelector());
            setCells.add(cell);
            AreaSettingDto calSettingDto = new AreaSettingDto(cell.toSelector(), rptTpl, AreaSettingEnum.CAL);
            invoker.setCacheDto((ReportCacheDto)calSettingDto);
        }
        commandParam.put(sheetManager.areaConf(AreaSettingEnum.CAL), spreadSelectors);
        new SetAreaCommand((Map)commandParam).invokeMethod(spreadModelParam);
        new SetFormalCommand((List)setCells).invokeMethod(spreadModelParam);
        sheetManager.setSheetCache(rptTplView);
    }

    public static void receiveSampleSpread(SpreadModelParam spreadParam, String onlySaveSample) {
        IFormView rptTplView = spreadParam.getView();
        IFormView sampleView = RptSampleFormHelper.getSampleView(rptTplView);
        String sampleSpreadCompressJson = SoeHrrPageUtils.getSpreadJsonByPView((IFormView)rptTplView);
        if (HRStringUtils.equals((String)onlySaveSample, (String)"0")) {
            JSONObject spreadJsonObject = SpreadJsonHelper.getSpreadJsonByUncompress((String)sampleSpreadCompressJson);
            String varsStr = (String)sampleView.getFormShowParameter().getCustomParam("soehrr_rpttplvar");
            String sheetNumber = rptTplView.getModel().getDataEntity().getString("number");
            JSONObject blankSpreadJson = SpreadJsonHelper.getBlankSpreadJson((JSONObject)spreadJsonObject, (String)sheetNumber);
            JSONArray nameStyles = spreadJsonObject.getJSONArray("namedStyles");
            if (HRCollUtil.isNotEmpty((Collection)nameStyles)) {
                JSONObject tarFirstSheet = SpreadJsonHelper.getSheetDataBySheetName((JSONObject)spreadJsonObject, (String)sheetNumber);
                Map<String, String> stylesName = FillTaskApplicationService.refreshParentName(sheetNumber, nameStyles, tarFirstSheet);
                RptTplFormHelper.refreshParentNameByTar(sheetNumber, stylesName, spreadJsonObject.getJSONObject("sheets"));
                String blankSpreadJsonStr = GzipTools.compressJson((String)blankSpreadJson.toJSONString());
                SpreadClientInvoker.invokeSetSpreadJsonMethod((IClientViewProxy)spreadParam.getProxy(), (String)spreadParam.getSpreadKey(), (Object)blankSpreadJsonStr);
            } else {
                String blankSpreadJsonStr = GzipTools.compressJson((String)blankSpreadJson.toJSONString());
                SpreadClientInvoker.invokeSetSpreadJsonMethod((IClientViewProxy)spreadParam.getProxy(), (String)spreadParam.getSpreadKey(), (Object)blankSpreadJsonStr);
            }
            spreadParam.getSheetManager().addSheet(sheetNumber, sampleSpreadCompressJson);
            List vars = (List)GzipTools.deSerializedBytes((String)varsStr);
            SheetManager sheetManager = spreadParam.getSheetManager();
            sheetManager.getInvoker().setCacheDtoList(vars);
            sheetManager.setSheetCache(rptTplView);
            SpreadClientInvoker.invokeLockSheetMethod((IClientViewProxy)spreadParam.getProxy(), (String)spreadParam.getSpreadKey(), Collections.singletonList(sheetNumber));
            RptTplFormHelper.setSampleViewFormulas(spreadParam);
        }
        SoeHrrPageUtils.setSpreadJsonByPView((IFormView)rptTplView, null);
        sampleView.getFormShowParameter().setCustomParam("soehrr_rpttplvar", null);
        sampleView.getFormShowParameter().setCustomParam("formulas", null);
        sampleView.cacheFormShowParameter();
        RptTplCallBackHandler.saveSpreadData(sampleSpreadCompressJson, spreadParam, null);
        spreadParam.getView().updateView("entryentity");
    }

    public static void refreshParentNameByTar(String rptTplNumber, Map<String, String> stylesName, JSONObject sheets) {
        sheets.forEach((s, o) -> {
            if (!rptTplNumber.equals(s)) {
                JSONObject tarSheet = (JSONObject)o;
                JSONObject data = tarSheet.getJSONObject("data");
                JSONObject dataTable = data.getJSONObject("dataTable");
                for (Map.Entry rowEntry : dataTable.entrySet()) {
                    Object value = rowEntry.getValue();
                    JSONObject rowJsonObject = (JSONObject)value;
                    rowJsonObject.forEach((key, colVal) -> {
                        JSONObject colJsonObject = (JSONObject)colVal;
                        if (colJsonObject.containsKey((Object)"style")) {
                            String styleStr;
                            Object colStyle = colJsonObject.get((Object)"style");
                            if (Objects.isNull(colStyle)) {
                                return;
                            }
                            if (colStyle instanceof JSONObject && ((JSONObject)colStyle).containsKey((Object)"parentName")) {
                                JSONObject styleObj = (JSONObject)colStyle;
                                String parentName = styleObj.getString("parentName");
                                if (stylesName.containsKey(parentName)) {
                                    styleObj.put("parentName", stylesName.get(parentName));
                                }
                            } else if (colStyle instanceof String && stylesName.containsKey(styleStr = (String)colStyle)) {
                                colJsonObject.put("style", stylesName.get(styleStr));
                            }
                        }
                    });
                }
            }
        });
    }

    public static void isShowPeriodType(IFormView view, DynamicObject repClassify) {
        boolean isCycRpt = false;
        if (!HRObjectUtils.isEmpty((Object)repClassify)) {
            isCycRpt = repClassify.getBoolean("iscycrpt");
        }
        view.setVisible(Boolean.valueOf(isCycRpt), new String[]{"periodtype"});
        if (!isCycRpt) {
            view.getModel().setValue("periodtype", null);
        } else {
            FieldEdit periodTypeField = (FieldEdit)view.getControl("periodtype");
            periodTypeField.setMustInput(isCycRpt);
            Object periodType = view.getModel().getValue("periodtype");
            if (Objects.isNull(periodType)) {
                view.getModel().setValue("periodtype", (Object)CollectTaskConstants.RPT_YEAR_ID);
            }
        }
    }
}

